"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_ecr_1 = require("@aws-sdk/client-ecr");
const ecrClient = new client_ecr_1.ECRClient({});
async function handler(assetHashes) {
    if (!process.env.REPOSITORY_NAME) {
        throw new Error('Missing REPOSITORY_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await ecrClient.send(new client_ecr_1.DescribeImagesCommand({
            repositoryName: process.env.REPOSITORY_NAME,
            nextToken,
        }));
        const toDelete = response.imageDetails?.filter(x => {
            if (!x.imageTags) {
                return false;
            }
            let pred = !assetHashes.includes(x.imageTags[0]);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!x.imagePushedAt) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await ecrClient.send(new client_ecr_1.BatchDeleteImageCommand({
                    repositoryName: process.env.REPOSITORY_NAME,
                    imageIds: toDelete.map(x => ({ imageTag: x.imageTags[0] })),
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.imageSizeInBytes ?? 0), 0);
        }
        nextToken = response.nextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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