"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const client_textract_1 = require("@aws-sdk/client-textract");
const web_api_1 = require("@slack/web-api");
const got_1 = require("got");
const textractClient = new client_textract_1.TextractClient({});
async function handler(event) {
    console.log('Event: %j', event);
    const slackClient = new web_api_1.WebClient(process.env.SLACK_TOKEN);
    // Get file info
    const info = await slackClient.files.info({
        file: event.file_id,
    });
    console.log('File info: %j', info);
    if (!info.file.mimetype.startsWith('image')) {
        console.log('Not an image');
        return;
    }
    // Get file
    const file = await got_1.default(info.file.url_private, {
        headers: {
            Authorization: `Bearer ${process.env.SLACK_TOKEN}`,
        },
    }).buffer();
    // Detect text with Textract
    const data = await textractClient.send(new client_textract_1.DetectDocumentTextCommand({
        Document: { Bytes: file },
    }));
    if (!data.Blocks) {
        console.log('No text detected');
        return;
    }
    // Add detected text in image thread
    const postMessage = await slackClient.chat.postMessage({
        channel: event.channel_id,
        text: data.Blocks.filter((b) => b.BlockType === 'LINE').map((b) => b.Text).join('\n'),
        thread_ts: info.file.shares.public[event.channel_id][0].ts,
    });
    console.log('Post message: %j', postMessage);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGV0ZWN0LmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zbGFjay10ZXh0cmFjdC9kZXRlY3QubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUErQjtBQUMvQiw4REFBcUY7QUFDckYsNENBQTZEO0FBQzdELDZCQUFzQjtBQXNCdEIsTUFBTSxjQUFjLEdBQUcsSUFBSSxnQ0FBYyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBRXZDLEtBQUssVUFBVSxPQUFPLENBQUMsS0FBaUI7SUFDN0MsT0FBTyxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFFaEMsTUFBTSxXQUFXLEdBQUcsSUFBSSxtQkFBUyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDLENBQUM7SUFFM0QsZ0JBQWdCO0lBQ2hCLE1BQU0sSUFBSSxHQUFHLE1BQU0sV0FBVyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDeEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxPQUFPO0tBQ3BCLENBQW9CLENBQUM7SUFDdEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFFbkMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRTtRQUMzQyxPQUFPLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQzVCLE9BQU87S0FDUjtJQUVELFdBQVc7SUFDWCxNQUFNLElBQUksR0FBRyxNQUFNLGFBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRTtRQUM1QyxPQUFPLEVBQUU7WUFDUCxhQUFhLEVBQUUsVUFBVSxPQUFPLENBQUMsR0FBRyxDQUFDLFdBQVcsRUFBRTtTQUNuRDtLQUNGLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUVaLDRCQUE0QjtJQUM1QixNQUFNLElBQUksR0FBRyxNQUFNLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSwyQ0FBeUIsQ0FBQztRQUNuRSxRQUFRLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFO0tBQzFCLENBQUMsQ0FBQyxDQUFDO0lBRUosSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7UUFDaEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ2hDLE9BQU87S0FDUjtJQUVELG9DQUFvQztJQUNwQyxNQUFNLFdBQVcsR0FBRyxNQUFNLFdBQVcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3JELE9BQU8sRUFBRSxLQUFLLENBQUMsVUFBVTtRQUN6QixJQUFJLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTLEtBQUssTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztRQUNyRixTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQzNELENBQUMsQ0FBQztJQUNILE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDL0MsQ0FBQztBQXhDRCwwQkF3Q0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZSBuby1jb25zb2xlICovXG5pbXBvcnQgeyBEZXRlY3REb2N1bWVudFRleHRDb21tYW5kLCBUZXh0cmFjdENsaWVudCB9IGZyb20gJ0Bhd3Mtc2RrL2NsaWVudC10ZXh0cmFjdCc7XG5pbXBvcnQgeyBXZWJDbGllbnQsIFdlYkFQSUNhbGxSZXN1bHQgfSBmcm9tICdAc2xhY2svd2ViLWFwaSc7XG5pbXBvcnQgZ290IGZyb20gJ2dvdCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgU2xhY2tFdmVudCB7XG4gIGNoYW5uZWxfaWQ6IHN0cmluZztcbiAgZmlsZV9pZDogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEZpbGVzSW5mb1Jlc3VsdCBleHRlbmRzIFdlYkFQSUNhbGxSZXN1bHQge1xuICBmaWxlOiB7XG4gICAgbWltZXR5cGU6IHN0cmluZztcbiAgICBmaWxldHlwZTogc3RyaW5nO1xuICAgIHVybF9wcml2YXRlOiBzdHJpbmc7XG4gICAgc2hhcmVzOiB7XG4gICAgICBwdWJsaWM6IHtcbiAgICAgICAgW2NoYW5uZWw6IHN0cmluZ106IFt7XG4gICAgICAgICAgdHM6IHN0cmluZztcbiAgICAgICAgfV07XG4gICAgICB9O1xuICAgIH07XG4gIH07XG59XG5cbmNvbnN0IHRleHRyYWN0Q2xpZW50ID0gbmV3IFRleHRyYWN0Q2xpZW50KHt9KTtcblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IFNsYWNrRXZlbnQpOiBQcm9taXNlPHZvaWQ+IHtcbiAgY29uc29sZS5sb2coJ0V2ZW50OiAlaicsIGV2ZW50KTtcblxuICBjb25zdCBzbGFja0NsaWVudCA9IG5ldyBXZWJDbGllbnQocHJvY2Vzcy5lbnYuU0xBQ0tfVE9LRU4pO1xuXG4gIC8vIEdldCBmaWxlIGluZm9cbiAgY29uc3QgaW5mbyA9IGF3YWl0IHNsYWNrQ2xpZW50LmZpbGVzLmluZm8oe1xuICAgIGZpbGU6IGV2ZW50LmZpbGVfaWQsXG4gIH0pIGFzIEZpbGVzSW5mb1Jlc3VsdDtcbiAgY29uc29sZS5sb2coJ0ZpbGUgaW5mbzogJWonLCBpbmZvKTtcblxuICBpZiAoIWluZm8uZmlsZS5taW1ldHlwZS5zdGFydHNXaXRoKCdpbWFnZScpKSB7XG4gICAgY29uc29sZS5sb2coJ05vdCBhbiBpbWFnZScpO1xuICAgIHJldHVybjtcbiAgfVxuXG4gIC8vIEdldCBmaWxlXG4gIGNvbnN0IGZpbGUgPSBhd2FpdCBnb3QoaW5mby5maWxlLnVybF9wcml2YXRlLCB7XG4gICAgaGVhZGVyczoge1xuICAgICAgQXV0aG9yaXphdGlvbjogYEJlYXJlciAke3Byb2Nlc3MuZW52LlNMQUNLX1RPS0VOfWAsXG4gICAgfSxcbiAgfSkuYnVmZmVyKCk7XG5cbiAgLy8gRGV0ZWN0IHRleHQgd2l0aCBUZXh0cmFjdFxuICBjb25zdCBkYXRhID0gYXdhaXQgdGV4dHJhY3RDbGllbnQuc2VuZChuZXcgRGV0ZWN0RG9jdW1lbnRUZXh0Q29tbWFuZCh7XG4gICAgRG9jdW1lbnQ6IHsgQnl0ZXM6IGZpbGUgfSxcbiAgfSkpO1xuXG4gIGlmICghZGF0YS5CbG9ja3MpIHtcbiAgICBjb25zb2xlLmxvZygnTm8gdGV4dCBkZXRlY3RlZCcpO1xuICAgIHJldHVybjtcbiAgfVxuXG4gIC8vIEFkZCBkZXRlY3RlZCB0ZXh0IGluIGltYWdlIHRocmVhZFxuICBjb25zdCBwb3N0TWVzc2FnZSA9IGF3YWl0IHNsYWNrQ2xpZW50LmNoYXQucG9zdE1lc3NhZ2Uoe1xuICAgIGNoYW5uZWw6IGV2ZW50LmNoYW5uZWxfaWQsXG4gICAgdGV4dDogZGF0YS5CbG9ja3MuZmlsdGVyKChiKSA9PiBiLkJsb2NrVHlwZSA9PT0gJ0xJTkUnKS5tYXAoKGIpID0+IGIuVGV4dCkuam9pbignXFxuJyksXG4gICAgdGhyZWFkX3RzOiBpbmZvLmZpbGUuc2hhcmVzLnB1YmxpY1tldmVudC5jaGFubmVsX2lkXVswXS50cyxcbiAgfSk7XG4gIGNvbnNvbGUubG9nKCdQb3N0IG1lc3NhZ2U6ICVqJywgcG9zdE1lc3NhZ2UpO1xufVxuIl19