"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailReceiver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const destinations = require("aws-cdk-lib/aws-lambda-destinations");
const logs = require("aws-cdk-lib/aws-logs");
const s3 = require("aws-cdk-lib/aws-s3");
const ses = require("aws-cdk-lib/aws-ses");
const actions = require("aws-cdk-lib/aws-ses-actions");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const s3_function_1 = require("./s3-function");
const whitelist_function_1 = require("./whitelist-function");
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
class EmailReceiver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const receiptRule = new ses.ReceiptRule(this, 'ReceiptRule', {
            ruleSet: props.receiptRuleSet,
            recipients: props.recipients,
            after: props.afterRule,
            enabled: props.enabled,
        });
        const bucket = new s3.Bucket(this, 'Bucket', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [{ expiration: aws_cdk_lib_1.Duration.days(1) }],
        });
        bucket.grantRead(props.function); // Download email
        const topic = new sns.Topic(this, 'Topic');
        // Actions
        if (props.sourceWhitelist) {
            const whitelistHandler = new whitelist_function_1.WhitelistFunction(this, 'whitelist', {
                environment: {
                    SOURCE_WHITELIST: props.sourceWhitelist,
                },
                logRetention: logs.RetentionDays.ONE_MONTH,
            });
            receiptRule.addAction(new actions.Lambda({
                function: whitelistHandler,
                invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            }));
        }
        receiptRule.addAction(new actions.S3({
            bucket,
            topic,
        }));
        const s3Handler = new s3_function_1.S3Function(this, 's3', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            onSuccess: new destinations.LambdaDestination(props.function, {
                responseOnly: true,
            }),
        });
        topic.addSubscription(new subscriptions.LambdaSubscription(s3Handler)); // Notify
    }
}
exports.EmailReceiver = EmailReceiver;
_a = JSII_RTTI_SYMBOL_1;
EmailReceiver[_a] = { fqn: "cloudstructs.EmailReceiver", version: "0.6.29" };
//# sourceMappingURL=data:application/json;base64,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