import os
from glob import glob

def generate_index_html(savedir, accessdir, indexpath):
    files = glob(os.path.join(savedir, "*.png"))
    generated = ""
    # generated += folder.format(href="/", title="/", size="", date="")
    for f in files:
        generated += file.format(
            href=os.path.basename(f), 
            title=os.path.basename(f), 
            size=os.path.getsize(f), 
            date=os.path.getmtime(f)
        )
    
    with open(indexpath, "w") as i:
        i.write(head + generated + tail)


head = """
<!DOCTYPE html>
<html>
<head>
    <meta charset='utf-8'>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <title>Directory Listing</title>
    <script type="text/javascript" src="/eel.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            outline: 0;
        }

        body {
            padding: 80px 100px;
            font: 13px "Helvetica Neue", "Lucida Grande", "Arial";
            background: #ECE9E9 -webkit-gradient(linear, 0% 0%, 0% 100%, from(#fff), to(#ECE9E9));
            background: #ECE9E9 -moz-linear-gradient(top, #fff, #ECE9E9);
            background-repeat: no-repeat;
            color: #555;
            -webkit-font-smoothing: antialiased;
        }

        h1,
        h2,
        h3 {
            font-size: 22px;
            color: #343434;
        }

        h1 em,
        h2 em {
            padding: 0 5px;
            font-weight: normal;
        }

        h1 {
            font-size: 60px;
        }

        h2 {
            margin-top: 10px;
        }

        h3 {
            margin: 5px 0 10px 0;
            padding-bottom: 5px;
            border-bottom: 1px solid #eee;
            font-size: 18px;
        }

        ul li {
            list-style: none;
        }

        ul li:hover {
            cursor: pointer;
            color: #2e2e2e;
        }

        ul li .path {
            padding-left: 5px;
            font-weight: bold;
        }

        ul li .line {
            padding-right: 5px;
            font-style: italic;
        }

        ul li:first-child .path {
            padding-left: 0;
        }

        p {
            line-height: 1.5;
        }

        a {
            color: #555;
            text-decoration: none;
        }

        a:hover {
            color: #303030;
        }

        #stacktrace {
            margin-top: 15px;
        }

        .directory h1 {
            margin-bottom: 15px;
            font-size: 18px;
        }

        ul#files {
            width: 100%;
            height: 100%;
            overflow: hidden;
        }

        ul#files li {
            float: left;
            width: 30%;
            line-height: 25px;
            margin: 1px;
        }

        ul#files li a {
            display: block;
            height: 25px;
            border: 1px solid transparent;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            overflow: hidden;
            white-space: nowrap;
        }

        ul#files li a:focus,
        ul#files li a:hover {
            background: rgba(255, 255, 255, 0.65);
            border: 1px solid #ececec;
        }

        ul#files li a.highlight {
            -webkit-transition: background .4s ease-in-out;
            background: #ffff4f;
            border-color: #E9DC51;
        }

        #search {
            display: block;
            position: fixed;
            top: 20px;
            right: 20px;
            width: 90px;
            -webkit-transition: width ease 0.2s, opacity ease 0.4s;
            -moz-transition: width ease 0.2s, opacity ease 0.4s;
            -webkit-border-radius: 32px;
            -moz-border-radius: 32px;
            -webkit-box-shadow: inset 0px 0px 3px rgba(0, 0, 0, 0.25), inset 0px 1px 3px rgba(0, 0, 0, 0.7), 0px 1px 0px rgba(255, 255, 255, 0.03);
            -moz-box-shadow: inset 0px 0px 3px rgba(0, 0, 0, 0.25), inset 0px 1px 3px rgba(0, 0, 0, 0.7), 0px 1px 0px rgba(255, 255, 255, 0.03);
            -webkit-font-smoothing: antialiased;
            text-align: left;
            font: 13px "Helvetica Neue", Arial, sans-serif;
            padding: 4px 10px;
            border: none;
            background: transparent;
            margin-bottom: 0;
            outline: none;
            opacity: 0.7;
            color: #888;
        }

        #search:focus {
            width: 120px;
            opacity: 1.0;
        }

        /*views*/
        #files span {
            display: inline-block;
            overflow: hidden;
            text-overflow: ellipsis;
            text-indent: 10px;
        }

        #files .name {
            background-repeat: no-repeat;
        }

        #files .icon .name {
            text-indent: 28px;
        }

        /*tiles*/
        .view-tiles .name {
            width: 100%;
            background-position: 8px 5px;
        }

        .view-tiles .size,
        .view-tiles .date {
            display: none;
        }

        /*details*/
        ul#files.view-details li {
            float: none;
            display: block;
            width: 90%;
        }

        ul#files.view-details li.header {
            height: 25px;
            background: #000;
            color: #fff;
            font-weight: bold;



            border-radius: 5px;
        }

        .view-details .name {
            width: 60%;
            background-position: 8px 5px;
        }

        .view-details .size {
            width: 10%;
        }

        .view-details .date {
            width: 30%;
        }

        .view-details .size,
        .view-details .date {
            text-align: right;
            direction: rtl;
        }

        /*mobile*/
        @media (max-width: 768px) {
            body {
                font-size: 13px;
                line-height: 16px;
                padding: 0;
            }

            #search {
                position: static;
                width: 100%;
                font-size: 2em;
                line-height: 1.8em;
                text-indent: 10px;
                border: 0;
                border-radius: 0;
                padding: 10px 0;
                margin: 0;
            }

            #search:focus {
                width: 100%;
                border: 0;
                opacity: 1;
            }

            .directory h1 {
                font-size: 2em;
                line-height: 1.5em;
                color: #fff;
                background: #000;
                padding: 15px 10px;
                margin: 0;
            }

            ul#files {
                border-top: 1px solid #cacaca;
            }

            ul#files li {
                float: none;
                width: auto !important;
                display: block;
                border-bottom: 1px solid #cacaca;
                font-size: 2em;
                line-height: 1.2em;
                text-indent: 0;
                margin: 0;
            }

            ul#files li:nth-child(odd) {
                background: #e0e0e0;
            }

            ul#files li a {
                height: auto;
                border: 0;
                border-radius: 0;
                padding: 15px 10px;
            }

            ul#files li a:focus,
            ul#files li a:hover {
                border: 0;
            }

            #files .header,
            #files .size,
            #files .date {
                display: none !important;
            }

            #files .name {
                float: none;
                display: inline-block;
                width: 100%;
                text-indent: 0;
                background-position: 0 50%;
            }

            #files .icon .name {
                text-indent: 41px;
            }
        }

        #files .icon-directory .name {
            background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAABGdBTUEAALGPC/xhBQAAAWtQTFRFAAAA/PPQ9Nhc2q402qQ12qs2/PTX2pg12p81+/LM89NE9dto2q82+/fp2rM22qY39d6U+/bo2qo2/frx/vz32q812qs12qE279SU8c4w9NZP+/LK//367s9y7s925cp0/vzw9t92//342po2/vz25s1579B6+OSO2bQ0/v799NyT8tE79dld8Msm+OrC/vzx79KA2IYs7s6I9d6R4cJe9+OF/PLI/fry79OF/v30//328tWB89RJ8c9p8c0u9eCf//7+9txs6sts5Mdr+++5+u2z/vrv+/fq6cFz8dBs8tA57cpq+OaU9uGs27Y8//799NdX/PbY9uB89unJ//z14sNf+emh+emk+vDc+uys9+OL8dJy89NH+eic8tN5+OaV+OWR9N2n9dtl9t529+KF9+GB9Nue9NdU8tR/9t5y89qW9dpj89iO89eG/vvu2pQ12Y4z/vzy2Ict/vvv48dr/vzz4sNg///+2Igty3PqwQAAAAF0Uk5TAEDm2GYAAACtSURBVBjTY2AgA2iYlJWVhfohBPg0yx38y92dS0pKVOVBAqIi6sb2vsWWpfrFeTI8QAEhYQEta28nCwM1OVleZqCAmKCEkUdwYWmhQnFeOStQgL9cySqkNNDHVJGbiY0FKCCuYuYSGRsV5KgjxcXIARRQNncNj09JTgqw0ZbkZAcK5LuFJaRmZqfHeNnpSucDBQoiEtOycnIz4qI9bfUKQA6pKKqAgqIKQyK8BgAZ5yfODmnHrQAAAABJRU5ErkJggg==);
        }

        #files .icon-image .name {
            background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGWSURBVBgZpcE/a1NhGMbh3/OeN56cKq2Dp6AoCOKmk4uCn8DNycEOIojilr2TaBfRzVnESQR3Bz+FFDoWA2IjtkRqmpyc97k9qYl/IQV7XSaJw4g0VlZfP0m13dwepPbuiH85fyhyWCx4/ubxjU6kkdxWHt69VC6XpZlFBAhwJgwJJHAmRKorbj94ewvoRBrbuykvT5R2/+lLTp05Tp45STmEJYJBMAjByILxYeM9jzr3GCczGpHGYAQhRM6fO8uFy1fJQoaUwCKYEcwwC4QQaGUBd36KTDmQ523axTGQmEcIEBORKQfG1ZDxcA/MkBxXwj1ggCQyS9TVAMmZiUxJ8Ln/kS+9PmOvcSW+jrao0mmMH5bzHfa+9UGBmciUBJ+2Fmh1h+yTQCXSkJkdCrpd8btIwwEJQnaEkOXMk7XaiF8CUxL/JdKQOwb0Ntc5SG9zHXQNd/ZFGsaEeLa2ChjzXQcqZiKNxSL0vR4unVwwMENMCATib0ZdV+QtE41I42geXt1Ze3dlMNZFdw6Ut6CIvKBhkjiM79Pyq1YUmtkKAAAAAElFTkSuQmCC);
        }
    </style>
    <script>
        function $(id) {
            var el = 'string' == typeof id
                ? document.getElementById(id)
                : id;

            el.on = function (event, fn) {
                if ('content loaded' == event) {
                    event = window.attachEvent ? "load" : "DOMContentLoaded";
                }
                el.addEventListener
                    ? el.addEventListener(event, fn, false)
                    : el.attachEvent("on" + event, fn);
            };

            el.all = function (selector) {
                return $(el.querySelectorAll(selector));
            };

            el.each = function (fn) {
                for (var i = 0, len = el.length; i < len; ++i) {
                    fn($(el[i]), i);
                }
            };

            el.getClasses = function () {
                return this.getAttribute('class').split(/\s+/);
            };

            el.addClass = function (name) {
                var classes = this.getAttribute('class');
                el.setAttribute('class', classes
                    ? classes + ' ' + name
                    : name);
            };

            el.removeClass = function (name) {
                var classes = this.getClasses().filter(function (curr) {
                    return curr != name;
                });
                this.setAttribute('class', classes.join(' '));
            };

            return el;
        }

        function search() {
            var str = $('search').value.toLowerCase();
            var links = $('files').all('a');

            links.each(function (link) {
                var text = link.textContent.toLowerCase();

                if ('..' == text) return;
                if (str.length && ~text.indexOf(str)) {
                    link.addClass('highlight');
                } else {
                    link.removeClass('highlight');
                }
            });
        }

        $(window).on('content loaded', function () {
            $('search').on('keyup', search);
        });
    </script>
</head>

<body class="directory">
    <input id="search" type="text" placeholder="Search" autocomplete="off" />
    <div id="wrapper">
        <ul id="files" class="view-tiles">
"""


#             <li><a href="/flowiz/gui/web" class="icon icon-directory" title=".."><span class="name">..</span><span
#                         class="size"></span><span class="date"></span></a></li> 
#             
#             <li><a href="/flowiz/gui/web/guitemp/frame_0001.flo.png" class="icon icon icon-png icon-image"
#                     title="frame_0001.flo.png"><span class="name">frame_0001.flo.png</span><span
#                         class="size">103712</span><span class="date">7/20/2019 4:55:33 PM</span></a></li>


folder = """"
            <li><a href="{href}" class="icon icon-directory" title="{title}"><span class="name">{title}</span><span
                        class="size">{size}</span><span class="date">{date}</span></a></li> 
"""

file = """
            <li><a href="{href}" target="_blank" class="icon icon icon-png icon-image"
                    title="{title}"><span class="name">{title}</span><span
                        class="size">{size}</span><span class="date">{date}</span></a></li>
"""

tail = """
        </ul>
        <div class="logo" style="width:100%; text-align: center; margin-top:50px; opacity: 1;">
            <a target="_blank"  href="https://github.com/georgegach/flowiz/stargazers" style="padding: 0 5px;"><img alt="GitHub stars" src="https://img.shields.io/github/stars/georgegach/flowiz.svg?style=social"></a>
            <a target="_blank"  href="https://github.com/georgegach/flowiz/network/members" style="padding: 0 5px;"><img alt="GitHub forks" src="https://img.shields.io/github/forks/georgegach/flowiz.svg?style=social"></a>
            <a target="_blank"  href="https://github.com/georgegach" style="padding: 0 5px;"><img alt="GitHub followers" src="https://img.shields.io/github/followers/georgegach.svg?style=social"></a>
            <a target="_blank"  href="https://github.com/georgegach/flowiz/watchers" style="padding: 0 5px;"><img alt="GitHub watchers" src="https://img.shields.io/github/watchers/georgegach/flowiz.svg?style=social"></a>
            <br /><br />
            <img src="../assets/ubuntu283.png" width="200px" class="" alt="">
        </div>
    </div>
</body>

</html>
"""