from ..........Internal.Core import Core
from ..........Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Tdomain:
	"""Tdomain commands group definition. 3 total commands, 3 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("tdomain", core, parent)

	@property
	def symbol(self):
		"""symbol commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_symbol'):
			from .Tdomain_.Symbol import Symbol
			self._symbol = Symbol(self._core, self._base)
		return self._symbol

	@property
	def chmapping(self):
		"""chmapping commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_chmapping'):
			from .Tdomain_.Chmapping import Chmapping
			self._chmapping = Chmapping(self._core, self._base)
		return self._chmapping

	@property
	def soffset(self):
		"""soffset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_soffset'):
			from .Tdomain_.Soffset import Soffset
			self._soffset = Soffset(self._core, self._base)
		return self._soffset

	def clone(self) -> 'Tdomain':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Tdomain(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
