# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Vehicle(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'datetime',
        'embedded': 'object',
        'links': 'VehicleLinks',
        'brand': 'str',
        'engine': 'list[VehicleEngine]',
        'id': 'str',
        'label': 'str',
        'pictures': 'list[Url]',
        'vin': 'str'
    }

    attribute_map = {
        'created_at': 'createdAt',
        'embedded': '_embedded',
        'links': '_links',
        'brand': 'brand',
        'engine': 'engine',
        'id': 'id',
        'label': 'label',
        'pictures': 'pictures',
        'vin': 'vin'
    }

    def __init__(self, created_at=None, embedded=None, links=None, brand=None, engine=None, id=None, label=None, pictures=None, vin=None):  # noqa: E501
        """Vehicle - a model defined in Swagger"""  # noqa: E501

        self._created_at = None
        self._embedded = None
        self._links = None
        self._brand = None
        self._engine = None
        self._id = None
        self._label = None
        self._pictures = None
        self._vin = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if embedded is not None:
            self.embedded = embedded
        if links is not None:
            self.links = links
        if brand is not None:
            self.brand = brand
        if engine is not None:
            self.engine = engine
        if id is not None:
            self.id = id
        if label is not None:
            self.label = label
        if pictures is not None:
            self.pictures = pictures
        if vin is not None:
            self.vin = vin

    @property
    def created_at(self):
        """Gets the created_at of this Vehicle.  # noqa: E501

        Date when the resource has been created.  # noqa: E501

        :return: The created_at of this Vehicle.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Vehicle.

        Date when the resource has been created.  # noqa: E501

        :param created_at: The created_at of this Vehicle.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def embedded(self):
        """Gets the embedded of this Vehicle.  # noqa: E501


        :return: The embedded of this Vehicle.  # noqa: E501
        :rtype: object
        """
        return self._embedded

    @embedded.setter
    def embedded(self, embedded):
        """Sets the embedded of this Vehicle.


        :param embedded: The embedded of this Vehicle.  # noqa: E501
        :type: object
        """

        self._embedded = embedded

    @property
    def links(self):
        """Gets the links of this Vehicle.  # noqa: E501


        :return: The links of this Vehicle.  # noqa: E501
        :rtype: VehicleLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Vehicle.


        :param links: The links of this Vehicle.  # noqa: E501
        :type: VehicleLinks
        """

        self._links = links

    @property
    def brand(self):
        """Gets the brand of this Vehicle.  # noqa: E501

        Brand of a vehicle  # noqa: E501

        :return: The brand of this Vehicle.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this Vehicle.

        Brand of a vehicle  # noqa: E501

        :param brand: The brand of this Vehicle.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def engine(self):
        """Gets the engine of this Vehicle.  # noqa: E501

        Engine of a vehicle  # noqa: E501

        :return: The engine of this Vehicle.  # noqa: E501
        :rtype: list[VehicleEngine]
        """
        return self._engine

    @engine.setter
    def engine(self, engine):
        """Sets the engine of this Vehicle.

        Engine of a vehicle  # noqa: E501

        :param engine: The engine of this Vehicle.  # noqa: E501
        :type: list[VehicleEngine]
        """

        self._engine = engine

    @property
    def id(self):
        """Gets the id of this Vehicle.  # noqa: E501


        :return: The id of this Vehicle.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Vehicle.


        :param id: The id of this Vehicle.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def label(self):
        """Gets the label of this Vehicle.  # noqa: E501

        Version of a vehicle  # noqa: E501

        :return: The label of this Vehicle.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this Vehicle.

        Version of a vehicle  # noqa: E501

        :param label: The label of this Vehicle.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def pictures(self):
        """Gets the pictures of this Vehicle.  # noqa: E501

        With the links it's possible to see the pictures of the vehicle  # noqa: E501

        :return: The pictures of this Vehicle.  # noqa: E501
        :rtype: list[Url]
        """
        return self._pictures

    @pictures.setter
    def pictures(self, pictures):
        """Sets the pictures of this Vehicle.

        With the links it's possible to see the pictures of the vehicle  # noqa: E501

        :param pictures: The pictures of this Vehicle.  # noqa: E501
        :type: list[Url]
        """

        self._pictures = pictures

    @property
    def vin(self):
        """Gets the vin of this Vehicle.  # noqa: E501

        Vehicle Identification Number  # noqa: E501

        :return: The vin of this Vehicle.  # noqa: E501
        :rtype: str
        """
        return self._vin

    @vin.setter
    def vin(self, vin):
        """Sets the vin of this Vehicle.

        Vehicle Identification Number  # noqa: E501

        :param vin: The vin of this Vehicle.  # noqa: E501
        :type: str
        """

        self._vin = vin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Vehicle, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Vehicle):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
