#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Apr  7 15:44:34 2020

@author: ringbom

This file is part of 'openSpex'
Copyright (c) 2021 Swedish Defence Research Agency (FOI)
"""
import wx

# replace with wx.NewIdRef(count=1) 

OPEN_SAMPLE = wx.NewIdRef(count=1) 
OPEN_GASBK =  wx.NewIdRef(count=1) 
OPEN_DETBK =  wx.NewIdRef(count=1) 
OPEN_QC =  wx.NewIdRef(count=1) 
OPEN_CALIB =  wx.NewIdRef(count=1) 
PRINT_SAMPLE = wx.NewIdRef(count=1) 
PRINT_GASBK =  wx.NewIdRef(count=1) 
PRINT_DETBK = wx.NewIdRef(count=1) 
PRINT_QC = wx.NewIdRef(count=1) 
PRINT_CALIB =  wx.NewIdRef(count=1) 
OPEN_MEAS =  wx.NewIdRef(count=1) 
OPEN_DATASET =  wx.NewIdRef(count=1) 
SAVE_MEAS =  wx.NewIdRef(count=1) 
SAVE_DATASET =  wx.NewIdRef(count=1) 
SAVE_SAMPLE_PHD =  wx.NewIdRef(count=1) 
SAVE_GASBK_PHD =  wx.NewIdRef(count=1) 
SAVE_DETBK_PHD =  wx.NewIdRef(count=1) 
SAVE_QC_PHD =  wx.NewIdRef(count=1) 
SAVE_CALIB_PHD =  wx.NewIdRef(count=1) 
SAVE_CSV = wx.NewIdRef(count=1) 
OPTIONS = wx.NewIdRef(count=1) 
ANALYZE = wx.NewIdRef(count=1) 
CLEAR_MEAS =  wx.NewIdRef(count=1) 
CALC_MSET_FILE =  wx.NewIdRef(count=1) 
CLEAR_MSET = wx.NewIdRef(count=1) 
PLOT_MSET =  wx.NewIdRef(count=1) 
APPEND_MSET =  wx.NewIdRef(count=1) 
COMPARE_MSET =  wx.NewIdRef(count=1) 
MSET_REPORT = wx.NewIdRef(count=1) 
MSET_FREQUENCY = wx.NewIdRef(count=1) 
MSET_MIRC3 = wx.NewIdRef(count=1) 
MSET_MIRC4 = wx.NewIdRef(count=1) 
MSET_UNMARK = wx.NewIdRef(count=1) 
PLOT_XEVOL = wx.NewIdRef(count=1) 
PLOT_XEYIELD = wx.NewIdRef(count=1) 
PLOT_AIRVOL = wx.NewIdRef(count=1) 
PLOT_ERR = wx.NewIdRef(count=1) 
HELP = wx.NewIdRef(count=1) 
ABOUT = wx.NewIdRef(count=1) 
CLEAR_LOG = wx.NewIdRef(count=1) 
SAVE_MEAS_REPORT = wx.NewIdRef(count=1) 
SAVE_MEASSET_REPORT = wx.NewIdRef(count=1) 

class menu(wx.MenuBar):
    """Menu for the GUI 'openSpex'"""
    def __init__(self):
        wx.MenuBar.__init__(self)
        #File menu
        file = wx.Menu()
        Open = wx.Menu()
        self.openMeasurement = Open.Append(OPEN_MEAS, "Measurement (.pkl)")
        self.openDataset = Open.Append(OPEN_DATASET, "Measurement set (.pkl)")
        OpenPHD =wx.Menu()
        self.openSample = OpenPHD.Append(OPEN_SAMPLE, "Sample PHD")
        self.openGasbk = OpenPHD.Append(OPEN_GASBK, "Gasbk PHD")
        self.openDetbk = OpenPHD.Append(OPEN_DETBK, "Detbk PHD")
        self.openQC = OpenPHD.Append(OPEN_QC, "QC PHD")
        self.openCalib = OpenPHD.Append(OPEN_CALIB, "Calib PHD")
        Open.AppendSubMenu(OpenPHD, "PHD")
        file.AppendSubMenu(Open, "Open")
        Save = wx.Menu()
        self.saveMeasurement = Save.Append(SAVE_MEAS, "Measurement (.pkl)")
        self.saveDataset = Save.Append(SAVE_DATASET, "Measurement set (.pkl)")
        self.saveMeasurementReport = Save.Append(SAVE_MEAS_REPORT, "Measurement report")
        self.saveMeasurementsetReport = Save.Append(SAVE_MEASSET_REPORT, "Measurementset report")
        file.AppendSubMenu(Save, "Save")
        
        Export = wx.Menu()
        self.saveDatasetCSV = Export.Append(SAVE_CSV, "Measurement set (.csv)")
        SavePHD = wx.Menu()
        self.saveSamplePHD = SavePHD.Append(SAVE_SAMPLE_PHD, "Sample")
        self.saveGasbkPHD = SavePHD.Append(SAVE_GASBK_PHD, "Gasbk")
        self.saveDetbkPHD = SavePHD.Append(SAVE_DETBK_PHD, "Detbk")
        self.saveQCPHD = SavePHD.Append(SAVE_QC_PHD, "QC")
        self.saveCalibPHD = SavePHD.Append(SAVE_CALIB_PHD, "Calib")
        Export.AppendSubMenu(SavePHD,"PHD")
        file.AppendSubMenu(Export, "Export")
        
        self.clearLog = file.Append(CLEAR_LOG, "Clear Log")
        self.quit = file.Append(wx.ID_EXIT, "Quit\tCtrl+W")
        self.Append(file,"File")
        #Measurement menu
        Mea = wx.Menu()
        self.analyze = Mea.Append(ANALYZE, "BGM analysis")
        PrintPHD =wx.Menu()
        self.printSample = PrintPHD.Append(PRINT_SAMPLE, "Sample")
        self.printGasbk = PrintPHD.Append(PRINT_GASBK, "Gasbk")
        self.printDetbk = PrintPHD.Append(PRINT_DETBK, "Detbk")
        self.printQC = PrintPHD.Append(PRINT_QC, "QC")
        self.printCalib = PrintPHD.Append(PRINT_CALIB, "Calib")
        Mea.AppendSubMenu(PrintPHD, "Print PHD")
        Mea.AppendSeparator()
        self.clearMea = Mea.Append(CLEAR_MEAS, "Clear")
        self.Append(Mea,"Measurement")
        #Measurementset
        MeaSet = wx.Menu()
        self.calcMsetFile = MeaSet.Append(CALC_MSET_FILE, "Calculate")
        self.reportMset = MeaSet.Append(MSET_REPORT, "Report")
        Mea.AppendSeparator()
        self.plotMset = MeaSet.Append(PLOT_MSET, "Timeseries")
        self.appendMset = MeaSet.Append(APPEND_MSET, "Append")
        self.freqMset = MeaSet.Append(MSET_FREQUENCY, "Frequency")
        self.mirc3Mset = MeaSet.Append(MSET_MIRC3, "MIRC3")
        self.mirc4Mset = MeaSet.Append(MSET_MIRC4, "MIRC4")
        PlotParam =wx.Menu()
        self.plotXeVol = PlotParam.AppendCheckItem(PLOT_XEVOL, "Xenon volume")
        self.plotXeYield = PlotParam.AppendCheckItem(PLOT_XEYIELD, "Xenon Yield")
        self.plotAirVol = PlotParam.AppendCheckItem(PLOT_AIRVOL, "Air volume")
        PlotParam.AppendSeparator()
        self.plotErrors = PlotParam.AppendCheckItem(PLOT_ERR, "Show errors")
        MeaSet.AppendSubMenu(PlotParam, "Plot parameter")
        MeaSet.AppendSeparator()
        self.unmarkMset = MeaSet.Append(MSET_UNMARK, "Unmark all")
        self.clearMset = MeaSet.Append(CLEAR_MSET, "Clear")
        self.Append(MeaSet,"Measurementset")
        #Options menu
        Options = wx.Menu()
        self.options = Options.Append(OPTIONS, "Options")
        self.Append(Options,"Options")
        Help = wx.Menu()
        self.help = Help.Append(HELP, "Help")
        self.about = Help.Append(ABOUT, "About")
        self.Append(Help,"Help")