# fuse-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import fuse-python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import fuse-python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import fuse-python
from pprint import pprint
from fuse-python.api import fuse_api
from fuse-python.model.create_asset_report_request import CreateAssetReportRequest
from fuse-python.model.create_asset_report_response import CreateAssetReportResponse
from fuse-python.model.create_link_token_request import CreateLinkTokenRequest
from fuse-python.model.create_link_token_response import CreateLinkTokenResponse
from fuse-python.model.create_session_request import CreateSessionRequest
from fuse-python.model.create_session_response import CreateSessionResponse
from fuse-python.model.delete_financial_connection_response import DeleteFinancialConnectionResponse
from fuse-python.model.exchange_financial_connections_public_token_request import ExchangeFinancialConnectionsPublicTokenRequest
from fuse-python.model.exchange_financial_connections_public_token_response import ExchangeFinancialConnectionsPublicTokenResponse
from fuse-python.model.get_asset_report_request import GetAssetReportRequest
from fuse-python.model.get_asset_report_response import GetAssetReportResponse
from fuse-python.model.get_entity_response import GetEntityResponse
from fuse-python.model.get_financial_connection_response import GetFinancialConnectionResponse
from fuse-python.model.get_financial_connections_account_details_request import GetFinancialConnectionsAccountDetailsRequest
from fuse-python.model.get_financial_connections_account_details_response import GetFinancialConnectionsAccountDetailsResponse
from fuse-python.model.get_financial_connections_accounts_request import GetFinancialConnectionsAccountsRequest
from fuse-python.model.get_financial_connections_accounts_response import GetFinancialConnectionsAccountsResponse
from fuse-python.model.get_financial_connections_balance_request import GetFinancialConnectionsBalanceRequest
from fuse-python.model.get_financial_connections_balance_response import GetFinancialConnectionsBalanceResponse
from fuse-python.model.get_financial_connections_owners_request import GetFinancialConnectionsOwnersRequest
from fuse-python.model.get_financial_connections_owners_response import GetFinancialConnectionsOwnersResponse
from fuse-python.model.get_financial_connections_transactions_request import GetFinancialConnectionsTransactionsRequest
from fuse-python.model.get_financial_connections_transactions_response import GetFinancialConnectionsTransactionsResponse
from fuse-python.model.get_financial_institution_response import GetFinancialInstitutionResponse
from fuse-python.model.get_investment_holdings_request import GetInvestmentHoldingsRequest
from fuse-python.model.get_investment_holdings_response import GetInvestmentHoldingsResponse
from fuse-python.model.get_investment_transactions_request import GetInvestmentTransactionsRequest
from fuse-python.model.get_investment_transactions_response import GetInvestmentTransactionsResponse
from fuse-python.model.get_liabilities_request import GetLiabilitiesRequest
from fuse-python.model.get_liabilities_response import GetLiabilitiesResponse
from fuse-python.model.migrate_financial_connections_token_request import MigrateFinancialConnectionsTokenRequest
from fuse-python.model.migrate_financial_connections_token_response import MigrateFinancialConnectionsTokenResponse
from fuse-python.model.refresh_asset_report_request import RefreshAssetReportRequest
from fuse-python.model.sync_financial_connections_data_response import SyncFinancialConnectionsDataResponse
# Defining the host is optional and defaults to https://sandbox-api.letsfuse.com
# See configuration.py for a list of all supported configuration parameters.
configuration = fuse-python.Configuration(
    host = "https://sandbox-api.letsfuse.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: fuseApiKey
configuration.api_key['fuseApiKey'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['fuseApiKey'] = 'Bearer'

# Configure API key authorization: fuseClientId
configuration.api_key['fuseClientId'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['fuseClientId'] = 'Bearer'


# Enter a context with an instance of the API client
with fuse-python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = fuse_api.FuseApi(api_client)
    create_asset_report_request = CreateAssetReportRequest(
        access_token="access_token_example",
        days_requested=1,
        include_identity=True,
    ) # CreateAssetReportRequest |  (optional)

    try:
        api_response = api_instance.create_asset_report(create_asset_report_request=create_asset_report_request)
        pprint(api_response)
    except fuse-python.ApiException as e:
        print("Exception when calling FuseApi->create_asset_report: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox-api.letsfuse.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FuseApi* | [**create_asset_report**](docs/FuseApi.md#create_asset_report) | **POST** /v1/asset_report/create | 
*FuseApi* | [**create_link_token**](docs/FuseApi.md#create_link_token) | **POST** /v1/link/token | 
*FuseApi* | [**create_session**](docs/FuseApi.md#create_session) | **POST** /v1/session | 
*FuseApi* | [**delete_financial_connection**](docs/FuseApi.md#delete_financial_connection) | **DELETE** /v1/financial_connections/{financial_connection_id_to_delete} | Delete a financial connection
*FuseApi* | [**exchange_financial_connections_public_token**](docs/FuseApi.md#exchange_financial_connections_public_token) | **POST** /v1/financial_connections/public_token/exchange | 
*FuseApi* | [**get_asset_report**](docs/FuseApi.md#get_asset_report) | **POST** /v1/asset_report | 
*FuseApi* | [**get_entity**](docs/FuseApi.md#get_entity) | **GET** /v1/entities/{entity_id} | Get entity
*FuseApi* | [**get_financial_connection**](docs/FuseApi.md#get_financial_connection) | **GET** /v1/financial_connections/{financial_connection_id} | Get financial connection details
*FuseApi* | [**get_financial_connections_account_details**](docs/FuseApi.md#get_financial_connections_account_details) | **POST** /v1/financial_connections/accounts/details | Get account details
*FuseApi* | [**get_financial_connections_accounts**](docs/FuseApi.md#get_financial_connections_accounts) | **POST** /v1/financial_connections/accounts | Get accounts
*FuseApi* | [**get_financial_connections_balances**](docs/FuseApi.md#get_financial_connections_balances) | **POST** /v1/financial_connections/balances | Get balances
*FuseApi* | [**get_financial_connections_owners**](docs/FuseApi.md#get_financial_connections_owners) | **POST** /v1/financial_connections/owners | Get account owners
*FuseApi* | [**get_financial_connections_transactions**](docs/FuseApi.md#get_financial_connections_transactions) | **POST** /v1/financial_connections/transactions | Get transactions
*FuseApi* | [**get_financial_institution**](docs/FuseApi.md#get_financial_institution) | **GET** /v1/financial_connections/institutions/{institution_id} | Get a financial institution
*FuseApi* | [**get_investment_holdings**](docs/FuseApi.md#get_investment_holdings) | **POST** /v1/financial_connections/investments/holdings | Get investment holdings
*FuseApi* | [**get_investment_transactions**](docs/FuseApi.md#get_investment_transactions) | **POST** /v1/financial_connections/investments/transactions | Get investment transactions
*FuseApi* | [**migrate_financial_connection**](docs/FuseApi.md#migrate_financial_connection) | **POST** /v1/financial_connections/migrate | Migrate financial connection
*FuseApi* | [**refresh_asset_report**](docs/FuseApi.md#refresh_asset_report) | **POST** /v1/asset_report/refresh | 
*FuseApi* | [**sync_financial_connections_data**](docs/FuseApi.md#sync_financial_connections_data) | **POST** /v1/financial_connections/sync | Sync financial connections data
*FuseApi* | [**v1_financial_connections_liabilities_post**](docs/FuseApi.md#v1_financial_connections_liabilities_post) | **POST** /v1/financial_connections/liabilities | Get liabilities


## Documentation For Models

 - [AccountSubtype](docs/AccountSubtype.md)
 - [AccountType](docs/AccountType.md)
 - [Aggregator](docs/Aggregator.md)
 - [CountryCode](docs/CountryCode.md)
 - [CreateAssetReportRequest](docs/CreateAssetReportRequest.md)
 - [CreateAssetReportResponse](docs/CreateAssetReportResponse.md)
 - [CreateEntityRequest](docs/CreateEntityRequest.md)
 - [CreateEntityResponse](docs/CreateEntityResponse.md)
 - [CreateLinkTokenRequest](docs/CreateLinkTokenRequest.md)
 - [CreateLinkTokenRequestMx](docs/CreateLinkTokenRequestMx.md)
 - [CreateLinkTokenRequestPlaid](docs/CreateLinkTokenRequestPlaid.md)
 - [CreateLinkTokenResponse](docs/CreateLinkTokenResponse.md)
 - [CreateSessionRequest](docs/CreateSessionRequest.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [Currency](docs/Currency.md)
 - [DeleteFinancialConnectionResponse](docs/DeleteFinancialConnectionResponse.md)
 - [Entity](docs/Entity.md)
 - [ExchangeFinancialConnectionsPublicTokenRequest](docs/ExchangeFinancialConnectionsPublicTokenRequest.md)
 - [ExchangeFinancialConnectionsPublicTokenResponse](docs/ExchangeFinancialConnectionsPublicTokenResponse.md)
 - [FinancialConnectionData](docs/FinancialConnectionData.md)
 - [FinancialConnectionDetails](docs/FinancialConnectionDetails.md)
 - [FinancialConnectionDetailsMx](docs/FinancialConnectionDetailsMx.md)
 - [FinancialConnectionDetailsPlaid](docs/FinancialConnectionDetailsPlaid.md)
 - [FinancialConnectionDetailsTeller](docs/FinancialConnectionDetailsTeller.md)
 - [FinancialConnectionsAccount](docs/FinancialConnectionsAccount.md)
 - [FinancialConnectionsAccountBalance](docs/FinancialConnectionsAccountBalance.md)
 - [FinancialConnectionsAccountCachedBalance](docs/FinancialConnectionsAccountCachedBalance.md)
 - [FinancialConnectionsAccountDetails](docs/FinancialConnectionsAccountDetails.md)
 - [FinancialConnectionsAccountDetailsAch](docs/FinancialConnectionsAccountDetailsAch.md)
 - [FinancialConnectionsAccountInstitution](docs/FinancialConnectionsAccountInstitution.md)
 - [FinancialConnectionsAccountLiability](docs/FinancialConnectionsAccountLiability.md)
 - [FinancialConnectionsAccountLiabilityAllOf](docs/FinancialConnectionsAccountLiabilityAllOf.md)
 - [FinancialConnectionsAccountLiabilityAllOfAprs](docs/FinancialConnectionsAccountLiabilityAllOfAprs.md)
 - [FinancialConnectionsHolding](docs/FinancialConnectionsHolding.md)
 - [FinancialConnectionsInvestmentSecurity](docs/FinancialConnectionsInvestmentSecurity.md)
 - [FinancialConnectionsInvestmentSecurityExchange](docs/FinancialConnectionsInvestmentSecurityExchange.md)
 - [FinancialConnectionsInvestmentTransaction](docs/FinancialConnectionsInvestmentTransaction.md)
 - [FinancialConnectionsOwner](docs/FinancialConnectionsOwner.md)
 - [FinancialConnectionsOwnerAddresses](docs/FinancialConnectionsOwnerAddresses.md)
 - [FinancialConnectionsOwnerData](docs/FinancialConnectionsOwnerData.md)
 - [FinancialConnectionsOwnerEmails](docs/FinancialConnectionsOwnerEmails.md)
 - [FinancialConnectionsOwnerNames](docs/FinancialConnectionsOwnerNames.md)
 - [FinancialConnectionsOwnerPhoneNumbers](docs/FinancialConnectionsOwnerPhoneNumbers.md)
 - [FinancialInstitution](docs/FinancialInstitution.md)
 - [FinancialInstitutionLogo](docs/FinancialInstitutionLogo.md)
 - [FuseApiError](docs/FuseApiError.md)
 - [FuseApiErrorData](docs/FuseApiErrorData.md)
 - [FuseApiWarning](docs/FuseApiWarning.md)
 - [FuseApiWarningData](docs/FuseApiWarningData.md)
 - [FuseApiWarningDataWarnings](docs/FuseApiWarningDataWarnings.md)
 - [GetAssetReportRequest](docs/GetAssetReportRequest.md)
 - [GetAssetReportResponse](docs/GetAssetReportResponse.md)
 - [GetAssetReportResponseReport](docs/GetAssetReportResponseReport.md)
 - [GetAssetReportResponseReportAccounts](docs/GetAssetReportResponseReportAccounts.md)
 - [GetAssetReportResponseReportBalances](docs/GetAssetReportResponseReportBalances.md)
 - [GetAssetReportResponseReportHistoricalBalances](docs/GetAssetReportResponseReportHistoricalBalances.md)
 - [GetEntityResponse](docs/GetEntityResponse.md)
 - [GetFinancialConnectionResponse](docs/GetFinancialConnectionResponse.md)
 - [GetFinancialConnectionsAccountDetailsRequest](docs/GetFinancialConnectionsAccountDetailsRequest.md)
 - [GetFinancialConnectionsAccountDetailsResponse](docs/GetFinancialConnectionsAccountDetailsResponse.md)
 - [GetFinancialConnectionsAccountsRequest](docs/GetFinancialConnectionsAccountsRequest.md)
 - [GetFinancialConnectionsAccountsResponse](docs/GetFinancialConnectionsAccountsResponse.md)
 - [GetFinancialConnectionsBalanceRequest](docs/GetFinancialConnectionsBalanceRequest.md)
 - [GetFinancialConnectionsBalanceRequestOptions](docs/GetFinancialConnectionsBalanceRequestOptions.md)
 - [GetFinancialConnectionsBalanceResponse](docs/GetFinancialConnectionsBalanceResponse.md)
 - [GetFinancialConnectionsOwnersRequest](docs/GetFinancialConnectionsOwnersRequest.md)
 - [GetFinancialConnectionsOwnersResponse](docs/GetFinancialConnectionsOwnersResponse.md)
 - [GetFinancialConnectionsOwnersResponseAccounts](docs/GetFinancialConnectionsOwnersResponseAccounts.md)
 - [GetFinancialConnectionsTransactionsRequest](docs/GetFinancialConnectionsTransactionsRequest.md)
 - [GetFinancialConnectionsTransactionsResponse](docs/GetFinancialConnectionsTransactionsResponse.md)
 - [GetFinancialInstitutionResponse](docs/GetFinancialInstitutionResponse.md)
 - [GetInvestmentHoldingsRequest](docs/GetInvestmentHoldingsRequest.md)
 - [GetInvestmentHoldingsRequestOptions](docs/GetInvestmentHoldingsRequestOptions.md)
 - [GetInvestmentHoldingsResponse](docs/GetInvestmentHoldingsResponse.md)
 - [GetInvestmentTransactionsRequest](docs/GetInvestmentTransactionsRequest.md)
 - [GetInvestmentTransactionsRequestOptions](docs/GetInvestmentTransactionsRequestOptions.md)
 - [GetInvestmentTransactionsResponse](docs/GetInvestmentTransactionsResponse.md)
 - [GetLiabilitiesRequest](docs/GetLiabilitiesRequest.md)
 - [GetLiabilitiesResponse](docs/GetLiabilitiesResponse.md)
 - [MigrateFinancialConnectionsAggregatorConnectionData](docs/MigrateFinancialConnectionsAggregatorConnectionData.md)
 - [MigrateFinancialConnectionsAggregatorConnectionDataMx](docs/MigrateFinancialConnectionsAggregatorConnectionDataMx.md)
 - [MigrateFinancialConnectionsAggregatorConnectionDataPlaid](docs/MigrateFinancialConnectionsAggregatorConnectionDataPlaid.md)
 - [MigrateFinancialConnectionsTokenRequest](docs/MigrateFinancialConnectionsTokenRequest.md)
 - [MigrateFinancialConnectionsTokenRequestEntity](docs/MigrateFinancialConnectionsTokenRequestEntity.md)
 - [MigrateFinancialConnectionsTokenResponse](docs/MigrateFinancialConnectionsTokenResponse.md)
 - [Product](docs/Product.md)
 - [RefreshAssetReportRequest](docs/RefreshAssetReportRequest.md)
 - [SyncFinancialConnectionsDataResponse](docs/SyncFinancialConnectionsDataResponse.md)
 - [SyncTransactionsRequest](docs/SyncTransactionsRequest.md)
 - [SyncTransactionsResponse](docs/SyncTransactionsResponse.md)
 - [SyncTransactionsResponseRemoved](docs/SyncTransactionsResponseRemoved.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionMerchant](docs/TransactionMerchant.md)
 - [UpdateEntityRequest](docs/UpdateEntityRequest.md)
 - [UpdateEntityResponse](docs/UpdateEntityResponse.md)
 - [WebhookEvent](docs/WebhookEvent.md)
 - [WebhookSource](docs/WebhookSource.md)
 - [WebhookType](docs/WebhookType.md)


## Documentation For Authorization


## fuseApiKey

- **Type**: API key
- **API key parameter name**: Fuse-Api-Key
- **Location**: HTTP header


## fuseClientId

- **Type**: API key
- **API key parameter name**: Fuse-Client-Id
- **Location**: HTTP header


## mxApiKey

- **Type**: API key
- **API key parameter name**: Mx-Api-Key
- **Location**: HTTP header


## mxClientId

- **Type**: API key
- **API key parameter name**: Mx-Client-Id
- **Location**: HTTP header


## plaidClientId

- **Type**: API key
- **API key parameter name**: Plaid-Client-Id
- **Location**: HTTP header


## plaidSecret

- **Type**: API key
- **API key parameter name**: Plaid-Secret
- **Location**: HTTP header


## proxyUrlKey

- **Type**: API key
- **API key parameter name**: Proxy-Url
- **Location**: HTTP header


## snaptradeClientId

- **Type**: API key
- **API key parameter name**: Snaptrade-Client-Id
- **Location**: HTTP header


## snaptradeConsumerKey

- **Type**: API key
- **API key parameter name**: Snaptrade-Consumer-Id
- **Location**: HTTP header


## tellerApplicationId

- **Type**: API key
- **API key parameter name**: Teller-Application-Id
- **Location**: HTTP header


## tellerCertificate

- **Type**: API key
- **API key parameter name**: Teller-Certificate
- **Location**: HTTP header


## tellerPrivateKey

- **Type**: API key
- **API key parameter name**: Teller-Private-Key
- **Location**: HTTP header


## tellerSigningSecret

- **Type**: API key
- **API key parameter name**: Teller-Signing-Secret
- **Location**: HTTP header


## tellerTokenSigningKey

- **Type**: API key
- **API key parameter name**: Teller-Token-Signing-Key
- **Location**: HTTP header


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fuse-python.apis and fuse-python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fuse-python.api.default_api import DefaultApi`
- `from fuse-python.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fuse-python
from fuse-python.apis import *
from fuse-python.models import *
```

