# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Document(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, apply_anchor_tabs=None, display=None, document_base64=None, document_fields=None, document_id=None, encrypted_with_key_manager=None, file_extension=None, file_format_hint=None, html_definition=None, include_in_download=None, is_dynamic_xfa=None, is_static_xfa=None, match_boxes=None, name=None, ocr_requests=None, order=None, page_count=None, pages=None, page_sizes=None, password=None, pdf_fields_data=None, pdf_form_field_option=None, pdf_widgets_base64=None, remote_url=None, signer_must_acknowledge=None, signer_must_acknowledge_use_account_default=None, tabs=None, template_locked=None, template_required=None, transform_pdf_fields=None, uri=None):
        """
        Document - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'apply_anchor_tabs': 'str',
            'display': 'str',
            'document_base64': 'str',
            'document_fields': 'list[NameValue]',
            'document_id': 'str',
            'encrypted_with_key_manager': 'str',
            'file_extension': 'str',
            'file_format_hint': 'str',
            'html_definition': 'DocumentHtmlDefinition',
            'include_in_download': 'str',
            'is_dynamic_xfa': 'bool',
            'is_static_xfa': 'bool',
            'match_boxes': 'list[MatchBox]',
            'name': 'str',
            'ocr_requests': 'list[OcrRequest]',
            'order': 'str',
            'page_count': 'str',
            'pages': 'str',
            'page_sizes': 'list[PageSize]',
            'password': 'str',
            'pdf_fields_data': 'str',
            'pdf_form_field_option': 'str',
            'pdf_widgets_base64': 'str',
            'remote_url': 'str',
            'signer_must_acknowledge': 'str',
            'signer_must_acknowledge_use_account_default': 'bool',
            'tabs': 'Tabs',
            'template_locked': 'str',
            'template_required': 'str',
            'transform_pdf_fields': 'str',
            'uri': 'str'
        }

        self.attribute_map = {
            'apply_anchor_tabs': 'applyAnchorTabs',
            'display': 'display',
            'document_base64': 'documentBase64',
            'document_fields': 'documentFields',
            'document_id': 'documentId',
            'encrypted_with_key_manager': 'encryptedWithKeyManager',
            'file_extension': 'fileExtension',
            'file_format_hint': 'fileFormatHint',
            'html_definition': 'htmlDefinition',
            'include_in_download': 'includeInDownload',
            'is_dynamic_xfa': 'isDynamicXfa',
            'is_static_xfa': 'isStaticXfa',
            'match_boxes': 'matchBoxes',
            'name': 'name',
            'ocr_requests': 'ocrRequests',
            'order': 'order',
            'page_count': 'pageCount',
            'pages': 'pages',
            'page_sizes': 'pageSizes',
            'password': 'password',
            'pdf_fields_data': 'pdfFieldsData',
            'pdf_form_field_option': 'pdfFormFieldOption',
            'pdf_widgets_base64': 'pdfWidgetsBase64',
            'remote_url': 'remoteUrl',
            'signer_must_acknowledge': 'signerMustAcknowledge',
            'signer_must_acknowledge_use_account_default': 'signerMustAcknowledgeUseAccountDefault',
            'tabs': 'tabs',
            'template_locked': 'templateLocked',
            'template_required': 'templateRequired',
            'transform_pdf_fields': 'transformPdfFields',
            'uri': 'uri'
        }

        self._apply_anchor_tabs = apply_anchor_tabs
        self._display = display
        self._document_base64 = document_base64
        self._document_fields = document_fields
        self._document_id = document_id
        self._encrypted_with_key_manager = encrypted_with_key_manager
        self._file_extension = file_extension
        self._file_format_hint = file_format_hint
        self._html_definition = html_definition
        self._include_in_download = include_in_download
        self._is_dynamic_xfa = is_dynamic_xfa
        self._is_static_xfa = is_static_xfa
        self._match_boxes = match_boxes
        self._name = name
        self._ocr_requests = ocr_requests
        self._order = order
        self._page_count = page_count
        self._pages = pages
        self._page_sizes = page_sizes
        self._password = password
        self._pdf_fields_data = pdf_fields_data
        self._pdf_form_field_option = pdf_form_field_option
        self._pdf_widgets_base64 = pdf_widgets_base64
        self._remote_url = remote_url
        self._signer_must_acknowledge = signer_must_acknowledge
        self._signer_must_acknowledge_use_account_default = signer_must_acknowledge_use_account_default
        self._tabs = tabs
        self._template_locked = template_locked
        self._template_required = template_required
        self._transform_pdf_fields = transform_pdf_fields
        self._uri = uri

    @property
    def apply_anchor_tabs(self):
        """
        Gets the apply_anchor_tabs of this Document.
        Reserved: TBD

        :return: The apply_anchor_tabs of this Document.
        :rtype: str
        """
        return self._apply_anchor_tabs

    @apply_anchor_tabs.setter
    def apply_anchor_tabs(self, apply_anchor_tabs):
        """
        Sets the apply_anchor_tabs of this Document.
        Reserved: TBD

        :param apply_anchor_tabs: The apply_anchor_tabs of this Document.
        :type: str
        """

        self._apply_anchor_tabs = apply_anchor_tabs

    @property
    def display(self):
        """
        Gets the display of this Document.
        

        :return: The display of this Document.
        :rtype: str
        """
        return self._display

    @display.setter
    def display(self, display):
        """
        Sets the display of this Document.
        

        :param display: The display of this Document.
        :type: str
        """

        self._display = display

    @property
    def document_base64(self):
        """
        Gets the document_base64 of this Document.
        The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.

        :return: The document_base64 of this Document.
        :rtype: str
        """
        return self._document_base64

    @document_base64.setter
    def document_base64(self, document_base64):
        """
        Sets the document_base64 of this Document.
        The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.

        :param document_base64: The document_base64 of this Document.
        :type: str
        """

        self._document_base64 = document_base64

    @property
    def document_fields(self):
        """
        Gets the document_fields of this Document.
        

        :return: The document_fields of this Document.
        :rtype: list[NameValue]
        """
        return self._document_fields

    @document_fields.setter
    def document_fields(self, document_fields):
        """
        Sets the document_fields of this Document.
        

        :param document_fields: The document_fields of this Document.
        :type: list[NameValue]
        """

        self._document_fields = document_fields

    @property
    def document_id(self):
        """
        Gets the document_id of this Document.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this Document.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this Document.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this Document.
        :type: str
        """

        self._document_id = document_id

    @property
    def encrypted_with_key_manager(self):
        """
        Gets the encrypted_with_key_manager of this Document.
        When set to **true**, the document is been already encrypted by the sender for use with the DocuSign Key Manager Security Appliance.  

        :return: The encrypted_with_key_manager of this Document.
        :rtype: str
        """
        return self._encrypted_with_key_manager

    @encrypted_with_key_manager.setter
    def encrypted_with_key_manager(self, encrypted_with_key_manager):
        """
        Sets the encrypted_with_key_manager of this Document.
        When set to **true**, the document is been already encrypted by the sender for use with the DocuSign Key Manager Security Appliance.  

        :param encrypted_with_key_manager: The encrypted_with_key_manager of this Document.
        :type: str
        """

        self._encrypted_with_key_manager = encrypted_with_key_manager

    @property
    def file_extension(self):
        """
        Gets the file_extension of this Document.
        The file extension type of the document. If the document is not a PDF it is converted to a PDF.  

        :return: The file_extension of this Document.
        :rtype: str
        """
        return self._file_extension

    @file_extension.setter
    def file_extension(self, file_extension):
        """
        Sets the file_extension of this Document.
        The file extension type of the document. If the document is not a PDF it is converted to a PDF.  

        :param file_extension: The file_extension of this Document.
        :type: str
        """

        self._file_extension = file_extension

    @property
    def file_format_hint(self):
        """
        Gets the file_format_hint of this Document.
        

        :return: The file_format_hint of this Document.
        :rtype: str
        """
        return self._file_format_hint

    @file_format_hint.setter
    def file_format_hint(self, file_format_hint):
        """
        Sets the file_format_hint of this Document.
        

        :param file_format_hint: The file_format_hint of this Document.
        :type: str
        """

        self._file_format_hint = file_format_hint

    @property
    def html_definition(self):
        """
        Gets the html_definition of this Document.

        :return: The html_definition of this Document.
        :rtype: DocumentHtmlDefinition
        """
        return self._html_definition

    @html_definition.setter
    def html_definition(self, html_definition):
        """
        Sets the html_definition of this Document.

        :param html_definition: The html_definition of this Document.
        :type: DocumentHtmlDefinition
        """

        self._html_definition = html_definition

    @property
    def include_in_download(self):
        """
        Gets the include_in_download of this Document.
        

        :return: The include_in_download of this Document.
        :rtype: str
        """
        return self._include_in_download

    @include_in_download.setter
    def include_in_download(self, include_in_download):
        """
        Sets the include_in_download of this Document.
        

        :param include_in_download: The include_in_download of this Document.
        :type: str
        """

        self._include_in_download = include_in_download

    @property
    def is_dynamic_xfa(self):
        """
        Gets the is_dynamic_xfa of this Document.
        

        :return: The is_dynamic_xfa of this Document.
        :rtype: bool
        """
        return self._is_dynamic_xfa

    @is_dynamic_xfa.setter
    def is_dynamic_xfa(self, is_dynamic_xfa):
        """
        Sets the is_dynamic_xfa of this Document.
        

        :param is_dynamic_xfa: The is_dynamic_xfa of this Document.
        :type: bool
        """

        self._is_dynamic_xfa = is_dynamic_xfa

    @property
    def is_static_xfa(self):
        """
        Gets the is_static_xfa of this Document.
        

        :return: The is_static_xfa of this Document.
        :rtype: bool
        """
        return self._is_static_xfa

    @is_static_xfa.setter
    def is_static_xfa(self, is_static_xfa):
        """
        Sets the is_static_xfa of this Document.
        

        :param is_static_xfa: The is_static_xfa of this Document.
        :type: bool
        """

        self._is_static_xfa = is_static_xfa

    @property
    def match_boxes(self):
        """
        Gets the match_boxes of this Document.
        Matchboxes define areas in a document for document matching when you are creating envelopes. They are only used when you upload and edit a template.   A matchbox consists of 5 elements:  * pageNumber - The document page number  on which the matchbox will appear.  * xPosition - The x position of the matchbox on a page.  * yPosition - The y position of the matchbox on a page. * width - The width of the matchbox.  * height - The height of the matchbox.  

        :return: The match_boxes of this Document.
        :rtype: list[MatchBox]
        """
        return self._match_boxes

    @match_boxes.setter
    def match_boxes(self, match_boxes):
        """
        Sets the match_boxes of this Document.
        Matchboxes define areas in a document for document matching when you are creating envelopes. They are only used when you upload and edit a template.   A matchbox consists of 5 elements:  * pageNumber - The document page number  on which the matchbox will appear.  * xPosition - The x position of the matchbox on a page.  * yPosition - The y position of the matchbox on a page. * width - The width of the matchbox.  * height - The height of the matchbox.  

        :param match_boxes: The match_boxes of this Document.
        :type: list[MatchBox]
        """

        self._match_boxes = match_boxes

    @property
    def name(self):
        """
        Gets the name of this Document.
        

        :return: The name of this Document.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Document.
        

        :param name: The name of this Document.
        :type: str
        """

        self._name = name

    @property
    def ocr_requests(self):
        """
        Gets the ocr_requests of this Document.
        

        :return: The ocr_requests of this Document.
        :rtype: list[OcrRequest]
        """
        return self._ocr_requests

    @ocr_requests.setter
    def ocr_requests(self, ocr_requests):
        """
        Sets the ocr_requests of this Document.
        

        :param ocr_requests: The ocr_requests of this Document.
        :type: list[OcrRequest]
        """

        self._ocr_requests = ocr_requests

    @property
    def order(self):
        """
        Gets the order of this Document.
        

        :return: The order of this Document.
        :rtype: str
        """
        return self._order

    @order.setter
    def order(self, order):
        """
        Sets the order of this Document.
        

        :param order: The order of this Document.
        :type: str
        """

        self._order = order

    @property
    def page_count(self):
        """
        Gets the page_count of this Document.
        

        :return: The page_count of this Document.
        :rtype: str
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count):
        """
        Sets the page_count of this Document.
        

        :param page_count: The page_count of this Document.
        :type: str
        """

        self._page_count = page_count

    @property
    def pages(self):
        """
        Gets the pages of this Document.
        

        :return: The pages of this Document.
        :rtype: str
        """
        return self._pages

    @pages.setter
    def pages(self, pages):
        """
        Sets the pages of this Document.
        

        :param pages: The pages of this Document.
        :type: str
        """

        self._pages = pages

    @property
    def page_sizes(self):
        """
        Gets the page_sizes of this Document.
        

        :return: The page_sizes of this Document.
        :rtype: list[PageSize]
        """
        return self._page_sizes

    @page_sizes.setter
    def page_sizes(self, page_sizes):
        """
        Sets the page_sizes of this Document.
        

        :param page_sizes: The page_sizes of this Document.
        :type: list[PageSize]
        """

        self._page_sizes = page_sizes

    @property
    def password(self):
        """
        Gets the password of this Document.
        

        :return: The password of this Document.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this Document.
        

        :param password: The password of this Document.
        :type: str
        """

        self._password = password

    @property
    def pdf_fields_data(self):
        """
        Gets the pdf_fields_data of this Document.
        

        :return: The pdf_fields_data of this Document.
        :rtype: str
        """
        return self._pdf_fields_data

    @pdf_fields_data.setter
    def pdf_fields_data(self, pdf_fields_data):
        """
        Sets the pdf_fields_data of this Document.
        

        :param pdf_fields_data: The pdf_fields_data of this Document.
        :type: str
        """

        self._pdf_fields_data = pdf_fields_data

    @property
    def pdf_form_field_option(self):
        """
        Gets the pdf_form_field_option of this Document.
        

        :return: The pdf_form_field_option of this Document.
        :rtype: str
        """
        return self._pdf_form_field_option

    @pdf_form_field_option.setter
    def pdf_form_field_option(self, pdf_form_field_option):
        """
        Sets the pdf_form_field_option of this Document.
        

        :param pdf_form_field_option: The pdf_form_field_option of this Document.
        :type: str
        """

        self._pdf_form_field_option = pdf_form_field_option

    @property
    def pdf_widgets_base64(self):
        """
        Gets the pdf_widgets_base64 of this Document.
        

        :return: The pdf_widgets_base64 of this Document.
        :rtype: str
        """
        return self._pdf_widgets_base64

    @pdf_widgets_base64.setter
    def pdf_widgets_base64(self, pdf_widgets_base64):
        """
        Sets the pdf_widgets_base64 of this Document.
        

        :param pdf_widgets_base64: The pdf_widgets_base64 of this Document.
        :type: str
        """

        self._pdf_widgets_base64 = pdf_widgets_base64

    @property
    def remote_url(self):
        """
        Gets the remote_url of this Document.
        The file id from the cloud storage service where the document is located. This information is returned using [ML:GET /folders] or [ML:/folders/{folderid}]. 

        :return: The remote_url of this Document.
        :rtype: str
        """
        return self._remote_url

    @remote_url.setter
    def remote_url(self, remote_url):
        """
        Sets the remote_url of this Document.
        The file id from the cloud storage service where the document is located. This information is returned using [ML:GET /folders] or [ML:/folders/{folderid}]. 

        :param remote_url: The remote_url of this Document.
        :type: str
        """

        self._remote_url = remote_url

    @property
    def signer_must_acknowledge(self):
        """
        Gets the signer_must_acknowledge of this Document.
        

        :return: The signer_must_acknowledge of this Document.
        :rtype: str
        """
        return self._signer_must_acknowledge

    @signer_must_acknowledge.setter
    def signer_must_acknowledge(self, signer_must_acknowledge):
        """
        Sets the signer_must_acknowledge of this Document.
        

        :param signer_must_acknowledge: The signer_must_acknowledge of this Document.
        :type: str
        """

        self._signer_must_acknowledge = signer_must_acknowledge

    @property
    def signer_must_acknowledge_use_account_default(self):
        """
        Gets the signer_must_acknowledge_use_account_default of this Document.
        

        :return: The signer_must_acknowledge_use_account_default of this Document.
        :rtype: bool
        """
        return self._signer_must_acknowledge_use_account_default

    @signer_must_acknowledge_use_account_default.setter
    def signer_must_acknowledge_use_account_default(self, signer_must_acknowledge_use_account_default):
        """
        Sets the signer_must_acknowledge_use_account_default of this Document.
        

        :param signer_must_acknowledge_use_account_default: The signer_must_acknowledge_use_account_default of this Document.
        :type: bool
        """

        self._signer_must_acknowledge_use_account_default = signer_must_acknowledge_use_account_default

    @property
    def tabs(self):
        """
        Gets the tabs of this Document.

        :return: The tabs of this Document.
        :rtype: Tabs
        """
        return self._tabs

    @tabs.setter
    def tabs(self, tabs):
        """
        Sets the tabs of this Document.

        :param tabs: The tabs of this Document.
        :type: Tabs
        """

        self._tabs = tabs

    @property
    def template_locked(self):
        """
        Gets the template_locked of this Document.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :return: The template_locked of this Document.
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """
        Sets the template_locked of this Document.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :param template_locked: The template_locked of this Document.
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """
        Gets the template_required of this Document.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :return: The template_required of this Document.
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """
        Sets the template_required of this Document.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :param template_required: The template_required of this Document.
        :type: str
        """

        self._template_required = template_required

    @property
    def transform_pdf_fields(self):
        """
        Gets the transform_pdf_fields of this Document.
        When set to **true**, PDF form field data is transformed into document tab values when the PDF form field name matches the DocuSign custom tab tabLabel. The resulting PDF form data is also returned in the PDF meta data when requesting the document PDF. See the [ML:Transform PDF Fields] section for more information about how fields are transformed into DocuSign tabs. 

        :return: The transform_pdf_fields of this Document.
        :rtype: str
        """
        return self._transform_pdf_fields

    @transform_pdf_fields.setter
    def transform_pdf_fields(self, transform_pdf_fields):
        """
        Sets the transform_pdf_fields of this Document.
        When set to **true**, PDF form field data is transformed into document tab values when the PDF form field name matches the DocuSign custom tab tabLabel. The resulting PDF form data is also returned in the PDF meta data when requesting the document PDF. See the [ML:Transform PDF Fields] section for more information about how fields are transformed into DocuSign tabs. 

        :param transform_pdf_fields: The transform_pdf_fields of this Document.
        :type: str
        """

        self._transform_pdf_fields = transform_pdf_fields

    @property
    def uri(self):
        """
        Gets the uri of this Document.
        

        :return: The uri of this Document.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this Document.
        

        :param uri: The uri of this Document.
        :type: str
        """

        self._uri = uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
