# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Contact(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, cloud_provider=None, cloud_provider_container_id=None, contact_id=None, contact_phone_numbers=None, contact_uri=None, emails=None, error_details=None, is_owner=None, name=None, organization=None, shared=None, signing_group=None, signing_group_name=None):
        """
        Contact - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'cloud_provider': 'str',
            'cloud_provider_container_id': 'str',
            'contact_id': 'str',
            'contact_phone_numbers': 'list[ContactPhoneNumber]',
            'contact_uri': 'str',
            'emails': 'list[str]',
            'error_details': 'ErrorDetails',
            'is_owner': 'bool',
            'name': 'str',
            'organization': 'str',
            'shared': 'str',
            'signing_group': 'str',
            'signing_group_name': 'str'
        }

        self.attribute_map = {
            'cloud_provider': 'cloudProvider',
            'cloud_provider_container_id': 'cloudProviderContainerId',
            'contact_id': 'contactId',
            'contact_phone_numbers': 'contactPhoneNumbers',
            'contact_uri': 'contactUri',
            'emails': 'emails',
            'error_details': 'errorDetails',
            'is_owner': 'isOwner',
            'name': 'name',
            'organization': 'organization',
            'shared': 'shared',
            'signing_group': 'signingGroup',
            'signing_group_name': 'signingGroupName'
        }

        self._cloud_provider = cloud_provider
        self._cloud_provider_container_id = cloud_provider_container_id
        self._contact_id = contact_id
        self._contact_phone_numbers = contact_phone_numbers
        self._contact_uri = contact_uri
        self._emails = emails
        self._error_details = error_details
        self._is_owner = is_owner
        self._name = name
        self._organization = organization
        self._shared = shared
        self._signing_group = signing_group
        self._signing_group_name = signing_group_name

    @property
    def cloud_provider(self):
        """
        Gets the cloud_provider of this Contact.
        

        :return: The cloud_provider of this Contact.
        :rtype: str
        """
        return self._cloud_provider

    @cloud_provider.setter
    def cloud_provider(self, cloud_provider):
        """
        Sets the cloud_provider of this Contact.
        

        :param cloud_provider: The cloud_provider of this Contact.
        :type: str
        """

        self._cloud_provider = cloud_provider

    @property
    def cloud_provider_container_id(self):
        """
        Gets the cloud_provider_container_id of this Contact.
        

        :return: The cloud_provider_container_id of this Contact.
        :rtype: str
        """
        return self._cloud_provider_container_id

    @cloud_provider_container_id.setter
    def cloud_provider_container_id(self, cloud_provider_container_id):
        """
        Sets the cloud_provider_container_id of this Contact.
        

        :param cloud_provider_container_id: The cloud_provider_container_id of this Contact.
        :type: str
        """

        self._cloud_provider_container_id = cloud_provider_container_id

    @property
    def contact_id(self):
        """
        Gets the contact_id of this Contact.
        

        :return: The contact_id of this Contact.
        :rtype: str
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """
        Sets the contact_id of this Contact.
        

        :param contact_id: The contact_id of this Contact.
        :type: str
        """

        self._contact_id = contact_id

    @property
    def contact_phone_numbers(self):
        """
        Gets the contact_phone_numbers of this Contact.
        

        :return: The contact_phone_numbers of this Contact.
        :rtype: list[ContactPhoneNumber]
        """
        return self._contact_phone_numbers

    @contact_phone_numbers.setter
    def contact_phone_numbers(self, contact_phone_numbers):
        """
        Sets the contact_phone_numbers of this Contact.
        

        :param contact_phone_numbers: The contact_phone_numbers of this Contact.
        :type: list[ContactPhoneNumber]
        """

        self._contact_phone_numbers = contact_phone_numbers

    @property
    def contact_uri(self):
        """
        Gets the contact_uri of this Contact.
        

        :return: The contact_uri of this Contact.
        :rtype: str
        """
        return self._contact_uri

    @contact_uri.setter
    def contact_uri(self, contact_uri):
        """
        Sets the contact_uri of this Contact.
        

        :param contact_uri: The contact_uri of this Contact.
        :type: str
        """

        self._contact_uri = contact_uri

    @property
    def emails(self):
        """
        Gets the emails of this Contact.
        

        :return: The emails of this Contact.
        :rtype: list[str]
        """
        return self._emails

    @emails.setter
    def emails(self, emails):
        """
        Sets the emails of this Contact.
        

        :param emails: The emails of this Contact.
        :type: list[str]
        """

        self._emails = emails

    @property
    def error_details(self):
        """
        Gets the error_details of this Contact.

        :return: The error_details of this Contact.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this Contact.

        :param error_details: The error_details of this Contact.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def is_owner(self):
        """
        Gets the is_owner of this Contact.
        

        :return: The is_owner of this Contact.
        :rtype: bool
        """
        return self._is_owner

    @is_owner.setter
    def is_owner(self, is_owner):
        """
        Sets the is_owner of this Contact.
        

        :param is_owner: The is_owner of this Contact.
        :type: bool
        """

        self._is_owner = is_owner

    @property
    def name(self):
        """
        Gets the name of this Contact.
        

        :return: The name of this Contact.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Contact.
        

        :param name: The name of this Contact.
        :type: str
        """

        self._name = name

    @property
    def organization(self):
        """
        Gets the organization of this Contact.
        

        :return: The organization of this Contact.
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """
        Sets the organization of this Contact.
        

        :param organization: The organization of this Contact.
        :type: str
        """

        self._organization = organization

    @property
    def shared(self):
        """
        Gets the shared of this Contact.
        When set to **true**, this custom tab is shared.

        :return: The shared of this Contact.
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this Contact.
        When set to **true**, this custom tab is shared.

        :param shared: The shared of this Contact.
        :type: str
        """

        self._shared = shared

    @property
    def signing_group(self):
        """
        Gets the signing_group of this Contact.
        

        :return: The signing_group of this Contact.
        :rtype: str
        """
        return self._signing_group

    @signing_group.setter
    def signing_group(self, signing_group):
        """
        Sets the signing_group of this Contact.
        

        :param signing_group: The signing_group of this Contact.
        :type: str
        """

        self._signing_group = signing_group

    @property
    def signing_group_name(self):
        """
        Gets the signing_group_name of this Contact.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :return: The signing_group_name of this Contact.
        :rtype: str
        """
        return self._signing_group_name

    @signing_group_name.setter
    def signing_group_name(self, signing_group_name):
        """
        Sets the signing_group_name of this Contact.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :param signing_group_name: The signing_group_name of this Contact.
        :type: str
        """

        self._signing_group_name = signing_group_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
