# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Agent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, access_code=None, access_code_metadata=None, add_access_code_to_email=None, allow_system_override_for_locked_recipient=None, client_user_id=None, completed_count=None, custom_fields=None, declined_date_time=None, declined_reason=None, delivered_date_time=None, delivery_method=None, delivery_method_metadata=None, designator_id=None, designator_id_guid=None, document_visibility=None, email=None, email_metadata=None, email_notification=None, embedded_recipient_start_url=None, error_details=None, excluded_documents=None, fax_number=None, fax_number_metadata=None, first_name=None, first_name_metadata=None, full_name=None, full_name_metadata=None, id_check_configuration_name=None, id_check_configuration_name_metadata=None, id_check_information_input=None, inherit_email_notification_configuration=None, last_name=None, last_name_metadata=None, locked_recipient_phone_auth_editable=None, locked_recipient_sms_editable=None, name=None, name_metadata=None, note=None, note_metadata=None, phone_authentication=None, recipient_attachments=None, recipient_authentication_status=None, recipient_feature_metadata=None, recipient_id=None, recipient_id_guid=None, recipient_type=None, recipient_type_metadata=None, require_id_lookup=None, require_id_lookup_metadata=None, role_name=None, routing_order=None, routing_order_metadata=None, sent_date_time=None, signed_date_time=None, signing_group_id=None, signing_group_id_metadata=None, signing_group_name=None, signing_group_users=None, sms_authentication=None, social_authentications=None, status=None, status_code=None, suppress_emails=None, template_locked=None, template_required=None, total_tab_count=None, user_id=None):
        """
        Agent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'access_code': 'str',
            'access_code_metadata': 'PropertyMetadata',
            'add_access_code_to_email': 'str',
            'allow_system_override_for_locked_recipient': 'str',
            'client_user_id': 'str',
            'completed_count': 'str',
            'custom_fields': 'list[str]',
            'declined_date_time': 'str',
            'declined_reason': 'str',
            'delivered_date_time': 'str',
            'delivery_method': 'str',
            'delivery_method_metadata': 'PropertyMetadata',
            'designator_id': 'str',
            'designator_id_guid': 'str',
            'document_visibility': 'list[DocumentVisibility]',
            'email': 'str',
            'email_metadata': 'PropertyMetadata',
            'email_notification': 'RecipientEmailNotification',
            'embedded_recipient_start_url': 'str',
            'error_details': 'ErrorDetails',
            'excluded_documents': 'list[str]',
            'fax_number': 'str',
            'fax_number_metadata': 'PropertyMetadata',
            'first_name': 'str',
            'first_name_metadata': 'PropertyMetadata',
            'full_name': 'str',
            'full_name_metadata': 'PropertyMetadata',
            'id_check_configuration_name': 'str',
            'id_check_configuration_name_metadata': 'PropertyMetadata',
            'id_check_information_input': 'IdCheckInformationInput',
            'inherit_email_notification_configuration': 'str',
            'last_name': 'str',
            'last_name_metadata': 'PropertyMetadata',
            'locked_recipient_phone_auth_editable': 'str',
            'locked_recipient_sms_editable': 'str',
            'name': 'str',
            'name_metadata': 'PropertyMetadata',
            'note': 'str',
            'note_metadata': 'PropertyMetadata',
            'phone_authentication': 'RecipientPhoneAuthentication',
            'recipient_attachments': 'list[RecipientAttachment]',
            'recipient_authentication_status': 'AuthenticationStatus',
            'recipient_feature_metadata': 'list[FeatureAvailableMetadata]',
            'recipient_id': 'str',
            'recipient_id_guid': 'str',
            'recipient_type': 'str',
            'recipient_type_metadata': 'PropertyMetadata',
            'require_id_lookup': 'str',
            'require_id_lookup_metadata': 'PropertyMetadata',
            'role_name': 'str',
            'routing_order': 'str',
            'routing_order_metadata': 'PropertyMetadata',
            'sent_date_time': 'str',
            'signed_date_time': 'str',
            'signing_group_id': 'str',
            'signing_group_id_metadata': 'PropertyMetadata',
            'signing_group_name': 'str',
            'signing_group_users': 'list[UserInfo]',
            'sms_authentication': 'RecipientSMSAuthentication',
            'social_authentications': 'list[SocialAuthentication]',
            'status': 'str',
            'status_code': 'str',
            'suppress_emails': 'str',
            'template_locked': 'str',
            'template_required': 'str',
            'total_tab_count': 'str',
            'user_id': 'str'
        }

        self.attribute_map = {
            'access_code': 'accessCode',
            'access_code_metadata': 'accessCodeMetadata',
            'add_access_code_to_email': 'addAccessCodeToEmail',
            'allow_system_override_for_locked_recipient': 'allowSystemOverrideForLockedRecipient',
            'client_user_id': 'clientUserId',
            'completed_count': 'completedCount',
            'custom_fields': 'customFields',
            'declined_date_time': 'declinedDateTime',
            'declined_reason': 'declinedReason',
            'delivered_date_time': 'deliveredDateTime',
            'delivery_method': 'deliveryMethod',
            'delivery_method_metadata': 'deliveryMethodMetadata',
            'designator_id': 'designatorId',
            'designator_id_guid': 'designatorIdGuid',
            'document_visibility': 'documentVisibility',
            'email': 'email',
            'email_metadata': 'emailMetadata',
            'email_notification': 'emailNotification',
            'embedded_recipient_start_url': 'embeddedRecipientStartURL',
            'error_details': 'errorDetails',
            'excluded_documents': 'excludedDocuments',
            'fax_number': 'faxNumber',
            'fax_number_metadata': 'faxNumberMetadata',
            'first_name': 'firstName',
            'first_name_metadata': 'firstNameMetadata',
            'full_name': 'fullName',
            'full_name_metadata': 'fullNameMetadata',
            'id_check_configuration_name': 'idCheckConfigurationName',
            'id_check_configuration_name_metadata': 'idCheckConfigurationNameMetadata',
            'id_check_information_input': 'idCheckInformationInput',
            'inherit_email_notification_configuration': 'inheritEmailNotificationConfiguration',
            'last_name': 'lastName',
            'last_name_metadata': 'lastNameMetadata',
            'locked_recipient_phone_auth_editable': 'lockedRecipientPhoneAuthEditable',
            'locked_recipient_sms_editable': 'lockedRecipientSmsEditable',
            'name': 'name',
            'name_metadata': 'nameMetadata',
            'note': 'note',
            'note_metadata': 'noteMetadata',
            'phone_authentication': 'phoneAuthentication',
            'recipient_attachments': 'recipientAttachments',
            'recipient_authentication_status': 'recipientAuthenticationStatus',
            'recipient_feature_metadata': 'recipientFeatureMetadata',
            'recipient_id': 'recipientId',
            'recipient_id_guid': 'recipientIdGuid',
            'recipient_type': 'recipientType',
            'recipient_type_metadata': 'recipientTypeMetadata',
            'require_id_lookup': 'requireIdLookup',
            'require_id_lookup_metadata': 'requireIdLookupMetadata',
            'role_name': 'roleName',
            'routing_order': 'routingOrder',
            'routing_order_metadata': 'routingOrderMetadata',
            'sent_date_time': 'sentDateTime',
            'signed_date_time': 'signedDateTime',
            'signing_group_id': 'signingGroupId',
            'signing_group_id_metadata': 'signingGroupIdMetadata',
            'signing_group_name': 'signingGroupName',
            'signing_group_users': 'signingGroupUsers',
            'sms_authentication': 'smsAuthentication',
            'social_authentications': 'socialAuthentications',
            'status': 'status',
            'status_code': 'statusCode',
            'suppress_emails': 'suppressEmails',
            'template_locked': 'templateLocked',
            'template_required': 'templateRequired',
            'total_tab_count': 'totalTabCount',
            'user_id': 'userId'
        }

        self._access_code = access_code
        self._access_code_metadata = access_code_metadata
        self._add_access_code_to_email = add_access_code_to_email
        self._allow_system_override_for_locked_recipient = allow_system_override_for_locked_recipient
        self._client_user_id = client_user_id
        self._completed_count = completed_count
        self._custom_fields = custom_fields
        self._declined_date_time = declined_date_time
        self._declined_reason = declined_reason
        self._delivered_date_time = delivered_date_time
        self._delivery_method = delivery_method
        self._delivery_method_metadata = delivery_method_metadata
        self._designator_id = designator_id
        self._designator_id_guid = designator_id_guid
        self._document_visibility = document_visibility
        self._email = email
        self._email_metadata = email_metadata
        self._email_notification = email_notification
        self._embedded_recipient_start_url = embedded_recipient_start_url
        self._error_details = error_details
        self._excluded_documents = excluded_documents
        self._fax_number = fax_number
        self._fax_number_metadata = fax_number_metadata
        self._first_name = first_name
        self._first_name_metadata = first_name_metadata
        self._full_name = full_name
        self._full_name_metadata = full_name_metadata
        self._id_check_configuration_name = id_check_configuration_name
        self._id_check_configuration_name_metadata = id_check_configuration_name_metadata
        self._id_check_information_input = id_check_information_input
        self._inherit_email_notification_configuration = inherit_email_notification_configuration
        self._last_name = last_name
        self._last_name_metadata = last_name_metadata
        self._locked_recipient_phone_auth_editable = locked_recipient_phone_auth_editable
        self._locked_recipient_sms_editable = locked_recipient_sms_editable
        self._name = name
        self._name_metadata = name_metadata
        self._note = note
        self._note_metadata = note_metadata
        self._phone_authentication = phone_authentication
        self._recipient_attachments = recipient_attachments
        self._recipient_authentication_status = recipient_authentication_status
        self._recipient_feature_metadata = recipient_feature_metadata
        self._recipient_id = recipient_id
        self._recipient_id_guid = recipient_id_guid
        self._recipient_type = recipient_type
        self._recipient_type_metadata = recipient_type_metadata
        self._require_id_lookup = require_id_lookup
        self._require_id_lookup_metadata = require_id_lookup_metadata
        self._role_name = role_name
        self._routing_order = routing_order
        self._routing_order_metadata = routing_order_metadata
        self._sent_date_time = sent_date_time
        self._signed_date_time = signed_date_time
        self._signing_group_id = signing_group_id
        self._signing_group_id_metadata = signing_group_id_metadata
        self._signing_group_name = signing_group_name
        self._signing_group_users = signing_group_users
        self._sms_authentication = sms_authentication
        self._social_authentications = social_authentications
        self._status = status
        self._status_code = status_code
        self._suppress_emails = suppress_emails
        self._template_locked = template_locked
        self._template_required = template_required
        self._total_tab_count = total_tab_count
        self._user_id = user_id

    @property
    def access_code(self):
        """
        Gets the access_code of this Agent.
        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.

        :return: The access_code of this Agent.
        :rtype: str
        """
        return self._access_code

    @access_code.setter
    def access_code(self, access_code):
        """
        Sets the access_code of this Agent.
        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.

        :param access_code: The access_code of this Agent.
        :type: str
        """

        self._access_code = access_code

    @property
    def access_code_metadata(self):
        """
        Gets the access_code_metadata of this Agent.

        :return: The access_code_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._access_code_metadata

    @access_code_metadata.setter
    def access_code_metadata(self, access_code_metadata):
        """
        Sets the access_code_metadata of this Agent.

        :param access_code_metadata: The access_code_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._access_code_metadata = access_code_metadata

    @property
    def add_access_code_to_email(self):
        """
        Gets the add_access_code_to_email of this Agent.
        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.

        :return: The add_access_code_to_email of this Agent.
        :rtype: str
        """
        return self._add_access_code_to_email

    @add_access_code_to_email.setter
    def add_access_code_to_email(self, add_access_code_to_email):
        """
        Sets the add_access_code_to_email of this Agent.
        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.

        :param add_access_code_to_email: The add_access_code_to_email of this Agent.
        :type: str
        """

        self._add_access_code_to_email = add_access_code_to_email

    @property
    def allow_system_override_for_locked_recipient(self):
        """
        Gets the allow_system_override_for_locked_recipient of this Agent.
        

        :return: The allow_system_override_for_locked_recipient of this Agent.
        :rtype: str
        """
        return self._allow_system_override_for_locked_recipient

    @allow_system_override_for_locked_recipient.setter
    def allow_system_override_for_locked_recipient(self, allow_system_override_for_locked_recipient):
        """
        Sets the allow_system_override_for_locked_recipient of this Agent.
        

        :param allow_system_override_for_locked_recipient: The allow_system_override_for_locked_recipient of this Agent.
        :type: str
        """

        self._allow_system_override_for_locked_recipient = allow_system_override_for_locked_recipient

    @property
    def client_user_id(self):
        """
        Gets the client_user_id of this Agent.
        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. 

        :return: The client_user_id of this Agent.
        :rtype: str
        """
        return self._client_user_id

    @client_user_id.setter
    def client_user_id(self, client_user_id):
        """
        Sets the client_user_id of this Agent.
        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. 

        :param client_user_id: The client_user_id of this Agent.
        :type: str
        """

        self._client_user_id = client_user_id

    @property
    def completed_count(self):
        """
        Gets the completed_count of this Agent.
        

        :return: The completed_count of this Agent.
        :rtype: str
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """
        Sets the completed_count of this Agent.
        

        :param completed_count: The completed_count of this Agent.
        :type: str
        """

        self._completed_count = completed_count

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this Agent.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :return: The custom_fields of this Agent.
        :rtype: list[str]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this Agent.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :param custom_fields: The custom_fields of this Agent.
        :type: list[str]
        """

        self._custom_fields = custom_fields

    @property
    def declined_date_time(self):
        """
        Gets the declined_date_time of this Agent.
        The date and time the recipient declined the document.

        :return: The declined_date_time of this Agent.
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """
        Sets the declined_date_time of this Agent.
        The date and time the recipient declined the document.

        :param declined_date_time: The declined_date_time of this Agent.
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def declined_reason(self):
        """
        Gets the declined_reason of this Agent.
        The reason the recipient declined the document.

        :return: The declined_reason of this Agent.
        :rtype: str
        """
        return self._declined_reason

    @declined_reason.setter
    def declined_reason(self, declined_reason):
        """
        Sets the declined_reason of this Agent.
        The reason the recipient declined the document.

        :param declined_reason: The declined_reason of this Agent.
        :type: str
        """

        self._declined_reason = declined_reason

    @property
    def delivered_date_time(self):
        """
        Gets the delivered_date_time of this Agent.
        Reserved: For DocuSign use only.

        :return: The delivered_date_time of this Agent.
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """
        Sets the delivered_date_time of this Agent.
        Reserved: For DocuSign use only.

        :param delivered_date_time: The delivered_date_time of this Agent.
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def delivery_method(self):
        """
        Gets the delivery_method of this Agent.
        Reserved: For DocuSign use only.

        :return: The delivery_method of this Agent.
        :rtype: str
        """
        return self._delivery_method

    @delivery_method.setter
    def delivery_method(self, delivery_method):
        """
        Sets the delivery_method of this Agent.
        Reserved: For DocuSign use only.

        :param delivery_method: The delivery_method of this Agent.
        :type: str
        """

        self._delivery_method = delivery_method

    @property
    def delivery_method_metadata(self):
        """
        Gets the delivery_method_metadata of this Agent.

        :return: The delivery_method_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._delivery_method_metadata

    @delivery_method_metadata.setter
    def delivery_method_metadata(self, delivery_method_metadata):
        """
        Sets the delivery_method_metadata of this Agent.

        :param delivery_method_metadata: The delivery_method_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._delivery_method_metadata = delivery_method_metadata

    @property
    def designator_id(self):
        """
        Gets the designator_id of this Agent.
        

        :return: The designator_id of this Agent.
        :rtype: str
        """
        return self._designator_id

    @designator_id.setter
    def designator_id(self, designator_id):
        """
        Sets the designator_id of this Agent.
        

        :param designator_id: The designator_id of this Agent.
        :type: str
        """

        self._designator_id = designator_id

    @property
    def designator_id_guid(self):
        """
        Gets the designator_id_guid of this Agent.
        

        :return: The designator_id_guid of this Agent.
        :rtype: str
        """
        return self._designator_id_guid

    @designator_id_guid.setter
    def designator_id_guid(self, designator_id_guid):
        """
        Sets the designator_id_guid of this Agent.
        

        :param designator_id_guid: The designator_id_guid of this Agent.
        :type: str
        """

        self._designator_id_guid = designator_id_guid

    @property
    def document_visibility(self):
        """
        Gets the document_visibility of this Agent.
        

        :return: The document_visibility of this Agent.
        :rtype: list[DocumentVisibility]
        """
        return self._document_visibility

    @document_visibility.setter
    def document_visibility(self, document_visibility):
        """
        Sets the document_visibility of this Agent.
        

        :param document_visibility: The document_visibility of this Agent.
        :type: list[DocumentVisibility]
        """

        self._document_visibility = document_visibility

    @property
    def email(self):
        """
        Gets the email of this Agent.
        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. 

        :return: The email of this Agent.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this Agent.
        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. 

        :param email: The email of this Agent.
        :type: str
        """

        self._email = email

    @property
    def email_metadata(self):
        """
        Gets the email_metadata of this Agent.

        :return: The email_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._email_metadata

    @email_metadata.setter
    def email_metadata(self, email_metadata):
        """
        Sets the email_metadata of this Agent.

        :param email_metadata: The email_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._email_metadata = email_metadata

    @property
    def email_notification(self):
        """
        Gets the email_notification of this Agent.

        :return: The email_notification of this Agent.
        :rtype: RecipientEmailNotification
        """
        return self._email_notification

    @email_notification.setter
    def email_notification(self, email_notification):
        """
        Sets the email_notification of this Agent.

        :param email_notification: The email_notification of this Agent.
        :type: RecipientEmailNotification
        """

        self._email_notification = email_notification

    @property
    def embedded_recipient_start_url(self):
        """
        Gets the embedded_recipient_start_url of this Agent.
        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` 

        :return: The embedded_recipient_start_url of this Agent.
        :rtype: str
        """
        return self._embedded_recipient_start_url

    @embedded_recipient_start_url.setter
    def embedded_recipient_start_url(self, embedded_recipient_start_url):
        """
        Sets the embedded_recipient_start_url of this Agent.
        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` 

        :param embedded_recipient_start_url: The embedded_recipient_start_url of this Agent.
        :type: str
        """

        self._embedded_recipient_start_url = embedded_recipient_start_url

    @property
    def error_details(self):
        """
        Gets the error_details of this Agent.

        :return: The error_details of this Agent.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this Agent.

        :param error_details: The error_details of this Agent.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def excluded_documents(self):
        """
        Gets the excluded_documents of this Agent.
        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.

        :return: The excluded_documents of this Agent.
        :rtype: list[str]
        """
        return self._excluded_documents

    @excluded_documents.setter
    def excluded_documents(self, excluded_documents):
        """
        Sets the excluded_documents of this Agent.
        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.

        :param excluded_documents: The excluded_documents of this Agent.
        :type: list[str]
        """

        self._excluded_documents = excluded_documents

    @property
    def fax_number(self):
        """
        Gets the fax_number of this Agent.
        Reserved:

        :return: The fax_number of this Agent.
        :rtype: str
        """
        return self._fax_number

    @fax_number.setter
    def fax_number(self, fax_number):
        """
        Sets the fax_number of this Agent.
        Reserved:

        :param fax_number: The fax_number of this Agent.
        :type: str
        """

        self._fax_number = fax_number

    @property
    def fax_number_metadata(self):
        """
        Gets the fax_number_metadata of this Agent.

        :return: The fax_number_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._fax_number_metadata

    @fax_number_metadata.setter
    def fax_number_metadata(self, fax_number_metadata):
        """
        Sets the fax_number_metadata of this Agent.

        :param fax_number_metadata: The fax_number_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._fax_number_metadata = fax_number_metadata

    @property
    def first_name(self):
        """
        Gets the first_name of this Agent.
        The user's first name.  Maximum Length: 50 characters.

        :return: The first_name of this Agent.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this Agent.
        The user's first name.  Maximum Length: 50 characters.

        :param first_name: The first_name of this Agent.
        :type: str
        """

        self._first_name = first_name

    @property
    def first_name_metadata(self):
        """
        Gets the first_name_metadata of this Agent.

        :return: The first_name_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._first_name_metadata

    @first_name_metadata.setter
    def first_name_metadata(self, first_name_metadata):
        """
        Sets the first_name_metadata of this Agent.

        :param first_name_metadata: The first_name_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._first_name_metadata = first_name_metadata

    @property
    def full_name(self):
        """
        Gets the full_name of this Agent.
        

        :return: The full_name of this Agent.
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """
        Sets the full_name of this Agent.
        

        :param full_name: The full_name of this Agent.
        :type: str
        """

        self._full_name = full_name

    @property
    def full_name_metadata(self):
        """
        Gets the full_name_metadata of this Agent.

        :return: The full_name_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._full_name_metadata

    @full_name_metadata.setter
    def full_name_metadata(self, full_name_metadata):
        """
        Sets the full_name_metadata of this Agent.

        :param full_name_metadata: The full_name_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._full_name_metadata = full_name_metadata

    @property
    def id_check_configuration_name(self):
        """
        Gets the id_check_configuration_name of this Agent.
        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.

        :return: The id_check_configuration_name of this Agent.
        :rtype: str
        """
        return self._id_check_configuration_name

    @id_check_configuration_name.setter
    def id_check_configuration_name(self, id_check_configuration_name):
        """
        Sets the id_check_configuration_name of this Agent.
        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.

        :param id_check_configuration_name: The id_check_configuration_name of this Agent.
        :type: str
        """

        self._id_check_configuration_name = id_check_configuration_name

    @property
    def id_check_configuration_name_metadata(self):
        """
        Gets the id_check_configuration_name_metadata of this Agent.

        :return: The id_check_configuration_name_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._id_check_configuration_name_metadata

    @id_check_configuration_name_metadata.setter
    def id_check_configuration_name_metadata(self, id_check_configuration_name_metadata):
        """
        Sets the id_check_configuration_name_metadata of this Agent.

        :param id_check_configuration_name_metadata: The id_check_configuration_name_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._id_check_configuration_name_metadata = id_check_configuration_name_metadata

    @property
    def id_check_information_input(self):
        """
        Gets the id_check_information_input of this Agent.

        :return: The id_check_information_input of this Agent.
        :rtype: IdCheckInformationInput
        """
        return self._id_check_information_input

    @id_check_information_input.setter
    def id_check_information_input(self, id_check_information_input):
        """
        Sets the id_check_information_input of this Agent.

        :param id_check_information_input: The id_check_information_input of this Agent.
        :type: IdCheckInformationInput
        """

        self._id_check_information_input = id_check_information_input

    @property
    def inherit_email_notification_configuration(self):
        """
        Gets the inherit_email_notification_configuration of this Agent.
        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. 

        :return: The inherit_email_notification_configuration of this Agent.
        :rtype: str
        """
        return self._inherit_email_notification_configuration

    @inherit_email_notification_configuration.setter
    def inherit_email_notification_configuration(self, inherit_email_notification_configuration):
        """
        Sets the inherit_email_notification_configuration of this Agent.
        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. 

        :param inherit_email_notification_configuration: The inherit_email_notification_configuration of this Agent.
        :type: str
        """

        self._inherit_email_notification_configuration = inherit_email_notification_configuration

    @property
    def last_name(self):
        """
        Gets the last_name of this Agent.
        

        :return: The last_name of this Agent.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this Agent.
        

        :param last_name: The last_name of this Agent.
        :type: str
        """

        self._last_name = last_name

    @property
    def last_name_metadata(self):
        """
        Gets the last_name_metadata of this Agent.

        :return: The last_name_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._last_name_metadata

    @last_name_metadata.setter
    def last_name_metadata(self, last_name_metadata):
        """
        Sets the last_name_metadata of this Agent.

        :param last_name_metadata: The last_name_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._last_name_metadata = last_name_metadata

    @property
    def locked_recipient_phone_auth_editable(self):
        """
        Gets the locked_recipient_phone_auth_editable of this Agent.
        

        :return: The locked_recipient_phone_auth_editable of this Agent.
        :rtype: str
        """
        return self._locked_recipient_phone_auth_editable

    @locked_recipient_phone_auth_editable.setter
    def locked_recipient_phone_auth_editable(self, locked_recipient_phone_auth_editable):
        """
        Sets the locked_recipient_phone_auth_editable of this Agent.
        

        :param locked_recipient_phone_auth_editable: The locked_recipient_phone_auth_editable of this Agent.
        :type: str
        """

        self._locked_recipient_phone_auth_editable = locked_recipient_phone_auth_editable

    @property
    def locked_recipient_sms_editable(self):
        """
        Gets the locked_recipient_sms_editable of this Agent.
        

        :return: The locked_recipient_sms_editable of this Agent.
        :rtype: str
        """
        return self._locked_recipient_sms_editable

    @locked_recipient_sms_editable.setter
    def locked_recipient_sms_editable(self, locked_recipient_sms_editable):
        """
        Sets the locked_recipient_sms_editable of this Agent.
        

        :param locked_recipient_sms_editable: The locked_recipient_sms_editable of this Agent.
        :type: str
        """

        self._locked_recipient_sms_editable = locked_recipient_sms_editable

    @property
    def name(self):
        """
        Gets the name of this Agent.
        

        :return: The name of this Agent.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Agent.
        

        :param name: The name of this Agent.
        :type: str
        """

        self._name = name

    @property
    def name_metadata(self):
        """
        Gets the name_metadata of this Agent.

        :return: The name_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._name_metadata

    @name_metadata.setter
    def name_metadata(self, name_metadata):
        """
        Sets the name_metadata of this Agent.

        :param name_metadata: The name_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._name_metadata = name_metadata

    @property
    def note(self):
        """
        Gets the note of this Agent.
        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.

        :return: The note of this Agent.
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """
        Sets the note of this Agent.
        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.

        :param note: The note of this Agent.
        :type: str
        """

        self._note = note

    @property
    def note_metadata(self):
        """
        Gets the note_metadata of this Agent.

        :return: The note_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._note_metadata

    @note_metadata.setter
    def note_metadata(self, note_metadata):
        """
        Sets the note_metadata of this Agent.

        :param note_metadata: The note_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._note_metadata = note_metadata

    @property
    def phone_authentication(self):
        """
        Gets the phone_authentication of this Agent.

        :return: The phone_authentication of this Agent.
        :rtype: RecipientPhoneAuthentication
        """
        return self._phone_authentication

    @phone_authentication.setter
    def phone_authentication(self, phone_authentication):
        """
        Sets the phone_authentication of this Agent.

        :param phone_authentication: The phone_authentication of this Agent.
        :type: RecipientPhoneAuthentication
        """

        self._phone_authentication = phone_authentication

    @property
    def recipient_attachments(self):
        """
        Gets the recipient_attachments of this Agent.
        Reserved:

        :return: The recipient_attachments of this Agent.
        :rtype: list[RecipientAttachment]
        """
        return self._recipient_attachments

    @recipient_attachments.setter
    def recipient_attachments(self, recipient_attachments):
        """
        Sets the recipient_attachments of this Agent.
        Reserved:

        :param recipient_attachments: The recipient_attachments of this Agent.
        :type: list[RecipientAttachment]
        """

        self._recipient_attachments = recipient_attachments

    @property
    def recipient_authentication_status(self):
        """
        Gets the recipient_authentication_status of this Agent.

        :return: The recipient_authentication_status of this Agent.
        :rtype: AuthenticationStatus
        """
        return self._recipient_authentication_status

    @recipient_authentication_status.setter
    def recipient_authentication_status(self, recipient_authentication_status):
        """
        Sets the recipient_authentication_status of this Agent.

        :param recipient_authentication_status: The recipient_authentication_status of this Agent.
        :type: AuthenticationStatus
        """

        self._recipient_authentication_status = recipient_authentication_status

    @property
    def recipient_feature_metadata(self):
        """
        Gets the recipient_feature_metadata of this Agent.
        

        :return: The recipient_feature_metadata of this Agent.
        :rtype: list[FeatureAvailableMetadata]
        """
        return self._recipient_feature_metadata

    @recipient_feature_metadata.setter
    def recipient_feature_metadata(self, recipient_feature_metadata):
        """
        Sets the recipient_feature_metadata of this Agent.
        

        :param recipient_feature_metadata: The recipient_feature_metadata of this Agent.
        :type: list[FeatureAvailableMetadata]
        """

        self._recipient_feature_metadata = recipient_feature_metadata

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this Agent.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this Agent.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this Agent.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this Agent.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def recipient_id_guid(self):
        """
        Gets the recipient_id_guid of this Agent.
        

        :return: The recipient_id_guid of this Agent.
        :rtype: str
        """
        return self._recipient_id_guid

    @recipient_id_guid.setter
    def recipient_id_guid(self, recipient_id_guid):
        """
        Sets the recipient_id_guid of this Agent.
        

        :param recipient_id_guid: The recipient_id_guid of this Agent.
        :type: str
        """

        self._recipient_id_guid = recipient_id_guid

    @property
    def recipient_type(self):
        """
        Gets the recipient_type of this Agent.
        

        :return: The recipient_type of this Agent.
        :rtype: str
        """
        return self._recipient_type

    @recipient_type.setter
    def recipient_type(self, recipient_type):
        """
        Sets the recipient_type of this Agent.
        

        :param recipient_type: The recipient_type of this Agent.
        :type: str
        """

        self._recipient_type = recipient_type

    @property
    def recipient_type_metadata(self):
        """
        Gets the recipient_type_metadata of this Agent.

        :return: The recipient_type_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._recipient_type_metadata

    @recipient_type_metadata.setter
    def recipient_type_metadata(self, recipient_type_metadata):
        """
        Sets the recipient_type_metadata of this Agent.

        :param recipient_type_metadata: The recipient_type_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._recipient_type_metadata = recipient_type_metadata

    @property
    def require_id_lookup(self):
        """
        Gets the require_id_lookup of this Agent.
        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. 

        :return: The require_id_lookup of this Agent.
        :rtype: str
        """
        return self._require_id_lookup

    @require_id_lookup.setter
    def require_id_lookup(self, require_id_lookup):
        """
        Sets the require_id_lookup of this Agent.
        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. 

        :param require_id_lookup: The require_id_lookup of this Agent.
        :type: str
        """

        self._require_id_lookup = require_id_lookup

    @property
    def require_id_lookup_metadata(self):
        """
        Gets the require_id_lookup_metadata of this Agent.

        :return: The require_id_lookup_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._require_id_lookup_metadata

    @require_id_lookup_metadata.setter
    def require_id_lookup_metadata(self, require_id_lookup_metadata):
        """
        Sets the require_id_lookup_metadata of this Agent.

        :param require_id_lookup_metadata: The require_id_lookup_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._require_id_lookup_metadata = require_id_lookup_metadata

    @property
    def role_name(self):
        """
        Gets the role_name of this Agent.
        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.

        :return: The role_name of this Agent.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name):
        """
        Sets the role_name of this Agent.
        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.

        :param role_name: The role_name of this Agent.
        :type: str
        """

        self._role_name = role_name

    @property
    def routing_order(self):
        """
        Gets the routing_order of this Agent.
        Specifies the routing order of the recipient in the envelope. 

        :return: The routing_order of this Agent.
        :rtype: str
        """
        return self._routing_order

    @routing_order.setter
    def routing_order(self, routing_order):
        """
        Sets the routing_order of this Agent.
        Specifies the routing order of the recipient in the envelope. 

        :param routing_order: The routing_order of this Agent.
        :type: str
        """

        self._routing_order = routing_order

    @property
    def routing_order_metadata(self):
        """
        Gets the routing_order_metadata of this Agent.

        :return: The routing_order_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._routing_order_metadata

    @routing_order_metadata.setter
    def routing_order_metadata(self, routing_order_metadata):
        """
        Sets the routing_order_metadata of this Agent.

        :param routing_order_metadata: The routing_order_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._routing_order_metadata = routing_order_metadata

    @property
    def sent_date_time(self):
        """
        Gets the sent_date_time of this Agent.
        The date and time the envelope was sent.

        :return: The sent_date_time of this Agent.
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """
        Sets the sent_date_time of this Agent.
        The date and time the envelope was sent.

        :param sent_date_time: The sent_date_time of this Agent.
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signed_date_time(self):
        """
        Gets the signed_date_time of this Agent.
        Reserved: For DocuSign use only. 

        :return: The signed_date_time of this Agent.
        :rtype: str
        """
        return self._signed_date_time

    @signed_date_time.setter
    def signed_date_time(self, signed_date_time):
        """
        Sets the signed_date_time of this Agent.
        Reserved: For DocuSign use only. 

        :param signed_date_time: The signed_date_time of this Agent.
        :type: str
        """

        self._signed_date_time = signed_date_time

    @property
    def signing_group_id(self):
        """
        Gets the signing_group_id of this Agent.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :return: The signing_group_id of this Agent.
        :rtype: str
        """
        return self._signing_group_id

    @signing_group_id.setter
    def signing_group_id(self, signing_group_id):
        """
        Sets the signing_group_id of this Agent.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :param signing_group_id: The signing_group_id of this Agent.
        :type: str
        """

        self._signing_group_id = signing_group_id

    @property
    def signing_group_id_metadata(self):
        """
        Gets the signing_group_id_metadata of this Agent.

        :return: The signing_group_id_metadata of this Agent.
        :rtype: PropertyMetadata
        """
        return self._signing_group_id_metadata

    @signing_group_id_metadata.setter
    def signing_group_id_metadata(self, signing_group_id_metadata):
        """
        Sets the signing_group_id_metadata of this Agent.

        :param signing_group_id_metadata: The signing_group_id_metadata of this Agent.
        :type: PropertyMetadata
        """

        self._signing_group_id_metadata = signing_group_id_metadata

    @property
    def signing_group_name(self):
        """
        Gets the signing_group_name of this Agent.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :return: The signing_group_name of this Agent.
        :rtype: str
        """
        return self._signing_group_name

    @signing_group_name.setter
    def signing_group_name(self, signing_group_name):
        """
        Sets the signing_group_name of this Agent.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :param signing_group_name: The signing_group_name of this Agent.
        :type: str
        """

        self._signing_group_name = signing_group_name

    @property
    def signing_group_users(self):
        """
        Gets the signing_group_users of this Agent.
        A complex type that contains information about users in the signing group.

        :return: The signing_group_users of this Agent.
        :rtype: list[UserInfo]
        """
        return self._signing_group_users

    @signing_group_users.setter
    def signing_group_users(self, signing_group_users):
        """
        Sets the signing_group_users of this Agent.
        A complex type that contains information about users in the signing group.

        :param signing_group_users: The signing_group_users of this Agent.
        :type: list[UserInfo]
        """

        self._signing_group_users = signing_group_users

    @property
    def sms_authentication(self):
        """
        Gets the sms_authentication of this Agent.

        :return: The sms_authentication of this Agent.
        :rtype: RecipientSMSAuthentication
        """
        return self._sms_authentication

    @sms_authentication.setter
    def sms_authentication(self, sms_authentication):
        """
        Sets the sms_authentication of this Agent.

        :param sms_authentication: The sms_authentication of this Agent.
        :type: RecipientSMSAuthentication
        """

        self._sms_authentication = sms_authentication

    @property
    def social_authentications(self):
        """
        Gets the social_authentications of this Agent.
         Lists the social ID type that can be used for recipient authentication.

        :return: The social_authentications of this Agent.
        :rtype: list[SocialAuthentication]
        """
        return self._social_authentications

    @social_authentications.setter
    def social_authentications(self, social_authentications):
        """
        Sets the social_authentications of this Agent.
         Lists the social ID type that can be used for recipient authentication.

        :param social_authentications: The social_authentications of this Agent.
        :type: list[SocialAuthentication]
        """

        self._social_authentications = social_authentications

    @property
    def status(self):
        """
        Gets the status of this Agent.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this Agent.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Agent.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this Agent.
        :type: str
        """

        self._status = status

    @property
    def status_code(self):
        """
        Gets the status_code of this Agent.
        

        :return: The status_code of this Agent.
        :rtype: str
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """
        Sets the status_code of this Agent.
        

        :param status_code: The status_code of this Agent.
        :type: str
        """

        self._status_code = status_code

    @property
    def suppress_emails(self):
        """
        Gets the suppress_emails of this Agent.
        

        :return: The suppress_emails of this Agent.
        :rtype: str
        """
        return self._suppress_emails

    @suppress_emails.setter
    def suppress_emails(self, suppress_emails):
        """
        Sets the suppress_emails of this Agent.
        

        :param suppress_emails: The suppress_emails of this Agent.
        :type: str
        """

        self._suppress_emails = suppress_emails

    @property
    def template_locked(self):
        """
        Gets the template_locked of this Agent.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :return: The template_locked of this Agent.
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """
        Sets the template_locked of this Agent.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :param template_locked: The template_locked of this Agent.
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """
        Gets the template_required of this Agent.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :return: The template_required of this Agent.
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """
        Sets the template_required of this Agent.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :param template_required: The template_required of this Agent.
        :type: str
        """

        self._template_required = template_required

    @property
    def total_tab_count(self):
        """
        Gets the total_tab_count of this Agent.
        

        :return: The total_tab_count of this Agent.
        :rtype: str
        """
        return self._total_tab_count

    @total_tab_count.setter
    def total_tab_count(self, total_tab_count):
        """
        Sets the total_tab_count of this Agent.
        

        :param total_tab_count: The total_tab_count of this Agent.
        :type: str
        """

        self._total_tab_count = total_tab_count

    @property
    def user_id(self):
        """
        Gets the user_id of this Agent.
        

        :return: The user_id of this Agent.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Agent.
        

        :param user_id: The user_id of this Agent.
        :type: str
        """

        self._user_id = user_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
