/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class HandJiggle {
    private final Collection<Point2D> points = new ArrayList<Point2D>();
    private double startX;
    private double startY;
    private final double defaultVariation;
    private final Random rnd;

    private double randomMe() {
        return this.rnd.nextDouble();
    }

    public HandJiggle(double startX, double startY, double defaultVariation, Random rnd) {
        this.startX = startX;
        this.startY = startY;
        this.defaultVariation = defaultVariation;
        this.rnd = rnd;
        this.points.add(new Point2D.Double(startX, startY));
    }

    public HandJiggle(Point2D start, double defaultVariation, Random rnd) {
        this(start.getX(), start.getY(), defaultVariation, rnd);
    }

    public void lineTo(Point2D end) {
        this.lineTo(end.getX(), end.getY());
    }

    public void arcTo(double angle0, double angle1, double centerX, double centerY, double rx, double ry) {
        this.lineTo(HandJiggle.pointOnCircle(centerX, centerY, (angle0 + angle1) / 2.0, rx, ry));
        this.lineTo(HandJiggle.pointOnCircle(centerX, centerY, angle1, rx, ry));
    }

    private static Point2D pointOnCircle(double centerX, double centerY, double angle, double rx, double ry) {
        double x = centerX + Math.cos(angle) * rx;
        double y = centerY + Math.sin(angle) * ry;
        return new Point2D.Double(x, y);
    }

    public void lineTo(double endX, double endY) {
        double diffY;
        double diffX = Math.abs(endX - this.startX);
        double distance = Math.sqrt(diffX * diffX + (diffY = Math.abs(endY - this.startY)) * diffY);
        if (distance < 0.001) {
            return;
        }
        int segments = (int)Math.round(distance / 10.0);
        double variation = this.defaultVariation;
        if (segments < 5) {
            segments = 5;
            variation /= 3.0;
        }
        double stepX = Math.signum(endX - this.startX) * diffX / (double)segments;
        double stepY = Math.signum(endY - this.startY) * diffY / (double)segments;
        double fx = diffX / distance;
        double fy = diffY / distance;
        for (int s = 0; s < segments; ++s) {
            double x = stepX * (double)s + this.startX;
            double y = stepY * (double)s + this.startY;
            double offset = (this.randomMe() - 0.5) * variation;
            this.points.add(new Point2D.Double(x - offset * fy, y - offset * fx));
        }
        this.points.add(new Point2D.Double(endX, endY));
        this.startX = endX;
        this.startY = endY;
    }

    public void curveTo(CubicCurve2D curve) {
        double flatness = curve.getFlatness();
        double dist = curve.getP1().distance(curve.getP2());
        if (flatness > 0.1 && dist > 20.0) {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            curve.subdivide(left, right);
            this.curveTo(left);
            this.curveTo(right);
            return;
        }
        this.lineTo(curve.getP2());
    }

    public UPolygon toUPolygon() {
        UPolygon result = new UPolygon();
        for (Point2D p : this.points) {
            result.addPoint(p.getX(), p.getY());
        }
        return result;
    }

    public UPath toUPath() {
        UPath path = null;
        for (Point2D p : this.points) {
            if (path == null) {
                path = new UPath();
                path.moveTo(p);
                continue;
            }
            path.lineTo(p);
        }
        if (path == null) {
            throw new IllegalStateException();
        }
        return path;
    }

    public void appendTo(UPath result) {
        for (Point2D p : this.points) {
            result.lineTo(p);
        }
    }
}

