/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.ctreber.acearth.util;

import java.util.HashSet;
import java.util.StringTokenizer;

public class Toolkit {
    public static final double TWOPI = Math.PI * 2;
    public static final double PI = Math.PI;
    public static final double HALFPI = 1.5707963267948966;
    private static final HashSet fsNoCap = new HashSet();

    public static double degsToRads(double pDegrees) {
        return pDegrees * (Math.PI * 2) / 360.0;
    }

    public static double radsToDegs(double pRadians) {
        return pRadians * 360.0 / (Math.PI * 2);
    }

    public static double limitRads(double x) {
        return Toolkit.fmod(x, -Math.PI, Math.PI);
    }

    public static double fmod(double pValue, double pMod) {
        while (pValue < 0.0) {
            pValue += pMod;
        }
        while (pValue > pMod) {
            pValue -= pMod;
        }
        return pValue;
    }

    public static double fmod(double pValue, double pMinValue, double pMaxValue) {
        double lRange = pMaxValue - pMinValue;
        int lFact = (int)((pValue - pMinValue) / lRange);
        if (pValue < pMinValue) {
            --lFact;
        }
        return pValue - (double)lFact * lRange;
    }

    public static String intelligentCapitalize(String pText) {
        boolean lDoCap = false;
        StringTokenizer lST = new StringTokenizer(pText, ".- ", true);
        StringBuffer lSB = new StringBuffer(50);
        while (lST.hasMoreTokens()) {
            String lWord = lST.nextToken();
            if (lWord.equals(".") || lWord.equals("-")) {
                lDoCap = true;
                lSB.append(lWord);
                continue;
            }
            if (lWord.equals(" ")) {
                lDoCap = false;
                lSB.append(lWord);
                continue;
            }
            if (lDoCap || lWord.length() > 3) {
                lSB.append(Character.toUpperCase(lWord.charAt(0)));
                lSB.append(lWord.substring(1).toLowerCase());
                continue;
            }
            if (fsNoCap.contains(lWord.toLowerCase())) {
                lSB.append(lWord.toLowerCase());
                continue;
            }
            lSB.append(lWord.toUpperCase());
        }
        return lSB.toString();
    }

    static {
        fsNoCap.add("a");
        fsNoCap.add("as");
        fsNoCap.add("to");
        fsNoCap.add("of");
        fsNoCap.add("the");
        fsNoCap.add("off");
        fsNoCap.add("and");
        fsNoCap.add("mid");
    }
}

