# coding: utf-8

"""
    Klaviyo API

    Empowering creators to own their destiny  # noqa: E501

    OpenAPI spec version: 2021.11.26
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ListsSegmentsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_members(self, list_id, **kwargs):  # noqa: E501
        """Add Members to a List  # noqa: E501

        Adds profiles to a list. This endpoint is functionally equivalent to adding profiles to a list via a CSV upload and will immediately add profiles to the list. If you would like to subscribe profiles to a list and use the double opt-in settings for the list, please use the subscribe endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_members(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdMembersBody body:
        :return: list[InlineResponse2007]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_members_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_members_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def add_members_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Add Members to a List  # noqa: E501

        Adds profiles to a list. This endpoint is functionally equivalent to adding profiles to a list via a CSV upload and will immediately add profiles to the list. If you would like to subscribe profiles to a list and use the double opt-in settings for the list, please use the subscribe endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_members_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdMembersBody body:
        :return: list[InlineResponse2007]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `add_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2007]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_list(self, **kwargs):  # noqa: E501
        """Create List  # noqa: E501

        Creates a new list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_name:
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_list_with_http_info(self, **kwargs):  # noqa: E501
        """Create List  # noqa: E501

        Creates a new list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_name:
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'list_name' in params:
            form_params.append(('list_name', params['list_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_list(self, list_id, **kwargs):  # noqa: E501
        """Delete List  # noqa: E501

        Deletes a list from an account. This is a destructive operation and cannot be undone. It will also remove flow triggers associated with the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_list(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_list_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_list_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def delete_list_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Delete List  # noqa: E501

        Deletes a list from an account. This is a destructive operation and cannot be undone. It will also remove flow triggers associated with the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_list_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exclude_globally(self, **kwargs):  # noqa: E501
        """Exclude Profile From All Email  # noqa: E501

        Marks a person as excluded from all email. This works the same way as manually excluding someone via the excluded people page. Someone who is excluded will no longer receive any campaigns or flow emails. Keep in mind, there is currently no API to un-exclude someone. In order to remove this block, you must manually remove someone from the unsubscribed list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exclude_globally(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email:
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.exclude_globally_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.exclude_globally_with_http_info(**kwargs)  # noqa: E501
            return data

    def exclude_globally_with_http_info(self, **kwargs):  # noqa: E501
        """Exclude Profile From All Email  # noqa: E501

        Marks a person as excluded from all email. This works the same way as manually excluding someone via the excluded people page. Someone who is excluded will no longer receive any campaigns or flow emails. Keep in mind, there is currently no API to un-exclude someone. In order to remove this block, you must manually remove someone from the unsubscribed list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exclude_globally_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email:
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exclude_globally" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'email' in params:
            form_params.append(('email', params['email']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/people/exclusions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2002',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_global_exclusions(self, **kwargs):  # noqa: E501
        """Get Global Exclusions & Unsubscribes  # noqa: E501

        Returns global exclusions/unsubscribes. Global exclusions are distinct from list exclusions in that these email addresses will not receive any emails from any list. Typically, when someone unsubscribes from a campaign, they are only unsubscribed from that list and are not globally unsubscribed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_global_exclusions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason: Filter results based on the reason for someone being excluded. The possible values are `unsubscribed`, `bounced`, `invalid_email`, `reported_spam` and `manually_excluded`. Only a single value may be specified at a time. Defaults to return all profiles regardless of reason.
        :param str sort: Sort order to apply to results, either ascending or descending. Valid values are `asc` or `desc`. Defaults to `asc`.
        :param int count: For pagination, the number of results to return. Default = 500
        :param int page: For pagination, which page of results to return. Default = 0
        :return: GlobalExclusionResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_global_exclusions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_global_exclusions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_global_exclusions_with_http_info(self, **kwargs):  # noqa: E501
        """Get Global Exclusions & Unsubscribes  # noqa: E501

        Returns global exclusions/unsubscribes. Global exclusions are distinct from list exclusions in that these email addresses will not receive any emails from any list. Typically, when someone unsubscribes from a campaign, they are only unsubscribed from that list and are not globally unsubscribed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_global_exclusions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason: Filter results based on the reason for someone being excluded. The possible values are `unsubscribed`, `bounced`, `invalid_email`, `reported_spam` and `manually_excluded`. Only a single value may be specified at a time. Defaults to return all profiles regardless of reason.
        :param str sort: Sort order to apply to results, either ascending or descending. Valid values are `asc` or `desc`. Defaults to `asc`.
        :param int count: For pagination, the number of results to return. Default = 500
        :param int page: For pagination, which page of results to return. Default = 0
        :return: GlobalExclusionResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reason', 'sort', 'count', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_global_exclusions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'reason' in params:
            query_params.append(('reason', params['reason']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/people/exclusions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GlobalExclusionResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_exclusions(self, list_id, **kwargs):  # noqa: E501
        """Get All Exclusions for a List  # noqa: E501

        Gets all of the emails and phone numbers that have been excluded from a list along with the exclusion reasons and exclusion time. This endpoint uses batching to return the records, so for a large list multiple calls will need to be made to get all of the records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_exclusions(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param int marker: A marker value returned by a previous GET call. Use this to grab the next batch of records.
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_exclusions_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_exclusions_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_exclusions_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Get All Exclusions for a List  # noqa: E501

        Gets all of the emails and phone numbers that have been excluded from a list along with the exclusion reasons and exclusion time. This endpoint uses batching to return the records, so for a large list multiple calls will need to be made to get all of the records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_exclusions_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param int marker: A marker value returned by a previous GET call. Use this to grab the next batch of records.
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'marker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_exclusions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_exclusions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []
        if 'marker' in params:
            query_params.append(('marker', params['marker']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/exclusions/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2008',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_info(self, list_id, **kwargs):  # noqa: E501
        """Get List Info  # noqa: E501

        Returns information about a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_info_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_info_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_info_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Get List Info  # noqa: E501

        Returns information about a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_info_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_members(self, list_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a List  # noqa: E501

        Checks if one or more emails, phone numbers, or push tokens are in a given list. No distinction is made between a person not being in a given list, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_members(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_members_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_members_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_members_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a List  # noqa: E501

        Checks if one or more emails, phone numbers, or push tokens are in a given list. No distinction is made between a person not being in a given list, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_members_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/get-members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckMembershipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_subscriptions(self, list_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a List and not Suppressed  # noqa: E501

        Checks if one or more emails are in a given list and not suppressed. No distinction is made between a person not being in a given list, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_subscriptions(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_subscriptions_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_subscriptions_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_subscriptions_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a List and not Suppressed  # noqa: E501

        Checks if one or more emails are in a given list and not suppressed. No distinction is made between a person not being in a given list, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_subscriptions_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_subscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/get-list-subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckMembershipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lists(self, **kwargs):  # noqa: E501
        """Get Lists  # noqa: E501

        Returns a listing of all of the lists in an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_lists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_lists_with_http_info(self, **kwargs):  # noqa: E501
        """Get Lists  # noqa: E501

        Returns a listing of all of the lists in an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lists" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2003]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_members(self, list_or_segment_id, **kwargs):  # noqa: E501
        """Get List and Segment Members  # noqa: E501

        Gets all of the emails, phone numbers, and push tokens for profiles in a given list or segment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_members(list_or_segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_or_segment_id: (required)
        :param int marker: A marker value returned by a previous GET call. Use this to grab the next batch of records.
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_members_with_http_info(list_or_segment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_members_with_http_info(list_or_segment_id, **kwargs)  # noqa: E501
            return data

    def get_members_with_http_info(self, list_or_segment_id, **kwargs):  # noqa: E501
        """Get List and Segment Members  # noqa: E501

        Gets all of the emails, phone numbers, and push tokens for profiles in a given list or segment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_members_with_http_info(list_or_segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_or_segment_id: (required)
        :param int marker: A marker value returned by a previous GET call. Use this to grab the next batch of records.
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_or_segment_id', 'marker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_or_segment_id' is set
        if ('list_or_segment_id' not in params or
                params['list_or_segment_id'] is None):
            raise ValueError("Missing the required parameter `list_or_segment_id` when calling `get_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_or_segment_id' in params:
            path_params['list_or_segment_id'] = params['list_or_segment_id']  # noqa: E501

        query_params = []
        if 'marker' in params:
            query_params.append(('marker', params['marker']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{list_or_segment_id}/members/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2009',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_segment_members(self, segment_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a Segment  # noqa: E501

        Checks if one or more emails, phone numbers, or push tokens are in a given segment. No distinction is made between a person not being in a given segment, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_segment_members(segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_segment_members_with_http_info(segment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_segment_members_with_http_info(segment_id, **kwargs)  # noqa: E501
            return data

    def get_segment_members_with_http_info(self, segment_id, **kwargs):  # noqa: E501
        """Check if Profiles Are in a Segment  # noqa: E501

        Checks if one or more emails, phone numbers, or push tokens are in a given segment. No distinction is made between a person not being in a given segment, and not being present in Klaviyo at all. Can check up to a maximum of 100 emails at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_segment_members_with_http_info(segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment_id: (required)
        :param CheckMembershipRequest body:
        :return: CheckMembershipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_segment_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params or
                params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `get_segment_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'segment_id' in params:
            path_params['segment_id'] = params['segment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/segment/{segment_id}/get-members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckMembershipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_members(self, list_id, **kwargs):  # noqa: E501
        """Remove Profiles From List  # noqa: E501

        Removes profiles from a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_members(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdMembersBody1 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_members_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_members_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def remove_members_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Remove Profiles From List  # noqa: E501

        Removes profiles from a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_members_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdMembersBody1 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `remove_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/members', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscribe(self, list_id, **kwargs):  # noqa: E501
        """Subscribe Profiles to List  # noqa: E501

        Subscribes profiles to a list. Profiles will be single or double opted into the specified list in accordance with that list’s settings. **Note:** If you have double opt-in enabled (default behavior), users will not be added to list until they opt-in, and so API will respond with an empty list: `[]`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdSubscribeBody body:
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscribe_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.subscribe_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def subscribe_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Subscribe Profiles to List  # noqa: E501

        Subscribes profiles to a list. Profiles will be single or double opted into the specified list in accordance with that list’s settings. **Note:** If you have double opt-in enabled (default behavior), users will not be added to list until they opt-in, and so API will respond with an empty list: `[]`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param ListIdSubscribeBody body:
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `subscribe`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/subscribe', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unsubscribe(self, list_id, **kwargs):  # noqa: E501
        """Unsubscribe Profiles From List  # noqa: E501

        Unsubscribes and removes profiles from a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param dict(str, object) body: Unsubscribe and remove profiles from a list.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unsubscribe_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unsubscribe_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def unsubscribe_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Unsubscribe Profiles From List  # noqa: E501

        Unsubscribes and removes profiles from a list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param dict(str, object) body: Unsubscribe and remove profiles from a list.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsubscribe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `unsubscribe`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}/subscribe', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_list_name(self, list_id, **kwargs):  # noqa: E501
        """Update List Name  # noqa: E501

        Updates a list's name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_list_name(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param str list_name:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_list_name_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_list_name_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def update_list_name_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Update List Name  # noqa: E501

        Updates a list's name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_list_name_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: (required)
        :param str list_name:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'list_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_list_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `update_list_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'list_name' in params:
            form_params.append(('list_name', params['list_name']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/list/{list_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
