# swagger-client
Empowering creators to own their destiny

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2021.11.26
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 

try:
    # Cancel a Campaign
    api_response = api_instance.cancel_campaign(campaign_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->cancel_campaign: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 
name = 'name_example' # str |  (optional)
list_id = 'list_id_example' # str |  (optional)

try:
    # Clone a Campaign
    api_response = api_instance.clone_campaign(campaign_id, name=name, list_id=list_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->clone_campaign: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
list_id = 'list_id_example' # str |  (optional)
template_id = 'template_id_example' # str |  (optional)
from_email = 'from_email_example' # str |  (optional)
from_name = 'from_name_example' # str |  (optional)
subject = 'subject_example' # str |  (optional)
name = 'name_example' # str |  (optional)
use_smart_sending = true # bool |  (optional)
add_google_analytics = true # bool |  (optional)

try:
    # Create New Campaign
    api_response = api_instance.create_campaign(list_id=list_id, template_id=template_id, from_email=from_email, from_name=from_name, subject=subject, name=name, use_smart_sending=use_smart_sending, add_google_analytics=add_google_analytics)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->create_campaign: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 

try:
    # Get Campaign Info
    api_response = api_instance.get_campaign_info(campaign_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->get_campaign_info: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 
count = 5000 # int | For pagination, the number of results to return. Max = 25,000 (optional) (default to 5000)
sort = 'asc' # str | Sort order to apply to results, either ascending or descending. Valid values are `asc` or `desc`. Defaults to `asc`. (optional) (default to asc)
offset = 'offset_example' # str | For pagination, if a response to this endpoint includes a `next_offset`, use that value to get the next page of recipients. (optional)

try:
    # Get Campaign Recipients
    api_response = api_instance.get_campaign_recipients(campaign_id, count=count, sort=sort, offset=offset)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->get_campaign_recipients: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
page = 0 # int | For pagination, which page of results to return. Default = 0 (optional) (default to 0)
count = 50 # int | For pagination, the number of results to return. Max = 100 (optional) (default to 50)

try:
    # Get Campaigns
    api_response = api_instance.get_campaigns(page=page, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->get_campaigns: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 
send_time = 'send_time_example' # str |  (optional)

try:
    # Schedule a Campaign
    api_response = api_instance.schedule_campaign(campaign_id, send_time=send_time)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->schedule_campaign: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 

try:
    # Send a Campaign Immediately
    api_response = api_instance.send_campaign(campaign_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->send_campaign: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = swagger_client.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.CampaignsApi(swagger_client.ApiClient(configuration))
campaign_id = 'campaign_id_example' # str | 
list_id = 'list_id_example' # str |  (optional)
template_id = 'template_id_example' # str |  (optional)
from_email = 'from_email_example' # str |  (optional)
from_name = 'from_name_example' # str |  (optional)
subject = 'subject_example' # str |  (optional)
name = 'name_example' # str |  (optional)
use_smart_sending = true # bool |  (optional)
add_google_analytics = true # bool |  (optional)

try:
    # Update Campaign
    api_response = api_instance.update_campaign(campaign_id, list_id=list_id, template_id=template_id, from_email=from_email, from_name=from_name, subject=subject, name=name, use_smart_sending=use_smart_sending, add_google_analytics=add_google_analytics)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CampaignsApi->update_campaign: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://a.klaviyo.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CampaignsApi* | [**cancel_campaign**](docs/CampaignsApi.md#cancel_campaign) | **POST** /v1/campaign/{campaign_id}/cancel | Cancel a Campaign
*CampaignsApi* | [**clone_campaign**](docs/CampaignsApi.md#clone_campaign) | **POST** /v1/campaign/{campaign_id}/clone | Clone a Campaign
*CampaignsApi* | [**create_campaign**](docs/CampaignsApi.md#create_campaign) | **POST** /v1/campaigns | Create New Campaign
*CampaignsApi* | [**get_campaign_info**](docs/CampaignsApi.md#get_campaign_info) | **GET** /v1/campaign/{campaign_id} | Get Campaign Info
*CampaignsApi* | [**get_campaign_recipients**](docs/CampaignsApi.md#get_campaign_recipients) | **GET** /v1/campaign/{campaign_id}/recipients | Get Campaign Recipients
*CampaignsApi* | [**get_campaigns**](docs/CampaignsApi.md#get_campaigns) | **GET** /v1/campaigns | Get Campaigns
*CampaignsApi* | [**schedule_campaign**](docs/CampaignsApi.md#schedule_campaign) | **POST** /v1/campaign/{campaign_id}/schedule | Schedule a Campaign
*CampaignsApi* | [**send_campaign**](docs/CampaignsApi.md#send_campaign) | **POST** /v1/campaign/{campaign_id}/send | Send a Campaign Immediately
*CampaignsApi* | [**update_campaign**](docs/CampaignsApi.md#update_campaign) | **PUT** /v1/campaign/{campaign_id} | Update Campaign
*DataPrivacyApi* | [**request_deletion**](docs/DataPrivacyApi.md#request_deletion) | **POST** /v2/data-privacy/deletion-request | Request a Deletion
*ListsSegmentsApi* | [**add_members**](docs/ListsSegmentsApi.md#add_members) | **POST** /v2/list/{list_id}/members | Add Members to a List
*ListsSegmentsApi* | [**create_list**](docs/ListsSegmentsApi.md#create_list) | **POST** /v2/lists | Create List
*ListsSegmentsApi* | [**delete_list**](docs/ListsSegmentsApi.md#delete_list) | **DELETE** /v2/list/{list_id} | Delete List
*ListsSegmentsApi* | [**exclude_globally**](docs/ListsSegmentsApi.md#exclude_globally) | **POST** /v1/people/exclusions | Exclude Profile From All Email
*ListsSegmentsApi* | [**get_global_exclusions**](docs/ListsSegmentsApi.md#get_global_exclusions) | **GET** /v1/people/exclusions | Get Global Exclusions &amp; Unsubscribes
*ListsSegmentsApi* | [**get_list_exclusions**](docs/ListsSegmentsApi.md#get_list_exclusions) | **GET** /v2/list/{list_id}/exclusions/all | Get All Exclusions for a List
*ListsSegmentsApi* | [**get_list_info**](docs/ListsSegmentsApi.md#get_list_info) | **GET** /v2/list/{list_id} | Get List Info
*ListsSegmentsApi* | [**get_list_members**](docs/ListsSegmentsApi.md#get_list_members) | **POST** /v2/list/{list_id}/get-members | Check if Profiles Are in a List
*ListsSegmentsApi* | [**get_list_subscriptions**](docs/ListsSegmentsApi.md#get_list_subscriptions) | **POST** /v2/list/{list_id}/get-list-subscriptions | Check if Profiles Are in a List and not Suppressed
*ListsSegmentsApi* | [**get_lists**](docs/ListsSegmentsApi.md#get_lists) | **GET** /v2/lists | Get Lists
*ListsSegmentsApi* | [**get_members**](docs/ListsSegmentsApi.md#get_members) | **GET** /v2/group/{list_or_segment_id}/members/all | Get List and Segment Members
*ListsSegmentsApi* | [**get_segment_members**](docs/ListsSegmentsApi.md#get_segment_members) | **POST** /v2/segment/{segment_id}/get-members | Check if Profiles Are in a Segment
*ListsSegmentsApi* | [**remove_members**](docs/ListsSegmentsApi.md#remove_members) | **DELETE** /v2/list/{list_id}/members | Remove Profiles From List
*ListsSegmentsApi* | [**subscribe**](docs/ListsSegmentsApi.md#subscribe) | **POST** /v2/list/{list_id}/subscribe | Subscribe Profiles to List
*ListsSegmentsApi* | [**unsubscribe**](docs/ListsSegmentsApi.md#unsubscribe) | **DELETE** /v2/list/{list_id}/subscribe | Unsubscribe Profiles From List
*ListsSegmentsApi* | [**update_list_name**](docs/ListsSegmentsApi.md#update_list_name) | **PUT** /v2/list/{list_id} | Update List Name
*MetricsApi* | [**get_metrics**](docs/MetricsApi.md#get_metrics) | **GET** /v1/metrics | Get Metrics Info
*MetricsApi* | [**metric_export**](docs/MetricsApi.md#metric_export) | **GET** /v1/metric/{metric_id}/export | Query Event Data
*MetricsApi* | [**metric_timeline**](docs/MetricsApi.md#metric_timeline) | **GET** /v1/metric/{metric_id}/timeline | Get Events for a Specific Metric
*MetricsApi* | [**metrics_timeline**](docs/MetricsApi.md#metrics_timeline) | **GET** /v1/metrics/timeline | Get Events for All Metrics
*ProfilesApi* | [**exchange**](docs/ProfilesApi.md#exchange) | **POST** /v2/people/exchange | Exchange ID for Profile ID
*ProfilesApi* | [**get_profile**](docs/ProfilesApi.md#get_profile) | **GET** /v1/person/{person_id} | Get Profile
*ProfilesApi* | [**profile_metric_timeline**](docs/ProfilesApi.md#profile_metric_timeline) | **GET** /v1/person/{person_id}/metric/{metric_id}/timeline | Get Profile&#x27;s Events for a Specific Metric
*ProfilesApi* | [**profile_metrics_timeline**](docs/ProfilesApi.md#profile_metrics_timeline) | **GET** /v1/person/{person_id}/metrics/timeline | Get Profile&#x27;s Events for all Metrics
*ProfilesApi* | [**update_profile**](docs/ProfilesApi.md#update_profile) | **PUT** /v1/person/{person_id} | Update Profile
*TemplatesApi* | [**clone_template**](docs/TemplatesApi.md#clone_template) | **POST** /v1/email-template/{template_id}/clone | Clone Template
*TemplatesApi* | [**create_template**](docs/TemplatesApi.md#create_template) | **POST** /v1/email-templates | Create New Template
*TemplatesApi* | [**delete_template**](docs/TemplatesApi.md#delete_template) | **DELETE** /v1/email-template/{template_id} | Delete Template
*TemplatesApi* | [**get_templates**](docs/TemplatesApi.md#get_templates) | **GET** /v1/email-templates | Get All Templates
*TemplatesApi* | [**render_template**](docs/TemplatesApi.md#render_template) | **POST** /v1/email-template/{template_id}/render | Render Template
*TemplatesApi* | [**send_template**](docs/TemplatesApi.md#send_template) | **POST** /v1/email-template/{template_id}/send | Render and Send Template
*TemplatesApi* | [**update_template**](docs/TemplatesApi.md#update_template) | **PUT** /v1/email-template/{template_id} | Update Template
*TrackIdentifyApi* | [**identify_get**](docs/TrackIdentifyApi.md#identify_get) | **GET** /identify | Identify Profile
*TrackIdentifyApi* | [**identify_post**](docs/TrackIdentifyApi.md#identify_post) | **POST** /identify | Identify Profile
*TrackIdentifyApi* | [**track_get**](docs/TrackIdentifyApi.md#track_get) | **GET** /track | Track Profile Activity
*TrackIdentifyApi* | [**track_post**](docs/TrackIdentifyApi.md#track_post) | **POST** /track | Track Profile Activity

## Documentation For Models

 - [Ascending](docs/Ascending.md)
 - [Campaign](docs/Campaign.md)
 - [CampaignCampaignIdBody](docs/CampaignCampaignIdBody.md)
 - [CampaignIdCloneBody](docs/CampaignIdCloneBody.md)
 - [CampaignIdScheduleBody](docs/CampaignIdScheduleBody.md)
 - [CampaignTemplate](docs/CampaignTemplate.md)
 - [CheckMembershipRequest](docs/CheckMembershipRequest.md)
 - [CheckMembershipResponse](docs/CheckMembershipResponse.md)
 - [CheckMembershipResponseInner](docs/CheckMembershipResponseInner.md)
 - [DeleteEmail](docs/DeleteEmail.md)
 - [DeletePerson](docs/DeletePerson.md)
 - [DeletePhone](docs/DeletePhone.md)
 - [DeprecatedGetListResponse](docs/DeprecatedGetListResponse.md)
 - [DeprecatedGetListResponseData](docs/DeprecatedGetListResponseData.md)
 - [Descending](docs/Descending.md)
 - [EmailtemplateTemplateIdBody](docs/EmailtemplateTemplateIdBody.md)
 - [GlobalExclusionResponseData](docs/GlobalExclusionResponseData.md)
 - [GlobalExclusionResponseDataData](docs/GlobalExclusionResponseDataData.md)
 - [IdentifyPayload](docs/IdentifyPayload.md)
 - [IdentifyPayloadPost](docs/IdentifyPayloadPost.md)
 - [IdentifyPayloadProperties](docs/IdentifyPayloadProperties.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20012Data](docs/InlineResponse20012Data.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2008Records](docs/InlineResponse2008Records.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse2009Records](docs/InlineResponse2009Records.md)
 - [ListIdMembersBody](docs/ListIdMembersBody.md)
 - [ListIdMembersBody1](docs/ListIdMembersBody1.md)
 - [ListIdSubscribeBody](docs/ListIdSubscribeBody.md)
 - [ListIdSubscribeBody1](docs/ListIdSubscribeBody1.md)
 - [ListListIdBody](docs/ListListIdBody.md)
 - [ListSubscribePostResponseData](docs/ListSubscribePostResponseData.md)
 - [ListSubscribePostResponseDataInner](docs/ListSubscribePostResponseDataInner.md)
 - [MeasurementCount](docs/MeasurementCount.md)
 - [MeasurementSum](docs/MeasurementSum.md)
 - [MeasurementUnique](docs/MeasurementUnique.md)
 - [MeasurementValue](docs/MeasurementValue.md)
 - [Metric](docs/Metric.md)
 - [MetricExport](docs/MetricExport.md)
 - [MetricExportData](docs/MetricExportData.md)
 - [MetricExportMetric](docs/MetricExportMetric.md)
 - [MetricExportResults](docs/MetricExportResults.md)
 - [MetricIntegration](docs/MetricIntegration.md)
 - [MetricTimeline](docs/MetricTimeline.md)
 - [MetricTimelineData](docs/MetricTimelineData.md)
 - [MetricTimelineEventProperties](docs/MetricTimelineEventProperties.md)
 - [MetricTimelinePerson](docs/MetricTimelinePerson.md)
 - [Model200ok](docs/Model200ok.md)
 - [OneOfidentifyPayloadPropertiesYourCustomField](docs/OneOfidentifyPayloadPropertiesYourCustomField.md)
 - [OneOfinlineResponse2006](docs/OneOfinlineResponse2006.md)
 - [OneOftrackPayloadPropertiesYourCustomField](docs/OneOftrackPayloadPropertiesYourCustomField.md)
 - [OneOftrackPayloadTime](docs/OneOftrackPayloadTime.md)
 - [PeopleExchangeBody](docs/PeopleExchangeBody.md)
 - [PeopleExclusionsBody](docs/PeopleExclusionsBody.md)
 - [Person](docs/Person.md)
 - [PrivacyEmail](docs/PrivacyEmail.md)
 - [PrivacyId](docs/PrivacyId.md)
 - [PrivacyPhone](docs/PrivacyPhone.md)
 - [ReasonBounced](docs/ReasonBounced.md)
 - [ReasonInvalidEmail](docs/ReasonInvalidEmail.md)
 - [ReasonManuallyExcluded](docs/ReasonManuallyExcluded.md)
 - [ReasonReportedSpam](docs/ReasonReportedSpam.md)
 - [ReasonUnsubscribed](docs/ReasonUnsubscribed.md)
 - [RenderedTemplate](docs/RenderedTemplate.md)
 - [RenderedtemplateData](docs/RenderedtemplateData.md)
 - [SinceInteger](docs/SinceInteger.md)
 - [SinceString](docs/SinceString.md)
 - [StringArray](docs/StringArray.md)
 - [Template](docs/Template.md)
 - [TemplateIdCloneBody](docs/TemplateIdCloneBody.md)
 - [TemplateIdRenderBody](docs/TemplateIdRenderBody.md)
 - [TemplateIdSendBody](docs/TemplateIdSendBody.md)
 - [TrackPayload](docs/TrackPayload.md)
 - [TrackPayloadCustomerProperties](docs/TrackPayloadCustomerProperties.md)
 - [TrackPayloadPost](docs/TrackPayloadPost.md)
 - [TrackPayloadProperties](docs/TrackPayloadProperties.md)
 - [UnitDay](docs/UnitDay.md)
 - [UnitMonth](docs/UnitMonth.md)
 - [UnitWeek](docs/UnitWeek.md)
 - [V1CampaignsBody](docs/V1CampaignsBody.md)
 - [V1EmailtemplatesBody](docs/V1EmailtemplatesBody.md)
 - [V2ListsBody](docs/V2ListsBody.md)

## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: URL query string


## Author


