import { ISubnet } from './vpc';
/**
 * Contains logic which chooses a set of subnets from a larger list, in conjunction with SubnetSelection, to determine where to place AWS resources such as VPC endpoints, EC2 instances, etc.
 *
 * @stability stable
 */
export declare abstract class SubnetFilter {
    /**
     * Chooses subnets by id.
     *
     * @stability stable
     */
    static byIds(subnetIds: string[]): SubnetFilter;
    /**
     * Chooses subnets which are in one of the given availability zones.
     *
     * @stability stable
     */
    static availabilityZones(availabilityZones: string[]): SubnetFilter;
    /**
     * Chooses subnets such that there is at most one per availability zone.
     *
     * @stability stable
     */
    static onePerAz(): SubnetFilter;
    /**
     * Chooses subnets which contain any of the specified IP addresses.
     *
     * @stability stable
     */
    static containsIpAddresses(ipv4addrs: string[]): SubnetFilter;
    /**
     * Chooses subnets which have the provided CIDR netmask.
     *
     * @stability stable
     */
    static byCidrMask(mask: number): SubnetFilter;
    /**
     * Executes the subnet filtering logic, returning a filtered set of subnets.
     *
     * @stability stable
     */
    selectSubnets(_subnets: ISubnet[]): ISubnet[];
}
