"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.launchTemplateBlockDeviceMappings = exports.instanceBlockDeviceMappings = void 0;
const core_1 = require("@aws-cdk/core");
const volume_1 = require("../volume");
function instanceBlockDeviceMappings(construct, blockDevices) {
    return synthesizeBlockDeviceMappings(construct, blockDevices, {});
}
exports.instanceBlockDeviceMappings = instanceBlockDeviceMappings;
function launchTemplateBlockDeviceMappings(construct, blockDevices) {
    return synthesizeBlockDeviceMappings(construct, blockDevices, '');
}
exports.launchTemplateBlockDeviceMappings = launchTemplateBlockDeviceMappings;
/**
 * Synthesize an array of block device mappings from a list of block device
 *
 * @param construct the instance/asg construct, used to host any warning
 * @param blockDevices list of block devices
 */
function synthesizeBlockDeviceMappings(construct, blockDevices, noDeviceValue) {
    return blockDevices.map(({ deviceName, volume, mappingEnabled }) => {
        const { virtualName, ebsDevice: ebs } = volume;
        if (ebs) {
            const { iops, volumeType } = ebs;
            if (!iops) {
                if (volumeType === volume_1.EbsDeviceVolumeType.IO1) {
                    throw new Error('iops property is required with volumeType: EbsDeviceVolumeType.IO1');
                }
            }
            else if (volumeType !== volume_1.EbsDeviceVolumeType.IO1) {
                core_1.Annotations.of(construct).addWarning('iops will be ignored without volumeType: EbsDeviceVolumeType.IO1');
            }
        }
        const noDevice = mappingEnabled === false ? noDeviceValue : undefined;
        return { deviceName, ebs, virtualName, noDevice };
    });
}
//# sourceMappingURL=data:application/json;base64,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