"""
--------------------------------------------------------------------------------
SPDX-FileCopyrightText: Copyright © 2025 Lockheed Martin <open.source@lmco.com>
SPDX-FileName: hoppr_cyclonedx_models/cyclonedx_1_5.py
SPDX-FileType: SOURCE
SPDX-License-Identifier: MIT
--------------------------------------------------------------------------------
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
--------------------------------------------------------------------------------
This file was generated by datamodel-codegen:
  filename:  bom-1.5.schema.json
  timestamp: 2025-09-17T19:02:47+00:00
  version:   0.25.7
"""

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional, Union

from pydantic import AnyUrl, EmailStr, Extra, Field
from typing_extensions import Annotated, Literal

from hoppr_cyclonedx_models.base import CycloneDXBaseModel

from . import spdx

RefLinkType = Annotated[
    str,
    Field(
        description=(
            "Descriptor for an element identified by the attribute 'bom-ref' in the same BOM document.\nIn contrast to"
            " `bomLinkElementType`."
        ),
        min_length=1,
    ),
]


BomLinkDocumentType = Annotated[
    str,
    Field(
        description="Descriptor for another BOM document. See https://cyclonedx.org/capabilities/bomlink/",
        regex="^urn:cdx:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/[1-9][0-9]*$",
        title="BOM-Link Document",
    ),
]


BomLinkElementType = Annotated[
    str,
    Field(
        description="Descriptor for an element in a BOM document. See https://cyclonedx.org/capabilities/bomlink/",
        regex="^urn:cdx:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/[1-9][0-9]*#.+$",
        title="BOM-Link Element",
    ),
]


class Phase(Enum):
    """
    A pre-defined phase in the product lifecycle.

    * __design__ = BOM produced early in the development lifecycle containing inventory of components and services that are proposed or planned to be used. The inventory may need to be procured, retrieved, or resourced prior to use.
    * __pre-build__ = BOM consisting of information obtained prior to a build process and may contain source files and development artifacts and manifests. The inventory may need to be resolved and retrieved prior to use.
    * __build__ = BOM consisting of information obtained during a build process where component inventory is available for use. The precise versions of resolved components are usually available at this time as well as the provenance of where the components were retrieved from.
    * __post-build__ = BOM consisting of information obtained after a build process has completed and the resulting components(s) are available for further analysis. Built components may exist as the result of a CI/CD process, may have been installed or deployed to a system or device, and may need to be retrieved or extracted from the system or device.
    * __operations__ = BOM produced that represents inventory that is running and operational. This may include staging or production environments and will generally encompass multiple SBOMs describing the applications and operating system, along with HBOMs describing the hardware that makes up the system. Operations Bill of Materials (OBOM) can provide full-stack inventory of runtime environments, configurations, and additional dependencies.
    * __discovery__ = BOM consisting of information observed through network discovery providing point-in-time enumeration of embedded, on-premise, and cloud-native services such as server applications, connected devices, microservices, and serverless functions.
    * __decommission__ = BOM containing inventory that will be, or has been retired from operations.
    """

    DESIGN = design = "design"
    PRE_BUILD = pre_build = "pre-build"
    BUILD = build = "build"
    POST_BUILD = post_build = "post-build"
    OPERATIONS = operations = "operations"
    DISCOVERY = discovery = "discovery"
    DECOMMISSION = decommission = "decommission"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Lifecycles(CycloneDXBaseModel):
    """
    The product lifecycle(s) that this BOM represents.
    """

    class Config:
        extra = Extra.forbid

    phase: Annotated[
        Phase,
        Field(
            description=(
                "A pre-defined phase in the product lifecycle.\n\n* __design__ = BOM produced early in the development"
                " lifecycle containing inventory of components and services that are proposed or planned to be used."
                " The inventory may need to be procured, retrieved, or resourced prior to use.\n* __pre-build__ = BOM"
                " consisting of information obtained prior to a build process and may contain source files and"
                " development artifacts and manifests. The inventory may need to be resolved and retrieved prior to"
                " use.\n* __build__ = BOM consisting of information obtained during a build process where component"
                " inventory is available for use. The precise versions of resolved components are usually available at"
                " this time as well as the provenance of where the components were retrieved from.\n* __post-build__ ="
                " BOM consisting of information obtained after a build process has completed and the resulting"
                " components(s) are available for further analysis. Built components may exist as the result of a CI/CD"
                " process, may have been installed or deployed to a system or device, and may need to be retrieved or"
                " extracted from the system or device.\n* __operations__ = BOM produced that represents inventory that"
                " is running and operational. This may include staging or production environments and will generally"
                " encompass multiple SBOMs describing the applications and operating system, along with HBOMs"
                " describing the hardware that makes up the system. Operations Bill of Materials (OBOM) can provide"
                " full-stack inventory of runtime environments, configurations, and additional dependencies.\n*"
                " __discovery__ = BOM consisting of information observed through network discovery providing"
                " point-in-time enumeration of embedded, on-premise, and cloud-native services such as server"
                " applications, connected devices, microservices, and serverless functions.\n* __decommission__ = BOM"
                " containing inventory that will be, or has been retired from operations."
            ),
            title="Phase",
        ),
    ]


class Lifecycles1(CycloneDXBaseModel):
    """
    The product lifecycle(s) that this BOM represents.
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[str, Field(description="The name of the lifecycle phase", title="Name")]
    description: Annotated[
        Optional[str], Field(description="The description of the lifecycle phase", title="Description")
    ] = None


class OrganizationalContact(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of a contact", examples=["Contact name"], title="Name")
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(
            description="The email address of the contact.",
            examples=["firstname.lastname@example.com"],
            title="Email Address",
        ),
    ] = None
    phone: Annotated[
        Optional[str], Field(description="The phone number of the contact.", examples=["800-555-1212"], title="Phone")
    ] = None


class Type(Enum):
    """
    Specifies the type of component. For software components, classify as application if no more specific appropriate classification is available or cannot be determined for the component. Types include:

    * __application__ = A software application. Refer to [https://en.wikipedia.org/wiki/Application_software](https://en.wikipedia.org/wiki/Application_software) for information about applications.
    * __framework__ = A software framework. Refer to [https://en.wikipedia.org/wiki/Software_framework](https://en.wikipedia.org/wiki/Software_framework) for information on how frameworks vary slightly from libraries.
    * __library__ = A software library. Refer to [https://en.wikipedia.org/wiki/Library_(computing)](https://en.wikipedia.org/wiki/Library_(computing))
     for information about libraries. All third-party and open source reusable components will likely be a library. If the library also has key features of a framework, then it should be classified as a framework. If not, or is unknown, then specifying library is RECOMMENDED.
    * __container__ = A packaging and/or runtime format, not specific to any particular technology, which isolates software inside the container from software outside of a container through virtualization technology. Refer to [https://en.wikipedia.org/wiki/OS-level_virtualization](https://en.wikipedia.org/wiki/OS-level_virtualization)
    * __platform__ = A runtime environment which interprets or executes software. This may include runtimes such as those that execute bytecode or low-code/no-code application platforms.
    * __operating-system__ = A software operating system without regard to deployment model (i.e. installed on physical hardware, virtual machine, image, etc) Refer to [https://en.wikipedia.org/wiki/Operating_system](https://en.wikipedia.org/wiki/Operating_system)
    * __device__ = A hardware device such as a processor, or chip-set. A hardware device containing firmware SHOULD include a component for the physical hardware itself, and another component of type 'firmware' or 'operating-system' (whichever is relevant), describing information about the software running on the device.
      See also the list of [known device properties](https://github.com/CycloneDX/cyclonedx-property-taxonomy/blob/main/cdx/device.md).
    * __device-driver__ = A special type of software that operates or controls a particular type of device. Refer to [https://en.wikipedia.org/wiki/Device_driver](https://en.wikipedia.org/wiki/Device_driver)
    * __firmware__ = A special type of software that provides low-level control over a devices hardware. Refer to [https://en.wikipedia.org/wiki/Firmware](https://en.wikipedia.org/wiki/Firmware)
    * __file__ = A computer file. Refer to [https://en.wikipedia.org/wiki/Computer_file](https://en.wikipedia.org/wiki/Computer_file) for information about files.
    * __machine-learning-model__ = A model based on training data that can make predictions or decisions without being explicitly programmed to do so.
    * __data__ = A collection of discrete values that convey information.
    """

    APPLICATION = application = "application"
    FRAMEWORK = framework = "framework"
    LIBRARY = library = "library"
    CONTAINER = container = "container"
    PLATFORM = platform = "platform"
    OPERATING_SYSTEM = operating_system = "operating-system"
    DEVICE = device = "device"
    DEVICE_DRIVER = device_driver = "device-driver"
    FIRMWARE = firmware = "firmware"
    FILE = file = "file"
    MACHINE_LEARNING_MODEL = machine_learning_model = "machine-learning-model"
    DATA = data = "data"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Scope(Enum):
    """
    Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by the consumer of the BOM.
    """

    REQUIRED = required = "required"
    OPTIONAL = optional = "optional"
    EXCLUDED = excluded = "excluded"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Attachment(CycloneDXBaseModel):
    """
    Specifies the metadata and content for an attachment.
    """

    class Config:
        extra = Extra.forbid

    contentType: Annotated[
        Optional[str],
        Field(
            description="Specifies the content type of the text. Defaults to text/plain if not specified.",
            title="Content-Type",
        ),
    ] = "text/plain"
    encoding: Annotated[
        Optional[Literal["base64"]],
        Field(description="Specifies the optional encoding the text is represented in.", title="Encoding"),
    ] = None
    content: Annotated[
        str,
        Field(
            description=(
                "The attachment data. Proactive controls such as input validation and sanitization should be employed"
                " to prevent misuse of attachment text."
            ),
            title="Attachment Text",
        ),
    ]


class HashAlg(Enum):
    MD5 = "MD5"
    SHA_1 = "SHA-1"
    SHA_256 = "SHA-256"
    SHA_384 = "SHA-384"
    SHA_512 = "SHA-512"
    SHA3_256 = "SHA3-256"
    SHA3_384 = "SHA3-384"
    SHA3_512 = "SHA3-512"
    BLAKE2B_256 = BLAKE2b_256 = "BLAKE2b-256"
    BLAKE2B_384 = BLAKE2b_384 = "BLAKE2b-384"
    BLAKE2B_512 = BLAKE2b_512 = "BLAKE2b-512"
    BLAKE3 = "BLAKE3"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class LicenseType(Enum):
    ACADEMIC = academic = "academic"
    APPLIANCE = appliance = "appliance"
    CLIENT_ACCESS = client_access = "client-access"
    CONCURRENT_USER = concurrent_user = "concurrent-user"
    CORE_POINTS = core_points = "core-points"
    CUSTOM_METRIC = custom_metric = "custom-metric"
    DEVICE = device = "device"
    EVALUATION = evaluation = "evaluation"
    NAMED_USER = named_user = "named-user"
    NODE_LOCKED = node_locked = "node-locked"
    OEM = oem = "oem"
    PERPETUAL = perpetual = "perpetual"
    PROCESSOR_POINTS = processor_points = "processor-points"
    SUBSCRIPTION = subscription = "subscription"
    USER = user = "user"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class LicenseChoice21(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    expression: Annotated[
        str,
        Field(
            examples=["Apache-2.0 AND (MIT OR GPL-2.0-only)", "GPL-3.0-only WITH Classpath-exception-2.0"],
            title="SPDX License Expression",
        ),
    ]
    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the license elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None


LicenseChoice2 = Annotated[
    List[LicenseChoice21],
    Field(
        description="A tuple of exactly one SPDX License Expression.",
        max_items=1,
        min_items=1,
        title="SPDX License Expression",
    ),
]


class Type1(Enum):
    """
    Specifies the purpose for the patch including the resolution of defects, security issues, or new behavior or functionality.

    * __unofficial__ = A patch which is not developed by the creators or maintainers of the software being patched. Refer to [https://en.wikipedia.org/wiki/Unofficial_patch](https://en.wikipedia.org/wiki/Unofficial_patch)
    * __monkey__ = A patch which dynamically modifies runtime behavior. Refer to [https://en.wikipedia.org/wiki/Monkey_patch](https://en.wikipedia.org/wiki/Monkey_patch)
    * __backport__ = A patch which takes code from a newer version of software and applies it to older versions of the same software. Refer to [https://en.wikipedia.org/wiki/Backporting](https://en.wikipedia.org/wiki/Backporting)
    * __cherry-pick__ = A patch created by selectively applying commits from other versions or branches of the same software.
    """

    UNOFFICIAL = unofficial = "unofficial"
    MONKEY = monkey = "monkey"
    BACKPORT = backport = "backport"
    CHERRY_PICK = cherry_pick = "cherry-pick"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Diff(CycloneDXBaseModel):
    """
    The patch file (or diff) that show changes. Refer to https://en.wikipedia.org/wiki/Diff
    """

    class Config:
        extra = Extra.forbid

    text: Annotated[
        Optional[Attachment], Field(description="Specifies the optional text of the diff", title="Diff text")
    ] = None
    url: Annotated[Optional[str], Field(description="Specifies the URL to the diff", title="URL")] = None


class Type2(Enum):
    """
    Specifies the type of issue
    """

    DEFECT = defect = "defect"
    ENHANCEMENT = enhancement = "enhancement"
    SECURITY = security = "security"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Source(CycloneDXBaseModel):
    """
    The source of the issue where it is documented
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source. For example 'National Vulnerability Database', 'NVD', and 'Apache'",
            title="Name",
        ),
    ] = None
    url: Annotated[
        Optional[str], Field(description="The url of the issue documentation as provided by the source", title="URL")
    ] = None


class Issue(CycloneDXBaseModel):
    """
    An individual issue that has been resolved.
    """

    class Config:
        extra = Extra.forbid

    type: Annotated[Type2, Field(description="Specifies the type of issue", title="Type")]
    id: Annotated[
        Optional[str], Field(description="The identifier of the issue assigned by the source of the issue", title="ID")
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the issue", title="Name")] = None
    description: Annotated[Optional[str], Field(description="A description of the issue", title="Description")] = None
    source: Annotated[
        Optional[Source], Field(description="The source of the issue where it is documented", title="Source")
    ] = None
    references: Annotated[
        Optional[List[str]],
        Field(
            description="A collection of URL's for reference. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="References",
        ),
    ] = None


class IdentifiableAction(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    class Config:
        extra = Extra.forbid

    timestamp: Annotated[
        Optional[datetime], Field(description="The timestamp in which the action occurred", title="Timestamp")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the individual who performed the action", title="Name")
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(description="The email address of the individual who performed the action", title="E-mail"),
    ] = None


class Type3(Enum):
    """
    Specifies the type of external reference.

    * __vcs__ = Version Control System
    * __issue-tracker__ = Issue or defect tracking system, or an Application Lifecycle Management (ALM) system
    * __website__ = Website
    * __advisories__ = Security advisories
    * __bom__ = Bill of Materials (SBOM, OBOM, HBOM, SaaSBOM, etc)
    * __mailing-list__ = Mailing list or discussion group
    * __social__ = Social media account
    * __chat__ = Real-time chat platform
    * __documentation__ = Documentation, guides, or how-to instructions
    * __support__ = Community or commercial support
    * __distribution__ = Direct or repository download location
    * __distribution-intake__ = The location where a component was published to. This is often the same as "distribution" but may also include specialized publishing processes that act as an intermediary
    * __license__ = The URL to the license file. If a license URL has been defined in the license node, it should also be defined as an external reference for completeness
    * __build-meta__ = Build-system specific meta file (i.e. pom.xml, package.json, .nuspec, etc)
    * __build-system__ = URL to an automated build system
    * __release-notes__ = URL to release notes
    * __security-contact__ = Specifies a way to contact the maintainer, supplier, or provider in the event of a security incident. Common URIs include links to a disclosure procedure, a mailto (RFC-2368) that specifies an email address, a tel (RFC-3966) that specifies a phone number, or dns (RFC-4501) that specifies the records containing DNS Security TXT
    * __model-card__ = A model card describes the intended uses of a machine learning model, potential limitations, biases, ethical considerations, training parameters, datasets used to train the model, performance metrics, and other relevant data useful for ML transparency
    * __log__ = A record of events that occurred in a computer system or application, such as problems, errors, or information on current operations
    * __configuration__ = Parameters or settings that may be used by other components or services
    * __evidence__ = Information used to substantiate a claim
    * __formulation__ = Describes how a component or service was manufactured or deployed
    * __attestation__ = Human or machine-readable statements containing facts, evidence, or testimony
    * __threat-model__ = An enumeration of identified weaknesses, threats, and countermeasures, dataflow diagram (DFD), attack tree, and other supporting documentation in human-readable or machine-readable format
    * __adversary-model__ = The defined assumptions, goals, and capabilities of an adversary.
    * __risk-assessment__ = Identifies and analyzes the potential of future events that may negatively impact individuals, assets, and/or the environment. Risk assessments may also include judgments on the tolerability of each risk.
    * __vulnerability-assertion__ = A Vulnerability Disclosure Report (VDR) which asserts the known and previously unknown vulnerabilities that affect a component, service, or product including the analysis and findings describing the impact (or lack of impact) that the reported vulnerability has on a component, service, or product.
    * __exploitability-statement__ = A Vulnerability Exploitability eXchange (VEX) which asserts the known vulnerabilities that do not affect a product, product family, or organization, and optionally the ones that do. The VEX should include the analysis and findings describing the impact (or lack of impact) that the reported vulnerability has on the product, product family, or organization.
    * __pentest-report__ = Results from an authorized simulated cyberattack on a component or service, otherwise known as a penetration test
    * __static-analysis-report__ = SARIF or proprietary machine or human-readable report for which static analysis has identified code quality, security, and other potential issues with the source code
    * __dynamic-analysis-report__ = Dynamic analysis report that has identified issues such as vulnerabilities and misconfigurations
    * __runtime-analysis-report__ = Report generated by analyzing the call stack of a running application
    * __component-analysis-report__ = Report generated by Software Composition Analysis (SCA), container analysis, or other forms of component analysis
    * __maturity-report__ = Report containing a formal assessment of an organization, business unit, or team against a maturity model
    * __certification-report__ = Industry, regulatory, or other certification from an accredited (if applicable) certification body
    * __quality-metrics__ = Report or system in which quality metrics can be obtained
    * __codified-infrastructure__ = Code or configuration that defines and provisions virtualized infrastructure, commonly referred to as Infrastructure as Code (IaC)
    * __poam__ = Plans of Action and Milestones (POAM) compliment an "attestation" external reference. POAM is defined by NIST as a "document that identifies tasks needing to be accomplished. It details resources required to accomplish the elements of the plan, any milestones in meeting the tasks and scheduled completion dates for the milestones".
    * __other__ = Use this if no other types accurately describe the purpose of the external reference
    """

    VCS = vcs = "vcs"
    ISSUE_TRACKER = issue_tracker = "issue-tracker"
    WEBSITE = website = "website"
    ADVISORIES = advisories = "advisories"
    BOM = bom = "bom"
    MAILING_LIST = mailing_list = "mailing-list"
    SOCIAL = social = "social"
    CHAT = chat = "chat"
    DOCUMENTATION = documentation = "documentation"
    SUPPORT = support = "support"
    DISTRIBUTION = distribution = "distribution"
    DISTRIBUTION_INTAKE = distribution_intake = "distribution-intake"
    LICENSE = license = "license"
    BUILD_META = build_meta = "build-meta"
    BUILD_SYSTEM = build_system = "build-system"
    RELEASE_NOTES = release_notes = "release-notes"
    SECURITY_CONTACT = security_contact = "security-contact"
    MODEL_CARD = model_card = "model-card"
    LOG = log = "log"
    CONFIGURATION = configuration = "configuration"
    EVIDENCE = evidence = "evidence"
    FORMULATION = formulation = "formulation"
    ATTESTATION = attestation = "attestation"
    THREAT_MODEL = threat_model = "threat-model"
    ADVERSARY_MODEL = adversary_model = "adversary-model"
    RISK_ASSESSMENT = risk_assessment = "risk-assessment"
    VULNERABILITY_ASSERTION = vulnerability_assertion = "vulnerability-assertion"
    EXPLOITABILITY_STATEMENT = exploitability_statement = "exploitability-statement"
    PENTEST_REPORT = pentest_report = "pentest-report"
    STATIC_ANALYSIS_REPORT = static_analysis_report = "static-analysis-report"
    DYNAMIC_ANALYSIS_REPORT = dynamic_analysis_report = "dynamic-analysis-report"
    RUNTIME_ANALYSIS_REPORT = runtime_analysis_report = "runtime-analysis-report"
    COMPONENT_ANALYSIS_REPORT = component_analysis_report = "component-analysis-report"
    MATURITY_REPORT = maturity_report = "maturity-report"
    CERTIFICATION_REPORT = certification_report = "certification-report"
    CODIFIED_INFRASTRUCTURE = codified_infrastructure = "codified-infrastructure"
    QUALITY_METRICS = quality_metrics = "quality-metrics"
    POAM = poam = "poam"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Dependency(CycloneDXBaseModel):
    """
    Defines the direct dependencies of a component or service. Components or services that do not have their own dependencies MUST be declared as empty elements within the graph. Components or services that are not represented in the dependency graph MAY have unknown dependencies. It is RECOMMENDED that implementations assume this to be opaque and not an indicator of a object being dependency-free. It is RECOMMENDED to leverage compositions to indicate unknown dependency graphs.
    """

    class Config:
        extra = Extra.forbid

    ref: Annotated[
        str,
        Field(
            description="References a component or service by its bom-ref attribute", min_length=1, title="Reference"
        ),
    ]
    dependsOn: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services that are dependencies of this dependency object."
            ),
            min_length=1,
            title="Depends On",
        ),
    ] = None


class DataFlowDirection(Enum):
    """
    Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states that data enters the service. Outbound flow states that data leaves the service. Bi-directional states that data flows both ways, and unknown states that the direction is not known.
    """

    INBOUND = inbound = "inbound"
    OUTBOUND = outbound = "outbound"
    BI_DIRECTIONAL = bi_directional = "bi-directional"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Copyright(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    text: Annotated[str, Field(title="Copyright Text")]


class FieldModel(Enum):
    """
    The identity field of the component which the evidence describes.
    """

    GROUP = group = "group"
    NAME = name = "name"
    VERSION = version = "version"
    PURL = purl = "purl"
    CPE = cpe = "cpe"
    SWID = swid = "swid"
    HASH = hash = "hash"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Technique(Enum):
    """
    The technique used in this method of analysis.
    """

    SOURCE_CODE_ANALYSIS = source_code_analysis = "source-code-analysis"
    BINARY_ANALYSIS = binary_analysis = "binary-analysis"
    MANIFEST_ANALYSIS = manifest_analysis = "manifest-analysis"
    AST_FINGERPRINT = ast_fingerprint = "ast-fingerprint"
    HASH_COMPARISON = hash_comparison = "hash-comparison"
    INSTRUMENTATION = instrumentation = "instrumentation"
    DYNAMIC_ANALYSIS = dynamic_analysis = "dynamic-analysis"
    FILENAME = filename = "filename"
    ATTESTATION = attestation = "attestation"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Method(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    technique: Annotated[
        Technique, Field(description="The technique used in this method of analysis.", title="Technique")
    ]
    confidence: Annotated[
        float,
        Field(
            description=(
                "The confidence of the evidence from 0 - 1, where 1 is 100% confidence. Confidence is specific to the"
                " technique used. Each technique of analysis can have independent confidence."
            ),
            ge=0.0,
            le=1.0,
            title="Confidence",
        ),
    ]
    value: Annotated[Optional[str], Field(description="The value or contents of the evidence.", title="Value")] = None


class Identity(CycloneDXBaseModel):
    """
    Evidence that substantiates the identity of a component.
    """

    class Config:
        extra = Extra.forbid

    field: Annotated[
        FieldModel,
        Field(description="The identity field of the component which the evidence describes.", title="Field"),
    ]
    confidence: Annotated[
        Optional[float],
        Field(
            description="The overall confidence of the evidence from 0 - 1, where 1 is 100% confidence.",
            ge=0.0,
            le=1.0,
            title="Confidence",
        ),
    ] = None
    methods: Annotated[
        Optional[List[Method]],
        Field(description="The methods used to extract and/or analyze the evidence.", title="Methods"),
    ] = None
    tools: Annotated[
        Optional[List[Union[RefLinkType, BomLinkElementType]]],
        Field(
            description=(
                "The object in the BOM identified by its bom-ref. This is often a component or service, but may be any"
                " object type supporting bom-refs. Tools used for analysis should already be defined in the BOM, either"
                " in the metadata/tools, components, or formulation."
            ),
            title="BOM References",
        ),
    ] = None


class Occurrence(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the occurrence elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    location: Annotated[
        str, Field(description="The location or path to where the component was found.", title="Location")
    ]


class Frame(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    package: Annotated[
        Optional[str],
        Field(
            description=(
                "A package organizes modules into namespaces, providing a unique namespace for each type it contains."
            ),
            title="Package",
        ),
    ] = None
    module: Annotated[
        str, Field(description="A module or class that encloses functions/methods and other code.", title="Module")
    ]
    function: Annotated[
        Optional[str], Field(description="A block of code designed to perform a particular task.", title="Function")
    ] = None
    parameters: Annotated[
        Optional[List[str]],
        Field(description="Optional arguments that are passed to the module or function.", title="Parameters"),
    ] = None
    line: Annotated[
        Optional[int], Field(description="The line number the code that is called resides on.", title="Line")
    ] = None
    column: Annotated[
        Optional[int], Field(description="The column the code that is called resides.", title="Column")
    ] = None
    fullFilename: Annotated[
        Optional[str], Field(description="The full path and filename of the module.", title="Full Filename")
    ] = None


class Callstack(CycloneDXBaseModel):
    """
    Evidence of the components use through the callstack.
    """

    class Config:
        extra = Extra.forbid

    frames: Annotated[Optional[List[Frame]], Field(title="Methods")] = None


class AggregateType(Enum):
    COMPLETE = complete = "complete"
    INCOMPLETE = incomplete = "incomplete"
    INCOMPLETE_FIRST_PARTY_ONLY = incomplete_first_party_only = "incomplete_first_party_only"
    INCOMPLETE_FIRST_PARTY_PROPRIETARY_ONLY = (
        incomplete_first_party_proprietary_only
    ) = "incomplete_first_party_proprietary_only"
    INCOMPLETE_FIRST_PARTY_OPENSOURCE_ONLY = (
        incomplete_first_party_opensource_only
    ) = "incomplete_first_party_opensource_only"
    INCOMPLETE_THIRD_PARTY_ONLY = incomplete_third_party_only = "incomplete_third_party_only"
    INCOMPLETE_THIRD_PARTY_PROPRIETARY_ONLY = (
        incomplete_third_party_proprietary_only
    ) = "incomplete_third_party_proprietary_only"
    INCOMPLETE_THIRD_PARTY_OPENSOURCE_ONLY = (
        incomplete_third_party_opensource_only
    ) = "incomplete_third_party_opensource_only"
    UNKNOWN = unknown = "unknown"
    NOT_SPECIFIED = not_specified = "not_specified"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Property(CycloneDXBaseModel):
    """
    Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.
    """

    name: Annotated[
        Optional[str],
        Field(
            description=(
                "The name of the property. Duplicate names are allowed, each potentially having a different value."
            ),
            title="Name",
        ),
    ] = None
    value: Annotated[Optional[str], Field(description="The value of the property.", title="Value")] = None


class Note(CycloneDXBaseModel):
    """
    A note containing the locale and content.
    """

    class Config:
        extra = Extra.forbid

    locale: Annotated[
        Optional[str],
        Field(
            description=(
                "The ISO-639 (or higher) language code and optional ISO-3166 (or higher) country code. Examples"
                ' include: "en", "en-US", "fr" and "fr-CA"'
            ),
            regex="^([a-z]{2})(-[A-Z]{2})?$",
            title="Locale",
        ),
    ] = None
    text: Annotated[
        Attachment, Field(description="Specifies the full content of the release note.", title="Release note content")
    ]


class ReleaseNotes(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[
        str,
        Field(
            description="The software versioning type the release note describes.",
            examples=["major", "minor", "patch", "pre-release", "internal"],
            title="Type",
        ),
    ]
    title: Annotated[Optional[str], Field(description="The title of the release.", title="Title")] = None
    featuredImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be prominently displayed with the release note.",
            title="Featured image",
        ),
    ] = None
    socialImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be used in messaging on social media platforms.",
            title="Social image",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A short description of the release.", title="Description")
    ] = None
    timestamp: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the release note was created.", title="Timestamp"),
    ] = None
    aliases: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "One or more alternate names the release may be referred to. This may include unofficial terms used by"
                " development and marketing teams (e.g. code names)."
            ),
            title="Aliases",
        ),
    ] = None
    tags: Annotated[
        Optional[List[str]],
        Field(description="One or more tags that may aid in search or retrieval of the release note.", title="Tags"),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]], Field(description="A collection of issues that have been resolved.", title="Resolves")
    ] = None
    notes: Annotated[
        Optional[List[Note]],
        Field(
            description=(
                "Zero or more release notes containing the locale and content. Multiple note objects may be specified"
                " to support release notes in a wide variety of languages."
            ),
            title="Notes",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Advisory(CycloneDXBaseModel):
    """
    Title and location where advisory information can be obtained. An advisory is a notification of a threat to a component, service, or system.
    """

    class Config:
        extra = Extra.forbid

    title: Annotated[Optional[str], Field(description="An optional name of the advisory.", title="Title")] = None
    url: Annotated[str, Field(description="Location where the advisory can be obtained.", title="URL")]


class Severity(Enum):
    """
    Textual representation of the severity of the vulnerability adopted by the analysis method. If the analysis method uses values other than what is provided, the user is expected to translate appropriately.
    """

    CRITICAL = critical = "critical"
    HIGH = high = "high"
    MEDIUM = medium = "medium"
    LOW = low = "low"
    INFO = info = "info"
    NONE = none = "none"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ScoreMethod(Enum):
    """
    Specifies the severity or risk scoring methodology or standard used.

    * CVSSv2 - [Common Vulnerability Scoring System v2](https://www.first.org/cvss/v2/)
    * CVSSv3 - [Common Vulnerability Scoring System v3](https://www.first.org/cvss/v3-0/)
    * CVSSv31 - [Common Vulnerability Scoring System v3.1](https://www.first.org/cvss/v3-1/)
    * CVSSv4 - [Common Vulnerability Scoring System v4](https://www.first.org/cvss/v4-0/)
    * OWASP - [OWASP Risk Rating Methodology](https://owasp.org/www-community/OWASP_Risk_Rating_Methodology)
    * SSVC - [Stakeholder Specific Vulnerability Categorization](https://github.com/CERTCC/SSVC) (all versions)
    """

    CVSSV2 = CVSSv2 = "CVSSv2"
    CVSSV3 = CVSSv3 = "CVSSv3"
    CVSSV31 = CVSSv31 = "CVSSv31"
    CVSSV4 = CVSSv4 = "CVSSv4"
    OWASP = "OWASP"
    SSVC = "SSVC"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ImpactAnalysisState(Enum):
    """
    Declares the current state of an occurrence of a vulnerability, after automated or manual analysis.

    * __resolved__ = the vulnerability has been remediated.
    * __resolved_with_pedigree__ = the vulnerability has been remediated and evidence of the changes are provided in the affected components pedigree containing verifiable commit history and/or diff(s).
    * __exploitable__ = the vulnerability may be directly or indirectly exploitable.
    * __in_triage__ = the vulnerability is being investigated.
    * __false_positive__ = the vulnerability is not specific to the component or service and was falsely identified or associated.
    * __not_affected__ = the component or service is not affected by the vulnerability. Justification should be specified for all not_affected cases.
    """

    RESOLVED = resolved = "resolved"
    RESOLVED_WITH_PEDIGREE = resolved_with_pedigree = "resolved_with_pedigree"
    EXPLOITABLE = exploitable = "exploitable"
    IN_TRIAGE = in_triage = "in_triage"
    FALSE_POSITIVE = false_positive = "false_positive"
    NOT_AFFECTED = not_affected = "not_affected"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ImpactAnalysisJustification(Enum):
    """
    The rationale of why the impact analysis state was asserted.

    * __code_not_present__ = the code has been removed or tree-shaked.
    * __code_not_reachable__ = the vulnerable code is not invoked at runtime.
    * __requires_configuration__ = exploitability requires a configurable option to be set/unset.
    * __requires_dependency__ = exploitability requires a dependency that is not present.
    * __requires_environment__ = exploitability requires a certain environment which is not present.
    * __protected_by_compiler__ = exploitability requires a compiler flag to be set/unset.
    * __protected_at_runtime__ = exploits are prevented at runtime.
    * __protected_at_perimeter__ = attacks are blocked at physical, logical, or network perimeter.
    * __protected_by_mitigating_control__ = preventative measures have been implemented that reduce the likelihood and/or impact of the vulnerability.
    """

    CODE_NOT_PRESENT = code_not_present = "code_not_present"
    CODE_NOT_REACHABLE = code_not_reachable = "code_not_reachable"
    REQUIRES_CONFIGURATION = requires_configuration = "requires_configuration"
    REQUIRES_DEPENDENCY = requires_dependency = "requires_dependency"
    REQUIRES_ENVIRONMENT = requires_environment = "requires_environment"
    PROTECTED_BY_COMPILER = protected_by_compiler = "protected_by_compiler"
    PROTECTED_AT_RUNTIME = protected_at_runtime = "protected_at_runtime"
    PROTECTED_AT_PERIMETER = protected_at_perimeter = "protected_at_perimeter"
    PROTECTED_BY_MITIGATING_CONTROL = protected_by_mitigating_control = "protected_by_mitigating_control"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class VulnerabilitySource(CycloneDXBaseModel):
    """
    The source of vulnerability information. This is often the organization that published the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    url: Annotated[
        Optional[str],
        Field(
            description="The url of the vulnerability documentation as provided by the source.",
            examples=["https://nvd.nist.gov/vuln/detail/CVE-2021-39182"],
            title="URL",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source.",
            examples=["NVD", "National Vulnerability Database", "OSS Index", "VulnDB", "GitHub Advisories"],
            title="Name",
        ),
    ] = None


class Reference(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    id: Annotated[
        str,
        Field(
            description="An identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ]
    source: Annotated[VulnerabilitySource, Field(description="The source that published the vulnerability.")]


class ProofOfConcept(CycloneDXBaseModel):
    """
    Evidence used to reproduce the vulnerability.
    """

    reproductionSteps: Annotated[
        Optional[str], Field(description="Precise steps to reproduce the vulnerability.", title="Steps to Reproduce")
    ] = None
    environment: Annotated[
        Optional[str],
        Field(description="A description of the environment in which reproduction was possible.", title="Environment"),
    ] = None
    supportingMaterial: Annotated[
        Optional[List[Attachment]],
        Field(
            description=(
                "Supporting material that helps in reproducing or understanding how reproduction is possible. This may"
                " include screenshots, payloads, and PoC exploit code."
            ),
            title="Supporting Material",
        ),
    ] = None


class ResponseEnum(Enum):
    CAN_NOT_FIX = can_not_fix = "can_not_fix"
    WILL_NOT_FIX = will_not_fix = "will_not_fix"
    UPDATE = update = "update"
    ROLLBACK = rollback = "rollback"
    WORKAROUND_AVAILABLE = workaround_available = "workaround_available"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Analysis(CycloneDXBaseModel):
    """
    An assessment of the impact and exploitability of the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    state: Optional[ImpactAnalysisState] = None
    justification: Optional[ImpactAnalysisJustification] = None
    response: Annotated[
        Optional[List[ResponseEnum]],
        Field(
            description=(
                "A response to the vulnerability by the manufacturer, supplier, or project responsible for the affected"
                " component or service. More than one response is allowed. Responses are strongly encouraged for"
                " vulnerabilities where the analysis state is exploitable."
            ),
            title="Response",
        ),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description=(
                "Detailed description of the impact including methods used during assessment. If a vulnerability is not"
                " exploitable, this field should include specific details on why the component or service is not"
                " impacted by this vulnerability."
            ),
            title="Detail",
        ),
    ] = None
    firstIssued: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the analysis was first issued.", title="First Issued"),
    ] = None
    lastUpdated: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the analysis was last updated.", title="Last Updated"),
    ] = None


class AffectedStatus(Enum):
    """
    The vulnerability status of a given version or range of versions of a product. The statuses 'affected' and 'unaffected' indicate that the version is affected or unaffected by the vulnerability. The status 'unknown' indicates that it is unknown or unspecified whether the given version is affected. There can be many reasons for an 'unknown' status, including that an investigation has not been undertaken or that a vendor has not disclosed the status.
    """

    AFFECTED = affected = "affected"
    UNAFFECTED = unaffected = "unaffected"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Type4(Enum):
    """
    Learning types describing the learning problem or hybrid learning problem.
    """

    SUPERVISED = supervised = "supervised"
    UNSUPERVISED = unsupervised = "unsupervised"
    REINFORCEMENT_LEARNING = reinforcement_learning = "reinforcement-learning"
    SEMI_SUPERVISED = semi_supervised = "semi-supervised"
    SELF_SUPERVISED = self_supervised = "self-supervised"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Approach(CycloneDXBaseModel):
    """
    The overall approach to learning used by the model for problem solving.
    """

    class Config:
        extra = Extra.forbid

    type: Annotated[
        Optional[Type4],
        Field(
            description="Learning types describing the learning problem or hybrid learning problem.",
            title="Learning Type",
        ),
    ] = None


class Datasets(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    ref: Annotated[
        Optional[Union[RefLinkType, BomLinkElementType]],
        Field(description="References a data component by the components bom-ref attribute", title="Reference"),
    ] = None


class InputOutputMLParameters(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    format: Annotated[
        Optional[str],
        Field(
            description=(
                "The data format for input/output to the model. Example formats include string, image, time-series"
            )
        ),
    ] = None


class Type5(Enum):
    """
    The general theme or subject matter of the data being specified.

    * __source-code__ = Any type of code, code snippet, or data-as-code.
    * __configuration__ = Parameters or settings that may be used by other components.
    * __dataset__ = A collection of data.
    * __definition__ = Data that can be used to create new instances of what the definition defines.
    * __other__ = Any other type of data that does not fit into existing definitions.
    """

    SOURCE_CODE = source_code = "source-code"
    CONFIGURATION = configuration = "configuration"
    DATASET = dataset = "dataset"
    DEFINITION = definition = "definition"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Contents(CycloneDXBaseModel):
    """
    The contents or references to the contents of the data being described.
    """

    class Config:
        extra = Extra.forbid

    attachment: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include textual or encoded data.", title="Data Attachment"),
    ] = None
    url: Annotated[
        Optional[str], Field(description="The URL to where the data can be retrieved.", title="Data URL")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document name-value parameters used for configuration.",
            title="Configuration Properties",
        ),
    ] = None


class Graphic(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    name: Annotated[Optional[str], Field(description="The name of the graphic.")] = None
    image: Annotated[
        Optional[Attachment],
        Field(
            description="The graphic (vector or raster). Base64 encoding MUST be specified for binary images.",
            title="Graphic Image",
        ),
    ] = None


class ConfidenceInterval(CycloneDXBaseModel):
    """
    The confidence interval of the metric.
    """

    class Config:
        extra = Extra.forbid

    lowerBound: Annotated[Optional[str], Field(description="The lower bound of the confidence interval.")] = None
    upperBound: Annotated[Optional[str], Field(description="The upper bound of the confidence interval.")] = None


class PerformanceMetric(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[Optional[str], Field(description="The type of performance metric.")] = None
    value: Annotated[Optional[str], Field(description="The value of the performance metric.")] = None
    slice: Annotated[
        Optional[str],
        Field(
            description=(
                "The name of the slice this metric was computed on. By default, assume this metric is not sliced."
            )
        ),
    ] = None
    confidenceInterval: Annotated[
        Optional[ConfidenceInterval], Field(description="The confidence interval of the metric.")
    ] = None


class Risk(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    name: Annotated[Optional[str], Field(description="The name of the risk.")] = None
    mitigationStrategy: Annotated[Optional[str], Field(description="Strategy used to address this risk.")] = None


class FairnessAssessment(CycloneDXBaseModel):
    """
    Information about the benefits and harms of the model to an identified at risk group.
    """

    class Config:
        extra = Extra.forbid

    groupAtRisk: Annotated[
        Optional[str],
        Field(description="The groups or individuals at risk of being systematically disadvantaged by the model."),
    ] = None
    benefits: Annotated[Optional[str], Field(description="Expected benefits to the identified groups.")] = None
    harms: Annotated[Optional[str], Field(description="Expected harms to the identified groups.")] = None
    mitigationStrategy: Annotated[
        Optional[str],
        Field(
            description=(
                "With respect to the benefits and harms outlined, please describe any mitigation strategy implemented."
            )
        ),
    ] = None


class Command(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    executed: Annotated[
        Optional[str], Field(description="A text representation of the executed command.", title="Executed")
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class AccessMode(Enum):
    """
    Describes the read-write access control for the workspace relative to the owning resource instance.
    """

    READ_ONLY = read_only = "read-only"
    READ_WRITE = read_write = "read-write"
    READ_WRITE_ONCE = read_write_once = "read-write-once"
    WRITE_ONCE = write_once = "write-once"
    WRITE_ONLY = write_only = "write-only"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Mode(Enum):
    """
    The mode for the volume instance.
    """

    FILESYSTEM = filesystem = "filesystem"
    BLOCK = block = "block"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Volume(CycloneDXBaseModel):
    """
    An identifiable, logical unit of data storage tied to a physical device.
    """

    class Config:
        extra = Extra.forbid

    uid: Annotated[
        Optional[str],
        Field(
            description="The unique identifier for the volume instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the volume instance", title="Name")] = None
    mode: Annotated[
        Optional[Mode], Field(description="The mode for the volume instance.", title="Mode")
    ] = Mode.filesystem
    path: Annotated[
        Optional[str], Field(description="The underlying path created from the actual volume.", title="Path")
    ] = None
    sizeAllocated: Annotated[
        Optional[str],
        Field(
            description=(
                "The allocated size of the volume accessible to the associated workspace. This should include the"
                " scalar size as well as IEC standard unit in either decimal or binary form."
            ),
            examples=["10GB", "2Ti", "1Pi"],
            title="Size allocated",
        ),
    ] = None
    persistent: Annotated[
        Optional[bool],
        Field(
            description="Indicates if the volume persists beyond the life of the resource it is associated with.",
            title="Persistent",
        ),
    ] = None
    remote: Annotated[
        Optional[bool],
        Field(description="Indicates if the volume is remotely (i.e., network) attached.", title="Remote"),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class Type6(Enum):
    """
    The source type of event which caused the trigger to fire.
    """

    MANUAL = manual = "manual"
    API = api = "api"
    WEBHOOK = webhook = "webhook"
    SCHEDULED = scheduled = "scheduled"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Type7(Enum):
    """
    Describes the type of data output.
    """

    ARTIFACT = artifact = "artifact"
    ATTESTATION = attestation = "attestation"
    LOG = log = "log"
    EVIDENCE = evidence = "evidence"
    METRICS = metrics = "metrics"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Condition(CycloneDXBaseModel):
    """
    A condition that was used to determine a trigger should be activated.
    """

    class Config:
        extra = Extra.forbid

    description: Annotated[
        Optional[str],
        Field(description="Describes the set of conditions which cause the trigger to activate.", title="Description"),
    ] = None
    expression: Annotated[
        Optional[str],
        Field(
            description="The logical expression that was evaluated that determined the trigger should be fired.",
            title="Expression",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class TaskType(Enum):
    COPY = copy = "copy"
    CLONE = clone = "clone"
    LINT = lint = "lint"
    SCAN = scan = "scan"
    MERGE = merge = "merge"
    BUILD = build = "build"
    TEST = test = "test"
    DELIVER = deliver = "deliver"
    DEPLOY = deploy = "deploy"
    RELEASE = release = "release"
    CLEAN = clean = "clean"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Parameter(CycloneDXBaseModel):
    """
    A representation of a functional parameter.
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[Optional[str], Field(description="The name of the parameter.", title="Name")] = None
    value: Annotated[Optional[str], Field(description="The value of the parameter.", title="Value")] = None
    dataType: Annotated[Optional[str], Field(description="The data type of the parameter.", title="Data type")] = None


class Algorithm(Enum):
    """
    Signature algorithm. The currently recognized JWA [RFC7518] and RFC8037 [RFC8037] asymmetric key algorithms. Note: Unlike RFC8037 [RFC8037] JSF requires explicit Ed* algorithm names instead of "EdDSA".
    """

    RS256 = "RS256"
    RS384 = "RS384"
    RS512 = "RS512"
    PS256 = "PS256"
    PS384 = "PS384"
    PS512 = "PS512"
    ES256 = "ES256"
    ES384 = "ES384"
    ES512 = "ES512"
    ED25519 = Ed25519 = "Ed25519"
    ED448 = Ed448 = "Ed448"
    HS256 = "HS256"
    HS384 = "HS384"
    HS512 = "HS512"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class KeyType(Enum):
    """
    Key type indicator.
    """

    EC = "EC"
    OKP = "OKP"
    RSA = "RSA"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class PublicKey(CycloneDXBaseModel):
    """
    Optional. Public key object.
    """

    class Config:
        extra = Extra.allow

    kty: KeyType


class OrganizationalEntity(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the organization", examples=["Example Inc."], title="Name")
    ] = None
    url: Annotated[
        Optional[List[str]],
        Field(
            description="The URL of the organization. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="URL",
        ),
    ] = None
    contact: Annotated[
        Optional[List[OrganizationalContact]],
        Field(description="A contact at the organization. Multiple contacts are allowed.", title="Contact"),
    ] = None


class Swid(CycloneDXBaseModel):
    """
    Specifies metadata and content for ISO-IEC 19770-2 Software Identification (SWID) Tags.
    """

    class Config:
        extra = Extra.forbid

    tagId: Annotated[str, Field(description="Maps to the tagId of a SoftwareIdentity.", title="Tag ID")]
    name: Annotated[str, Field(description="Maps to the name of a SoftwareIdentity.", title="Name")]
    version: Annotated[
        Optional[str], Field(description="Maps to the version of a SoftwareIdentity.", title="Version")
    ] = "0.0"
    tagVersion: Annotated[
        Optional[int], Field(description="Maps to the tagVersion of a SoftwareIdentity.", title="Tag Version")
    ] = 0
    patch: Annotated[
        Optional[bool], Field(description="Maps to the patch of a SoftwareIdentity.", title="Patch")
    ] = False
    text: Annotated[
        Optional[Attachment],
        Field(description="Specifies the metadata and content of the SWID tag.", title="Attachment text"),
    ] = None
    url: Annotated[Optional[str], Field(description="The URL to the SWID file.", title="URL")] = None


class Hash(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    alg: HashAlg
    content: Annotated[
        str,
        Field(
            examples=["3942447fac867ae5cdb3229b658f4d48"],
            regex="^([a-fA-F0-9]{32}|[a-fA-F0-9]{40}|[a-fA-F0-9]{64}|[a-fA-F0-9]{96}|[a-fA-F0-9]{128})$",
            title="Hash Content (value)",
        ),
    ]


class Licensor(CycloneDXBaseModel):
    """
    The individual or organization that grants a license to another individual or organization
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        OrganizationalEntity,
        Field(description="The organization that granted the license", title="Licensor (Organization)"),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ] = None


class Licensor1(CycloneDXBaseModel):
    """
    The individual or organization that grants a license to another individual or organization
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that granted the license", title="Licensor (Organization)"),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ]


class Licensee(CycloneDXBaseModel):
    """
    The individual or organization for which a license was granted to
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        OrganizationalEntity,
        Field(description="The organization that was granted the license", title="Licensee (Organization)"),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ] = None


class Licensee1(CycloneDXBaseModel):
    """
    The individual or organization for which a license was granted to
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that was granted the license", title="Licensee (Organization)"),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ]


class Purchaser(CycloneDXBaseModel):
    """
    The individual or organization that purchased the license
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        OrganizationalEntity,
        Field(description="The organization that purchased the license", title="Purchaser (Organization)"),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ] = None


class Purchaser1(CycloneDXBaseModel):
    """
    The individual or organization that purchased the license
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that purchased the license", title="Purchaser (Organization)"),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ]


class Licensing(CycloneDXBaseModel):
    """
    Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and other important metadata
    """

    class Config:
        extra = Extra.forbid

    altIds: Annotated[
        Optional[List[str]],
        Field(
            description="License identifiers that may be used to manage licenses and their lifecycle",
            title="Alternate License Identifiers",
        ),
    ] = None
    licensor: Annotated[
        Optional[Union[Licensor, Licensor1]],
        Field(
            description="The individual or organization that grants a license to another individual or organization",
            title="Licensor",
        ),
    ] = None
    licensee: Annotated[
        Optional[Union[Licensee, Licensee1]],
        Field(description="The individual or organization for which a license was granted to", title="Licensee"),
    ] = None
    purchaser: Annotated[
        Optional[Union[Purchaser, Purchaser1]],
        Field(description="The individual or organization that purchased the license", title="Purchaser"),
    ] = None
    purchaseOrder: Annotated[
        Optional[str],
        Field(
            description=(
                "The purchase order identifier the purchaser sent to a supplier or vendor to authorize a purchase"
            ),
            title="Purchase Order",
        ),
    ] = None
    licenseTypes: Annotated[
        Optional[List[LicenseType]],
        Field(
            description=(
                "The type of license(s) that was granted to the licensee\n\n* __academic__ = A license that grants use"
                " of software solely for the purpose of education or research.\n* __appliance__ = A license covering"
                " use of software embedded in a specific piece of hardware.\n* __client-access__ = A Client Access"
                " License (CAL) allows client computers to access services provided by server software.\n*"
                " __concurrent-user__ = A Concurrent User license (aka floating license) limits the number of licenses"
                " for a software application and licenses are shared among a larger number of users.\n* __core-points__"
                " = A license where the core of a computer's processor is assigned a specific number of points.\n*"
                " __custom-metric__ = A license for which consumption is measured by non-standard metrics.\n*"
                " __device__ = A license that covers a defined number of installations on computers and other types of"
                " devices.\n* __evaluation__ = A license that grants permission to install and use software for trial"
                " purposes.\n* __named-user__ = A license that grants access to the software to one or more pre-defined"
                " users.\n* __node-locked__ = A license that grants access to the software on one or more pre-defined"
                " computers or devices.\n* __oem__ = An Original Equipment Manufacturer license that is delivered with"
                " hardware, cannot be transferred to other hardware, and is valid for the life of the hardware.\n*"
                " __perpetual__ = A license where the software is sold on a one-time basis and the licensee can use a"
                " copy of the software indefinitely.\n* __processor-points__ = A license where each installation"
                " consumes points per processor.\n* __subscription__ = A license where the licensee pays a fee to use"
                " the software or service.\n* __user__ = A license that grants access to the software or service by a"
                " specified number of users.\n* __other__ = Another license type.\n"
            ),
            title="License Type",
        ),
    ] = None
    lastRenewal: Annotated[
        Optional[datetime],
        Field(
            description=(
                "The timestamp indicating when the license was last renewed. For new purchases, this is often the"
                " purchase or acquisition date. For non-perpetual licenses or subscriptions, this is the timestamp of"
                " when the license was last renewed."
            ),
            title="Last Renewal",
        ),
    ] = None
    expiration: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the current license expires (if applicable).", title="Expiration"
        ),
    ] = None


class License1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the license elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        spdx.LicenseID, Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)")
    ]
    name: Annotated[
        Optional[str],
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ] = None
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None
    licensing: Annotated[
        Optional[Licensing],
        Field(
            description=(
                "Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and"
                " other important metadata"
            ),
            title="Licensing information",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Licensor2(Licensor):
    """
    The individual or organization that grants a license to another individual or organization
    """


class Licensor3(Licensor1):
    """
    The individual or organization that grants a license to another individual or organization
    """


class Licensee2(Licensee):
    """
    The individual or organization for which a license was granted to
    """


class Licensee3(Licensee1):
    """
    The individual or organization for which a license was granted to
    """


class Purchaser2(Purchaser):
    """
    The individual or organization that purchased the license
    """


class Purchaser3(Purchaser1):
    """
    The individual or organization that purchased the license
    """


class Licensing1(CycloneDXBaseModel):
    """
    Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and other important metadata
    """

    class Config:
        extra = Extra.forbid

    altIds: Annotated[
        Optional[List[str]],
        Field(
            description="License identifiers that may be used to manage licenses and their lifecycle",
            title="Alternate License Identifiers",
        ),
    ] = None
    licensor: Annotated[
        Optional[Union[Licensor2, Licensor3]],
        Field(
            description="The individual or organization that grants a license to another individual or organization",
            title="Licensor",
        ),
    ] = None
    licensee: Annotated[
        Optional[Union[Licensee2, Licensee3]],
        Field(description="The individual or organization for which a license was granted to", title="Licensee"),
    ] = None
    purchaser: Annotated[
        Optional[Union[Purchaser2, Purchaser3]],
        Field(description="The individual or organization that purchased the license", title="Purchaser"),
    ] = None
    purchaseOrder: Annotated[
        Optional[str],
        Field(
            description=(
                "The purchase order identifier the purchaser sent to a supplier or vendor to authorize a purchase"
            ),
            title="Purchase Order",
        ),
    ] = None
    licenseTypes: Annotated[
        Optional[List[LicenseType]],
        Field(
            description=(
                "The type of license(s) that was granted to the licensee\n\n* __academic__ = A license that grants use"
                " of software solely for the purpose of education or research.\n* __appliance__ = A license covering"
                " use of software embedded in a specific piece of hardware.\n* __client-access__ = A Client Access"
                " License (CAL) allows client computers to access services provided by server software.\n*"
                " __concurrent-user__ = A Concurrent User license (aka floating license) limits the number of licenses"
                " for a software application and licenses are shared among a larger number of users.\n* __core-points__"
                " = A license where the core of a computer's processor is assigned a specific number of points.\n*"
                " __custom-metric__ = A license for which consumption is measured by non-standard metrics.\n*"
                " __device__ = A license that covers a defined number of installations on computers and other types of"
                " devices.\n* __evaluation__ = A license that grants permission to install and use software for trial"
                " purposes.\n* __named-user__ = A license that grants access to the software to one or more pre-defined"
                " users.\n* __node-locked__ = A license that grants access to the software on one or more pre-defined"
                " computers or devices.\n* __oem__ = An Original Equipment Manufacturer license that is delivered with"
                " hardware, cannot be transferred to other hardware, and is valid for the life of the hardware.\n*"
                " __perpetual__ = A license where the software is sold on a one-time basis and the licensee can use a"
                " copy of the software indefinitely.\n* __processor-points__ = A license where each installation"
                " consumes points per processor.\n* __subscription__ = A license where the licensee pays a fee to use"
                " the software or service.\n* __user__ = A license that grants access to the software or service by a"
                " specified number of users.\n* __other__ = Another license type.\n"
            ),
            title="License Type",
        ),
    ] = None
    lastRenewal: Annotated[
        Optional[datetime],
        Field(
            description=(
                "The timestamp indicating when the license was last renewed. For new purchases, this is often the"
                " purchase or acquisition date. For non-perpetual licenses or subscriptions, this is the timestamp of"
                " when the license was last renewed."
            ),
            title="Last Renewal",
        ),
    ] = None
    expiration: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the current license expires (if applicable).", title="Expiration"
        ),
    ] = None


class License2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the license elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        Optional[spdx.LicenseID],
        Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)"),
    ] = None
    name: Annotated[
        str,
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ]
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None
    licensing: Annotated[
        Optional[Licensing1],
        Field(
            description=(
                "Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and"
                " other important metadata"
            ),
            title="Licensing information",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class LicenseChoice1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    license: Annotated[Union[License1, License2], Field(title="License Object")]


class Commit(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    class Config:
        extra = Extra.forbid

    uid: Annotated[
        Optional[str],
        Field(
            description=(
                "A unique identifier of the commit. This may be version control specific. For example, Subversion uses"
                " revision numbers whereas git uses commit hashes."
            ),
            title="UID",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the commit. This URL will typically point to a commit in a version control system.",
            title="URL",
        ),
    ] = None
    author: Annotated[
        Optional[IdentifiableAction],
        Field(description="The author who created the changes in the commit", title="Author"),
    ] = None
    committer: Annotated[
        Optional[IdentifiableAction],
        Field(description="The person who committed or pushed the commit", title="Committer"),
    ] = None
    message: Annotated[
        Optional[str], Field(description="The text description of the contents of the commit", title="Message")
    ] = None


class Patch(CycloneDXBaseModel):
    """
    Specifies an individual patch
    """

    class Config:
        extra = Extra.forbid

    type: Annotated[
        Type1,
        Field(
            description=(
                "Specifies the purpose for the patch including the resolution of defects, security issues, or new"
                " behavior or functionality.\n\n* __unofficial__ = A patch which is not developed by the creators or"
                " maintainers of the software being patched. Refer to"
                " [https://en.wikipedia.org/wiki/Unofficial_patch](https://en.wikipedia.org/wiki/Unofficial_patch)\n*"
                " __monkey__ = A patch which dynamically modifies runtime behavior. Refer to"
                " [https://en.wikipedia.org/wiki/Monkey_patch](https://en.wikipedia.org/wiki/Monkey_patch)\n*"
                " __backport__ = A patch which takes code from a newer version of software and applies it to older"
                " versions of the same software. Refer to"
                " [https://en.wikipedia.org/wiki/Backporting](https://en.wikipedia.org/wiki/Backporting)\n*"
                " __cherry-pick__ = A patch created by selectively applying commits from other versions or branches of"
                " the same software."
            ),
            title="Type",
        ),
    ]
    diff: Annotated[
        Optional[Diff],
        Field(
            description=(
                "The patch file (or diff) that show changes. Refer to"
                " [https://en.wikipedia.org/wiki/Diff](https://en.wikipedia.org/wiki/Diff)"
            ),
            title="Diff",
        ),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]], Field(description="A collection of issues the patch resolves", title="Resolves")
    ] = None


class ExternalReference(CycloneDXBaseModel):
    """
    External references provide a way to document systems, sites, and information that may be relevant, but are not included with the BOM. They may also establish specific relationships within or external to the BOM.
    """

    class Config:
        extra = Extra.forbid

    url: Annotated[
        Union[str, Union[BomLinkDocumentType, BomLinkElementType]],
        Field(
            description=(
                "The URI (URL or URN) to the external reference. External references are URIs and therefore can accept"
                " any URL scheme including https ([RFC-7230](https://www.ietf.org/rfc/rfc7230.txt)), mailto"
                " ([RFC-2368](https://www.ietf.org/rfc/rfc2368.txt)), tel"
                " ([RFC-3966](https://www.ietf.org/rfc/rfc3966.txt)), and dns"
                " ([RFC-4501](https://www.ietf.org/rfc/rfc4501.txt)). External references may also include formally"
                " registered URNs such as [CycloneDX BOM-Link](https://cyclonedx.org/capabilities/bomlink/) to"
                " reference CycloneDX BOMs or any object within a BOM. BOM-Link transforms applicable external"
                " references into relationships that can be expressed in a BOM or across BOMs."
            ),
            title="URL",
        ),
    ]
    comment: Annotated[
        Optional[str], Field(description="An optional comment describing the external reference", title="Comment")
    ] = None
    type: Annotated[
        Type3,
        Field(
            description=(
                "Specifies the type of external reference.\n\n* __vcs__ = Version Control System\n* __issue-tracker__ ="
                " Issue or defect tracking system, or an Application Lifecycle Management (ALM) system\n* __website__ ="
                " Website\n* __advisories__ = Security advisories\n* __bom__ = Bill of Materials (SBOM, OBOM, HBOM,"
                " SaaSBOM, etc)\n* __mailing-list__ = Mailing list or discussion group\n* __social__ = Social media"
                " account\n* __chat__ = Real-time chat platform\n* __documentation__ = Documentation, guides, or how-to"
                " instructions\n* __support__ = Community or commercial support\n* __distribution__ = Direct or"
                " repository download location\n* __distribution-intake__ = The location where a component was"
                ' published to. This is often the same as "distribution" but may also include specialized publishing'
                " processes that act as an intermediary\n* __license__ = The URL to the license file. If a license URL"
                " has been defined in the license node, it should also be defined as an external reference for"
                " completeness\n* __build-meta__ = Build-system specific meta file (i.e. pom.xml, package.json,"
                " .nuspec, etc)\n* __build-system__ = URL to an automated build system\n* __release-notes__ = URL to"
                " release notes\n* __security-contact__ = Specifies a way to contact the maintainer, supplier, or"
                " provider in the event of a security incident. Common URIs include links to a disclosure procedure, a"
                " mailto (RFC-2368) that specifies an email address, a tel (RFC-3966) that specifies a phone number, or"
                " dns (RFC-4501) that specifies the records containing DNS Security TXT\n* __model-card__ = A model"
                " card describes the intended uses of a machine learning model, potential limitations, biases, ethical"
                " considerations, training parameters, datasets used to train the model, performance metrics, and other"
                " relevant data useful for ML transparency\n* __log__ = A record of events that occurred in a computer"
                " system or application, such as problems, errors, or information on current operations\n*"
                " __configuration__ = Parameters or settings that may be used by other components or services\n*"
                " __evidence__ = Information used to substantiate a claim\n* __formulation__ = Describes how a"
                " component or service was manufactured or deployed\n* __attestation__ = Human or machine-readable"
                " statements containing facts, evidence, or testimony\n* __threat-model__ = An enumeration of"
                " identified weaknesses, threats, and countermeasures, dataflow diagram (DFD), attack tree, and other"
                " supporting documentation in human-readable or machine-readable format\n* __adversary-model__ = The"
                " defined assumptions, goals, and capabilities of an adversary.\n* __risk-assessment__ = Identifies and"
                " analyzes the potential of future events that may negatively impact individuals, assets, and/or the"
                " environment. Risk assessments may also include judgments on the tolerability of each risk.\n*"
                " __vulnerability-assertion__ = A Vulnerability Disclosure Report (VDR) which asserts the known and"
                " previously unknown vulnerabilities that affect a component, service, or product including the"
                " analysis and findings describing the impact (or lack of impact) that the reported vulnerability has"
                " on a component, service, or product.\n* __exploitability-statement__ = A Vulnerability Exploitability"
                " eXchange (VEX) which asserts the known vulnerabilities that do not affect a product, product family,"
                " or organization, and optionally the ones that do. The VEX should include the analysis and findings"
                " describing the impact (or lack of impact) that the reported vulnerability has on the product, product"
                " family, or organization.\n* __pentest-report__ = Results from an authorized simulated cyberattack on"
                " a component or service, otherwise known as a penetration test\n* __static-analysis-report__ = SARIF"
                " or proprietary machine or human-readable report for which static analysis has identified code"
                " quality, security, and other potential issues with the source code\n* __dynamic-analysis-report__ ="
                " Dynamic analysis report that has identified issues such as vulnerabilities and misconfigurations\n*"
                " __runtime-analysis-report__ = Report generated by analyzing the call stack of a running"
                " application\n* __component-analysis-report__ = Report generated by Software Composition Analysis"
                " (SCA), container analysis, or other forms of component analysis\n* __maturity-report__ = Report"
                " containing a formal assessment of an organization, business unit, or team against a maturity model\n*"
                " __certification-report__ = Industry, regulatory, or other certification from an accredited (if"
                " applicable) certification body\n* __quality-metrics__ = Report or system in which quality metrics can"
                " be obtained\n* __codified-infrastructure__ = Code or configuration that defines and provisions"
                " virtualized infrastructure, commonly referred to as Infrastructure as Code (IaC)\n* __poam__ = Plans"
                ' of Action and Milestones (POAM) compliment an "attestation" external reference. POAM is defined by'
                ' NIST as a "document that identifies tasks needing to be accomplished. It details resources required'
                " to accomplish the elements of the plan, any milestones in meeting the tasks and scheduled completion"
                ' dates for the milestones".\n* __other__ = Use this if no other types accurately describe the purpose'
                " of the external reference"
            ),
            title="Type",
        ),
    ]
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the external reference (if applicable).", title="Hashes")
    ] = None


class ComponentEvidence(CycloneDXBaseModel):
    """
    Provides the ability to document evidence collected through various forms of extraction or analysis.
    """

    class Config:
        extra = Extra.forbid

    identity: Annotated[
        Optional[Identity], Field(description="Evidence that substantiates the identity of a component.")
    ] = None
    occurrences: Annotated[
        Optional[List[Occurrence]],
        Field(
            description="Evidence of individual instances of a component spread across multiple locations.",
            title="Occurrences",
        ),
    ] = None
    callstack: Annotated[
        Optional[Callstack], Field(description="Evidence of the components use through the callstack.")
    ] = None
    licenses: Annotated[
        Optional[Union[List[LicenseChoice1], LicenseChoice2]],
        Field(
            description=(
                "EITHER (list of SPDX licenses and/or named licenses) OR (tuple of one SPDX License Expression)"
            ),
            title="Component License(s)",
        ),
    ] = None
    copyright: Annotated[Optional[List[Copyright]], Field(title="Copyright")] = None


class Rating(CycloneDXBaseModel):
    """
    Defines the severity or risk ratings of a vulnerability.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[VulnerabilitySource],
        Field(description="The source that calculated the severity or risk rating of the vulnerability."),
    ] = None
    score: Annotated[Optional[float], Field(description="The numerical score of the rating.", title="Score")] = None
    severity: Annotated[
        Optional[Severity],
        Field(
            description="Textual representation of the severity that corresponds to the numerical score of the rating."
        ),
    ] = None
    method: Optional[ScoreMethod] = None
    vector: Annotated[
        Optional[str],
        Field(
            description="Textual representation of the metric values used to score the vulnerability", title="Vector"
        ),
    ] = None
    justification: Annotated[
        Optional[str],
        Field(description="An optional reason for rating the vulnerability as it was", title="Justification"),
    ] = None


class Credits(CycloneDXBaseModel):
    """
    Individuals or organizations credited with the discovery of the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    organizations: Annotated[
        Optional[List[OrganizationalEntity]],
        Field(description="The organizations credited with vulnerability discovery.", title="Organizations"),
    ] = None
    individuals: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description=(
                "The individuals, not associated with organizations, that are credited with vulnerability discovery."
            ),
            title="Individuals",
        ),
    ] = None


class Versions(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    version: Annotated[
        str, Field(description="A single version of a component or service.", max_length=1024, min_length=1)
    ]
    range: Annotated[
        Optional[str],
        Field(
            description=(
                "A version range specified in Package URL Version Range syntax (vers) which is defined at"
                " https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst"
            ),
            max_length=1024,
            min_length=1,
        ),
    ] = None
    status: Annotated[
        Optional[AffectedStatus], Field(description="The vulnerability status for the version or range of versions.")
    ] = AffectedStatus.affected


class Versions1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    version: Annotated[
        Optional[str], Field(description="A single version of a component or service.", max_length=1024, min_length=1)
    ] = None
    range: Annotated[
        str,
        Field(
            description=(
                "A version range specified in Package URL Version Range syntax (vers) which is defined at"
                " https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst"
            ),
            max_length=1024,
            min_length=1,
        ),
    ]
    status: Annotated[
        Optional[AffectedStatus], Field(description="The vulnerability status for the version or range of versions.")
    ] = AffectedStatus.affected


class Affect(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    ref: Annotated[
        Union[RefLinkType, BomLinkElementType],
        Field(description="References a component or service by the objects bom-ref", title="Reference"),
    ]
    versions: Annotated[
        Optional[List[Union[Versions, Versions1]]],
        Field(description="Zero or more individual versions or range of versions.", title="Versions"),
    ] = None


class Considerations(CycloneDXBaseModel):
    """
    What considerations should be taken into account regarding the model's construction, training, and application?
    """

    class Config:
        extra = Extra.forbid

    users: Annotated[
        Optional[List[str]], Field(description="Who are the intended users of the model?", title="Users")
    ] = None
    useCases: Annotated[
        Optional[List[str]], Field(description="What are the intended use cases of the model?", title="Use Cases")
    ] = None
    technicalLimitations: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "What are the known technical limitations of the model? E.g. What kind(s) of data should the model be"
                " expected not to perform well on? What are the factors that might degrade model performance?"
            ),
            title="Technical Limitations",
        ),
    ] = None
    performanceTradeoffs: Annotated[
        Optional[List[str]],
        Field(
            description="What are the known tradeoffs in accuracy/performance of the model?",
            title="Performance Tradeoffs",
        ),
    ] = None
    ethicalConsiderations: Annotated[
        Optional[List[Risk]],
        Field(
            description="What are the ethical (or environmental) risks involved in the application of this model?",
            title="Ethical Considerations",
        ),
    ] = None
    fairnessAssessments: Annotated[
        Optional[List[FairnessAssessment]],
        Field(
            description=(
                "How does the model affect groups at risk of being systematically disadvantaged? What are the harms and"
                " benefits to the various affected groups?"
            ),
            title="Fairness Assessments",
        ),
    ] = None


class DataGovernanceResponsibleParty1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    organization: Annotated[OrganizationalEntity, Field(title="Organization")]
    contact: Annotated[Optional[OrganizationalContact], Field(title="Individual")] = None


class DataGovernanceResponsibleParty2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    organization: Annotated[Optional[OrganizationalEntity], Field(title="Organization")] = None
    contact: Annotated[OrganizationalContact, Field(title="Individual")]


class GraphicsCollection(CycloneDXBaseModel):
    """
    A collection of graphics that represent various measurements.
    """

    class Config:
        extra = Extra.forbid

    description: Annotated[Optional[str], Field(description="A description of this collection of graphics.")] = None
    collection: Annotated[Optional[List[Graphic]], Field(description="A collection of graphics.")] = None


class Step(CycloneDXBaseModel):
    """
    Executes specific commands or tools in order to accomplish its owning task as part of a sequence.
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[Optional[str], Field(description="A name for the step.", title="Name")] = None
    description: Annotated[Optional[str], Field(description="A description of the step.", title="Description")] = None
    commands: Annotated[
        Optional[List[Command]],
        Field(description="Ordered list of commands or directives for the step", title="Commands"),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class ResourceReferenceChoice1(CycloneDXBaseModel):
    """
    A reference to a locally defined resource (e.g., a bom-ref) or an externally accessible resource.
    """

    class Config:
        extra = Extra.forbid

    ref: Annotated[
        Union[RefLinkType, BomLinkElementType],
        Field(description="References an object by its bom-ref attribute", title="BOM Reference"),
    ]
    externalReference: Annotated[
        Optional[ExternalReference],
        Field(description="Reference to an externally accessible resource.", title="External reference"),
    ] = None


class ResourceReferenceChoice2(CycloneDXBaseModel):
    """
    A reference to a locally defined resource (e.g., a bom-ref) or an externally accessible resource.
    """

    class Config:
        extra = Extra.forbid

    ref: Annotated[
        Optional[Union[RefLinkType, BomLinkElementType]],
        Field(description="References an object by its bom-ref attribute", title="BOM Reference"),
    ] = None
    externalReference: Annotated[
        ExternalReference,
        Field(description="Reference to an externally accessible resource.", title="External reference"),
    ]


class Signer(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    algorithm: Union[Algorithm, AnyUrl]
    keyId: Annotated[
        Optional[str],
        Field(description="Optional. Application specific string identifying the signature key.", title="Key ID"),
    ] = None
    publicKey: Annotated[
        Optional[PublicKey], Field(description="Optional. Public key object.", title="Public key")
    ] = None
    certificatePath: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Optional. Sorted array of X.509 [RFC5280] certificates, where the first element must contain the"
                " signature certificate. The certificate path must be contiguous but is not required to be complete."
            ),
            title="Certificate path",
        ),
    ] = None
    excludes: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Optional. Array holding the names of one or more application level properties that must be excluded"
                ' from the signature process. Note that the "excludes" property itself, must also be excluded from the'
                ' signature process. Since both the "excludes" property and the associated data it points to are'
                " unsigned, a conforming JSF implementation must provide options for specifying which properties to"
                " accept."
            ),
            title="Excludes",
        ),
    ] = None
    value: Annotated[
        str,
        Field(
            description=(
                "The signature data. Note that the binary representation must follow the JWA [RFC7518] specifications."
            ),
            title="Signature",
        ),
    ]


class Tool(CycloneDXBaseModel):
    """
    [Deprecated] - DO NOT USE. This will be removed in a future version. This will be removed in a future version. Use component or service instead. Information about the automated or manual tool used
    """

    class Config:
        extra = Extra.forbid

    vendor: Annotated[
        Optional[str], Field(description="The name of the vendor who created the tool", title="Tool Vendor")
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the tool", title="Tool Name")] = None
    version: Annotated[Optional[str], Field(description="The version of the tool", title="Tool Version")] = None
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the tool (if applicable).", title="Hashes")
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant,"
                " but are not included with the BOM. They may also establish specific relationships within or external"
                " to the BOM."
            ),
            title="External References",
        ),
    ] = None


class QuantitativeAnalysis(CycloneDXBaseModel):
    """
    A quantitative analysis of the model
    """

    class Config:
        extra = Extra.forbid

    performanceMetrics: Annotated[
        Optional[List[PerformanceMetric]],
        Field(
            description=(
                "The model performance metrics being reported. Examples may include accuracy, F1 score, precision,"
                " top-3 error rates, MSC, etc."
            ),
            title="Performance Metrics",
        ),
    ] = None
    graphics: Optional[GraphicsCollection] = None


class DataGovernance(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    custodians: Annotated[
        Optional[List[Union[DataGovernanceResponsibleParty1, DataGovernanceResponsibleParty2]]],
        Field(
            description="Data custodians are responsible for the safe custody, transport, and storage of data.",
            title="Data Custodians",
        ),
    ] = None
    stewards: Annotated[
        Optional[List[Union[DataGovernanceResponsibleParty1, DataGovernanceResponsibleParty2]]],
        Field(
            description="Data stewards are responsible for data content, context, and associated business rules.",
            title="Data Stewards",
        ),
    ] = None
    owners: Annotated[
        Optional[List[Union[DataGovernanceResponsibleParty1, DataGovernanceResponsibleParty2]]],
        Field(description="Data owners are concerned with risk and appropriate access to data.", title="Data Owners"),
    ] = None


class Workspace(CycloneDXBaseModel):
    """
    A named filesystem or data resource shareable by workflow tasks.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        str,
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the workspace elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[Optional[str], Field(description="The name of the resource instance.", title="Name")] = None
    aliases: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The names for the workspace as referenced by other workflow tasks. Effectively, a name mapping so"
                " other tasks can use their own local name in their steps."
            ),
            title="Aliases",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the resource instance.", title="Description")
    ] = None
    resourceReferences: Annotated[
        Optional[List[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    accessMode: Annotated[
        Optional[AccessMode],
        Field(
            description=(
                "Describes the read-write access control for the workspace relative to the owning resource instance."
            ),
            title="Access mode",
        ),
    ] = None
    mountPath: Annotated[
        Optional[str],
        Field(
            description=(
                "A path to a location on disk where the workspace will be available to the associated task's steps."
            ),
            title="Mount path",
        ),
    ] = None
    managedDataType: Annotated[
        Optional[str],
        Field(
            description="The name of a domain-specific data type the workspace represents.",
            examples=["ConfigMap", "Secret"],
            title="Managed data type",
        ),
    ] = None
    volumeRequest: Annotated[
        Optional[str],
        Field(
            description="Identifies the reference to the request for a specific volume type and parameters.",
            examples=["a kubernetes Persistent Volume Claim (PVC) name"],
            title="Volume request",
        ),
    ] = None
    volume: Annotated[
        Optional[Volume],
        Field(
            description="Information about the actual volume instance allocated to the workspace.",
            examples=["see https://kubernetes.io/docs/concepts/storage/persistent-volumes/"],
            title="Volume",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class Event(CycloneDXBaseModel):
    """
    Represents something that happened that may trigger a response.
    """

    class Config:
        extra = Extra.forbid

    uid: Annotated[
        Optional[str], Field(description="The unique identifier of the event.", title="Unique Identifier (UID)")
    ] = None
    description: Annotated[Optional[str], Field(description="A description of the event.", title="Description")] = None
    timeReceived: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the event was received.", title="Time Received"),
    ] = None
    data: Annotated[Optional[Attachment], Field(description="Encoding of the raw event data.", title="Data")] = None
    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(description="References the component or service that was the source of the event", title="Source"),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(description="References the component or service that was the target of the event", title="Target"),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class InputType1(CycloneDXBaseModel):
    """
    Type that represents various input data types and formats.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A references to the component or service that provided the input to the task (e.g., reference to a"
                " service with data flow value of `inbound`)"
            ),
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to the component or service that received or stored the input if not the task itself"
                " (e.g., a local, named storage workspace)"
            ),
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Union[ResourceReferenceChoice1, ResourceReferenceChoice2],
        Field(
            description=(
                "A reference to an independent resource provided as an input to a task by the workflow runtime."
            ),
            examples=[
                "reference to a configuration file in a repository (i.e., a bom-ref)",
                "reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ]
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class InputType2(CycloneDXBaseModel):
    """
    Type that represents various input data types and formats.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A references to the component or service that provided the input to the task (e.g., reference to a"
                " service with data flow value of `inbound`)"
            ),
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to the component or service that received or stored the input if not the task itself"
                " (e.g., a local, named storage workspace)"
            ),
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to an independent resource provided as an input to a task by the workflow runtime."
            ),
            examples=[
                "reference to a configuration file in a repository (i.e., a bom-ref)",
                "reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        List[Parameter],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ]
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class InputType3(CycloneDXBaseModel):
    """
    Type that represents various input data types and formats.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A references to the component or service that provided the input to the task (e.g., reference to a"
                " service with data flow value of `inbound`)"
            ),
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to the component or service that received or stored the input if not the task itself"
                " (e.g., a local, named storage workspace)"
            ),
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to an independent resource provided as an input to a task by the workflow runtime."
            ),
            examples=[
                "reference to a configuration file in a repository (i.e., a bom-ref)",
                "reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        List[Union[Property, str]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ]
    data: Annotated[Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class InputType4(CycloneDXBaseModel):
    """
    Type that represents various input data types and formats.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A references to the component or service that provided the input to the task (e.g., reference to a"
                " service with data flow value of `inbound`)"
            ),
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to the component or service that received or stored the input if not the task itself"
                " (e.g., a local, named storage workspace)"
            ),
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "A reference to an independent resource provided as an input to a task by the workflow runtime."
            ),
            examples=[
                "reference to a configuration file in a repository (i.e., a bom-ref)",
                "reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[Attachment, Field(description="Inputs that have the form of data.", title="Data")]
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class OutputType1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[Optional[Type7], Field(description="Describes the type of data output.", title="Type")] = None
    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "Component or service that received the output from the task (e.g., reference to an artifactory service"
                " with data flow value of `outbound`)"
            ),
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Union[ResourceReferenceChoice1, ResourceReferenceChoice2],
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ]
    data: Annotated[Optional[Attachment], Field(description="Outputs that have the form of data.", title="Data")] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class OutputType2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[Optional[Type7], Field(description="Describes the type of data output.", title="Type")] = None
    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "Component or service that received the output from the task (e.g., reference to an artifactory service"
                " with data flow value of `outbound`)"
            ),
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ] = None
    data: Annotated[Optional[Attachment], Field(description="Outputs that have the form of data.", title="Data")] = None
    environmentVars: Annotated[
        List[Union[Property, str]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ]
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class OutputType3(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[Optional[Type7], Field(description="Describes the type of data output.", title="Type")] = None
    source: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description=(
                "Component or service that received the output from the task (e.g., reference to an artifactory service"
                " with data flow value of `outbound`)"
            ),
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]],
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ] = None
    data: Annotated[Attachment, Field(description="Outputs that have the form of data.", title="Data")]
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class Signature1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    signers: Annotated[
        Optional[List[Signer]],
        Field(description="Unique top level property for Multiple Signatures. (multisignature)", title="Signature"),
    ] = None


class Signature2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    chain: Annotated[
        Optional[List[Signer]],
        Field(description="Unique top level property for Signature Chains. (signaturechain)", title="Signature"),
    ] = None


class ServiceData(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    flow: Annotated[
        DataFlowDirection,
        Field(
            description=(
                "Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states"
                " that data enters the service. Outbound flow states that data leaves the service. Bi-directional"
                " states that data flows both ways, and unknown states that the direction is not known."
            ),
            title="Directional Flow",
        ),
    ]
    classification: Annotated[
        str,
        Field(
            description=(
                "Data classification tags data according to its type, sensitivity, and value if altered, stolen, or"
                " destroyed."
            ),
            title="Data Classification",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="Name for the defined data", examples=["Credit card reporting"], title="Name")
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="Short description of the data content and usage",
            examples=["Credit card information being exchanged in between the web app and the database"],
            title="Description",
        ),
    ] = None
    governance: Annotated[Optional[DataGovernance], Field(title="Data Governance")] = None
    source: Annotated[
        Optional[List[Union[str, BomLinkElementType]]],
        Field(
            description="The URI, URL, or BOM-Link of the components or services the data came in from", title="Source"
        ),
    ] = None
    destination: Annotated[
        Optional[List[Union[str, BomLinkElementType]]],
        Field(
            description="The URI, URL, or BOM-Link of the components or services the data is sent to",
            title="Destination",
        ),
    ] = None


class ComponentData(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the dataset elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    type: Annotated[
        Type5,
        Field(
            description=(
                "The general theme or subject matter of the data being specified.\n\n* __source-code__ = Any type of"
                " code, code snippet, or data-as-code.\n* __configuration__ = Parameters or settings that may be used"
                " by other components.\n* __dataset__ = A collection of data.\n* __definition__ = Data that can be used"
                " to create new instances of what the definition defines.\n* __other__ = Any other type of data that"
                " does not fit into existing definitions."
            ),
            title="Type of Data",
        ),
    ]
    name: Annotated[Optional[str], Field(description="The name of the dataset.")] = None
    contents: Annotated[
        Optional[Contents],
        Field(
            description="The contents or references to the contents of the data being described.", title="Data Contents"
        ),
    ] = None
    classification: Annotated[
        Optional[str],
        Field(
            description=(
                "Data classification tags data according to its type, sensitivity, and value if altered, stolen, or"
                " destroyed."
            ),
            title="Data Classification",
        ),
    ] = None
    sensitiveData: Annotated[
        Optional[List[str]], Field(description="A description of any sensitive data in a dataset.")
    ] = None
    graphics: Optional[GraphicsCollection] = None
    description: Annotated[
        Optional[str],
        Field(
            description=(
                "A description of the dataset. Can describe size of dataset, whether it's used for source code,"
                " training, testing, or validation, etc."
            )
        ),
    ] = None
    governance: Annotated[Optional[DataGovernance], Field(title="Data Governance")] = None


class Trigger(CycloneDXBaseModel):
    """
    Represents a resource that can conditionally activate (or fire) tasks based upon associated events and their data.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        str,
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the trigger elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[Optional[str], Field(description="The name of the resource instance.", title="Name")] = None
    description: Annotated[
        Optional[str], Field(description="A description of the resource instance.", title="Description")
    ] = None
    resourceReferences: Annotated[
        Optional[List[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    type: Annotated[
        Type6, Field(description="The source type of event which caused the trigger to fire.", title="Type")
    ]
    event: Annotated[
        Optional[Event],
        Field(description="The event data that caused the associated trigger to activate.", title="Event"),
    ] = None
    conditions: Annotated[Optional[List[Condition]], Field()] = None
    timeActivated: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the trigger was activated.", title="Time activated"),
    ] = None
    inputs: Annotated[
        Optional[List[Union[InputType1, InputType2, InputType3, InputType4]]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=["a `configuration` file which was declared as a local `component` or `externalReference`"],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[Union[OutputType1, OutputType2, OutputType3]]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class Service(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the service elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    provider: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that provides the service.", title="Provider"),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name, namespace, or identifier. This will often be a shortened, single name of the"
                " company or project that produced the service or domain name. Whitespace and special characters should"
                " be avoided."
            ),
            examples=["com.acme"],
            title="Service Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the service. This will often be a shortened, single name of the service.",
            examples=["ticker-service"],
            title="Service Name",
        ),
    ]
    version: Annotated[
        Optional[str], Field(description="The service version.", examples=["1.0.0"], title="Service Version")
    ] = None
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the service", title="Service Description")
    ] = None
    endpoints: Annotated[
        Optional[List[str]],
        Field(
            description="The endpoint URIs of the service. Multiple endpoints are allowed.",
            examples=["https://example.com/api/v1/ticker"],
            title="Endpoints",
        ),
    ] = None
    authenticated: Annotated[
        Optional[bool],
        Field(
            description=(
                "A boolean value indicating if the service requires authentication. A value of true indicates the"
                " service requires authentication prior to use. A value of false indicates the service does not require"
                " authentication."
            ),
            title="Authentication Required",
        ),
    ] = None
    x_trust_boundary: Annotated[
        Optional[bool],
        Field(
            alias="x-trust-boundary",
            description=(
                "A boolean value indicating if use of the service crosses a trust zone or boundary. A value of true"
                " indicates that by using the service, a trust boundary is crossed. A value of false indicates that by"
                " using the service, a trust boundary is not crossed."
            ),
            title="Crosses Trust Boundary",
        ),
    ] = None
    trustZone: Annotated[
        Optional[str], Field(description="The name of the trust zone the service resides in.", title="Trust Zone")
    ] = None
    data: Annotated[
        Optional[List[ServiceData]],
        Field(
            description=(
                "Specifies information about the data including the directional flow of data and the data"
                " classification."
            ),
            title="Data",
        ),
    ] = None
    licenses: Annotated[
        Optional[Union[List[LicenseChoice1], LicenseChoice2]],
        Field(
            description=(
                "EITHER (list of SPDX licenses and/or named licenses) OR (tuple of one SPDX License Expression)"
            ),
            title="Component License(s)",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant,"
                " but are not included with the BOM. They may also establish specific relationships within or external"
                " to the BOM."
            ),
            title="External References",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services included or deployed behind the parent service. This is not a dependency tree. It"
                " provides a way to specify a hierarchical representation of service assemblies."
            ),
            title="Services",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes], Field(description="Specifies optional release notes.", title="Release notes")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Compositions(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the composition elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    aggregate: Annotated[
        AggregateType,
        Field(
            description=(
                "Specifies an aggregate type that describe how complete a relationship is.\n\n* __complete__ = The"
                " relationship is complete. No further relationships including constituent components, services, or"
                " dependencies are known to exist.\n* __incomplete__ = The relationship is incomplete. Additional"
                " relationships exist and may include constituent components, services, or dependencies.\n*"
                " __incomplete&#95;first&#95;party&#95;only__ = The relationship is incomplete. Only relationships for"
                " first-party components, services, or their dependencies are represented.\n*"
                " __incomplete&#95;first&#95;party&#95;proprietary&#95;only__ = The relationship is incomplete. Only"
                " relationships for first-party components, services, or their dependencies are represented, limited"
                " specifically to those that are proprietary.\n*"
                " __incomplete&#95;first&#95;party&#95;opensource&#95;only__ = The relationship is incomplete. Only"
                " relationships for first-party components, services, or their dependencies are represented, limited"
                " specifically to those that are opensource.\n* __incomplete&#95;third&#95;party&#95;only__ = The"
                " relationship is incomplete. Only relationships for third-party components, services, or their"
                " dependencies are represented.\n* __incomplete&#95;third&#95;party&#95;proprietary&#95;only__ = The"
                " relationship is incomplete. Only relationships for third-party components, services, or their"
                " dependencies are represented, limited specifically to those that are proprietary.\n*"
                " __incomplete&#95;third&#95;party&#95;opensource&#95;only__ = The relationship is incomplete. Only"
                " relationships for third-party components, services, or their dependencies are represented, limited"
                " specifically to those that are opensource.\n* __unknown__ = The relationship may be complete or"
                " incomplete. This usually signifies a 'best-effort' to obtain constituent components, services, or"
                " dependencies but the completeness is inconclusive.\n* __not&#95;specified__ = The relationship"
                " completeness is not specified.\n"
            ),
            title="Aggregate",
        ),
    ]
    assemblies: Annotated[
        Optional[List[Union[RefLinkType, BomLinkElementType]]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Assemblies refer to nested"
                " relationships whereby a constituent part may include other constituent parts. References do not"
                " cascade to child parts. References are explicit for the specified constituent part only."
            ),
            title="BOM references",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Dependencies refer to a"
                " relationship whereby an independent constituent part requires another independent constituent part."
                " References do not cascade to transitive dependencies. References are explicit for the specified"
                " dependency only."
            ),
            title="BOM references",
        ),
    ] = None
    vulnerabilities: Annotated[
        Optional[List[str]],
        Field(
            description="The bom-ref identifiers of the vulnerabilities being described.",
            title="BOM references",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class ModelParameters(CycloneDXBaseModel):
    """
    Hyper-parameters for construction of the model.
    """

    class Config:
        extra = Extra.forbid

    approach: Annotated[
        Optional[Approach],
        Field(description="The overall approach to learning used by the model for problem solving.", title="Approach"),
    ] = None
    task: Annotated[
        Optional[str],
        Field(
            description=(
                "Directly influences the input and/or output. Examples include classification, regression, clustering,"
                " etc."
            ),
            title="Task",
        ),
    ] = None
    architectureFamily: Annotated[
        Optional[str],
        Field(
            description=(
                "The model architecture family such as transformer network, convolutional neural network, residual"
                " neural network, LSTM neural network, etc."
            ),
            title="Architecture Family",
        ),
    ] = None
    modelArchitecture: Annotated[
        Optional[str],
        Field(
            description="The specific architecture of the model such as GPT-1, ResNet-50, YOLOv3, etc.",
            title="Model Architecture",
        ),
    ] = None
    datasets: Annotated[
        Optional[List[Union[ComponentData, Datasets]]],
        Field(description="The datasets used to train and evaluate the model.", title="Datasets"),
    ] = None
    inputs: Annotated[
        Optional[List[InputOutputMLParameters]], Field(description="The input format(s) of the model", title="Inputs")
    ] = None
    outputs: Annotated[
        Optional[List[InputOutputMLParameters]],
        Field(description="The output format(s) from the model", title="Outputs"),
    ] = None


class ModelCard(CycloneDXBaseModel):
    """
    A model card describes the intended uses of a machine learning model and potential limitations, including biases and ethical considerations. Model cards typically contain the training parameters, which datasets were used to train the model, performance metrics, and other relevant data useful for ML transparency. This object SHOULD be specified for any component of type `machine-learning-model` and MUST NOT be specified for other component types.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the model card elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    modelParameters: Annotated[
        Optional[ModelParameters],
        Field(description="Hyper-parameters for construction of the model.", title="Model Parameters"),
    ] = None
    quantitativeAnalysis: Annotated[
        Optional[QuantitativeAnalysis],
        Field(description="A quantitative analysis of the model", title="Quantitative Analysis"),
    ] = None
    considerations: Annotated[
        Optional[Considerations],
        Field(
            description=(
                "What considerations should be taken into account regarding the model's construction, training, and"
                " application?"
            ),
            title="Considerations",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Task(CycloneDXBaseModel):
    """
    Describes the inputs, sequence of steps and resources used to accomplish a task and its output.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        str,
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the task elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[Optional[str], Field(description="The name of the resource instance.", title="Name")] = None
    description: Annotated[
        Optional[str], Field(description="A description of the resource instance.", title="Description")
    ] = None
    resourceReferences: Annotated[
        Optional[List[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    taskTypes: Annotated[
        List[TaskType],
        Field(
            description="Indicates the types of activities performed by the set of workflow tasks.", title="Task types"
        ),
    ]
    trigger: Annotated[
        Optional[Trigger], Field(description="The trigger that initiated the task.", title="Trigger")
    ] = None
    steps: Annotated[
        Optional[List[Step]],
        Field(
            description="The sequence of steps for the task.",
            title="Steps",
        ),
    ] = None
    inputs: Annotated[
        Optional[List[Union[InputType1, InputType2, InputType3, InputType4]]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=["a `configuration` file which was declared as a local `component` or `externalReference`"],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[Union[OutputType1, OutputType2, OutputType3]]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    timeStart: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the task started.", title="Time start"),
    ] = None
    timeEnd: Annotated[
        Optional[datetime], Field(description="The date and time (timestamp) when the task ended.", title="Time end")
    ] = None
    workspaces: Annotated[
        Optional[List[Workspace]],
        Field(
            description="A set of named filesystem or data resource shareable by workflow tasks.",
            title="Workspaces",
        ),
    ] = None
    runtimeTopology: Annotated[
        Optional[List[Dependency]],
        Field(
            description="A graph of the component runtime topology for task's instance.",
            title="Runtime topology",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class Workflow(CycloneDXBaseModel):
    """
    A specialized orchestration task.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        str,
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the workflow elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[Optional[str], Field(description="The name of the resource instance.", title="Name")] = None
    description: Annotated[
        Optional[str], Field(description="A description of the resource instance.", title="Description")
    ] = None
    resourceReferences: Annotated[
        Optional[List[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    tasks: Annotated[
        Optional[List[Task]],
        Field(
            description="The tasks that comprise the workflow.",
            title="Tasks",
        ),
    ] = None
    taskDependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="The graph of dependencies between tasks within the workflow.",
            title="Task dependency graph",
        ),
    ] = None
    taskTypes: Annotated[
        List[TaskType],
        Field(
            description="Indicates the types of activities performed by the set of workflow tasks.", title="Task types"
        ),
    ]
    trigger: Annotated[
        Optional[Trigger], Field(description="The trigger that initiated the task.", title="Trigger")
    ] = None
    steps: Annotated[
        Optional[List[Step]],
        Field(
            description="The sequence of steps for the task.",
            title="Steps",
        ),
    ] = None
    inputs: Annotated[
        Optional[List[Union[InputType1, InputType2, InputType3, InputType4]]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=["a `configuration` file which was declared as a local `component` or `externalReference`"],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[Union[OutputType1, OutputType2, OutputType3]]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    timeStart: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the task started.", title="Time start"),
    ] = None
    timeEnd: Annotated[
        Optional[datetime], Field(description="The date and time (timestamp) when the task ended.", title="Time end")
    ] = None
    workspaces: Annotated[
        Optional[List[Workspace]],
        Field(
            description="A set of named filesystem or data resource shareable by workflow tasks.",
            title="Workspaces",
        ),
    ] = None
    runtimeTopology: Annotated[
        Optional[List[Dependency]],
        Field(
            description="A graph of the component runtime topology for workflow's instance.",
            title="Runtime topology",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


class CyclonedxSoftwareBillOfMaterialsStandard(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    field_schema: Annotated[
        Optional[Literal["http://cyclonedx.org/schema/bom-1.5.schema.json"]], Field(alias="$schema")
    ] = None
    bomFormat: Annotated[
        Literal["CycloneDX"],
        Field(
            description=(
                "Specifies the format of the BOM. This helps to identify the file as CycloneDX since BOMs do not have a"
                ' filename convention nor does JSON schema support namespaces. This value MUST be "CycloneDX".'
            ),
            title="BOM Format",
        ),
    ] = "CycloneDX"
    specVersion: Annotated[
        str,
        Field(
            description="The version of the CycloneDX specification a BOM conforms to (starting at version 1.2).",
            examples=["1.5"],
            title="CycloneDX Specification Version",
        ),
    ]
    serialNumber: Annotated[
        Optional[str],
        Field(
            description=(
                "Every BOM generated SHOULD have a unique serial number, even if the contents of the BOM have not"
                " changed over time. If specified, the serial number MUST conform to RFC-4122. Use of serial numbers"
                " are RECOMMENDED."
            ),
            examples=["urn:uuid:3e671687-395b-41f5-a30f-a58921a69b79"],
            regex="^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            title="BOM Serial Number",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description=(
                "Whenever an existing BOM is modified, either manually or through automated processes, the version of"
                " the BOM SHOULD be incremented by 1. When a system is presented with multiple BOMs with identical"
                " serial numbers, the system SHOULD use the most recent version of the BOM. The default version is '1'."
            ),
            examples=[1],
            ge=1,
            title="BOM Version",
        ),
    ] = 1
    metadata: Annotated[
        Optional[Metadata], Field(description="Provides additional information about a BOM.", title="BOM Metadata")
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components.",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services. This may include microservices, function-as-a-service, and other types of network"
                " or intra-process services."
            ),
            title="Services",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant,"
                " but are not included with the BOM. They may also establish specific relationships within or external"
                " to the BOM."
            ),
            title="External References",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="Provides the ability to document dependency relationships.",
            title="Dependencies",
        ),
    ] = None
    compositions: Annotated[
        Optional[List[Compositions]],
        Field(
            description=(
                "Compositions describe constituent parts (including components, services, and dependency relationships)"
                " and their completeness. The completeness of vulnerabilities expressed in a BOM may also be described."
            ),
            title="Compositions",
        ),
    ] = None
    vulnerabilities: Annotated[
        Optional[List[Vulnerability]],
        Field(
            description="Vulnerabilities identified in components or services.",
            title="Vulnerabilities",
        ),
    ] = None
    annotations: Annotated[
        Optional[List[Annotations]],
        Field(
            description=(
                "Comments made by people, organizations, or tools about any object with a bom-ref, such as components,"
                " services, vulnerabilities, or the BOM itself. Unlike inventory information, annotations may contain"
                " opinion or commentary from various stakeholders. Annotations may be inline (with inventory) or"
                " externalized via BOM-Link, and may optionally be signed."
            ),
            title="Annotations",
        ),
    ] = None
    formulation: Annotated[
        Optional[List[Formula]],
        Field(
            description=(
                "Describes how a component or service was manufactured or deployed. This is achieved through the use of"
                " formulas, workflows, tasks, and steps, which declare the precise steps to reproduce along with the"
                " observed formulas describing the steps which transpired in the manufacturing process."
            ),
            title="Formulation",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Tools(CycloneDXBaseModel):
    """
    The tool(s) used in the creation of the BOM.
    """

    class Config:
        extra = Extra.forbid

    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components used as tools",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services used as tools. This may include microservices, function-as-a-service, and other"
                " types of network or intra-process services."
            ),
            title="Services",
        ),
    ] = None


class Metadata(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the BOM was created.", title="Timestamp"),
    ] = None
    lifecycles: Annotated[
        Optional[List[Union[Lifecycles, Lifecycles1]]], Field(description="", title="Lifecycles")
    ] = None
    tools: Optional[Union[Tools, List[Tool]]] = None
    authors: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description=(
                "The person(s) who created the BOM. Authors are common in BOMs created through manual processes. BOMs"
                " created through automated means may not have authors."
            ),
            title="Authors",
        ),
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The component that the BOM describes.", title="Component")
    ] = None
    manufacture: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that manufactured the component that the BOM describes.", title="Manufacture"
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component that the BOM describes. The supplier may often be the"
                " manufacturer, but may also be a distributor or repackager."
            ),
            title="Supplier",
        ),
    ] = None
    licenses: Annotated[
        Optional[Union[List[LicenseChoice1], LicenseChoice2]],
        Field(
            description=(
                "EITHER (list of SPDX licenses and/or named licenses) OR (tuple of one SPDX License Expression)"
            ),
            title="BOM License(s)",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Pedigree(CycloneDXBaseModel):
    """
    Component pedigree is a way to document complex supply chain scenarios where components are created, distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to document variants where the exact relation may not be known.
    """

    class Config:
        extra = Extra.forbid

    ancestors: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Describes zero or more components in which a component is derived from. This is commonly used to"
                " describe forks from existing projects where the forked version contains a ancestor node containing"
                " the original component it was forked from. For example, Component A is the original component."
                " Component B is the component being used and documented in the BOM. However, Component B contains a"
                " pedigree node with a single ancestor documenting Component A - the original component from which"
                " Component B is derived from."
            ),
            title="Ancestors",
        ),
    ] = None
    descendants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Descendants are the exact opposite of ancestors. This provides a way to document all forks (and their"
                " forks) of an original or root component."
            ),
            title="Descendants",
        ),
    ] = None
    variants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Variants describe relations where the relationship between the components are not known. For example,"
                " if Component A contains nearly identical code to Component B. They are both related, but it is"
                " unclear if one is derived from the other, or if they share a common ancestor."
            ),
            title="Variants",
        ),
    ] = None
    commits: Annotated[
        Optional[List[Commit]],
        Field(
            description=(
                "A list of zero or more commits which provide a trail describing how the component deviates from an"
                " ancestor, descendant, or variant."
            ),
            title="Commits",
        ),
    ] = None
    patches: Annotated[
        Optional[List[Patch]],
        Field(
            description=(
                ">A list of zero or more patches describing how the component deviates from an ancestor, descendant, or"
                " variant. Patches may be complimentary to commits or may be used in place of commits."
            ),
            title="Patches",
        ),
    ] = None
    notes: Annotated[
        Optional[str],
        Field(
            description="Notes, observations, and other non-structured commentary describing the components pedigree.",
            title="Notes",
        ),
    ] = None


class Component(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[
        Type,
        Field(
            description=(
                "Specifies the type of component. For software components, classify as application if no more specific"
                " appropriate classification is available or cannot be determined for the component. Types"
                " include:\n\n* __application__ = A software application. Refer to"
                " [https://en.wikipedia.org/wiki/Application_software](https://en.wikipedia.org/wiki/Application_software)"
                " for information about applications.\n* __framework__ = A software framework. Refer to"
                " [https://en.wikipedia.org/wiki/Software_framework](https://en.wikipedia.org/wiki/Software_framework)"
                " for information on how frameworks vary slightly from libraries.\n* __library__ = A software library."
                " Refer to"
                " [https://en.wikipedia.org/wiki/Library_(computing)](https://en.wikipedia.org/wiki/Library_(computing))\n"
                " for information about libraries. All third-party and open source reusable components will likely be a"
                " library. If the library also has key features of a framework, then it should be classified as a"
                " framework. If not, or is unknown, then specifying library is RECOMMENDED.\n* __container__ = A"
                " packaging and/or runtime format, not specific to any particular technology, which isolates software"
                " inside the container from software outside of a container through virtualization technology. Refer to"
                " [https://en.wikipedia.org/wiki/OS-level_virtualization](https://en.wikipedia.org/wiki/OS-level_virtualization)\n*"
                " __platform__ = A runtime environment which interprets or executes software. This may include runtimes"
                " such as those that execute bytecode or low-code/no-code application platforms.\n*"
                " __operating-system__ = A software operating system without regard to deployment model (i.e. installed"
                " on physical hardware, virtual machine, image, etc) Refer to"
                " [https://en.wikipedia.org/wiki/Operating_system](https://en.wikipedia.org/wiki/Operating_system)\n*"
                " __device__ = A hardware device such as a processor, or chip-set. A hardware device containing"
                " firmware SHOULD include a component for the physical hardware itself, and another component of type"
                " 'firmware' or 'operating-system' (whichever is relevant), describing information about the software"
                " running on the device.\n  See also the list of [known device"
                " properties](https://github.com/CycloneDX/cyclonedx-property-taxonomy/blob/main/cdx/device.md).\n*"
                " __device-driver__ = A special type of software that operates or controls a particular type of device."
                " Refer to"
                " [https://en.wikipedia.org/wiki/Device_driver](https://en.wikipedia.org/wiki/Device_driver)\n*"
                " __firmware__ = A special type of software that provides low-level control over a devices hardware."
                " Refer to [https://en.wikipedia.org/wiki/Firmware](https://en.wikipedia.org/wiki/Firmware)\n* __file__"
                " = A computer file. Refer to"
                " [https://en.wikipedia.org/wiki/Computer_file](https://en.wikipedia.org/wiki/Computer_file) for"
                " information about files.\n* __machine-learning-model__ = A model based on training data that can make"
                " predictions or decisions without being explicitly programmed to do so.\n* __data__ = A collection of"
                " discrete values that convey information."
            ),
            examples=["library"],
            title="Component Type",
        ),
    ]
    mime_type: Annotated[
        Optional[str],
        Field(
            alias="mime-type",
            description=(
                "The optional mime-type of the component. When used on file components, the mime-type can provide"
                " additional context about the kind of file being represented such as an image, font, or executable."
                " Some library or framework components may also have an associated mime-type."
            ),
            examples=["image/jpeg"],
            regex="^[-+a-z0-9.]+/[-+a-z0-9.]+$",
            title="Mime-Type",
        ),
    ] = None
    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the component elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component. The supplier may often be the manufacturer, but may"
                " also be a distributor or repackager."
            ),
            title="Component Supplier",
        ),
    ] = None
    author: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that authored the component",
            examples=["Acme Inc"],
            title="Component Author",
        ),
    ] = None
    publisher: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that published the component",
            examples=["Acme Inc"],
            title="Component Publisher",
        ),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name or identifier. This will often be a shortened, single name of the company or project"
                " that produced the component, or the source package or domain name. Whitespace and special characters"
                " should be avoided. Examples include: apache, org.apache.commons, and apache.org."
            ),
            examples=["com.acme"],
            title="Component Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "The name of the component. This will often be a shortened, single name of the component. Examples:"
                " commons-lang3 and jquery"
            ),
            examples=["tomcat-catalina"],
            title="Component Name",
        ),
    ]
    version: Annotated[
        Optional[str],
        Field(
            description=(
                "The component version. The version should ideally comply with semantic versioning but is not enforced."
            ),
            examples=["9.0.14"],
            title="Component Version",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the component", title="Component Description")
    ] = None
    scope: Annotated[
        Optional[Scope],
        Field(
            description=(
                "Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by"
                " the consumer of the BOM."
            ),
            title="Component Scope",
        ),
    ] = Scope.required
    hashes: Annotated[Optional[List[Hash]], Field(title="Component Hashes")] = None
    licenses: Annotated[
        Optional[Union[List[LicenseChoice1], LicenseChoice2]],
        Field(
            description=(
                "EITHER (list of SPDX licenses and/or named licenses) OR (tuple of one SPDX License Expression)"
            ),
            title="Component License(s)",
        ),
    ] = None
    copyright: Annotated[
        Optional[str],
        Field(
            description=(
                "A copyright notice informing users of the underlying claims to copyright ownership in a published"
                " work."
            ),
            examples=["Acme Inc"],
            title="Component Copyright",
        ),
    ] = None
    cpe: Annotated[
        Optional[str],
        Field(
            description=(
                "Specifies a well-formed CPE name that conforms to the CPE 2.2 or 2.3 specification. See"
                " [https://nvd.nist.gov/products/cpe](https://nvd.nist.gov/products/cpe)"
            ),
            examples=["cpe:2.3:a:acme:component_framework:-:*:*:*:*:*:*:*"],
            title="Component Common Platform Enumeration (CPE)",
        ),
    ] = None
    purl: Annotated[
        Optional[str],
        Field(
            description=(
                "Specifies the package-url (purl). The purl, if specified, MUST be valid and conform to the"
                " specification defined at:"
                " [https://github.com/package-url/purl-spec](https://github.com/package-url/purl-spec)"
            ),
            examples=["pkg:maven/com.acme/tomcat-catalina@9.0.14?packaging=jar"],
            title="Component Package URL (purl)",
        ),
    ] = None
    swid: Annotated[
        Optional[Swid],
        Field(
            description=(
                "Specifies metadata and content for [ISO-IEC 19770-2 Software Identification (SWID)"
                " Tags](https://www.iso.org/standard/65666.html)."
            ),
            title="SWID Tag",
        ),
    ] = None
    modified: Annotated[
        Optional[bool],
        Field(
            description=(
                "[Deprecated] - DO NOT USE. This will be removed in a future version. Use the pedigree element instead"
                " to supply information on exactly how the component was modified. A boolean value indicating if the"
                " component has been modified from the original. A value of true indicates the component is a"
                " derivative of the original. A value of false indicates the component has not been modified from the"
                " original."
            ),
            title="Component Modified From Original",
        ),
    ] = None
    pedigree: Annotated[
        Optional[Pedigree],
        Field(
            description=(
                "Component pedigree is a way to document complex supply chain scenarios where components are created,"
                " distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing"
                " this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to"
                " document variants where the exact relation may not be known."
            ),
            title="Component Pedigree",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant,"
                " but are not included with the BOM. They may also establish specific relationships within or external"
                " to the BOM."
            ),
            title="External References",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "A list of software and hardware components included in the parent component. This is not a dependency"
                " tree. It provides a way to specify a hierarchical representation of component assemblies, similar to"
                " system &#8594; subsystem &#8594; parts assembly in physical supply chains."
            ),
            title="Components",
        ),
    ] = None
    evidence: Annotated[
        Optional[ComponentEvidence],
        Field(
            description=(
                "Provides the ability to document evidence collected through various forms of extraction or analysis."
            ),
            title="Evidence",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes], Field(description="Specifies optional release notes.", title="Release notes")
    ] = None
    modelCard: Annotated[Optional[ModelCard], Field(title="Machine Learning Model Card")] = None
    data: Annotated[
        Optional[List[ComponentData]],
        Field(
            description=(
                "This object SHOULD be specified for any component of type `data` and MUST NOT be specified for other"
                " component types."
            ),
            title="Data",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Tools1(CycloneDXBaseModel):
    """
    The tool(s) used to identify, confirm, or score the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components used as tools",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services used as tools. This may include microservices, function-as-a-service, and other"
                " types of network or intra-process services."
            ),
            title="Services",
        ),
    ] = None


class Vulnerability(CycloneDXBaseModel):
    """
    Defines a weakness in a component or service that could be exploited or triggered by a threat source.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the vulnerability elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            description="The identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ] = None
    source: Annotated[
        Optional[VulnerabilitySource], Field(description="The source that published the vulnerability.")
    ] = None
    references: Annotated[
        Optional[List[Reference]],
        Field(
            description=(
                "Zero or more pointers to vulnerabilities that are the equivalent of the vulnerability specified. Often"
                " times, the same vulnerability may exist in multiple sources of vulnerability intelligence, but have"
                " different identifiers. References provide a way to correlate vulnerabilities across multiple sources"
                " of vulnerability intelligence."
            ),
            title="References",
        ),
    ] = None
    ratings: Annotated[
        Optional[List[Rating]], Field(description="List of vulnerability ratings", title="Ratings")
    ] = None
    cwes: Annotated[
        Optional[List[int]],
        Field(
            description=(
                "List of Common Weaknesses Enumerations (CWEs) codes that describes this vulnerability. For example 399"
                " (of https://cwe.mitre.org/data/definitions/399.html)"
            ),
            examples=[399],
            ge=1,
            title="CWEs",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the vulnerability as provided by the source.", title="Description"),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description=(
                "If available, an in-depth description of the vulnerability as provided by the source organization."
                " Details often include information useful in understanding root cause."
            ),
            title="Details",
        ),
    ] = None
    recommendation: Annotated[
        Optional[str],
        Field(
            description="Recommendations of how the vulnerability can be remediated or mitigated.",
            title="Recommendation",
        ),
    ] = None
    workaround: Annotated[
        Optional[str],
        Field(
            description=(
                "A bypass, usually temporary, of the vulnerability that reduces its likelihood and/or impact."
                " Workarounds often involve changes to configuration or deployments."
            ),
            title="Workarounds",
        ),
    ] = None
    proofOfConcept: Annotated[
        Optional[ProofOfConcept],
        Field(description="Evidence used to reproduce the vulnerability.", title="Proof of Concept"),
    ] = None
    advisories: Annotated[
        Optional[List[Advisory]],
        Field(description="Published advisories of the vulnerability if provided.", title="Advisories"),
    ] = None
    created: Annotated[
        Optional[datetime],
        Field(
            description=(
                "The date and time (timestamp) when the vulnerability record was created in the vulnerability database."
            ),
            title="Created",
        ),
    ] = None
    published: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was first published.",
            title="Published",
        ),
    ] = None
    updated: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was last updated.", title="Updated"
        ),
    ] = None
    rejected: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was rejected (if applicable).",
            title="Rejected",
        ),
    ] = None
    credits: Annotated[
        Optional[Credits],
        Field(
            description="Individuals or organizations credited with the discovery of the vulnerability.",
            title="Credits",
        ),
    ] = None
    tools: Optional[Union[Tools1, List[Tool]]] = None
    analysis: Annotated[
        Optional[Analysis],
        Field(
            description="An assessment of the impact and exploitability of the vulnerability.", title="Impact Analysis"
        ),
    ] = None
    affects: Annotated[
        Optional[List[Affect]],
        Field(
            description="The components or services that are affected by the vulnerability.",
            title="Affects",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Annotator(CycloneDXBaseModel):
    """
    The organization, person, component, or service which created the textual content of the annotation.
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[OrganizationalEntity, Field(description="The organization that created the annotation")]
    individual: Annotated[
        Optional[OrganizationalContact], Field(description="The person that created the annotation")
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[Optional[Service], Field(description="The service that created the annotation")] = None


class Annotator1(CycloneDXBaseModel):
    """
    The organization, person, component, or service which created the textual content of the annotation.
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity], Field(description="The organization that created the annotation")
    ] = None
    individual: Annotated[OrganizationalContact, Field(description="The person that created the annotation")]
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[Optional[Service], Field(description="The service that created the annotation")] = None


class Annotator2(CycloneDXBaseModel):
    """
    The organization, person, component, or service which created the textual content of the annotation.
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity], Field(description="The organization that created the annotation")
    ] = None
    individual: Annotated[
        Optional[OrganizationalContact], Field(description="The person that created the annotation")
    ] = None
    component: Annotated[Component, Field(description="The tool or component that created the annotation")]
    service: Annotated[Optional[Service], Field(description="The service that created the annotation")] = None


class Annotator3(CycloneDXBaseModel):
    """
    The organization, person, component, or service which created the textual content of the annotation.
    """

    class Config:
        extra = Extra.forbid

    organization: Annotated[
        Optional[OrganizationalEntity], Field(description="The organization that created the annotation")
    ] = None
    individual: Annotated[
        Optional[OrganizationalContact], Field(description="The person that created the annotation")
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[Service, Field(description="The service that created the annotation")]


class Annotations(CycloneDXBaseModel):
    """
    A comment, note, explanation, or similar textual content which provides additional context to the object(s) being annotated.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the annotation elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    subjects: Annotated[
        List[Union[RefLinkType, BomLinkElementType]],
        Field(
            description=(
                "The object in the BOM identified by its bom-ref. This is often a component or service, but may be any"
                " object type supporting bom-refs."
            ),
            title="BOM References",
        ),
    ]
    annotator: Annotated[
        Union[Annotator, Annotator1, Annotator2, Annotator3],
        Field(
            description=(
                "The organization, person, component, or service which created the textual content of the annotation."
            ),
            title="Annotator",
        ),
    ]
    timestamp: Annotated[
        datetime, Field(description="The date and time (timestamp) when the annotation was created.", title="Timestamp")
    ]
    text: Annotated[str, Field(description="The textual content of the annotation.", title="Text")]
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Formula(CycloneDXBaseModel):
    """
    Describes workflows and resources that captures rules and other aspects of how the associated BOM component or service was formed.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the formula elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            min_length=1,
            title="BOM Reference",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Transient components that are used in tasks that constitute one or more of this formula's workflows"
            ),
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "Transient services that are used in tasks that constitute one or more of this formula's workflows"
            ),
            title="Services",
        ),
    ] = None
    workflows: Annotated[
        Optional[List[Workflow]],
        Field(
            description=(
                "List of workflows that can be declared to accomplish specific orchestrated goals and independently"
                " triggered."
            ),
            title="Workflows",
        ),
    ] = None
    properties: Annotated[Optional[List[Property]], Field(title="Properties")] = None


Service.update_forward_refs()
CyclonedxSoftwareBillOfMaterialsStandard.update_forward_refs()
Tools.update_forward_refs()
Metadata.update_forward_refs()
Pedigree.update_forward_refs()
