"""
--------------------------------------------------------------------------------
SPDX-FileCopyrightText: Copyright © 2025 Lockheed Martin <open.source@lmco.com>
SPDX-FileName: hoppr_cyclonedx_models/cyclonedx_1_4.py
SPDX-FileType: SOURCE
SPDX-License-Identifier: MIT
--------------------------------------------------------------------------------
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
--------------------------------------------------------------------------------
This file was generated by datamodel-codegen:
  filename:  bom-1.4.schema.json
  timestamp: 2025-09-17T19:02:47+00:00
  version:   0.25.7
"""

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional, Union

from pydantic import AnyUrl, EmailStr, Extra, Field
from typing_extensions import Annotated, Literal

from hoppr_cyclonedx_models.base import CycloneDXBaseModel

from . import spdx


class OrganizationalContact(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    name: Annotated[
        Optional[str], Field(description="The name of a contact", examples=["Contact name"], title="Name")
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(
            description="The email address of the contact.",
            examples=["firstname.lastname@example.com"],
            title="Email Address",
        ),
    ] = None
    phone: Annotated[
        Optional[str], Field(description="The phone number of the contact.", examples=["800-555-1212"], title="Phone")
    ] = None


class Type(Enum):
    """
    Specifies the type of component. For software components, classify as application if no more specific appropriate classification is available or cannot be determined for the component. Types include:

    * __application__ = A software application. Refer to [https://en.wikipedia.org/wiki/Application_software](https://en.wikipedia.org/wiki/Application_software) for information about applications.
    * __framework__ = A software framework. Refer to [https://en.wikipedia.org/wiki/Software_framework](https://en.wikipedia.org/wiki/Software_framework) for information on how frameworks vary slightly from libraries.
    * __library__ = A software library. Refer to [https://en.wikipedia.org/wiki/Library_(computing)](https://en.wikipedia.org/wiki/Library_(computing))
     for information about libraries. All third-party and open source reusable components will likely be a library. If the library also has key features of a framework, then it should be classified as a framework. If not, or is unknown, then specifying library is RECOMMENDED.
    * __container__ = A packaging and/or runtime format, not specific to any particular technology, which isolates software inside the container from software outside of a container through virtualization technology. Refer to [https://en.wikipedia.org/wiki/OS-level_virtualization](https://en.wikipedia.org/wiki/OS-level_virtualization)
    * __operating-system__ = A software operating system without regard to deployment model (i.e. installed on physical hardware, virtual machine, image, etc) Refer to [https://en.wikipedia.org/wiki/Operating_system](https://en.wikipedia.org/wiki/Operating_system)
    * __device__ = A hardware device such as a processor, or chip-set. A hardware device containing firmware SHOULD include a component for the physical hardware itself, and another component of type 'firmware' or 'operating-system' (whichever is relevant), describing information about the software running on the device.
      See also the list of [known device properties](https://github.com/CycloneDX/cyclonedx-property-taxonomy/blob/main/cdx/device.md).
    * __firmware__ = A special type of software that provides low-level control over a devices hardware. Refer to [https://en.wikipedia.org/wiki/Firmware](https://en.wikipedia.org/wiki/Firmware)
    * __file__ = A computer file. Refer to [https://en.wikipedia.org/wiki/Computer_file](https://en.wikipedia.org/wiki/Computer_file) for information about files.
    """

    APPLICATION = application = "application"
    FRAMEWORK = framework = "framework"
    LIBRARY = library = "library"
    CONTAINER = container = "container"
    OPERATING_SYSTEM = operating_system = "operating-system"
    DEVICE = device = "device"
    FIRMWARE = firmware = "firmware"
    FILE = file = "file"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Scope(Enum):
    """
    Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by the consumer of the BOM.
    """

    REQUIRED = required = "required"
    OPTIONAL = optional = "optional"
    EXCLUDED = excluded = "excluded"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Attachment(CycloneDXBaseModel):
    """
    Specifies the metadata and content for an attachment.
    """

    class Config:
        extra = Extra.forbid

    contentType: Annotated[
        Optional[str],
        Field(
            description="Specifies the content type of the text. Defaults to text/plain if not specified.",
            title="Content-Type",
        ),
    ] = "text/plain"
    encoding: Annotated[
        Optional[Literal["base64"]],
        Field(description="Specifies the optional encoding the text is represented in.", title="Encoding"),
    ] = None
    content: Annotated[
        str,
        Field(
            description=(
                "The attachment data. Proactive controls such as input validation and sanitization should be employed"
                " to prevent misuse of attachment text."
            ),
            title="Attachment Text",
        ),
    ]


class HashAlg(Enum):
    MD5 = "MD5"
    SHA_1 = "SHA-1"
    SHA_256 = "SHA-256"
    SHA_384 = "SHA-384"
    SHA_512 = "SHA-512"
    SHA3_256 = "SHA3-256"
    SHA3_384 = "SHA3-384"
    SHA3_512 = "SHA3-512"
    BLAKE2B_256 = BLAKE2b_256 = "BLAKE2b-256"
    BLAKE2B_384 = BLAKE2b_384 = "BLAKE2b-384"
    BLAKE2B_512 = BLAKE2b_512 = "BLAKE2b-512"
    BLAKE3 = "BLAKE3"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Type1(Enum):
    """
    Specifies the purpose for the patch including the resolution of defects, security issues, or new behavior or functionality.

    * __unofficial__ = A patch which is not developed by the creators or maintainers of the software being patched. Refer to [https://en.wikipedia.org/wiki/Unofficial_patch](https://en.wikipedia.org/wiki/Unofficial_patch)
    * __monkey__ = A patch which dynamically modifies runtime behavior. Refer to [https://en.wikipedia.org/wiki/Monkey_patch](https://en.wikipedia.org/wiki/Monkey_patch)
    * __backport__ = A patch which takes code from a newer version of software and applies it to older versions of the same software. Refer to [https://en.wikipedia.org/wiki/Backporting](https://en.wikipedia.org/wiki/Backporting)
    * __cherry-pick__ = A patch created by selectively applying commits from other versions or branches of the same software.
    """

    UNOFFICIAL = unofficial = "unofficial"
    MONKEY = monkey = "monkey"
    BACKPORT = backport = "backport"
    CHERRY_PICK = cherry_pick = "cherry-pick"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Diff(CycloneDXBaseModel):
    """
    The patch file (or diff) that show changes. Refer to https://en.wikipedia.org/wiki/Diff
    """

    class Config:
        extra = Extra.forbid

    text: Annotated[
        Optional[Attachment], Field(description="Specifies the optional text of the diff", title="Diff text")
    ] = None
    url: Annotated[Optional[str], Field(description="Specifies the URL to the diff", title="URL")] = None


class Type2(Enum):
    """
    Specifies the type of issue
    """

    DEFECT = defect = "defect"
    ENHANCEMENT = enhancement = "enhancement"
    SECURITY = security = "security"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Source(CycloneDXBaseModel):
    """
    The source of the issue where it is documented
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source. For example 'National Vulnerability Database', 'NVD', and 'Apache'",
            title="Name",
        ),
    ] = None
    url: Annotated[
        Optional[str], Field(description="The url of the issue documentation as provided by the source", title="URL")
    ] = None


class Issue(CycloneDXBaseModel):
    """
    An individual issue that has been resolved.
    """

    class Config:
        extra = Extra.forbid

    type: Annotated[Type2, Field(description="Specifies the type of issue", title="Type")]
    id: Annotated[
        Optional[str], Field(description="The identifier of the issue assigned by the source of the issue", title="ID")
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the issue", title="Name")] = None
    description: Annotated[Optional[str], Field(description="A description of the issue", title="Description")] = None
    source: Annotated[
        Optional[Source], Field(description="The source of the issue where it is documented", title="Source")
    ] = None
    references: Annotated[
        Optional[List[str]],
        Field(
            description="A collection of URL's for reference. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="References",
        ),
    ] = None


class IdentifiableAction(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    class Config:
        extra = Extra.forbid

    timestamp: Annotated[
        Optional[datetime], Field(description="The timestamp in which the action occurred", title="Timestamp")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the individual who performed the action", title="Name")
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(description="The email address of the individual who performed the action", title="E-mail"),
    ] = None


class Type3(Enum):
    """
    Specifies the type of external reference. There are built-in types to describe common references. If a type does not exist for the reference being referred to, use the "other" type.
    """

    VCS = vcs = "vcs"
    ISSUE_TRACKER = issue_tracker = "issue-tracker"
    WEBSITE = website = "website"
    ADVISORIES = advisories = "advisories"
    BOM = bom = "bom"
    MAILING_LIST = mailing_list = "mailing-list"
    SOCIAL = social = "social"
    CHAT = chat = "chat"
    DOCUMENTATION = documentation = "documentation"
    SUPPORT = support = "support"
    DISTRIBUTION = distribution = "distribution"
    LICENSE = license = "license"
    BUILD_META = build_meta = "build-meta"
    BUILD_SYSTEM = build_system = "build-system"
    RELEASE_NOTES = release_notes = "release-notes"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Dependency(CycloneDXBaseModel):
    """
    Defines the direct dependencies of a component. Components that do not have their own dependencies MUST be declared as empty elements within the graph. Components that are not represented in the dependency graph MAY have unknown dependencies. It is RECOMMENDED that implementations assume this to be opaque and not an indicator of a component being dependency-free.
    """

    class Config:
        extra = Extra.forbid

    ref: Annotated[
        str, Field(description="References a component by the components bom-ref attribute", title="Reference")
    ]
    dependsOn: Annotated[
        Optional[List[str]],
        Field(
            description="The bom-ref identifiers of the components that are dependencies of this dependency object.",
            title="Depends On",
        ),
    ] = None


class DataFlow(Enum):
    """
    Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states that data enters the service. Outbound flow states that data leaves the service. Bi-directional states that data flows both ways, and unknown states that the direction is not known.
    """

    INBOUND = inbound = "inbound"
    OUTBOUND = outbound = "outbound"
    BI_DIRECTIONAL = bi_directional = "bi-directional"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Copyright(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    text: Annotated[str, Field(title="Copyright Text")]


class AggregateType(Enum):
    COMPLETE = complete = "complete"
    INCOMPLETE = incomplete = "incomplete"
    INCOMPLETE_FIRST_PARTY_ONLY = incomplete_first_party_only = "incomplete_first_party_only"
    INCOMPLETE_THIRD_PARTY_ONLY = incomplete_third_party_only = "incomplete_third_party_only"
    UNKNOWN = unknown = "unknown"
    NOT_SPECIFIED = not_specified = "not_specified"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Property(CycloneDXBaseModel):
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "The name of the property. Duplicate names are allowed, each potentially having a different value."
            ),
            title="Name",
        ),
    ] = None
    value: Annotated[Optional[str], Field(description="The value of the property.", title="Value")] = None


class Note(CycloneDXBaseModel):
    """
    A note containing the locale and content.
    """

    class Config:
        extra = Extra.forbid

    locale: Annotated[
        Optional[str],
        Field(
            description=(
                "The ISO-639 (or higher) language code and optional ISO-3166 (or higher) country code. Examples"
                ' include: "en", "en-US", "fr" and "fr-CA"'
            ),
            regex="^([a-z]{2})(-[A-Z]{2})?$",
            title="Locale",
        ),
    ] = None
    text: Annotated[
        Attachment, Field(description="Specifies the full content of the release note.", title="Release note content")
    ]


class ReleaseNotes(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[
        str,
        Field(
            description="The software versioning type the release note describes.",
            examples=["major", "minor", "patch", "pre-release", "internal"],
            title="Type",
        ),
    ]
    title: Annotated[Optional[str], Field(description="The title of the release.", title="Title")] = None
    featuredImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be prominently displayed with the release note.",
            title="Featured image",
        ),
    ] = None
    socialImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be used in messaging on social media platforms.",
            title="Social image",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A short description of the release.", title="Description")
    ] = None
    timestamp: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the release note was created.", title="Timestamp"),
    ] = None
    aliases: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "One or more alternate names the release may be referred to. This may include unofficial terms used by"
                " development and marketing teams (e.g. code names)."
            ),
            title="Aliases",
        ),
    ] = None
    tags: Annotated[
        Optional[List[str]],
        Field(description="One or more tags that may aid in search or retrieval of the release note.", title="Tags"),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]], Field(description="A collection of issues that have been resolved.", title="Resolves")
    ] = None
    notes: Annotated[
        Optional[List[Note]],
        Field(
            description=(
                "Zero or more release notes containing the locale and content. Multiple note objects may be specified"
                " to support release notes in a wide variety of languages."
            ),
            title="Notes",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Advisory(CycloneDXBaseModel):
    """
    Title and location where advisory information can be obtained. An advisory is a notification of a threat to a component, service, or system.
    """

    class Config:
        extra = Extra.forbid

    title: Annotated[Optional[str], Field(description="An optional name of the advisory.", title="Title")] = None
    url: Annotated[str, Field(description="Location where the advisory can be obtained.", title="URL")]


class Severity(Enum):
    """
    Textual representation of the severity of the vulnerability adopted by the analysis method. If the analysis method uses values other than what is provided, the user is expected to translate appropriately.
    """

    CRITICAL = critical = "critical"
    HIGH = high = "high"
    MEDIUM = medium = "medium"
    LOW = low = "low"
    INFO = info = "info"
    NONE = none = "none"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ScoreMethod(Enum):
    """
    Specifies the severity or risk scoring methodology or standard used.

    * CVSSv2 - [Common Vulnerability Scoring System v2](https://www.first.org/cvss/v2/)
    * CVSSv3 - [Common Vulnerability Scoring System v3](https://www.first.org/cvss/v3-0/)
    * CVSSv31 - [Common Vulnerability Scoring System v3.1](https://www.first.org/cvss/v3-1/)
    * OWASP - [OWASP Risk Rating Methodology](https://owasp.org/www-community/OWASP_Risk_Rating_Methodology)
    """

    CVSSV2 = CVSSv2 = "CVSSv2"
    CVSSV3 = CVSSv3 = "CVSSv3"
    CVSSV31 = CVSSv31 = "CVSSv31"
    OWASP = "OWASP"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ImpactAnalysisState(Enum):
    """
    Declares the current state of an occurrence of a vulnerability, after automated or manual analysis.

    * __resolved__ = the vulnerability has been remediated.
    * __resolved_with_pedigree__ = the vulnerability has been remediated and evidence of the changes are provided in the affected components pedigree containing verifiable commit history and/or diff(s).
    * __exploitable__ = the vulnerability may be directly or indirectly exploitable.
    * __in_triage__ = the vulnerability is being investigated.
    * __false_positive__ = the vulnerability is not specific to the component or service and was falsely identified or associated.
    * __not_affected__ = the component or service is not affected by the vulnerability. Justification should be specified for all not_affected cases.
    """

    RESOLVED = resolved = "resolved"
    RESOLVED_WITH_PEDIGREE = resolved_with_pedigree = "resolved_with_pedigree"
    EXPLOITABLE = exploitable = "exploitable"
    IN_TRIAGE = in_triage = "in_triage"
    FALSE_POSITIVE = false_positive = "false_positive"
    NOT_AFFECTED = not_affected = "not_affected"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class ImpactAnalysisJustification(Enum):
    """
    The rationale of why the impact analysis state was asserted.

    * __code_not_present__ = the code has been removed or tree-shaked.
    * __code_not_reachable__ = the vulnerable code is not invoked at runtime.
    * __requires_configuration__ = exploitability requires a configurable option to be set/unset.
    * __requires_dependency__ = exploitability requires a dependency that is not present.
    * __requires_environment__ = exploitability requires a certain environment which is not present.
    * __protected_by_compiler__ = exploitability requires a compiler flag to be set/unset.
    * __protected_at_runtime__ = exploits are prevented at runtime.
    * __protected_at_perimeter__ = attacks are blocked at physical, logical, or network perimeter.
    * __protected_by_mitigating_control__ = preventative measures have been implemented that reduce the likelihood and/or impact of the vulnerability.
    """

    CODE_NOT_PRESENT = code_not_present = "code_not_present"
    CODE_NOT_REACHABLE = code_not_reachable = "code_not_reachable"
    REQUIRES_CONFIGURATION = requires_configuration = "requires_configuration"
    REQUIRES_DEPENDENCY = requires_dependency = "requires_dependency"
    REQUIRES_ENVIRONMENT = requires_environment = "requires_environment"
    PROTECTED_BY_COMPILER = protected_by_compiler = "protected_by_compiler"
    PROTECTED_AT_RUNTIME = protected_at_runtime = "protected_at_runtime"
    PROTECTED_AT_PERIMETER = protected_at_perimeter = "protected_at_perimeter"
    PROTECTED_BY_MITIGATING_CONTROL = protected_by_mitigating_control = "protected_by_mitigating_control"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class VulnerabilitySource(CycloneDXBaseModel):
    """
    The source of vulnerability information. This is often the organization that published the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    url: Annotated[
        Optional[str],
        Field(
            description="The url of the vulnerability documentation as provided by the source.",
            examples=["https://nvd.nist.gov/vuln/detail/CVE-2021-39182"],
            title="URL",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source.",
            examples=["NVD", "National Vulnerability Database", "OSS Index", "VulnDB", "GitHub Advisories"],
            title="Name",
        ),
    ] = None


class Reference(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    id: Annotated[
        str,
        Field(
            description="An identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ]
    source: Annotated[VulnerabilitySource, Field(description="The source that published the vulnerability.")]


class ResponseEnum(Enum):
    CAN_NOT_FIX = can_not_fix = "can_not_fix"
    WILL_NOT_FIX = will_not_fix = "will_not_fix"
    UPDATE = update = "update"
    ROLLBACK = rollback = "rollback"
    WORKAROUND_AVAILABLE = workaround_available = "workaround_available"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Analysis(CycloneDXBaseModel):
    """
    An assessment of the impact and exploitability of the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    state: Optional[ImpactAnalysisState] = None
    justification: Optional[ImpactAnalysisJustification] = None
    response: Annotated[
        Optional[List[ResponseEnum]],
        Field(
            description=(
                "A response to the vulnerability by the manufacturer, supplier, or project responsible for the affected"
                " component or service. More than one response is allowed. Responses are strongly encouraged for"
                " vulnerabilities where the analysis state is exploitable."
            ),
            title="Response",
        ),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description=(
                "Detailed description of the impact including methods used during assessment. If a vulnerability is not"
                " exploitable, this field should include specific details on why the component or service is not"
                " impacted by this vulnerability."
            ),
            title="Detail",
        ),
    ] = None


class AffectedStatus(Enum):
    """
    The vulnerability status of a given version or range of versions of a product. The statuses 'affected' and 'unaffected' indicate that the version is affected or unaffected by the vulnerability. The status 'unknown' indicates that it is unknown or unspecified whether the given version is affected. There can be many reasons for an 'unknown' status, including that an investigation has not been undertaken or that a vendor has not disclosed the status.
    """

    AFFECTED = affected = "affected"
    UNAFFECTED = unaffected = "unaffected"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Algorithm(Enum):
    """
    Signature algorithm. The currently recognized JWA [RFC7518] and RFC8037 [RFC8037] asymmetric key algorithms. Note: Unlike RFC8037 [RFC8037] JSF requires explicit Ed* algorithm names instead of "EdDSA".
    """

    RS256 = "RS256"
    RS384 = "RS384"
    RS512 = "RS512"
    PS256 = "PS256"
    PS384 = "PS384"
    PS512 = "PS512"
    ES256 = "ES256"
    ES384 = "ES384"
    ES512 = "ES512"
    ED25519 = Ed25519 = "Ed25519"
    ED448 = Ed448 = "Ed448"
    HS256 = "HS256"
    HS384 = "HS384"
    HS512 = "HS512"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class KeyType(Enum):
    """
    Key type indicator.
    """

    EC = "EC"
    OKP = "OKP"
    RSA = "RSA"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class PublicKey(CycloneDXBaseModel):
    """
    Optional. Public key object.
    """

    class Config:
        extra = Extra.allow

    kty: KeyType


class OrganizationalEntity(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    name: Annotated[
        Optional[str], Field(description="The name of the organization", examples=["Example Inc."], title="Name")
    ] = None
    url: Annotated[
        Optional[List[str]],
        Field(
            description="The URL of the organization. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="URL",
        ),
    ] = None
    contact: Annotated[
        Optional[List[OrganizationalContact]],
        Field(description="A contact at the organization. Multiple contacts are allowed.", title="Contact"),
    ] = None


class Swid(CycloneDXBaseModel):
    """
    Specifies metadata and content for ISO-IEC 19770-2 Software Identification (SWID) Tags.
    """

    class Config:
        extra = Extra.forbid

    tagId: Annotated[str, Field(description="Maps to the tagId of a SoftwareIdentity.", title="Tag ID")]
    name: Annotated[str, Field(description="Maps to the name of a SoftwareIdentity.", title="Name")]
    version: Annotated[
        Optional[str], Field(description="Maps to the version of a SoftwareIdentity.", title="Version")
    ] = "0.0"
    tagVersion: Annotated[
        Optional[int], Field(description="Maps to the tagVersion of a SoftwareIdentity.", title="Tag Version")
    ] = 0
    patch: Annotated[
        Optional[bool], Field(description="Maps to the patch of a SoftwareIdentity.", title="Patch")
    ] = False
    text: Annotated[
        Optional[Attachment],
        Field(description="Specifies the metadata and content of the SWID tag.", title="Attachment text"),
    ] = None
    url: Annotated[Optional[str], Field(description="The URL to the SWID file.", title="URL")] = None


class Hash(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    alg: HashAlg
    content: Annotated[
        str,
        Field(
            examples=["3942447fac867ae5cdb3229b658f4d48"],
            regex="^([a-fA-F0-9]{32}|[a-fA-F0-9]{40}|[a-fA-F0-9]{64}|[a-fA-F0-9]{96}|[a-fA-F0-9]{128})$",
            title="Hash Content (value)",
        ),
    ]


class License1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    id: Annotated[
        spdx.LicenseID, Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)")
    ]
    name: Annotated[
        Optional[str],
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ] = None
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None


class License2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    id: Annotated[
        Optional[spdx.LicenseID],
        Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)"),
    ] = None
    name: Annotated[
        str,
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ]
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None


class LicenseChoice1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    license: Annotated[Union[License1, License2], Field(title="License Object")]
    expression: Annotated[
        Optional[str],
        Field(
            examples=["Apache-2.0 AND (MIT OR GPL-2.0-only)", "GPL-3.0-only WITH Classpath-exception-2.0"],
            title="SPDX License Expression",
        ),
    ] = None


class LicenseChoice2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    license: Annotated[Optional[Union[License1, License2]], Field(title="License Object")] = None
    expression: Annotated[
        str,
        Field(
            examples=["Apache-2.0 AND (MIT OR GPL-2.0-only)", "GPL-3.0-only WITH Classpath-exception-2.0"],
            title="SPDX License Expression",
        ),
    ]


class Commit(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    class Config:
        extra = Extra.forbid

    uid: Annotated[
        Optional[str],
        Field(
            description=(
                "A unique identifier of the commit. This may be version control specific. For example, Subversion uses"
                " revision numbers whereas git uses commit hashes."
            ),
            title="UID",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the commit. This URL will typically point to a commit in a version control system.",
            title="URL",
        ),
    ] = None
    author: Annotated[
        Optional[IdentifiableAction],
        Field(description="The author who created the changes in the commit", title="Author"),
    ] = None
    committer: Annotated[
        Optional[IdentifiableAction],
        Field(description="The person who committed or pushed the commit", title="Committer"),
    ] = None
    message: Annotated[
        Optional[str], Field(description="The text description of the contents of the commit", title="Message")
    ] = None


class Patch(CycloneDXBaseModel):
    """
    Specifies an individual patch
    """

    class Config:
        extra = Extra.forbid

    type: Annotated[
        Type1,
        Field(
            description=(
                "Specifies the purpose for the patch including the resolution of defects, security issues, or new"
                " behavior or functionality.\n\n* __unofficial__ = A patch which is not developed by the creators or"
                " maintainers of the software being patched. Refer to"
                " [https://en.wikipedia.org/wiki/Unofficial_patch](https://en.wikipedia.org/wiki/Unofficial_patch)\n*"
                " __monkey__ = A patch which dynamically modifies runtime behavior. Refer to"
                " [https://en.wikipedia.org/wiki/Monkey_patch](https://en.wikipedia.org/wiki/Monkey_patch)\n*"
                " __backport__ = A patch which takes code from a newer version of software and applies it to older"
                " versions of the same software. Refer to"
                " [https://en.wikipedia.org/wiki/Backporting](https://en.wikipedia.org/wiki/Backporting)\n*"
                " __cherry-pick__ = A patch created by selectively applying commits from other versions or branches of"
                " the same software."
            ),
            title="Type",
        ),
    ]
    diff: Annotated[
        Optional[Diff],
        Field(
            description=(
                "The patch file (or diff) that show changes. Refer to"
                " [https://en.wikipedia.org/wiki/Diff](https://en.wikipedia.org/wiki/Diff)"
            ),
            title="Diff",
        ),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]], Field(description="A collection of issues the patch resolves", title="Resolves")
    ] = None


class ExternalReference(CycloneDXBaseModel):
    """
    Specifies an individual external reference
    """

    class Config:
        extra = Extra.forbid

    url: Annotated[str, Field(description="The URL to the external reference", title="URL")]
    comment: Annotated[
        Optional[str], Field(description="An optional comment describing the external reference", title="Comment")
    ] = None
    type: Annotated[
        Type3,
        Field(
            description=(
                "Specifies the type of external reference. There are built-in types to describe common references. If a"
                ' type does not exist for the reference being referred to, use the "other" type.'
            ),
            title="Type",
        ),
    ]
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the external reference (if applicable).", title="Hashes")
    ] = None


class DataClassification(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    flow: Annotated[
        DataFlow,
        Field(
            description=(
                "Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states"
                " that data enters the service. Outbound flow states that data leaves the service. Bi-directional"
                " states that data flows both ways, and unknown states that the direction is not known."
            ),
            title="Directional Flow",
        ),
    ]
    classification: Annotated[
        str,
        Field(
            description=(
                "Data classification tags data according to its type, sensitivity, and value if altered, stolen, or"
                " destroyed."
            ),
            title="Classification",
        ),
    ]


class ComponentEvidence(CycloneDXBaseModel):
    """
    Provides the ability to document evidence collected through various forms of extraction or analysis.
    """

    class Config:
        extra = Extra.forbid

    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    copyright: Annotated[Optional[List[Copyright]], Field(title="Copyright")] = None


class Rating(CycloneDXBaseModel):
    """
    Defines the severity or risk ratings of a vulnerability.
    """

    class Config:
        extra = Extra.forbid

    source: Annotated[
        Optional[VulnerabilitySource],
        Field(description="The source that calculated the severity or risk rating of the vulnerability."),
    ] = None
    score: Annotated[Optional[float], Field(description="The numerical score of the rating.", title="Score")] = None
    severity: Annotated[
        Optional[Severity],
        Field(
            description="Textual representation of the severity that corresponds to the numerical score of the rating."
        ),
    ] = None
    method: Optional[ScoreMethod] = None
    vector: Annotated[
        Optional[str],
        Field(
            description="Textual representation of the metric values used to score the vulnerability", title="Vector"
        ),
    ] = None
    justification: Annotated[
        Optional[str],
        Field(description="An optional reason for rating the vulnerability as it was", title="Justification"),
    ] = None


class Credits(CycloneDXBaseModel):
    """
    Individuals or organizations credited with the discovery of the vulnerability.
    """

    class Config:
        extra = Extra.forbid

    organizations: Annotated[
        Optional[List[OrganizationalEntity]],
        Field(description="The organizations credited with vulnerability discovery.", title="Organizations"),
    ] = None
    individuals: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description=(
                "The individuals, not associated with organizations, that are credited with vulnerability discovery."
            ),
            title="Individuals",
        ),
    ] = None


class Versions(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    version: Annotated[
        str, Field(description="A single version of a component or service.", max_length=1024, min_length=1)
    ]
    range: Annotated[
        Optional[str],
        Field(
            description=(
                "A version range specified in Package URL Version Range syntax (vers) which is defined at"
                " https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst"
            ),
            max_length=1024,
            min_length=1,
        ),
    ] = None
    status: Annotated[
        Optional[AffectedStatus], Field(description="The vulnerability status for the version or range of versions.")
    ] = AffectedStatus.affected


class Versions1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    version: Annotated[
        Optional[str], Field(description="A single version of a component or service.", max_length=1024, min_length=1)
    ] = None
    range: Annotated[
        str,
        Field(
            description=(
                "A version range specified in Package URL Version Range syntax (vers) which is defined at"
                " https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst"
            ),
            max_length=1024,
            min_length=1,
        ),
    ]
    status: Annotated[
        Optional[AffectedStatus], Field(description="The vulnerability status for the version or range of versions.")
    ] = AffectedStatus.affected


class Affect(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    ref: Annotated[
        str, Field(description="References a component or service by the objects bom-ref", title="Reference")
    ]
    versions: Annotated[
        Optional[List[Union[Versions, Versions1]]],
        Field(description="Zero or more individual versions or range of versions.", title="Versions"),
    ] = None


class Signer(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    algorithm: Union[Algorithm, AnyUrl]
    keyId: Annotated[
        Optional[str],
        Field(description="Optional. Application specific string identifying the signature key.", title="Key ID"),
    ] = None
    publicKey: Annotated[
        Optional[PublicKey], Field(description="Optional. Public key object.", title="Public key")
    ] = None
    certificatePath: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Optional. Sorted array of X.509 [RFC5280] certificates, where the first element must contain the"
                " signature certificate. The certificate path must be contiguous but is not required to be complete."
            ),
            title="Certificate path",
        ),
    ] = None
    excludes: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Optional. Array holding the names of one or more application level properties that must be excluded"
                ' from the signature process. Note that the "excludes" property itself, must also be excluded from the'
                ' signature process. Since both the "excludes" property and the associated data it points to are'
                " unsigned, a conforming JSF implementation must provide options for specifying which properties to"
                " accept."
            ),
            title="Excludes",
        ),
    ] = None
    value: Annotated[
        str,
        Field(
            description=(
                "The signature data. Note that the binary representation must follow the JWA [RFC7518] specifications."
            ),
            title="Signature",
        ),
    ]


class Tool(CycloneDXBaseModel):
    """
    Information about the automated or manual tool used
    """

    class Config:
        extra = Extra.forbid

    vendor: Annotated[
        Optional[str], Field(description="The name of the vendor who created the tool", title="Tool Vendor")
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the tool", title="Tool Name")] = None
    version: Annotated[Optional[str], Field(description="The version of the tool", title="Tool Version")] = None
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the tool (if applicable).", title="Hashes")
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant but"
                " which are not included with the BOM."
            ),
            title="External References",
        ),
    ] = None


class Vulnerability(CycloneDXBaseModel):
    """
    Defines a weakness in an component or service that could be exploited or triggered by a threat source.
    """

    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the vulnerability elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            description="The identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ] = None
    source: Annotated[
        Optional[VulnerabilitySource], Field(description="The source that published the vulnerability.")
    ] = None
    references: Annotated[
        Optional[List[Reference]],
        Field(
            description=(
                "Zero or more pointers to vulnerabilities that are the equivalent of the vulnerability specified. Often"
                " times, the same vulnerability may exist in multiple sources of vulnerability intelligence, but have"
                " different identifiers. References provide a way to correlate vulnerabilities across multiple sources"
                " of vulnerability intelligence."
            ),
            title="References",
        ),
    ] = None
    ratings: Annotated[
        Optional[List[Rating]], Field(description="List of vulnerability ratings", title="Ratings")
    ] = None
    cwes: Annotated[
        Optional[List[int]],
        Field(
            description=(
                "List of Common Weaknesses Enumerations (CWEs) codes that describes this vulnerability. For example 399"
                " (of https://cwe.mitre.org/data/definitions/399.html)"
            ),
            examples=[399],
            ge=1,
            title="CWEs",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the vulnerability as provided by the source.", title="Description"),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description=(
                "If available, an in-depth description of the vulnerability as provided by the source organization."
                " Details often include examples, proof-of-concepts, and other information useful in understanding root"
                " cause."
            ),
            title="Details",
        ),
    ] = None
    recommendation: Annotated[
        Optional[str],
        Field(description="Recommendations of how the vulnerability can be remediated or mitigated.", title="Details"),
    ] = None
    advisories: Annotated[
        Optional[List[Advisory]],
        Field(description="Published advisories of the vulnerability if provided.", title="Advisories"),
    ] = None
    created: Annotated[
        Optional[datetime],
        Field(
            description=(
                "The date and time (timestamp) when the vulnerability record was created in the vulnerability database."
            ),
            title="Created",
        ),
    ] = None
    published: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was first published.",
            title="Published",
        ),
    ] = None
    updated: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was last updated.", title="Updated"
        ),
    ] = None
    credits: Annotated[
        Optional[Credits],
        Field(
            description="Individuals or organizations credited with the discovery of the vulnerability.",
            title="Credits",
        ),
    ] = None
    tools: Annotated[
        Optional[List[Tool]],
        Field(description="The tool(s) used to identify, confirm, or score the vulnerability.", title="Creation Tools"),
    ] = None
    analysis: Annotated[
        Optional[Analysis],
        Field(
            description="An assessment of the impact and exploitability of the vulnerability.", title="Impact Analysis"
        ),
    ] = None
    affects: Annotated[
        Optional[List[Affect]],
        Field(
            description="The components or services that are affected by the vulnerability.",
            title="Affects",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Signature1(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    signers: Annotated[
        Optional[List[Signer]],
        Field(description="Unique top level property for Multiple Signatures. (multisignature)", title="Signature"),
    ] = None


class Signature2(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    chain: Annotated[
        Optional[List[Signer]],
        Field(description="Unique top level property for Signature Chains. (signaturechain)", title="Signature"),
    ] = None


class Service(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the service elsewhere in the BOM. Every bom-ref"
                " MUST be unique within the BOM."
            ),
            title="BOM Reference",
        ),
    ] = None
    provider: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that provides the service.", title="Provider"),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name, namespace, or identifier. This will often be a shortened, single name of the"
                " company or project that produced the service or domain name. Whitespace and special characters should"
                " be avoided."
            ),
            examples=["com.acme"],
            title="Service Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the service. This will often be a shortened, single name of the service.",
            examples=["ticker-service"],
            title="Service Name",
        ),
    ]
    version: Annotated[
        Optional[str], Field(description="The service version.", examples=["1.0.0"], title="Service Version")
    ] = None
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the service", title="Service Description")
    ] = None
    endpoints: Annotated[
        Optional[List[str]],
        Field(
            description="The endpoint URIs of the service. Multiple endpoints are allowed.",
            examples=["https://example.com/api/v1/ticker"],
            title="Endpoints",
        ),
    ] = None
    authenticated: Annotated[
        Optional[bool],
        Field(
            description=(
                "A boolean value indicating if the service requires authentication. A value of true indicates the"
                " service requires authentication prior to use. A value of false indicates the service does not require"
                " authentication."
            ),
            title="Authentication Required",
        ),
    ] = None
    x_trust_boundary: Annotated[
        Optional[bool],
        Field(
            alias="x-trust-boundary",
            description=(
                "A boolean value indicating if use of the service crosses a trust zone or boundary. A value of true"
                " indicates that by using the service, a trust boundary is crossed. A value of false indicates that by"
                " using the service, a trust boundary is not crossed."
            ),
            title="Crosses Trust Boundary",
        ),
    ] = None
    data: Annotated[
        Optional[List[DataClassification]],
        Field(description="Specifies the data classification.", title="Data Classification"),
    ] = None
    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant but"
                " which are not included with the BOM."
            ),
            title="External References",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services included or deployed behind the parent service. This is not a dependency tree. It"
                " provides a way to specify a hierarchical representation of service assemblies."
            ),
            title="Services",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes], Field(description="Specifies optional release notes.", title="Release notes")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Compositions(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    aggregate: Annotated[
        AggregateType,
        Field(
            description="Specifies an aggregate type that describe how complete a relationship is.", title="Aggregate"
        ),
    ]
    assemblies: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Assemblies refer to nested"
                " relationships whereby a constituent part may include other constituent parts. References do not"
                " cascade to child parts. References are explicit for the specified constituent part only."
            ),
            title="BOM references",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Dependencies refer to a"
                " relationship whereby an independent constituent part requires another independent constituent part."
                " References do not cascade to transitive dependencies. References are explicit for the specified"
                " dependency only."
            ),
            title="BOM references",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class CyclonedxSoftwareBillOfMaterialsStandard(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    field_schema: Annotated[
        Optional[Literal["http://cyclonedx.org/schema/bom-1.4.schema.json"]], Field(alias="$schema")
    ] = None
    bomFormat: Annotated[
        Literal["CycloneDX"],
        Field(
            description=(
                "Specifies the format of the BOM. This helps to identify the file as CycloneDX since BOMs do not have a"
                ' filename convention nor does JSON schema support namespaces. This value MUST be "CycloneDX".'
            ),
            title="BOM Format",
        ),
    ] = "CycloneDX"
    specVersion: Annotated[
        str,
        Field(
            description="The version of the CycloneDX specification a BOM conforms to (starting at version 1.2).",
            examples=["1.4"],
            title="CycloneDX Specification Version",
        ),
    ]
    serialNumber: Annotated[
        Optional[str],
        Field(
            description=(
                "Every BOM generated SHOULD have a unique serial number, even if the contents of the BOM have not"
                " changed over time. If specified, the serial number MUST conform to RFC-4122. Use of serial numbers"
                " are RECOMMENDED."
            ),
            examples=["urn:uuid:3e671687-395b-41f5-a30f-a58921a69b79"],
            regex="^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            title="BOM Serial Number",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description=(
                "Whenever an existing BOM is modified, either manually or through automated processes, the version of"
                " the BOM SHOULD be incremented by 1. When a system is presented with multiple BOMs with identical"
                " serial numbers, the system SHOULD use the most recent version of the BOM. The default version is '1'."
            ),
            examples=[1],
            title="BOM Version",
        ),
    ] = 1
    metadata: Annotated[
        Optional[Metadata], Field(description="Provides additional information about a BOM.", title="BOM Metadata")
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components.",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description=(
                "A list of services. This may include microservices, function-as-a-service, and other types of network"
                " or intra-process services."
            ),
            title="Services",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant but"
                " which are not included with the BOM."
            ),
            title="External References",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="Provides the ability to document dependency relationships.",
            title="Dependencies",
        ),
    ] = None
    compositions: Annotated[
        Optional[List[Compositions]],
        Field(
            description=(
                "Compositions describe constituent parts (including components, services, and dependency relationships)"
                " and their completeness."
            ),
            title="Compositions",
        ),
    ] = None
    vulnerabilities: Annotated[
        Optional[List[Vulnerability]],
        Field(
            description="Vulnerabilities identified in components or services.",
            title="Vulnerabilities",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


class Metadata(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the BOM was created.", title="Timestamp"),
    ] = None
    tools: Annotated[
        Optional[List[Tool]], Field(description="The tool(s) used in the creation of the BOM.", title="Creation Tools")
    ] = None
    authors: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description=(
                "The person(s) who created the BOM. Authors are common in BOMs created through manual processes. BOMs"
                " created through automated means may not have authors."
            ),
            title="Authors",
        ),
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The component that the BOM describes.", title="Component")
    ] = None
    manufacture: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that manufactured the component that the BOM describes.", title="Manufacture"
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component that the BOM describes. The supplier may often be the"
                " manufacturer, but may also be a distributor or repackager."
            ),
            title="Supplier",
        ),
    ] = None
    licenses: Annotated[Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="BOM License(s)")] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None


class Pedigree(CycloneDXBaseModel):
    """
    Component pedigree is a way to document complex supply chain scenarios where components are created, distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to document variants where the exact relation may not be known.
    """

    class Config:
        extra = Extra.forbid

    ancestors: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Describes zero or more components in which a component is derived from. This is commonly used to"
                " describe forks from existing projects where the forked version contains a ancestor node containing"
                " the original component it was forked from. For example, Component A is the original component."
                " Component B is the component being used and documented in the BOM. However, Component B contains a"
                " pedigree node with a single ancestor documenting Component A - the original component from which"
                " Component B is derived from."
            ),
            title="Ancestors",
        ),
    ] = None
    descendants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Descendants are the exact opposite of ancestors. This provides a way to document all forks (and their"
                " forks) of an original or root component."
            ),
            title="Descendants",
        ),
    ] = None
    variants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Variants describe relations where the relationship between the components are not known. For example,"
                " if Component A contains nearly identical code to Component B. They are both related, but it is"
                " unclear if one is derived from the other, or if they share a common ancestor."
            ),
            title="Variants",
        ),
    ] = None
    commits: Annotated[
        Optional[List[Commit]],
        Field(
            description=(
                "A list of zero or more commits which provide a trail describing how the component deviates from an"
                " ancestor, descendant, or variant."
            ),
            title="Commits",
        ),
    ] = None
    patches: Annotated[
        Optional[List[Patch]],
        Field(
            description=(
                ">A list of zero or more patches describing how the component deviates from an ancestor, descendant, or"
                " variant. Patches may be complimentary to commits or may be used in place of commits."
            ),
            title="Patches",
        ),
    ] = None
    notes: Annotated[
        Optional[str],
        Field(
            description="Notes, observations, and other non-structured commentary describing the components pedigree.",
            title="Notes",
        ),
    ] = None


class Component(CycloneDXBaseModel):
    class Config:
        extra = Extra.forbid

    type: Annotated[
        Type,
        Field(
            description=(
                "Specifies the type of component. For software components, classify as application if no more specific"
                " appropriate classification is available or cannot be determined for the component. Types"
                " include:\n\n* __application__ = A software application. Refer to"
                " [https://en.wikipedia.org/wiki/Application_software](https://en.wikipedia.org/wiki/Application_software)"
                " for information about applications.\n* __framework__ = A software framework. Refer to"
                " [https://en.wikipedia.org/wiki/Software_framework](https://en.wikipedia.org/wiki/Software_framework)"
                " for information on how frameworks vary slightly from libraries.\n* __library__ = A software library."
                " Refer to"
                " [https://en.wikipedia.org/wiki/Library_(computing)](https://en.wikipedia.org/wiki/Library_(computing))\n"
                " for information about libraries. All third-party and open source reusable components will likely be a"
                " library. If the library also has key features of a framework, then it should be classified as a"
                " framework. If not, or is unknown, then specifying library is RECOMMENDED.\n* __container__ = A"
                " packaging and/or runtime format, not specific to any particular technology, which isolates software"
                " inside the container from software outside of a container through virtualization technology. Refer to"
                " [https://en.wikipedia.org/wiki/OS-level_virtualization](https://en.wikipedia.org/wiki/OS-level_virtualization)\n*"
                " __operating-system__ = A software operating system without regard to deployment model (i.e. installed"
                " on physical hardware, virtual machine, image, etc) Refer to"
                " [https://en.wikipedia.org/wiki/Operating_system](https://en.wikipedia.org/wiki/Operating_system)\n*"
                " __device__ = A hardware device such as a processor, or chip-set. A hardware device containing"
                " firmware SHOULD include a component for the physical hardware itself, and another component of type"
                " 'firmware' or 'operating-system' (whichever is relevant), describing information about the software"
                " running on the device.\n  See also the list of [known device"
                " properties](https://github.com/CycloneDX/cyclonedx-property-taxonomy/blob/main/cdx/device.md).\n*"
                " __firmware__ = A special type of software that provides low-level control over a devices hardware."
                " Refer to [https://en.wikipedia.org/wiki/Firmware](https://en.wikipedia.org/wiki/Firmware)\n* __file__"
                " = A computer file. Refer to"
                " [https://en.wikipedia.org/wiki/Computer_file](https://en.wikipedia.org/wiki/Computer_file) for"
                " information about files."
            ),
            examples=["library"],
            title="Component Type",
        ),
    ]
    mime_type: Annotated[
        Optional[str],
        Field(
            alias="mime-type",
            description=(
                "The optional mime-type of the component. When used on file components, the mime-type can provide"
                " additional context about the kind of file being represented such as an image, font, or executable."
                " Some library or framework components may also have an associated mime-type."
            ),
            examples=["image/jpeg"],
            regex="^[-+a-z0-9.]+/[-+a-z0-9.]+$",
            title="Mime-Type",
        ),
    ] = None
    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the component elsewhere in the BOM. Every"
                " bom-ref MUST be unique within the BOM."
            ),
            title="BOM Reference",
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component. The supplier may often be the manufacturer, but may"
                " also be a distributor or repackager."
            ),
            title="Component Supplier",
        ),
    ] = None
    author: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that authored the component",
            examples=["Acme Inc"],
            title="Component Author",
        ),
    ] = None
    publisher: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that published the component",
            examples=["Acme Inc"],
            title="Component Publisher",
        ),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name or identifier. This will often be a shortened, single name of the company or project"
                " that produced the component, or the source package or domain name. Whitespace and special characters"
                " should be avoided. Examples include: apache, org.apache.commons, and apache.org."
            ),
            examples=["com.acme"],
            title="Component Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "The name of the component. This will often be a shortened, single name of the component. Examples:"
                " commons-lang3 and jquery"
            ),
            examples=["tomcat-catalina"],
            title="Component Name",
        ),
    ]
    version: Annotated[
        Optional[str],
        Field(
            description=(
                "The component version. The version should ideally comply with semantic versioning but is not enforced."
            ),
            examples=["9.0.14"],
            title="Component Version",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the component", title="Component Description")
    ] = None
    scope: Annotated[
        Optional[Scope],
        Field(
            description=(
                "Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by"
                " the consumer of the BOM."
            ),
            title="Component Scope",
        ),
    ] = Scope.required
    hashes: Annotated[Optional[List[Hash]], Field(title="Component Hashes")] = None
    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    copyright: Annotated[
        Optional[str],
        Field(
            description=(
                "A copyright notice informing users of the underlying claims to copyright ownership in a published"
                " work."
            ),
            examples=["Acme Inc"],
            title="Component Copyright",
        ),
    ] = None
    cpe: Annotated[
        Optional[str],
        Field(
            description=(
                "Specifies a well-formed CPE name that conforms to the CPE 2.2 or 2.3 specification. See"
                " [https://nvd.nist.gov/products/cpe](https://nvd.nist.gov/products/cpe)"
            ),
            examples=["cpe:2.3:a:acme:component_framework:-:*:*:*:*:*:*:*"],
            title="Component Common Platform Enumeration (CPE)",
        ),
    ] = None
    purl: Annotated[
        Optional[str],
        Field(
            description=(
                "Specifies the package-url (purl). The purl, if specified, MUST be valid and conform to the"
                " specification defined at:"
                " [https://github.com/package-url/purl-spec](https://github.com/package-url/purl-spec)"
            ),
            examples=["pkg:maven/com.acme/tomcat-catalina@9.0.14?packaging=jar"],
            title="Component Package URL (purl)",
        ),
    ] = None
    swid: Annotated[
        Optional[Swid],
        Field(
            description=(
                "Specifies metadata and content for [ISO-IEC 19770-2 Software Identification (SWID)"
                " Tags](https://www.iso.org/standard/65666.html)."
            ),
            title="SWID Tag",
        ),
    ] = None
    modified: Annotated[
        Optional[bool],
        Field(
            description=(
                "[Deprecated] - DO NOT USE. This will be removed in a future version. Use the pedigree element instead"
                " to supply information on exactly how the component was modified. A boolean value indicating if the"
                " component has been modified from the original. A value of true indicates the component is a"
                " derivative of the original. A value of false indicates the component has not been modified from the"
                " original."
            ),
            title="Component Modified From Original",
        ),
    ] = None
    pedigree: Annotated[
        Optional[Pedigree],
        Field(
            description=(
                "Component pedigree is a way to document complex supply chain scenarios where components are created,"
                " distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing"
                " this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to"
                " document variants where the exact relation may not be known."
            ),
            title="Component Pedigree",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant but"
                " which are not included with the BOM."
            ),
            title="External References",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "A list of software and hardware components included in the parent component. This is not a dependency"
                " tree. It provides a way to specify a hierarchical representation of component assemblies, similar to"
                " system &#8594; subsystem &#8594; parts assembly in physical supply chains."
            ),
            title="Components",
        ),
    ] = None
    evidence: Annotated[
        Optional[ComponentEvidence],
        Field(
            description=(
                "Provides the ability to document evidence collected through various forms of extraction or analysis."
            ),
            title="Evidence",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes], Field(description="Specifies optional release notes.", title="Release notes")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values. Property names of interest to the general public are encouraged to be"
                " registered in the [CycloneDX Property"
                " Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL."
            ),
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Union[Signature1, Signature2, Signer]],
        Field(
            description=(
                "Enveloped signature in [JSON Signature Format"
                " (JSF)](https://cyberphone.github.io/doc/security/jsf.html)."
            ),
            title="Signature",
        ),
    ] = None


Service.update_forward_refs()
CyclonedxSoftwareBillOfMaterialsStandard.update_forward_refs()
Metadata.update_forward_refs()
Pedigree.update_forward_refs()
