"""
--------------------------------------------------------------------------------
SPDX-FileCopyrightText: Copyright © 2025 Lockheed Martin <open.source@lmco.com>
SPDX-FileName: hoppr_cyclonedx_models/cyclonedx_1_3.py
SPDX-FileType: SOURCE
SPDX-License-Identifier: MIT
--------------------------------------------------------------------------------
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
--------------------------------------------------------------------------------
This file was generated by datamodel-codegen:
  filename:  bom-1.3.schema.json
  timestamp: 2025-09-17T19:02:47+00:00
  version:   0.25.7
"""

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional, Union

from pydantic import EmailStr, Field
from typing_extensions import Annotated, Literal

from hoppr_cyclonedx_models.base import CycloneDXBaseModel

from . import spdx


class OrganizationalContact(CycloneDXBaseModel):
    name: Annotated[
        Optional[str], Field(description="The name of a contact", examples=["Contact name"], title="Name")
    ] = None
    email: Annotated[
        Optional[str],
        Field(
            description="The email address of the contact.",
            examples=["firstname.lastname@example.com"],
            title="Email Address",
        ),
    ] = None
    phone: Annotated[
        Optional[str], Field(description="The phone number of the contact.", examples=["800-555-1212"], title="Phone")
    ] = None


class Type(Enum):
    """
    Specifies the type of component. For software components, classify as application if no more specific appropriate classification is available or cannot be determined for the component.
    """

    APPLICATION = application = "application"
    FRAMEWORK = framework = "framework"
    LIBRARY = library = "library"
    CONTAINER = container = "container"
    OPERATING_SYSTEM = operating_system = "operating-system"
    DEVICE = device = "device"
    FIRMWARE = firmware = "firmware"
    FILE = file = "file"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Scope(Enum):
    """
    Specifies the scope of the component. If scope is not specified, 'required' scope should be assumed by the consumer of the BOM
    """

    REQUIRED = required = "required"
    OPTIONAL = optional = "optional"
    EXCLUDED = excluded = "excluded"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Attachment(CycloneDXBaseModel):
    """
    Specifies the metadata and content for an attachment.
    """

    contentType: Annotated[
        Optional[str],
        Field(
            description="Specifies the content type of the text. Defaults to text/plain if not specified.",
            title="Content-Type",
        ),
    ] = "text/plain"
    encoding: Annotated[
        Optional[Literal["base64"]],
        Field(description="Specifies the optional encoding the text is represented in.", title="Encoding"),
    ] = None
    content: Annotated[str, Field(description="The attachment data", title="Attachment Text")]


class HashAlg(Enum):
    MD5 = "MD5"
    SHA_1 = "SHA-1"
    SHA_256 = "SHA-256"
    SHA_384 = "SHA-384"
    SHA_512 = "SHA-512"
    SHA3_256 = "SHA3-256"
    SHA3_384 = "SHA3-384"
    SHA3_512 = "SHA3-512"
    BLAKE2B_256 = BLAKE2b_256 = "BLAKE2b-256"
    BLAKE2B_384 = BLAKE2b_384 = "BLAKE2b-384"
    BLAKE2B_512 = BLAKE2b_512 = "BLAKE2b-512"
    BLAKE3 = "BLAKE3"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Type1(Enum):
    """
    Specifies the purpose for the patch including the resolution of defects, security issues, or new behavior or functionality
    """

    UNOFFICIAL = unofficial = "unofficial"
    MONKEY = monkey = "monkey"
    BACKPORT = backport = "backport"
    CHERRY_PICK = cherry_pick = "cherry-pick"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Diff(CycloneDXBaseModel):
    """
    The patch file (or diff) that show changes. Refer to https://en.wikipedia.org/wiki/Diff
    """

    text: Annotated[
        Optional[Attachment], Field(description="Specifies the optional text of the diff", title="Diff text")
    ] = None
    url: Annotated[Optional[str], Field(description="Specifies the URL to the diff", title="URL")] = None


class Type2(Enum):
    """
    Specifies the type of issue
    """

    DEFECT = defect = "defect"
    ENHANCEMENT = enhancement = "enhancement"
    SECURITY = security = "security"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Source(CycloneDXBaseModel):
    """
    The source of the issue where it is documented
    """

    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source. For example 'National Vulnerability Database', 'NVD', and 'Apache'",
            title="Name",
        ),
    ] = None
    url: Annotated[
        Optional[str], Field(description="The url of the issue documentation as provided by the source", title="URL")
    ] = None


class Issue(CycloneDXBaseModel):
    """
    The patch file (or diff) that show changes. Refer to https://en.wikipedia.org/wiki/Diff
    """

    type: Annotated[Type2, Field(description="Specifies the type of issue", title="Type")]
    id: Annotated[
        Optional[str], Field(description="The identifier of the issue assigned by the source of the issue", title="ID")
    ] = None
    name: Annotated[Optional[str], Field(description="The name of the issue", title="Name")] = None
    description: Annotated[Optional[str], Field(description="A description of the issue", title="Description")] = None
    source: Annotated[
        Optional[Source], Field(description="The source of the issue where it is documented", title="Source")
    ] = None
    references: Annotated[
        Optional[List[str]],
        Field(
            description="A collection of URL's for reference. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="References",
        ),
    ] = None


class IdentifiableAction(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    timestamp: Annotated[
        Optional[datetime], Field(description="The timestamp in which the action occurred", title="Timestamp")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the individual who performed the action", title="Name")
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(description="The email address of the individual who performed the action", title="E-mail"),
    ] = None


class Type3(Enum):
    """
    Specifies the type of external reference. There are built-in types to describe common references. If a type does not exist for the reference being referred to, use the "other" type.
    """

    VCS = vcs = "vcs"
    ISSUE_TRACKER = issue_tracker = "issue-tracker"
    WEBSITE = website = "website"
    ADVISORIES = advisories = "advisories"
    BOM = bom = "bom"
    MAILING_LIST = mailing_list = "mailing-list"
    SOCIAL = social = "social"
    CHAT = chat = "chat"
    DOCUMENTATION = documentation = "documentation"
    SUPPORT = support = "support"
    DISTRIBUTION = distribution = "distribution"
    LICENSE = license = "license"
    BUILD_META = build_meta = "build-meta"
    BUILD_SYSTEM = build_system = "build-system"
    OTHER = other = "other"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Dependency(CycloneDXBaseModel):
    """
    Defines the direct dependencies of a component. Components that do not have their own dependencies MUST be declared as empty elements within the graph. Components that are not represented in the dependency graph MAY have unknown dependencies. It is RECOMMENDED that implementations assume this to be opaque and not an indicator of a component being dependency-free.
    """

    ref: Annotated[
        str, Field(description="References a component by the components bom-ref attribute", title="Reference")
    ]
    dependsOn: Annotated[
        Optional[List[str]],
        Field(
            description="The bom-ref identifiers of the components that are dependencies of this dependency object.",
            title="Depends On",
        ),
    ] = None


class DataFlow(Enum):
    INBOUND = inbound = "inbound"
    OUTBOUND = outbound = "outbound"
    BI_DIRECTIONAL = bi_directional = "bi-directional"
    UNKNOWN = unknown = "unknown"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Copyright(CycloneDXBaseModel):
    text: Annotated[str, Field(title="Copyright Text")]


class AggregateType(Enum):
    COMPLETE = complete = "complete"
    INCOMPLETE = incomplete = "incomplete"
    INCOMPLETE_FIRST_PARTY_ONLY = incomplete_first_party_only = "incomplete_first_party_only"
    INCOMPLETE_THIRD_PARTY_ONLY = incomplete_third_party_only = "incomplete_third_party_only"
    UNKNOWN = unknown = "unknown"
    NOT_SPECIFIED = not_specified = "not_specified"

    def __str__(self) -> str:
        return str(self.value)

    @classmethod
    def _missing_(cls, value: object):
        return next((member for member in cls if member.name in {str(value), str(value).upper()}), None)


class Property(CycloneDXBaseModel):
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "The name of the property. Duplicate names are allowed, each potentially having a different value."
            ),
            title="Name",
        ),
    ] = None
    value: Annotated[Optional[str], Field(description="The value of the property.", title="Value")] = None


class OrganizationalEntity(CycloneDXBaseModel):
    name: Annotated[
        Optional[str], Field(description="The name of the organization", examples=["Example Inc."], title="Name")
    ] = None
    url: Annotated[
        Optional[List[str]],
        Field(
            description="The URL of the organization. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="URL",
        ),
    ] = None
    contact: Annotated[
        Optional[List[OrganizationalContact]],
        Field(description="A contact at the organization. Multiple contacts are allowed.", title="Contact"),
    ] = None


class Swid(CycloneDXBaseModel):
    """
    Specifies metadata and content for ISO-IEC 19770-2 Software Identification (SWID) Tags.
    """

    tagId: Annotated[str, Field(description="Maps to the tagId of a SoftwareIdentity.", title="Tag ID")]
    name: Annotated[str, Field(description="Maps to the name of a SoftwareIdentity.", title="Name")]
    version: Annotated[
        Optional[str], Field(description="Maps to the version of a SoftwareIdentity.", title="Version")
    ] = "0.0"
    tagVersion: Annotated[
        Optional[int], Field(description="Maps to the tagVersion of a SoftwareIdentity.", title="Tag Version")
    ] = 0
    patch: Annotated[
        Optional[bool], Field(description="Maps to the patch of a SoftwareIdentity.", title="Patch")
    ] = False
    text: Annotated[
        Optional[Attachment],
        Field(description="Specifies the metadata and content of the SWID tag.", title="Attachment text"),
    ] = None
    url: Annotated[Optional[str], Field(description="The URL to the SWID file.", title="URL")] = None


class Hash(CycloneDXBaseModel):
    alg: HashAlg
    content: Annotated[
        str,
        Field(
            examples=["3942447fac867ae5cdb3229b658f4d48"],
            regex="^([a-fA-F0-9]{32}|[a-fA-F0-9]{40}|[a-fA-F0-9]{64}|[a-fA-F0-9]{96}|[a-fA-F0-9]{128})$",
            title="Hash Content (value)",
        ),
    ]


class License1(CycloneDXBaseModel):
    id: Annotated[
        spdx.LicenseID, Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)")
    ]
    name: Annotated[
        Optional[str],
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ] = None
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None


class License2(CycloneDXBaseModel):
    id: Annotated[
        Optional[spdx.LicenseID],
        Field(description="A valid SPDX license ID", examples=["Apache-2.0"], title="License ID (SPDX)"),
    ] = None
    name: Annotated[
        str,
        Field(
            description="If SPDX does not define the license used, this field may be used to provide the license name",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ]
    text: Annotated[
        Optional[Attachment],
        Field(description="An optional way to include the textual content of a license.", title="License text"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description=(
                "The URL to the license file. If specified, a 'license' externalReference should also be specified for"
                " completeness"
            ),
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None


class LicenseChoice1(CycloneDXBaseModel):
    license: Annotated[Union[License1, License2], Field(title="License Object")]
    expression: Annotated[
        Optional[str],
        Field(
            examples=["Apache-2.0 AND (MIT OR GPL-2.0-only)", "GPL-3.0-only WITH Classpath-exception-2.0"],
            title="SPDX License Expression",
        ),
    ] = None


class LicenseChoice2(CycloneDXBaseModel):
    license: Annotated[Optional[Union[License1, License2]], Field(title="License Object")] = None
    expression: Annotated[
        str,
        Field(
            examples=["Apache-2.0 AND (MIT OR GPL-2.0-only)", "GPL-3.0-only WITH Classpath-exception-2.0"],
            title="SPDX License Expression",
        ),
    ]


class Commit(CycloneDXBaseModel):
    """
    Specifies an individual commit
    """

    uid: Annotated[
        Optional[str],
        Field(
            description=(
                "A unique identifier of the commit. This may be version control specific. For example, Subversion uses"
                " revision numbers whereas git uses commit hashes."
            ),
            title="UID",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the commit. This URL will typically point to a commit in a version control system.",
            title="URL",
        ),
    ] = None
    author: Annotated[
        Optional[IdentifiableAction],
        Field(description="The author who created the changes in the commit", title="Author"),
    ] = None
    committer: Annotated[
        Optional[IdentifiableAction],
        Field(description="The person who committed or pushed the commit", title="Committer"),
    ] = None
    message: Annotated[
        Optional[str], Field(description="The text description of the contents of the commit", title="Message")
    ] = None


class Patch(CycloneDXBaseModel):
    """
    Specifies an individual patch
    """

    type: Annotated[
        Type1,
        Field(
            description=(
                "Specifies the purpose for the patch including the resolution of defects, security issues, or new"
                " behavior or functionality"
            ),
            title="Type",
        ),
    ]
    diff: Annotated[
        Optional[Diff],
        Field(
            description="The patch file (or diff) that show changes. Refer to https://en.wikipedia.org/wiki/Diff",
            title="Diff",
        ),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]], Field(description="A collection of issues the patch resolves", title="Resolves")
    ] = None


class ExternalReference(CycloneDXBaseModel):
    """
    Specifies an individual external reference
    """

    url: Annotated[str, Field(description="The URL to the external reference", title="URL")]
    comment: Annotated[
        Optional[str], Field(description="An optional comment describing the external reference", title="Comment")
    ] = None
    type: Annotated[
        Type3,
        Field(
            description=(
                "Specifies the type of external reference. There are built-in types to describe common references. If a"
                ' type does not exist for the reference being referred to, use the "other" type.'
            ),
            title="Type",
        ),
    ]
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the external reference (if applicable).", title="Hashes")
    ] = None


class DataClassification(CycloneDXBaseModel):
    flow: DataFlow
    classification: str


class ComponentEvidence(CycloneDXBaseModel):
    """
    Provides the ability to document evidence collected through various forms of extraction or analysis.
    """

    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    copyright: Annotated[Optional[List[Copyright]], Field(title="Copyright")] = None


class Compositions(CycloneDXBaseModel):
    aggregate: Annotated[
        AggregateType,
        Field(
            description="Specifies an aggregate type that describe how complete a relationship is.", title="Aggregate"
        ),
    ]
    assemblies: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Assemblies refer to nested"
                " relationships whereby a constituent part may include other constituent parts. References do not"
                " cascade to child parts. References are explicit for the specified constituent part only."
            ),
            title="BOM references",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "The bom-ref identifiers of the components or services being described. Dependencies refer to a"
                " relationship whereby an independent constituent part requires another independent constituent part."
                " References do not cascade to transitive dependencies. References are explicit for the specified"
                " dependency only."
            ),
            title="BOM references",
        ),
    ] = None


class Tool(CycloneDXBaseModel):
    """
    The tool used to create the BOM.
    """

    vendor: Annotated[
        Optional[str],
        Field(description="The date and time (timestamp) when the document was created.", title="Tool Vendor"),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The date and time (timestamp) when the document was created.", title="Tool Name"),
    ] = None
    version: Annotated[
        Optional[str],
        Field(description="The date and time (timestamp) when the document was created.", title="Tool Version"),
    ] = None
    hashes: Annotated[
        Optional[List[Hash]], Field(description="The hashes of the tool (if applicable).", title="Hashes")
    ] = None


class Service(CycloneDXBaseModel):
    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the service elsewhere in the BOM. Every bom-ref"
                " should be unique."
            ),
            title="BOM Reference",
        ),
    ] = None
    provider: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that provides the service.", title="Provider"),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name, namespace, or identifier. This will often be a shortened, single name of the"
                " company or project that produced the service or domain name. Whitespace and special characters should"
                " be avoided."
            ),
            examples=["com.acme"],
            title="Service Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the service. This will often be a shortened, single name of the service.",
            examples=["ticker-service"],
            title="Service Name",
        ),
    ]
    version: Annotated[
        Optional[str], Field(description="The service version.", examples=["1.0.0"], title="Service Version")
    ] = None
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the service", title="Service Description")
    ] = None
    endpoints: Annotated[
        Optional[List[str]],
        Field(
            description="The endpoint URIs of the service. Multiple endpoints are allowed.",
            examples=["https://example.com/api/v1/ticker"],
            title="Endpoints",
        ),
    ] = None
    authenticated: Annotated[
        Optional[bool],
        Field(
            description=(
                "A boolean value indicating if the service requires authentication. A value of true indicates the"
                " service requires authentication prior to use. A value of false indicates the service does not require"
                " authentication."
            ),
            title="Authentication Required",
        ),
    ] = None
    x_trust_boundary: Annotated[
        Optional[bool],
        Field(
            alias="x-trust-boundary",
            description=(
                "A boolean value indicating if use of the service crosses a trust zone or boundary. A value of true"
                " indicates that by using the service, a trust boundary is crossed. A value of false indicates that by"
                " using the service, a trust boundary is not crossed."
            ),
            title="Crosses Trust Boundary",
        ),
    ] = None
    data: Annotated[
        Optional[List[DataClassification]],
        Field(description="Specifies the data classification.", title="Data Classification"),
    ] = None
    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    externalReferences: Annotated[Optional[List[ExternalReference]], Field(title="External References")] = None
    services: Annotated[Optional[List[Service]], Field(title="Services")] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values."
            ),
            title="Properties",
        ),
    ] = None


class CyclonedxSoftwareBillOfMaterialSpecification(CycloneDXBaseModel):
    bomFormat: Annotated[
        Literal["CycloneDX"],
        Field(
            description=(
                "Specifies the format of the BOM. This helps to identify the file as CycloneDX since BOMs do not have a"
                " filename convention nor does JSON schema support namespaces."
            ),
            title="BOM Format",
        ),
    ] = "CycloneDX"
    specVersion: Annotated[
        str,
        Field(
            description="The version of the CycloneDX specification a BOM is written to (starting at version 1.2)",
            examples=["1.3"],
            title="CycloneDX Specification Version",
        ),
    ]
    serialNumber: Annotated[
        Optional[str],
        Field(
            description=(
                "Every BOM generated should have a unique serial number, even if the contents of the BOM being"
                " generated have not changed over time. The process or tool responsible for creating the BOM should"
                " create random UUID's for every BOM generated."
            ),
            examples=["urn:uuid:3e671687-395b-41f5-a30f-a58921a69b79"],
            regex="^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            title="BOM Serial Number",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description=(
                "The version allows component publishers/authors to make changes to existing BOMs to update various"
                " aspects of the document such as description or licenses. When a system is presented with multiple"
                " BOMs for the same component, the system should use the most recent version of the BOM. The default"
                " version is '1' and should be incremented for each version of the BOM that is published. Each version"
                " of a component should have a unique BOM and if no changes are made to the BOMs, then each BOM will"
                " have a version of '1'."
            ),
            examples=[1],
            title="BOM Version",
        ),
    ] = 1
    metadata: Annotated[
        Optional[Metadata], Field(description="Provides additional information about a BOM.", title="BOM Metadata")
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            title="Services",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description=(
                "External references provide a way to document systems, sites, and information that may be relevant but"
                " which are not included with the BOM."
            ),
            title="External References",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="Provides the ability to document dependency relationships.",
            title="Dependencies",
        ),
    ] = None
    compositions: Annotated[
        Optional[List[Compositions]],
        Field(
            description=(
                "Compositions describe constituent parts (including components, services, and dependency relationships)"
                " and their completeness."
            ),
            title="Compositions",
        ),
    ] = None


class Metadata(CycloneDXBaseModel):
    timestamp: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the document was created.", title="Timestamp"),
    ] = None
    tools: Annotated[
        Optional[List[Tool]], Field(description="The tool(s) used in the creation of the BOM.", title="Creation Tools")
    ] = None
    authors: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description=(
                "The person(s) who created the BOM. Authors are common in BOMs created through manual processes. BOMs"
                " created through automated means may not have authors."
            ),
            title="Authors",
        ),
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The component that the BOM describes.", title="Component")
    ] = None
    manufacture: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that manufactured the component that the BOM describes.", title="Manufacture"
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component that the BOM describes. The supplier may often be the"
                " manufacturer, but may also be a distributor or repackager."
            ),
            title="Supplier",
        ),
    ] = None
    licenses: Annotated[Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="BOM License(s)")] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values."
            ),
            title="Properties",
        ),
    ] = None


class Pedigree(CycloneDXBaseModel):
    """
    Component pedigree is a way to document complex supply chain scenarios where components are created, distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to document variants where the exact relation may not be known.
    """

    ancestors: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Describes zero or more components in which a component is derived from. This is commonly used to"
                " describe forks from existing projects where the forked version contains a ancestor node containing"
                " the original component it was forked from. For example, Component A is the original component."
                " Component B is the component being used and documented in the BOM. However, Component B contains a"
                " pedigree node with a single ancestor documenting Component A - the original component from which"
                " Component B is derived from."
            ),
            title="Ancestors",
        ),
    ] = None
    descendants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Descendants are the exact opposite of ancestors. This provides a way to document all forks (and their"
                " forks) of an original or root component."
            ),
            title="Descendants",
        ),
    ] = None
    variants: Annotated[
        Optional[List[Component]],
        Field(
            description=(
                "Variants describe relations where the relationship between the components are not known. For example,"
                " if Component A contains nearly identical code to Component B. They are both related, but it is"
                " unclear if one is derived from the other, or if they share a common ancestor."
            ),
            title="Variants",
        ),
    ] = None
    commits: Annotated[
        Optional[List[Commit]],
        Field(
            description=(
                "A list of zero or more commits which provide a trail describing how the component deviates from an"
                " ancestor, descendant, or variant."
            ),
            title="Commits",
        ),
    ] = None
    patches: Annotated[
        Optional[List[Patch]],
        Field(
            description=(
                ">A list of zero or more patches describing how the component deviates from an ancestor, descendant, or"
                " variant. Patches may be complimentary to commits or may be used in place of commits."
            ),
            title="Patches",
        ),
    ] = None
    notes: Annotated[
        Optional[str],
        Field(
            description="Notes, observations, and other non-structured commentary describing the components pedigree.",
            title="Notes",
        ),
    ] = None


class Component(CycloneDXBaseModel):
    type: Annotated[
        Type,
        Field(
            description=(
                "Specifies the type of component. For software components, classify as application if no more specific"
                " appropriate classification is available or cannot be determined for the component."
            ),
            examples=["library"],
            title="Component Type",
        ),
    ]
    mime_type: Annotated[
        Optional[str],
        Field(
            alias="mime-type",
            description=(
                "The optional mime-type of the component. When used on file components, the mime-type can provide"
                " additional context about the kind of file being represented such as an image, font, or executable."
                " Some library or framework components may also have an associated mime-type."
            ),
            examples=["image/jpeg"],
            regex="^[-+a-z0-9.]+/[-+a-z0-9.]+$",
            title="Mime-Type",
        ),
    ] = None
    bom_ref: Annotated[
        Optional[str],
        Field(
            alias="bom-ref",
            description=(
                "An optional identifier which can be used to reference the component elsewhere in the BOM. Every"
                " bom-ref should be unique."
            ),
            title="BOM Reference",
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=(
                " The organization that supplied the component. The supplier may often be the manufacturer, but may"
                " also be a distributor or repackager."
            ),
            title="Component Supplier",
        ),
    ] = None
    author: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that authored the component",
            examples=["Acme Inc"],
            title="Component Author",
        ),
    ] = None
    publisher: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that published the component",
            examples=["Acme Inc"],
            title="Component Publisher",
        ),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description=(
                "The grouping name or identifier. This will often be a shortened, single name of the company or project"
                " that produced the component, or the source package or domain name. Whitespace and special characters"
                " should be avoided. Examples include: apache, org.apache.commons, and apache.org."
            ),
            examples=["com.acme"],
            title="Component Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "The name of the component. This will often be a shortened, single name of the component. Examples:"
                " commons-lang3 and jquery"
            ),
            examples=["tomcat-catalina"],
            title="Component Name",
        ),
    ]
    version: Annotated[
        str,
        Field(
            description=(
                "The component version. The version should ideally comply with semantic versioning but is not enforced."
            ),
            examples=["9.0.14"],
            title="Component Version",
        ),
    ]
    description: Annotated[
        Optional[str], Field(description="Specifies a description for the component", title="Component Description")
    ] = None
    scope: Annotated[
        Optional[Scope],
        Field(
            description=(
                "Specifies the scope of the component. If scope is not specified, 'required' scope should be assumed by"
                " the consumer of the BOM"
            ),
            title="Component Scope",
        ),
    ] = Scope.required
    hashes: Annotated[Optional[List[Hash]], Field(title="Component Hashes")] = None
    licenses: Annotated[
        Optional[List[Union[LicenseChoice1, LicenseChoice2]]], Field(title="Component License(s)")
    ] = None
    copyright: Annotated[
        Optional[str],
        Field(
            description=(
                "An optional copyright notice informing users of the underlying claims to copyright ownership in a"
                " published work."
            ),
            examples=["Acme Inc"],
            title="Component Copyright",
        ),
    ] = None
    cpe: Annotated[
        Optional[str],
        Field(
            description=(
                "DEPRECATED - DO NOT USE. This will be removed in a future version. Specifies a well-formed CPE name."
                " See https://nvd.nist.gov/products/cpe"
            ),
            examples=["cpe:2.3:a:acme:component_framework:-:*:*:*:*:*:*:*"],
            title="Component Common Platform Enumeration (CPE)",
        ),
    ] = None
    purl: Annotated[
        Optional[str],
        Field(
            examples=["pkg:maven/com.acme/tomcat-catalina@9.0.14?packaging=jar"], title="Component Package URL (purl)"
        ),
    ] = None
    swid: Annotated[
        Optional[Swid],
        Field(
            description="Specifies metadata and content for ISO-IEC 19770-2 Software Identification (SWID) Tags.",
            title="SWID Tag",
        ),
    ] = None
    modified: Annotated[
        Optional[bool],
        Field(
            description=(
                "DEPRECATED - DO NOT USE. This will be removed in a future version. Use the pedigree element instead to"
                " supply information on exactly how the component was modified. A boolean value indicating is the"
                " component has been modified from the original. A value of true indicates the component is a"
                " derivative of the original. A value of false indicates the component has not been modified from the"
                " original."
            ),
            title="Component Modified From Original",
        ),
    ] = None
    pedigree: Annotated[
        Optional[Pedigree],
        Field(
            description=(
                "Component pedigree is a way to document complex supply chain scenarios where components are created,"
                " distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing"
                " this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to"
                " document variants where the exact relation may not be known."
            ),
            title="Component Pedigree",
        ),
    ] = None
    externalReferences: Annotated[Optional[List[ExternalReference]], Field(title="External References")] = None
    components: Annotated[Optional[List[Component]], Field(title="Components")] = None
    evidence: Annotated[
        Optional[ComponentEvidence],
        Field(
            description=(
                "Provides the ability to document evidence collected through various forms of extraction or analysis."
            ),
            title="Evidence",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description=(
                "Provides the ability to document properties in a name-value store. This provides flexibility to"
                " include data not officially supported in the standard without having to use additional namespaces or"
                " create extensions. Unlike key-value stores, properties support duplicate names, each potentially"
                " having different values."
            ),
            title="Properties",
        ),
    ] = None


Service.update_forward_refs()
CyclonedxSoftwareBillOfMaterialSpecification.update_forward_refs()
Metadata.update_forward_refs()
Pedigree.update_forward_refs()
