"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @stability stable
 */
class OriginGroup {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @stability stable
     */
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.OriginGroup", version: "1.129.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3JpZ2luLWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFnQkEsTUFBYSxXQUFXOzs7O0lBQ3RCLFlBQW9DLEtBQXVCO1FBQXZCLFVBQUssR0FBTCxLQUFLLENBQWtCO0lBQzNELENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxLQUFnQixFQUFFLE9BQXFDO1FBQ2pFLE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztRQUMxRSxJQUFJLG1CQUFtQixDQUFDLGNBQWMsRUFBRTtZQUN0QyxNQUFNLElBQUksS0FBSyxDQUFDLGdHQUFnRyxDQUFDLENBQUM7U0FDbkg7UUFFRCxPQUFPO1lBQ0wsY0FBYyxFQUFFLG1CQUFtQixDQUFDLGNBQWM7WUFDbEQsY0FBYyxFQUFFO2dCQUNkLGNBQWMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWM7Z0JBQ3pDLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQjthQUM1QztTQUNGLENBQUM7SUFDSixDQUFDOztBQWpCSCxrQ0FrQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE9yaWdpbkdyb3VwUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByaW1hcnlPcmlnaW46IGNsb3VkZnJvbnQuSU9yaWdpbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZhbGxiYWNrT3JpZ2luOiBjbG91ZGZyb250LklPcmlnaW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmYWxsYmFja1N0YXR1c0NvZGVzPzogbnVtYmVyW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIE9yaWdpbkdyb3VwIGltcGxlbWVudHMgY2xvdWRmcm9udC5JT3JpZ2luIHtcbiAgcHVibGljIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IE9yaWdpbkdyb3VwUHJvcHMpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIG9wdGlvbnM6IGNsb3VkZnJvbnQuT3JpZ2luQmluZE9wdGlvbnMpOiBjbG91ZGZyb250Lk9yaWdpbkJpbmRDb25maWcge1xuICAgIGNvbnN0IHByaW1hcnlPcmlnaW5Db25maWcgPSB0aGlzLnByb3BzLnByaW1hcnlPcmlnaW4uYmluZChzY29wZSwgb3B0aW9ucyk7XG4gICAgaWYgKHByaW1hcnlPcmlnaW5Db25maWcuZmFpbG92ZXJDb25maWcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQW4gT3JpZ2luR3JvdXAgY2Fubm90IHVzZSBhbiBPcmlnaW4gd2l0aCBpdHMgb3duIGZhaWxvdmVyIGNvbmZpZ3VyYXRpb24gYXMgaXRzIHByaW1hcnkgb3JpZ2luIScpO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBvcmlnaW5Qcm9wZXJ0eTogcHJpbWFyeU9yaWdpbkNvbmZpZy5vcmlnaW5Qcm9wZXJ0eSxcbiAgICAgIGZhaWxvdmVyQ29uZmlnOiB7XG4gICAgICAgIGZhaWxvdmVyT3JpZ2luOiB0aGlzLnByb3BzLmZhbGxiYWNrT3JpZ2luLFxuICAgICAgICBzdGF0dXNDb2RlczogdGhpcy5wcm9wcy5mYWxsYmFja1N0YXR1c0NvZGVzLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=