"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferenceEvent = void 0;
const events = require("@aws-cdk/aws-events");
/**
 * Fields of CloudWatch Events that change references.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 * @stability stable
 */
class ReferenceEvent {
    /**
     * The type of reference event.
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     *
     * @stability stable
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * Name of the CodeCommit repository.
     *
     * @stability stable
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * Id of the CodeCommit repository.
     *
     * @stability stable
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * Type of reference changed.
     *
     * 'branch' or 'tag'
     *
     * @stability stable
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * Name of reference changed (branch or tag name).
     *
     * @stability stable
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * Full reference name.
     *
     * For example, 'refs/tags/myTag'
     *
     * @stability stable
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * Commit id this reference now points to.
     *
     * @stability stable
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
    constructor() {
    }
}
exports.ReferenceEvent = ReferenceEvent;
//# sourceMappingURL=data:application/json;base64,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