# Welcome to LowPy Version 0.0.1!
<p align="center"><img src="logo.png" height="100px"></p>

**LowPy** is a high level GPU simulator of low level device characteristics in machine algorithms. It seeks to streamline the investigation process when considering memristive and other novel devices for implementing a machine learning algorithm in hardware. By using the familiar [Keras](https://keras.io) syntax, it will be second nature to write GPU-optimized code to push your algorithm to its limits.

# Features
The aim is to focus first on the algorithms most published on in the field of neuromorphic computing, for both static and time series datasets.
### Datasets
- MNIST
### Algorithms
- Single Layer Perceptron (SLP)
- Multi-Layer Perceprton (MLP)
### Activation Functions
- Sigmoid
### Optimization Functions
- Stochastic Gradient Descent (SGD)
- SGD with Momentum
### Initialization Distributions
- Uniform 
- Normal
### Device Characteristics
- Write Variability


# Requirements
The following are required to use LowPy:
- GPU: NVIDIA
- OS: Linux (should work on Windows, not tested)
- Python 3.0 or newer
- PyCUDA

