import pyxel
import error.error as error

class Characters:
    """define a images that correspond to character and use pyxel function to draw it"""
    
    tuple_0 = ( (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 0, 0, 0)
              ) 
    tuple_1 = ( (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
              ) 
    tuple_2 = ( (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
              )
    tuple_3 = ( (0, 0, 0, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 1, 1, 1, 1, 1, 0, 0),
              )
    tuple_4 = ( (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 0, 0),
                (1, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (1, 1, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
              )
    tuple_5 = ( (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
              )
    tuple_6 = ( (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
              )
    tuple_7 = ( (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
    )
    tuple_8 = ( (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
              ) 
    tuple_9 = ( (0, 0, 0, 0, 1, 1, 1, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
              )
    tuple_A = ( (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
    )
    tuple_B = ( (0, 0, 1, 1, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
    )
    tuple_C = ( (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
    )
    tuple_D = ( (0, 0, 1, 1, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 0, 0, 0, 0, 0),
    )
    tuple_E = ( (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
    )
    tuple_F = ( (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
    )
    tuple_G = ( (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 1, 1, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
    )
    tuple_H = ( (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
    )
    tuple_I = ( (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
    )
    tuple_J = ( (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 1, 1, 0, 0, 0, 0, 0),
    )
    tuple_K = ( (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
    )
    tuple_L = ( (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
    )
    tuple_M = ( (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 1, 0, 0, 0, 1, 1, 0, 0),
                (0, 1, 0, 1, 0, 1, 0, 1, 0, 0),
                (0, 1, 0, 0, 1, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 1, 0, 0),
    )
    tuple_N = ( (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 1, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 1, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 1, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
    )
    tuple_O = ( (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
    )
    tuple_P = ( (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
    )
    tuple_R = ( (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
    )
    tuple_Q = ( (0, 0, 0, 1, 1, 1, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 1, 0, 0, 1, 0),
                (0, 1, 0, 0, 0, 0, 1, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 1, 1, 0, 1, 0),
    )
    tuple_S = ( (0, 0, 0, 0, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 0, 0, 0),
    )
    tuple_T = ( (0, 0, 1, 1, 1, 1, 1, 1, 1, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
    )
    tuple_U = ( (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
    )
    tuple_V = ( (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
    )
    tuple_W = ( (0, 1, 0, 0, 0, 0, 0, 0, 0, 1),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 1, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 1, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 1, 0, 1, 0, 0),
                (0, 0, 0, 1, 1, 0, 1, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
    )
    tuple_X = ( (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 1, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 1, 0, 0),
    )
    tuple_Y = ( (0, 0, 1, 0, 0, 0, 0, 0, 1, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 1, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
    )
    tuple_Z = ( (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 0, 1, 0, 0),
                (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                (0, 0, 0, 1, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 0, 0, 0, 0, 0, 0, 0),
                (0, 0, 1, 1, 1, 1, 1, 1, 0, 0),
    )
    tuple_interrogation = ( (0, 0, 0, 1, 1, 1, 0, 0, 0, 0),
                            (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                            (0, 0, 1, 0, 0, 0, 1, 0, 0, 0),
                            (0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
                            (0, 0, 0, 0, 0, 1, 0, 0, 0, 0),
                            (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                            (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                            (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                            (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                            (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
    )
    tuple_exclamation = ( (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                          (0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
    )
    tuple_separateur = ((0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                        (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                       )
    tuple_vide = ( (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                   (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    )
    demi_tuple_vide = ( (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
    )
    tuple_point = ( (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (1, 0, 0, 0, 0),
    )
    tuple_comma = ( (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 0, 0, 0, 0),
                    (0, 1, 0, 0, 0),
                    (0, 1, 0, 0, 0),
                    (1, 0, 0, 0, 0),
    )
    tuple_semicolon = ( (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 1, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 0, 0, 0, 0),
                        (0, 1, 0, 0, 0),
                        (0, 1, 0, 0, 0),
                        (1, 0, 0, 0, 0),
    )
    character_reference = {
      """
      a dictionnary that associate a char with its image equivalent
      """

      "\\" : tuple_vide,
      "1" : tuple_1,
      "2" : tuple_2,
      "3" : tuple_3,
      "4" : tuple_4,
      "5" : tuple_5,
      "6" : tuple_6,
      "7" : tuple_7,
      "8" : tuple_8, 
      "9" : tuple_9,
      "0" : tuple_0,
      "A" : tuple_A,
      "B" : tuple_B,
      "C" : tuple_C,
      "D" : tuple_D,
      "E" : tuple_E,
      "F" : tuple_F,
      "G" : tuple_G,
      "H" : tuple_H,
      "I" : tuple_I,
      "J" : tuple_J,
      "K" : tuple_K,
      "L" : tuple_L,
      "M" : tuple_M,
      "N" : tuple_N,
      "O" : tuple_O,
      "P" : tuple_P,
      "Q" : tuple_Q,
      "R" : tuple_R,
      "S" : tuple_S,
      "T" : tuple_T,
      "U" : tuple_U,
      "V" : tuple_V,
      "W" : tuple_W,
      "X" : tuple_X,
      "Y" : tuple_Y,
      "Z" : tuple_Z,
      " " : demi_tuple_vide,
      "?" : tuple_interrogation,
      "!" : tuple_exclamation,
      "|" : tuple_separateur,
      "." : tuple_point,
      "," : tuple_comma,
      ";" : tuple_semicolon,
    }   

    @classmethod
    def affichage(cls, tuple_char, x_depart, y_depart, unity_width = 5, transparence = True):
        """
        tuple_char, the image in the dictionnary, x and y the top-left coordinate, unity width is the width of a unit must be strictely inferior to 21
        """
        pyxel.load('writing_module.pyxres', True, False, False, False)
        for y in range(len(tuple_char)) :
            for x in range(len(tuple_char[y])) :
                if tuple_char[y][x] :
                    pyxel.blt(x_depart + x * unity_width, y_depart + y * unity_width, 0, 0, 0, unity_width, unity_width)
                elif not transparence:
                    pyxel.blt(x_depart + x * unity_width, y_depart + y * unity_width, 0, 21, 0, unity_width, unity_width)
        return x_depart + unity_width * len(tuple_char[1])
    
    @classmethod
    def parsing(cls, string, x_depart, y_depart, unity_width = 5, transparence = True):
      """from the string, parse it and draw the text"""

      for char in string:
        try:
          tuple_char = cls.character_reference[char.upper()]
        except KeyError:
          raise(error.CharacterNotSupportedFatalError("This character isn't supported yet: " + char))
        
        x_depart = cls.affichage(tuple_char, x_depart, y_depart, unity_width, transparence)