# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BaremetalServerIpArgs',
    'DatabaseAclAclRuleArgs',
    'DatabaseInstanceLoadBalancerArgs',
    'DatabaseInstancePrivateNetworkArgs',
    'DatabaseInstanceReadReplicaArgs',
    'DatabaseReadReplicaDirectAccessArgs',
    'DatabaseReadReplicaPrivateNetworkArgs',
    'DomainRecordGeoIpArgs',
    'DomainRecordGeoIpMatchArgs',
    'DomainRecordHttpServiceArgs',
    'DomainRecordViewArgs',
    'DomainRecordWeightedArgs',
    'InstanceImageAdditionalVolumeArgs',
    'InstanceSecurityGroupInboundRuleArgs',
    'InstanceSecurityGroupOutboundRuleArgs',
    'InstanceSecurityGroupRulesInboundRuleArgs',
    'InstanceSecurityGroupRulesOutboundRuleArgs',
    'InstanceServerPrivateNetworkArgs',
    'InstanceServerRootVolumeArgs',
    'IotDeviceCertificateArgs',
    'IotDeviceMessageFiltersArgs',
    'IotDeviceMessageFiltersPublishArgs',
    'IotDeviceMessageFiltersSubscribeArgs',
    'IotRouteDatabaseArgs',
    'IotRouteRestArgs',
    'IotRouteS3Args',
    'KubernetesClusterAutoUpgradeArgs',
    'KubernetesClusterAutoscalerConfigArgs',
    'KubernetesClusterKubeconfigArgs',
    'KubernetesClusterOpenIdConnectConfigArgs',
    'KubernetesNodePoolNodeArgs',
    'KubernetesNodePoolUpgradePolicyArgs',
    'LoadbalancerBackendHealthCheckHttpArgs',
    'LoadbalancerBackendHealthCheckHttpsArgs',
    'LoadbalancerBackendHealthCheckTcpArgs',
    'LoadbalancerCertificateCustomCertificateArgs',
    'LoadbalancerCertificateLetsencryptArgs',
    'LoadbalancerFrontendAclArgs',
    'LoadbalancerFrontendAclActionArgs',
    'LoadbalancerFrontendAclMatchArgs',
    'LoadbalancerPrivateNetworkArgs',
    'ObjectBucketAclAccessControlPolicyArgs',
    'ObjectBucketAclAccessControlPolicyGrantArgs',
    'ObjectBucketAclAccessControlPolicyGrantGranteeArgs',
    'ObjectBucketAclAccessControlPolicyOwnerArgs',
    'ObjectBucketCorsRuleArgs',
    'ObjectBucketLifecycleRuleArgs',
    'ObjectBucketLifecycleRuleExpirationArgs',
    'ObjectBucketLifecycleRuleTransitionArgs',
    'ObjectBucketVersioningArgs',
    'ObjectBucketWebsiteConfigurationErrorDocumentArgs',
    'ObjectBucketWebsiteConfigurationIndexDocumentArgs',
    'RedisClusterAclArgs',
    'RedisClusterPrivateNetworkArgs',
    'RedisClusterPublicNetworkArgs',
]

@pulumi.input_type
class BaremetalServerIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the IP.
        :param pulumi.Input[str] id: The ID of the IP.
        :param pulumi.Input[str] reverse: The reverse of the IP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the IP.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IP.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse of the IP.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DatabaseAclAclRuleArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[str] description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DatabaseInstanceLoadBalancerArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the private network.
        :param pulumi.Input[str] hostname: Name of the endpoint.
        :param pulumi.Input[str] ip: IP of the endpoint.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the private network.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DatabaseInstancePrivateNetworkArgs:
    def __init__(__self__, *,
                 ip_net: pulumi.Input[str],
                 pn_id: pulumi.Input[str],
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the private network.
        :param pulumi.Input[str] hostname: Name of the endpoint.
        :param pulumi.Input[str] ip: IP of the endpoint.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port of the endpoint.
        """
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "pn_id", pn_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ip_net")

    @ip_net.setter
    def ip_net(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_net", value)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pn_id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the private network.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DatabaseInstanceReadReplicaArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] ip: IP of the endpoint.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port of the endpoint.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DatabaseReadReplicaDirectAccessArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DatabaseReadReplicaPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[str],
                 service_ip: pulumi.Input[str],
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: UUID of the private network to be connected to the read replica.
        :param pulumi.Input[str] service_ip: Endpoint IPv4 address with a CIDR notation. Check documentation about IP and subnet limitations. (IP network).
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "service_ip", service_ip)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[str]:
        """
        UUID of the private network to be connected to the read replica.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> pulumi.Input[str]:
        """
        Endpoint IPv4 address with a CIDR notation. Check documentation about IP and subnet limitations. (IP network).
        """
        return pulumi.get(self, "service_ip")

    @service_ip.setter
    def service_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_ip", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DomainRecordGeoIpArgs:
    def __init__(__self__, *,
                 matches: pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]] matches: The list of matches. *(Can be more than 1)*
        """
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]:
        """
        The list of matches. *(Can be more than 1)*
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]):
        pulumi.set(self, "matches", value)


@pulumi.input_type
class DomainRecordGeoIpMatchArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 continents: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[Sequence[pulumi.Input[str]]] continents: List of continents (eg: `EU` for Europe, `NA` for North America, `AS` for Asia...). [List of all continents code](https://api.scaleway.com/domain-private/v2beta1/continents)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] countries: List of countries (eg: `FR` for France, `US` for the United States, `GB` for Great Britain...). [List of all countries code](https://api.scaleway.com/domain-private/v2beta1/countries)
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The data of the view record
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def continents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of continents (eg: `EU` for Europe, `NA` for North America, `AS` for Asia...). [List of all continents code](https://api.scaleway.com/domain-private/v2beta1/continents)
        """
        return pulumi.get(self, "continents")

    @continents.setter
    def continents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "continents", value)

    @property
    @pulumi.getter
    def countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of countries (eg: `FR` for France, `US` for the United States, `GB` for Great Britain...). [List of all countries code](https://api.scaleway.com/domain-private/v2beta1/countries)
        """
        return pulumi.get(self, "countries")

    @countries.setter
    def countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "countries", value)


@pulumi.input_type
class DomainRecordHttpServiceArgs:
    def __init__(__self__, *,
                 ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 must_contain: pulumi.Input[str],
                 strategy: pulumi.Input[str],
                 url: pulumi.Input[str],
                 user_agent: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ips: List of IPs to check
        :param pulumi.Input[str] must_contain: Text to search
        :param pulumi.Input[str] strategy: Strategy to return an IP from the IPs list. Can be `random` or `hashed`
        :param pulumi.Input[str] url: URL to match the `must_contain` text to validate an IP
        :param pulumi.Input[str] user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of IPs to check
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> pulumi.Input[str]:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @must_contain.setter
    def must_contain(self, value: pulumi.Input[str]):
        pulumi.set(self, "must_contain", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        """
        Strategy to return an IP from the IPs list. Can be `random` or `hashed`
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        URL to match the `must_contain` text to validate an IP
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[pulumi.Input[str]]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")

    @user_agent.setter
    def user_agent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_agent", value)


@pulumi.input_type
class DomainRecordViewArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 subnet: pulumi.Input[str]):
        """
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[str] subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The data of the view record
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class DomainRecordWeightedArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[str] ip: The weighted IP
        :param pulumi.Input[int] weight: The weight of the IP as an integer UInt32.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The weight of the IP as an integer UInt32.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class InstanceImageAdditionalVolumeArgs:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 export_uri: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 modification_date: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] creation_date: Date of the volume creation.
        :param pulumi.Input[str] export_uri: The export URI of the volume.
        :param pulumi.Input[str] id: ID of the server containing the volume.
        :param pulumi.Input[str] modification_date: Date of volume latest update.
        :param pulumi.Input[str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[str] organization: The organization ID the volume is associated with.
        :param pulumi.Input[str] project: ID of the project the volume is associated with
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param pulumi.Input[int] size: The size of the volume.
        :param pulumi.Input[str] state: State of the volume.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[str] volume_type: The type of volume, possible values are `l_ssd` and `b_ssd`.
        :param pulumi.Input[str] zone: The zone in which the image should be created.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if export_uri is not None:
            pulumi.set(__self__, "export_uri", export_uri)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if modification_date is not None:
            pulumi.set(__self__, "modification_date", modification_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date of the volume creation.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="exportUri")
    def export_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The export URI of the volume.
        """
        return pulumi.get(self, "export_uri")

    @export_uri.setter
    def export_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_uri", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date of volume latest update.
        """
        return pulumi.get(self, "modification_date")

    @modification_date.setter
    def modification_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the volume is associated with.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project the volume is associated with
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume, possible values are `l_ssd` and `b_ssd`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class InstanceSecurityGroupInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupRulesInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupRulesOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceServerPrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[str],
                 mac_address: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pn_id", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class InstanceServerRootVolumeArgs:
    def __init__(__self__, *,
                 boot: Optional[pulumi.Input[bool]] = None,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] delete_on_termination: Forces deletion of the root volume on instance termination.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[int] size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://api.scaleway.com/instance/v1/zones/fr-par-1/products/servers) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Updates to this field will recreate a new resource.
        :param pulumi.Input[str] volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param pulumi.Input[str] volume_type: Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "boot")

    @boot.setter
    def boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot", value)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://api.scaleway.com/instance/v1/zones/fr-par-1/products/servers) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class IotDeviceCertificateArgs:
    def __init__(__self__, *,
                 crt: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "crt")

    @crt.setter
    def crt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crt", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class IotDeviceMessageFiltersArgs:
    def __init__(__self__, *,
                 publish: Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']] = None,
                 subscribe: Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']] = None):
        """
        :param pulumi.Input['IotDeviceMessageFiltersPublishArgs'] publish: Rules used to restrict topics the device can publish to.
        :param pulumi.Input['IotDeviceMessageFiltersSubscribeArgs'] subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']]:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def subscribe(self) -> Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']]:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")

    @subscribe.setter
    def subscribe(self, value: Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']]):
        pulumi.set(self, "subscribe", value)


@pulumi.input_type
class IotDeviceMessageFiltersPublishArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] policy: Same as publish rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: Same as publish rules.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)


@pulumi.input_type
class IotDeviceMessageFiltersSubscribeArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] policy: Same as publish rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: Same as publish rules.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)


@pulumi.input_type
class IotRouteDatabaseArgs:
    def __init__(__self__, *,
                 dbname: pulumi.Input[str],
                 host: pulumi.Input[str],
                 password: pulumi.Input[str],
                 port: pulumi.Input[int],
                 query: pulumi.Input[str],
                 username: pulumi.Input[str]):
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> pulumi.Input[str]:
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: pulumi.Input[str]):
        pulumi.set(self, "dbname", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class IotRouteRestArgs:
    def __init__(__self__, *,
                 headers: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 uri: pulumi.Input[str],
                 verb: pulumi.Input[str]):
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def verb(self) -> pulumi.Input[str]:
        return pulumi.get(self, "verb")

    @verb.setter
    def verb(self, value: pulumi.Input[str]):
        pulumi.set(self, "verb", value)


@pulumi.input_type
class IotRouteS3Args:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 bucket_region: pulumi.Input[str],
                 strategy: pulumi.Input[str],
                 object_prefix: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "object_prefix")

    @object_prefix.setter
    def object_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_prefix", value)


@pulumi.input_type
class KubernetesClusterAutoUpgradeArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool],
                 maintenance_window_day: pulumi.Input[str],
                 maintenance_window_start_hour: pulumi.Input[int]):
        """
        :param pulumi.Input[bool] enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param pulumi.Input[str] maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param pulumi.Input[int] maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> pulumi.Input[str]:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @maintenance_window_day.setter
    def maintenance_window_day(self, value: pulumi.Input[str]):
        pulumi.set(self, "maintenance_window_day", value)

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> pulumi.Input[int]:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")

    @maintenance_window_start_hour.setter
    def maintenance_window_start_hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "maintenance_window_start_hour", value)


@pulumi.input_type
class KubernetesClusterAutoscalerConfigArgs:
    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[pulumi.Input[bool]] = None,
                 disable_scale_down: Optional[pulumi.Input[bool]] = None,
                 estimator: Optional[pulumi.Input[str]] = None,
                 expander: Optional[pulumi.Input[str]] = None,
                 expendable_pods_priority_cutoff: Optional[pulumi.Input[int]] = None,
                 ignore_daemonsets_utilization: Optional[pulumi.Input[bool]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[int]] = None,
                 scale_down_delay_after_add: Optional[pulumi.Input[str]] = None,
                 scale_down_unneeded_time: Optional[pulumi.Input[str]] = None,
                 scale_down_utilization_threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param pulumi.Input[bool] disable_scale_down: Disables the scale down feature of the autoscaler.
        :param pulumi.Input[str] estimator: Type of resource estimator to be used in scale up.
        :param pulumi.Input[str] expander: Type of node group expander to be used in scale up.
        :param pulumi.Input[int] expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param pulumi.Input[bool] ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param pulumi.Input[int] max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param pulumi.Input[str] scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param pulumi.Input[str] scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param pulumi.Input[float] scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @balance_similar_node_groups.setter
    def balance_similar_node_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "balance_similar_node_groups", value)

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @disable_scale_down.setter
    def disable_scale_down(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_scale_down", value)

    @property
    @pulumi.getter
    def estimator(self) -> Optional[pulumi.Input[str]]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @estimator.setter
    def estimator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimator", value)

    @property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[str]]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expander", value)

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[pulumi.Input[int]]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @expendable_pods_priority_cutoff.setter
    def expendable_pods_priority_cutoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expendable_pods_priority_cutoff", value)

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @ignore_daemonsets_utilization.setter
    def ignore_daemonsets_utilization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_daemonsets_utilization", value)

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[pulumi.Input[str]]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @scale_down_delay_after_add.setter
    def scale_down_delay_after_add(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_add", value)

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[pulumi.Input[str]]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @scale_down_unneeded_time.setter
    def scale_down_unneeded_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unneeded_time", value)

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")

    @scale_down_utilization_threshold.setter
    def scale_down_utilization_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_utilization_threshold", value)


@pulumi.input_type
class KubernetesClusterKubeconfigArgs:
    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[pulumi.Input[str]] = None,
                 config_file: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param pulumi.Input[str] config_file: The raw kubeconfig file.
        :param pulumi.Input[str] host: The URL of the Kubernetes API server.
        :param pulumi.Input[str] token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[str]]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class KubernetesClusterOpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 issuer_url: pulumi.Input[str],
                 groups_claims: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_prefix: Optional[pulumi.Input[str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_claim: Optional[pulumi.Input[str]] = None,
                 username_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: A client id that all tokens must be issued for
        :param pulumi.Input[str] issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_claims: JWT claim to use as the user's group
        :param pulumi.Input[str] groups_prefix: Prefix prepended to group claims
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param pulumi.Input[str] username_claim: JWT claim to use as the user name
        :param pulumi.Input[str] username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[str]:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @groups_claims.setter
    def groups_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_claims", value)

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @groups_prefix.setter
    def groups_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_prefix", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_claims", value)

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[pulumi.Input[str]]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @username_claim.setter
    def username_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_claim", value)

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")

    @username_prefix.setter
    def username_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_prefix", value)


@pulumi.input_type
class KubernetesNodePoolNodeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 public_ip_v6: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] public_ip: The public IPv4.
        :param pulumi.Input[str] public_ip_v6: The public IPv6.
        :param pulumi.Input[str] status: The status of the node.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> Optional[pulumi.Input[str]]:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @public_ip_v6.setter
    def public_ip_v6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_v6", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class KubernetesNodePoolUpgradePolicyArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[int]] = None,
                 max_unavailable: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_surge: The maximum number of nodes to be created during the upgrade
        :param pulumi.Input[int] max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unavailable", value)


@pulumi.input_type
class LoadbalancerBackendHealthCheckHttpArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 code: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] uri: The HTTPS endpoint URL to call for HC requests.
        :param pulumi.Input[int] code: The expected HTTP status code.
        :param pulumi.Input[str] method: The HTTP method to use for HC requests.
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The HTTPS endpoint URL to call for HC requests.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for HC requests.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)


@pulumi.input_type
class LoadbalancerBackendHealthCheckHttpsArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 code: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] uri: The HTTPS endpoint URL to call for HC requests.
        :param pulumi.Input[int] code: The expected HTTP status code.
        :param pulumi.Input[str] method: The HTTP method to use for HC requests.
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The HTTPS endpoint URL to call for HC requests.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for HC requests.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)


@pulumi.input_type
class LoadbalancerBackendHealthCheckTcpArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class LoadbalancerCertificateCustomCertificateArgs:
    def __init__(__self__, *,
                 certificate_chain: pulumi.Input[str]):
        """
        :param pulumi.Input[str] certificate_chain: Full PEM-formatted certificate chain.
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Input[str]:
        """
        Full PEM-formatted certificate chain.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_chain", value)


@pulumi.input_type
class LoadbalancerCertificateLetsencryptArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[str],
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] common_name: Main domain of the certificate. A new certificate will be created if this field is changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: Array of alternative domain names.  A new certificate will be created if this field is changed.
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        Main domain of the certificate. A new certificate will be created if this field is changed.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of alternative domain names.  A new certificate will be created if this field is changed.
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alternative_names", value)


@pulumi.input_type
class LoadbalancerFrontendAclArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['LoadbalancerFrontendAclActionArgs'],
                 match: pulumi.Input['LoadbalancerFrontendAclMatchArgs'],
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['LoadbalancerFrontendAclActionArgs'] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input['LoadbalancerFrontendAclMatchArgs'] match: The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[str] name: The ACL name. If not provided it will be randomly generated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['LoadbalancerFrontendAclActionArgs']:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['LoadbalancerFrontendAclActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['LoadbalancerFrontendAclMatchArgs']:
        """
        The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['LoadbalancerFrontendAclMatchArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadbalancerFrontendAclActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: The action type. Possible values are: `allow` or `deny`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The action type. Possible values are: `allow` or `deny`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LoadbalancerFrontendAclMatchArgs:
    def __init__(__self__, *,
                 http_filter: Optional[pulumi.Input[str]] = None,
                 http_filter_option: Optional[pulumi.Input[str]] = None,
                 http_filter_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invert: Optional[pulumi.Input[bool]] = None,
                 ip_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        :param pulumi.Input[bool] invert: If set to `true`, the condition will be of type "unless".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @http_filter.setter
    def http_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter", value)

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_filter_option")

    @http_filter_option.setter
    def http_filter_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter_option", value)

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @http_filter_values.setter
    def http_filter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "http_filter_values", value)

    @property
    @pulumi.getter
    def invert(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @invert.setter
    def invert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert", value)

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        return pulumi.get(self, "ip_subnets")

    @ip_subnets.setter
    def ip_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_subnets", value)


@pulumi.input_type
class LoadbalancerPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[str],
                 dhcp_config: Optional[pulumi.Input[bool]] = None,
                 static_configs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: (Required) The ID of the Private Network to associate.
        :param pulumi.Input[bool] dhcp_config: (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_configs: (Optional) Define two local ip address of your choice for each load balancer instance. See below.
        :param pulumi.Input[str] zone: `zone`) The zone in which the IP should be reserved.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if static_configs is not None:
            pulumi.set(__self__, "static_configs", static_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[str]:
        """
        (Required) The ID of the Private Network to associate.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        """
        return pulumi.get(self, "dhcp_config")

    @dhcp_config.setter
    def dhcp_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_config", value)

    @property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Optional) Define two local ip address of your choice for each load balancer instance. See below.
        """
        return pulumi.get(self, "static_configs")

    @static_configs.setter
    def static_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_configs", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the IP should be reserved.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs'],
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]] = None):
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs']:
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs']):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]]:
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]]):
        pulumi.set(self, "grants", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyGrantArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 grantee: Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']] = None):
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def grantee(self) -> Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']]:
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']]):
        pulumi.set(self, "grantee", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyGrantGranteeArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The `region`,`bucket` and `acl` separated by (`/`).
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyOwnerArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The `region`,`bucket` and `acl` separated by (`/`).
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class ObjectBucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None):
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 abort_incomplete_multipart_upload_days: Optional[pulumi.Input[int]] = None,
                 expiration: Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]] = None):
        """
        :param pulumi.Input[str] id: The unique name of the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A list of tags (key / value) for the bucket.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @abort_incomplete_multipart_upload_days.setter
    def abort_incomplete_multipart_upload_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "abort_incomplete_multipart_upload_days", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']]:
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the bucket.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of tags (key / value) for the bucket.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]]:
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[int]):
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[int]:
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[int]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[str],
                 days: Optional[pulumi.Input[int]] = None):
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class ObjectBucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ObjectBucketWebsiteConfigurationErrorDocumentArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class ObjectBucketWebsiteConfigurationIndexDocumentArgs:
    def __init__(__self__, *,
                 suffix: pulumi.Input[str]):
        pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def suffix(self) -> pulumi.Input[str]:
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: pulumi.Input[str]):
        pulumi.set(self, "suffix", value)


@pulumi.input_type
class RedisClusterAclArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[str] description: A text describing this rule. Default description: `Allow IP`
        :param pulumi.Input[str] id: The UUID of the private network resource.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing this rule. Default description: `Allow IP`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RedisClusterPrivateNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 service_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The UUID of the private network resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_ips: Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        :param pulumi.Input[str] zone: `zone`) The zone in which the Redis Cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_ips", service_ips)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        """
        return pulumi.get(self, "service_ips")

    @service_ips.setter
    def service_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "service_ips", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class RedisClusterPublicNetworkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: The UUID of the private network resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


