# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import datetime
import typing
import zoneinfo
from enum import Enum, auto

class OpeningHours:
    r"""
    Parse input opening hours description.

    Parameters
    ----------
    - oh: Opening hours expression as defined in OSM (eg. "24/7"). See
      https://wiki.openstreetmap.org/wiki/Key:opening_hours/specification
    - timezone: Timezone where the physical place attached to these opening hours lives in. When
      specified, operations on this expression will return dates attached to this timezone and
      input times in other timezones will be converted.
    - country: ISO code of the country this physical place lives in. This will be used to load a
      calendar of local public holidays.
    - coords: (latitude, longitude) of this place. When this is specified together with a timezone
      sun events will be accurate (sunrise, sunset, dusk, dawn). By default, this will be used to
      automatically detect the timezone and a country code.
    - auto_country: If set to `True`, the country code will automatically be inferred from
      coordinates when they are specified.
    - auto_timezone: If set to `True`, the timezone will automatically be inferred from coordinates
      when they are specified.

    Raises
    ------
    SyntaxError
        Given string is not in valid opening hours format.

    Examples
    --------
    >>> oh = OpeningHours("24/7")
    >>> oh.is_open()
    True

    >>> dt = datetime.fromisoformat("2024-07-14 15:00")
    >>> oh = OpeningHours("sunrise-sunset ; PH off", country="FR", coords=(48.8535, 2.34839))
    >>> assert oh.is_closed(dt)
    >>> assert oh.next_change(dt).replace(tzinfo=None) == datetime.fromisoformat("2024-07-15 06:03")
    """
    def __new__(
        cls,
        oh: builtins.str,
        timezone: typing.Optional[zoneinfo.ZoneInfo] = None,
        country: typing.Optional[builtins.str] = None,
        coords: typing.Optional[tuple[builtins.float, builtins.float]] = None,
        auto_country: typing.Optional[builtins.bool] = True,
        auto_timezone: typing.Optional[builtins.bool] = True,
    ): ...
    def state(self, time: typing.Optional[datetime.datetime] = None) -> State:
        r"""
        Get current state of the time domain, the state can be either "open",
        "closed" or "unknown".

        Parameters
        ----------
        - time: Base time for the evaluation, current time will be used if it is not specified.

        Examples
        --------
        >>> OpeningHours("24/7 off").state()
        State.CLOSED
        """
        ...

    def is_open(self, time: typing.Optional[datetime.datetime] = None) -> builtins.bool:
        r"""
        Check if current state is open.

        Parameters
        ----------
        - time: Base time for the evaluation, current time will be used if it is not specified.

        Examples
        --------
        >>> OpeningHours("24/7").is_open()
        True
        """
        ...

    def is_closed(
        self, time: typing.Optional[datetime.datetime] = None
    ) -> builtins.bool:
        r"""
        Check if current state is closed.

        Parameters
        ----------
        - time: Base time for the evaluation, current time will be used if it is not specified.

        Examples
        --------
        >>> OpeningHours("24/7 off").is_closed()
        True
        """
        ...

    def is_unknown(
        self, time: typing.Optional[datetime.datetime] = None
    ) -> builtins.bool:
        r"""
        Check if current state is unknown.

        Parameters
        ----------
        - time: Base time for the evaluation, current time will be used if it is not specified.

        Examples
        --------
        >>> OpeningHours("24/7 unknown").is_unknown()
        True
        """
        ...

    def next_change(
        self, time: typing.Optional[datetime.datetime] = None
    ) -> typing.Optional[datetime.datetime]:
        r"""
        Get the date for next change of state.
        If the date exceed the limit date, returns None.

        Parameters
        ----------
        - time: Base time for the evaluation, current time will be used if it is not specified.

        Examples
        --------
        >>> OpeningHours("24/7").next_change() # None
        >>> OpeningHours("2099Mo-Su 12:30-17:00").next_change()
        datetime.datetime(2099, 1, 1, 12, 30)
        """
        ...

    def intervals(
        self,
        start: typing.Optional[datetime.datetime] = None,
        end: typing.Optional[datetime.datetime] = None,
    ) -> typing.Iterator[
        builtins.tuple[datetime.datetime, datetime.datetime, State, builtins.str]
    ]:
        r"""
        Give an iterator that yields successive time intervals of consistent
        state.

        Parameters
        ----------
        - start: Initial time for the iterator, current time will be used if it is not specified.
        - end: Maximal time for the iterator, the iterator will continue until year 9999 if it no
          max is specified.

        Examples
        --------
        >>> intervals = OpeningHours("2099Mo-Su 12:30-17:00").intervals()
        >>> next(intervals)
        (..., datetime.datetime(2099, 1, 1, 12, 30), State.CLOSED, [])
        >>> next(intervals)
        (datetime.datetime(2099, 1, 1, 12, 30), datetime.datetime(2099, 1, 1, 17, 0), State.OPEN, [])
        """
        ...

    def __str__(self) -> builtins.str: ...
    def __repr__(self) -> builtins.str: ...

class State(Enum):
    r"""
    Specify the state of an opening hours interval.
    """

    OPEN = auto()
    CLOSED = auto()
    UNKNOWN = auto()

def validate(oh: builtins.str) -> builtins.bool:
    r"""
    Validate that input string is a correct opening hours description.

    Examples
    --------
    >>> opening_hours.validate("24/7")
    True
    >>> opening_hours.validate("24/24")
    False
    """
    ...
