# Contributing to Edulib Python Project

Thank you for your interest in contributing to the Edulib Python project! This document provides guidelines to help you get started with the development process.

## Getting Started

### Clone the Project

First, clone the project repository to your local machine:

```bash
git clone https://github.com/Aleksa-Lukic/Edulib.git
```

### Setting Up the Development Environment

Follow the instructions in the [Development Guide](./README.md) to set up your development environment.

## Development Workflow

### 1. Create a New Branch

Before making changes to the codebase, create a new branch for your work:

```bash
git checkout -b your-feature-branch
```

### 2. Implement Your Changes

Now you can start implementing your changes in the your-feature-branch. Feel free to edit files, add new features or fix bugs as needed.


### 3. Running Tests

Make sure to run tests using the following command to ensure that your changes don't break existing functionality:

```bash
tox
```

### 4. Commit Your Changes

Once your changes are complete and tests have passed, commit your changes:

```bash
git add .
git commit -m "Add a descriptive commit message"

```
