# coding: utf-8

"""
    Pure Storage FlashBlade REST 1.11 Python SDK

    Pure Storage FlashBlade REST 1.11 Python SDK. Compatible with REST API versions 1.0 - 1.11. Developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

    OpenAPI spec version: 1.11
    Contact: info@purestorage.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class FileSystemReplicaLinksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_file_system_replica_link_policies(self, **kwargs):
        """
        Create a connection between a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_replica_link_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_file_system_replica_link_policies_with_http_info(**kwargs)
        else:
            (data) = self.create_file_system_replica_link_policies_with_http_info(**kwargs)
            return data

    def create_file_system_replica_link_policies_with_http_info(self, **kwargs):
        """
        Create a connection between a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_replica_link_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_system_replica_link_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links/policies', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberWithRemoteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_file_system_replica_links(self, **kwargs):
        """
        Create new file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_replica_links(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with `local_file_system_ids` query parameter.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names.
        :param FileSystemReplicaLink file_system_replica_link: The attribute map used to create the file system replica link.
        :return: FileSystemReplicaLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_file_system_replica_links_with_http_info(**kwargs)
        else:
            (data) = self.create_file_system_replica_links_with_http_info(**kwargs)
            return data

    def create_file_system_replica_links_with_http_info(self, **kwargs):
        """
        Create new file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_replica_links_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with `local_file_system_ids` query parameter.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names.
        :param FileSystemReplicaLink file_system_replica_link: The attribute map used to create the file system replica link.
        :return: FileSystemReplicaLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_ids', 'local_file_system_names', 'remote_ids', 'remote_names', 'remote_file_system_names', 'file_system_replica_link']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_system_replica_links" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'
        if 'remote_file_system_names' in params:
            query_params.append(('remote_file_system_names', params['remote_file_system_names']))
            collection_formats['remote_file_system_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_system_replica_link' in params:
            body_params = params['file_system_replica_link']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemReplicaLinkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_file_system_replica_link_policies(self, **kwargs):
        """
        Delete a connection betwwen a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_replica_link_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_system_replica_link_policies_with_http_info(**kwargs)
        else:
            (data) = self.delete_file_system_replica_link_policies_with_http_info(**kwargs)
            return data

    def delete_file_system_replica_link_policies_with_http_info(self, **kwargs):
        """
        Delete a connection betwwen a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_replica_link_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_system_replica_link_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links/policies', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_file_system_replica_link_policies(self, **kwargs):
        """
        List policies attached to file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_link_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names. This cannot be provided together with `remote_file_system_ids` query parameter.
        :param list[str] remote_file_system_ids: A comma-separated list of remote file system IDs. This cannot be provided together with `remote_file_system_names` query parameter.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_file_system_replica_link_policies_with_http_info(**kwargs)
        else:
            (data) = self.list_file_system_replica_link_policies_with_http_info(**kwargs)
            return data

    def list_file_system_replica_link_policies_with_http_info(self, **kwargs):
        """
        List policies attached to file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_link_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names. This cannot be provided together with `remote_file_system_ids` query parameter.
        :param list[str] remote_file_system_ids: A comma-separated list of remote file system IDs. This cannot be provided together with `remote_file_system_names` query parameter.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names', 'remote_file_system_names', 'remote_file_system_ids', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_system_replica_link_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'
        if 'remote_file_system_names' in params:
            query_params.append(('remote_file_system_names', params['remote_file_system_names']))
            collection_formats['remote_file_system_names'] = 'csv'
        if 'remote_file_system_ids' in params:
            query_params.append(('remote_file_system_ids', params['remote_file_system_ids']))
            collection_formats['remote_file_system_ids'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links/policies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberWithRemoteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_file_system_replica_link_transfer(self, **kwargs):
        """
        List file system replica link transfer records
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_link_transfer(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :param bool total_only: Return only the total object.
        :return: FileSystemSnapshotTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_file_system_replica_link_transfer_with_http_info(**kwargs)
        else:
            (data) = self.list_file_system_replica_link_transfer_with_http_info(**kwargs)
            return data

    def list_file_system_replica_link_transfer_with_http_info(self, **kwargs):
        """
        List file system replica link transfer records
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_link_transfer_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :param bool total_only: Return only the total object.
        :return: FileSystemSnapshotTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'remote_ids', 'remote_names', 'names_or_owner_names', 'filter', 'sort', 'start', 'limit', 'token', 'total_only']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_system_replica_link_transfer" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'
        if 'names_or_owner_names' in params:
            query_params.append(('names_or_owner_names', params['names_or_owner_names']))
            collection_formats['names_or_owner_names'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))
        if 'total_only' in params:
            query_params.append(('total_only', params['total_only']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links/transfer', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemSnapshotTransferResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_file_system_replica_links(self, **kwargs):
        """
        List file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_links(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str filter: The filter to be used for query.
        :param int limit: limit, should be >= 0
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with `local_file_system_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: FileSystemReplicaLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_file_system_replica_links_with_http_info(**kwargs)
        else:
            (data) = self.list_file_system_replica_links_with_http_info(**kwargs)
            return data

    def list_file_system_replica_links_with_http_info(self, **kwargs):
        """
        List file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_replica_links_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str filter: The filter to be used for query.
        :param int limit: limit, should be >= 0
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with `local_file_system_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: FileSystemReplicaLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'filter', 'limit', 'local_file_system_ids', 'local_file_system_names', 'remote_file_system_names', 'remote_ids', 'remote_names', 'sort', 'start', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_system_replica_links" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'remote_file_system_names' in params:
            query_params.append(('remote_file_system_names', params['remote_file_system_names']))
            collection_formats['remote_file_system_names'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/file-system-replica-links', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemReplicaLinkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
