![GitHub](https://img.shields.io/github/license/felixleopoldo/trilearn)
![PyPI](https://img.shields.io/pypi/v/trilearn)
![Libraries.io dependency status for latest release](https://img.shields.io/librariesio/release/pypi/trilearn)

# Bayesian inference in decomposable graphical models using sequential Monte Carlo methods
This library contains Bayesian inference in decomposable (triangulated) graphical models based on sequential Monte Carlo methods.
Currently supported functionalities include:

- Bayesian structure learning for discrete log-linear and Gaussian data.

- Estimation of the number of decomopsable graphs with a 
given number of nodes.

- Predictive classification using Bayesian model averaging (BMA).

- Random generation of junction trees (the Christmas tree algorithm).

### Installation
This package currently requires Python 2.7.
If graphviz is not installed, you can install it from brew / aptitude / pacman for example
```
$ brew install graphviz
```
On Ubuntu you might need to run
```
sudo apt-get install python-dev graphviz libgraphviz-dev pkg-config
```

Then run
```
$ pip install trilearn
```

### Running the tests

```
$ make test
```
## Usage
See the Jupyter notebooks for examples of usage.


## Scripts
### Continuous data
To approximate the underlying decomposable graph posterior given the dataset sample_data/data_ar1-5.csv run
```
$ pgibbs_ggm_sample -N 50 -M 1000 -f sample_data/data_ar1-5.csv
```
this will produce a file containing the Markov chain generated by the particle Gibbs algorithm. 
In order to analyze the chain run
```
$ analyze_graph_tajectories
```
this will produce a bunch of files in the current directory to be analyzed.

### Discrete data
The data set examples/data/czech_autoworkers.csv contains six binary variables.
To generate a particle Gibbs trajectory of decomposable graphs type
```
$ pgibbs_loglinear_sample -N 50 -M 300 -f sample_data/czech_autoworkers.csv
```
and
```
$ analyze_graph_tajectories
```
this will produce a number of files in the current directory.

### Estimate the number of decomposable graphs

To estimate the number of decomposable graphs with up to 15 nodes run for example
```
$ count_chordal_graphs -p 15 -N 20000
```
## Built With

* [NetworkX](https://networkx.github.io/documentation/stable/index.html)

* [NumPy](https://docs.scipy.org/doc/)

* [Scipy](https://docs.scipy.org/doc/)

* [Pandas](http://pandas.pydata.org/pandas-docs/stable/)

* [Seaborn](https://seaborn.pydata.org/api.html)
## Authors

* **Felix L. Rios** just send me an e-mail in case of any questions, felix.leopoldo.rios at gmail com 

## References
* [J. Olsson, T. Pavlenko, and F. L. Rios. Bayesian learning of weakly structural Markov graph laws using sequential Monte Carlo methods. *Electron. J. Statist.*, 13(2):2865–2897, 2019.](https://projecteuclid.org/euclid.ejs/1567065622)
* [J. Olsson, T. Pavlenko, F. L. Rios, Sequential sampling of junction trees for decomposable graphs,
 ArXiv, 2018](https://arxiv.org/abs/1806.00584)
* [T. Pavlenko, F. L. Rios, Graphical posterior predictive classifier: Bayesian model averaging with particle Gibbs, ArXiv 2018](https://arxiv.org/abs/1707.06792)

## License

This project is licensed under the Apache 2.0 License - see the [LICENSE](LICENSE) file for details

## Acknowledgments

* **Jim Holmstrom**
