# MIT LICENSE
#
# Copyright 1997 - 2020 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
import sys
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files

if sys.version_info >= (3, 5):
    from typing import List, Any, Union


class DynamicFrameSize(Base):
    """This object fetches the options for setting dynamic frame size.
    The DynamicFrameSize class encapsulates a list of dynamicFrameSize resources that are managed by the system.
    A list of resources can be retrieved from the server using the DynamicFrameSize.find() method.
    """

    __slots__ = ()
    _SDM_NAME = "dynamicFrameSize"
    _SDM_ATT_MAP = {
        "FixedSize": "fixedSize",
        "HighLevelStreamName": "highLevelStreamName",
        "RandomMax": "randomMax",
        "RandomMin": "randomMin",
        "TrafficItemName": "trafficItemName",
        "Type": "type",
    }
    _SDM_ENUM_MAP = {
        "type": ["fixed", "random"],
    }

    def __init__(self, parent, list_op=False):
        super(DynamicFrameSize, self).__init__(parent, list_op)

    @property
    def FixedSize(self):
        # type: () -> int
        """
        Returns
        -------
        - number: Sets all frames to a specified constant size. The default is 64 bytes.
        """
        return self._get_attribute(self._SDM_ATT_MAP["FixedSize"])

    @FixedSize.setter
    def FixedSize(self, value):
        # type: (int) -> None
        self._set_attribute(self._SDM_ATT_MAP["FixedSize"], value)

    @property
    def HighLevelStreamName(self):
        # type: () -> str
        """
        Returns
        -------
        - str: The name of the high level stream.
        """
        return self._get_attribute(self._SDM_ATT_MAP["HighLevelStreamName"])

    @property
    def RandomMax(self):
        # type: () -> int
        """
        Returns
        -------
        - number: Sets frame size to maximum length in bytes. The maximum length is 65536 bytes.
        """
        return self._get_attribute(self._SDM_ATT_MAP["RandomMax"])

    @RandomMax.setter
    def RandomMax(self, value):
        # type: (int) -> None
        self._set_attribute(self._SDM_ATT_MAP["RandomMax"], value)

    @property
    def RandomMin(self):
        # type: () -> int
        """
        Returns
        -------
        - number: Sets frame size to minimum length in bytes. The minimum length is 12 bytes.
        """
        return self._get_attribute(self._SDM_ATT_MAP["RandomMin"])

    @RandomMin.setter
    def RandomMin(self, value):
        # type: (int) -> None
        self._set_attribute(self._SDM_ATT_MAP["RandomMin"], value)

    @property
    def TrafficItemName(self):
        # type: () -> str
        """
        Returns
        -------
        - str: The name of the parent traffic item.
        """
        return self._get_attribute(self._SDM_ATT_MAP["TrafficItemName"])

    @property
    def Type(self):
        # type: () -> str
        """
        Returns
        -------
        - str(fixed | random): Sets the frame size type to either fixed or random lengths in bytes.
        """
        return self._get_attribute(self._SDM_ATT_MAP["Type"])

    @Type.setter
    def Type(self, value):
        # type: (str) -> None
        self._set_attribute(self._SDM_ATT_MAP["Type"], value)

    def update(self, FixedSize=None, RandomMax=None, RandomMin=None, Type=None):
        # type: (int, int, int, str) -> DynamicFrameSize
        """Updates dynamicFrameSize resource on the server.

        Args
        ----
        - FixedSize (number): Sets all frames to a specified constant size. The default is 64 bytes.
        - RandomMax (number): Sets frame size to maximum length in bytes. The maximum length is 65536 bytes.
        - RandomMin (number): Sets frame size to minimum length in bytes. The minimum length is 12 bytes.
        - Type (str(fixed | random)): Sets the frame size type to either fixed or random lengths in bytes.

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(self._map_locals(self._SDM_ATT_MAP, locals()))

    def add(self, FixedSize=None, RandomMax=None, RandomMin=None, Type=None):
        # type: (int, int, int, str) -> DynamicFrameSize
        """Adds a new dynamicFrameSize resource on the json, only valid with batch add utility

        Args
        ----
        - FixedSize (number): Sets all frames to a specified constant size. The default is 64 bytes.
        - RandomMax (number): Sets frame size to maximum length in bytes. The maximum length is 65536 bytes.
        - RandomMin (number): Sets frame size to minimum length in bytes. The minimum length is 12 bytes.
        - Type (str(fixed | random)): Sets the frame size type to either fixed or random lengths in bytes.

        Returns
        -------
        - self: This instance with all currently retrieved dynamicFrameSize resources using find and the newly added dynamicFrameSize resources available through an iterator or index

        Raises
        ------
        - Exception: if this function is not being used with config assistance
        """
        return self._add_xpath(self._map_locals(self._SDM_ATT_MAP, locals()))

    def find(
        self,
        FixedSize=None,
        HighLevelStreamName=None,
        RandomMax=None,
        RandomMin=None,
        TrafficItemName=None,
        Type=None,
    ):
        # type: (int, str, int, int, str, str) -> DynamicFrameSize
        """Finds and retrieves dynamicFrameSize resources from the server.

        All named parameters are evaluated on the server using regex. The named parameters can be used to selectively retrieve dynamicFrameSize resources from the server.
        To retrieve an exact match ensure the parameter value starts with ^ and ends with $
        By default the find method takes no parameters and will retrieve all dynamicFrameSize resources from the server.

        Args
        ----
        - FixedSize (number): Sets all frames to a specified constant size. The default is 64 bytes.
        - HighLevelStreamName (str): The name of the high level stream.
        - RandomMax (number): Sets frame size to maximum length in bytes. The maximum length is 65536 bytes.
        - RandomMin (number): Sets frame size to minimum length in bytes. The minimum length is 12 bytes.
        - TrafficItemName (str): The name of the parent traffic item.
        - Type (str(fixed | random)): Sets the frame size type to either fixed or random lengths in bytes.

        Returns
        -------
        - self: This instance with matching dynamicFrameSize resources retrieved from the server available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(self._map_locals(self._SDM_ATT_MAP, locals()))

    def read(self, href):
        """Retrieves a single instance of dynamicFrameSize data from the server.

        Args
        ----
        - href (str): An href to the instance to be retrieved

        Returns
        -------
        - self: This instance with the dynamicFrameSize resources from the server available through an iterator or index

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
