# Welcome to the pysan library
> Sequence analysis in Python


```python
from nbdev.showdoc import *
```


[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/pysan-dev/pysan/CI?logo=github&style=for-the-badge&e)](https://github.com/pysan-dev/pysan/actions)
[![PyPI](https://img.shields.io/pypi/v/pysan?style=for-the-badge&color=blue)](https://pypi.org/project/PySAN/)
[![Commit](https://img.shields.io/github/last-commit/pysan-dev/pysan?label=Last%20update&style=for-the-badge&)](https://github.com/pysan-dev/pysan/commit/master)

The pysan library is a collection of methods for doing sequence analysis. It's free, open source, and each method is fully documented with examples. Using pysan you'll be able to run powerful sequence analysis and visualisation tasks with just a few lines of code, and integrate or extend them into your other Python workflows.

The pysan library is specifically for sequence analysis in the social sciences, which concerns the order in which people do things (like communicate), but can be applied to broader sequence analysis problems that are framed in the sequence domain. To find out more, get started by installing the library using the commands below, and read through the rest of this site.

## Install

Install pysan using the following pip command;

`pip install pysan`

You can also use the very latest version by cloning the github repository.

`git clone https://github.com/pysan-dev/pysan.git`

## Why use pysan?

Lots of events in the natural world happen in a particular order, from making a cup of tea, to getting promotions, and so on.
In science, this applies to everything from communication data, to consumer spending, and to gambling behaviour.
Analysing these events whilst preserving their sequential order requires analysis in the sequence domain.
The pysan library contains methods for visualising, comparing, and dissecting sequences, helping you develop insights into your sequences with only a few lines of code.

**Why Python?** - Python is quickly becoming *the* go-to language for data analysis across a number of research areas.
By writing a sequence analysis library in Python, analysts can take advantage of other tools written in Python, whilst writing simple and readable code.

