# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class SavedSearch(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_epoch_millis': 'int',
        'creator_id': 'str',
        'entity_type': 'str',
        'id': 'str',
        'query': 'dict(str, str)',
        'updated_epoch_millis': 'int',
        'updater_id': 'str',
        'user_id': 'str'
    }

    attribute_map = {
        'created_epoch_millis': 'createdEpochMillis',
        'creator_id': 'creatorId',
        'entity_type': 'entityType',
        'id': 'id',
        'query': 'query',
        'updated_epoch_millis': 'updatedEpochMillis',
        'updater_id': 'updaterId',
        'user_id': 'userId'
    }

    def __init__(self, created_epoch_millis=None, creator_id=None, entity_type=None, id=None, query=None, updated_epoch_millis=None, updater_id=None, user_id=None, _configuration=None):  # noqa: E501
        """SavedSearch - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._created_epoch_millis = None
        self._creator_id = None
        self._entity_type = None
        self._id = None
        self._query = None
        self._updated_epoch_millis = None
        self._updater_id = None
        self._user_id = None
        self.discriminator = None

        if created_epoch_millis is not None:
            self.created_epoch_millis = created_epoch_millis
        if creator_id is not None:
            self.creator_id = creator_id
        self.entity_type = entity_type
        if id is not None:
            self.id = id
        self.query = query
        if updated_epoch_millis is not None:
            self.updated_epoch_millis = updated_epoch_millis
        if updater_id is not None:
            self.updater_id = updater_id
        if user_id is not None:
            self.user_id = user_id

    @property
    def created_epoch_millis(self):
        """Gets the created_epoch_millis of this SavedSearch.  # noqa: E501


        :return: The created_epoch_millis of this SavedSearch.  # noqa: E501
        :rtype: int
        """
        return self._created_epoch_millis

    @created_epoch_millis.setter
    def created_epoch_millis(self, created_epoch_millis):
        """Sets the created_epoch_millis of this SavedSearch.


        :param created_epoch_millis: The created_epoch_millis of this SavedSearch.  # noqa: E501
        :type: int
        """

        self._created_epoch_millis = created_epoch_millis

    @property
    def creator_id(self):
        """Gets the creator_id of this SavedSearch.  # noqa: E501


        :return: The creator_id of this SavedSearch.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this SavedSearch.


        :param creator_id: The creator_id of this SavedSearch.  # noqa: E501
        :type: str
        """

        self._creator_id = creator_id

    @property
    def entity_type(self):
        """Gets the entity_type of this SavedSearch.  # noqa: E501

        The Wavefront entity type over which to search  # noqa: E501

        :return: The entity_type of this SavedSearch.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this SavedSearch.

        The Wavefront entity type over which to search  # noqa: E501

        :param entity_type: The entity_type of this SavedSearch.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and entity_type is None:
            raise ValueError("Invalid value for `entity_type`, must not be `None`")  # noqa: E501
        allowed_values = ["DASHBOARD", "ALERT", "MAINTENANCE_WINDOW", "NOTIFICANT", "EVENT", "SOURCE", "EXTERNAL_LINK", "AGENT", "CLOUD_INTEGRATION", "APPLICATION", "REGISTERED_QUERY", "USER", "USER_GROUP", "SERVICE_ACCOUNT", "INGESTION_POLICY", "ROLE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                entity_type not in allowed_values):
            raise ValueError(
                "Invalid value for `entity_type` ({0}), must be one of {1}"  # noqa: E501
                .format(entity_type, allowed_values)
            )

        self._entity_type = entity_type

    @property
    def id(self):
        """Gets the id of this SavedSearch.  # noqa: E501


        :return: The id of this SavedSearch.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SavedSearch.


        :param id: The id of this SavedSearch.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def query(self):
        """Gets the query of this SavedSearch.  # noqa: E501

        The map corresponding to the search query.  The key is the name of the query, and the value is a JSON representation of the query  # noqa: E501

        :return: The query of this SavedSearch.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this SavedSearch.

        The map corresponding to the search query.  The key is the name of the query, and the value is a JSON representation of the query  # noqa: E501

        :param query: The query of this SavedSearch.  # noqa: E501
        :type: dict(str, str)
        """
        if self._configuration.client_side_validation and query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")  # noqa: E501

        self._query = query

    @property
    def updated_epoch_millis(self):
        """Gets the updated_epoch_millis of this SavedSearch.  # noqa: E501


        :return: The updated_epoch_millis of this SavedSearch.  # noqa: E501
        :rtype: int
        """
        return self._updated_epoch_millis

    @updated_epoch_millis.setter
    def updated_epoch_millis(self, updated_epoch_millis):
        """Sets the updated_epoch_millis of this SavedSearch.


        :param updated_epoch_millis: The updated_epoch_millis of this SavedSearch.  # noqa: E501
        :type: int
        """

        self._updated_epoch_millis = updated_epoch_millis

    @property
    def updater_id(self):
        """Gets the updater_id of this SavedSearch.  # noqa: E501


        :return: The updater_id of this SavedSearch.  # noqa: E501
        :rtype: str
        """
        return self._updater_id

    @updater_id.setter
    def updater_id(self, updater_id):
        """Sets the updater_id of this SavedSearch.


        :param updater_id: The updater_id of this SavedSearch.  # noqa: E501
        :type: str
        """

        self._updater_id = updater_id

    @property
    def user_id(self):
        """Gets the user_id of this SavedSearch.  # noqa: E501

        The user for whom this search is saved  # noqa: E501

        :return: The user_id of this SavedSearch.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this SavedSearch.

        The user for whom this search is saved  # noqa: E501

        :param user_id: The user_id of this SavedSearch.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SavedSearch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SavedSearch):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SavedSearch):
            return True

        return self.to_dict() != other.to_dict()
