# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class IngestionPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'customer': 'str',
        'description': 'str',
        'id': 'str',
        'last_updated_account_id': 'str',
        'last_updated_ms': 'int',
        'name': 'str',
        'sampled_service_accounts': 'list[str]',
        'sampled_user_accounts': 'list[str]',
        'service_account_count': 'int',
        'user_account_count': 'int'
    }

    attribute_map = {
        'customer': 'customer',
        'description': 'description',
        'id': 'id',
        'last_updated_account_id': 'lastUpdatedAccountId',
        'last_updated_ms': 'lastUpdatedMs',
        'name': 'name',
        'sampled_service_accounts': 'sampledServiceAccounts',
        'sampled_user_accounts': 'sampledUserAccounts',
        'service_account_count': 'serviceAccountCount',
        'user_account_count': 'userAccountCount'
    }

    def __init__(self, customer=None, description=None, id=None, last_updated_account_id=None, last_updated_ms=None, name=None, sampled_service_accounts=None, sampled_user_accounts=None, service_account_count=None, user_account_count=None, _configuration=None):  # noqa: E501
        """IngestionPolicy - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._customer = None
        self._description = None
        self._id = None
        self._last_updated_account_id = None
        self._last_updated_ms = None
        self._name = None
        self._sampled_service_accounts = None
        self._sampled_user_accounts = None
        self._service_account_count = None
        self._user_account_count = None
        self.discriminator = None

        if customer is not None:
            self.customer = customer
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if last_updated_account_id is not None:
            self.last_updated_account_id = last_updated_account_id
        if last_updated_ms is not None:
            self.last_updated_ms = last_updated_ms
        if name is not None:
            self.name = name
        if sampled_service_accounts is not None:
            self.sampled_service_accounts = sampled_service_accounts
        if sampled_user_accounts is not None:
            self.sampled_user_accounts = sampled_user_accounts
        if service_account_count is not None:
            self.service_account_count = service_account_count
        if user_account_count is not None:
            self.user_account_count = user_account_count

    @property
    def customer(self):
        """Gets the customer of this IngestionPolicy.  # noqa: E501

        ID of the customer to which the ingestion policy belongs  # noqa: E501

        :return: The customer of this IngestionPolicy.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this IngestionPolicy.

        ID of the customer to which the ingestion policy belongs  # noqa: E501

        :param customer: The customer of this IngestionPolicy.  # noqa: E501
        :type: str
        """

        self._customer = customer

    @property
    def description(self):
        """Gets the description of this IngestionPolicy.  # noqa: E501

        The description of the ingestion policy  # noqa: E501

        :return: The description of this IngestionPolicy.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this IngestionPolicy.

        The description of the ingestion policy  # noqa: E501

        :param description: The description of this IngestionPolicy.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this IngestionPolicy.  # noqa: E501

        The unique ID for the ingestion policy  # noqa: E501

        :return: The id of this IngestionPolicy.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this IngestionPolicy.

        The unique ID for the ingestion policy  # noqa: E501

        :param id: The id of this IngestionPolicy.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def last_updated_account_id(self):
        """Gets the last_updated_account_id of this IngestionPolicy.  # noqa: E501

        The account that updated this ingestion policy last time  # noqa: E501

        :return: The last_updated_account_id of this IngestionPolicy.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_account_id

    @last_updated_account_id.setter
    def last_updated_account_id(self, last_updated_account_id):
        """Sets the last_updated_account_id of this IngestionPolicy.

        The account that updated this ingestion policy last time  # noqa: E501

        :param last_updated_account_id: The last_updated_account_id of this IngestionPolicy.  # noqa: E501
        :type: str
        """

        self._last_updated_account_id = last_updated_account_id

    @property
    def last_updated_ms(self):
        """Gets the last_updated_ms of this IngestionPolicy.  # noqa: E501

        The last time when the ingestion policy is updated, in epoch milliseconds  # noqa: E501

        :return: The last_updated_ms of this IngestionPolicy.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_ms

    @last_updated_ms.setter
    def last_updated_ms(self, last_updated_ms):
        """Sets the last_updated_ms of this IngestionPolicy.

        The last time when the ingestion policy is updated, in epoch milliseconds  # noqa: E501

        :param last_updated_ms: The last_updated_ms of this IngestionPolicy.  # noqa: E501
        :type: int
        """

        self._last_updated_ms = last_updated_ms

    @property
    def name(self):
        """Gets the name of this IngestionPolicy.  # noqa: E501

        The name of the ingestion policy  # noqa: E501

        :return: The name of this IngestionPolicy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IngestionPolicy.

        The name of the ingestion policy  # noqa: E501

        :param name: The name of this IngestionPolicy.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def sampled_service_accounts(self):
        """Gets the sampled_service_accounts of this IngestionPolicy.  # noqa: E501

        A sample of the service accounts accounts assigned to this ingestion policy. Please use the Ingestion Policy facet of the Account Search API to get the full list of service accounts for this policy  # noqa: E501

        :return: The sampled_service_accounts of this IngestionPolicy.  # noqa: E501
        :rtype: list[str]
        """
        return self._sampled_service_accounts

    @sampled_service_accounts.setter
    def sampled_service_accounts(self, sampled_service_accounts):
        """Sets the sampled_service_accounts of this IngestionPolicy.

        A sample of the service accounts accounts assigned to this ingestion policy. Please use the Ingestion Policy facet of the Account Search API to get the full list of service accounts for this policy  # noqa: E501

        :param sampled_service_accounts: The sampled_service_accounts of this IngestionPolicy.  # noqa: E501
        :type: list[str]
        """

        self._sampled_service_accounts = sampled_service_accounts

    @property
    def sampled_user_accounts(self):
        """Gets the sampled_user_accounts of this IngestionPolicy.  # noqa: E501

        A sample of the user accounts assigned to this ingestion policy. Please use the Ingestion Policy facet of the Account Search API to get the full list of users for this policy  # noqa: E501

        :return: The sampled_user_accounts of this IngestionPolicy.  # noqa: E501
        :rtype: list[str]
        """
        return self._sampled_user_accounts

    @sampled_user_accounts.setter
    def sampled_user_accounts(self, sampled_user_accounts):
        """Sets the sampled_user_accounts of this IngestionPolicy.

        A sample of the user accounts assigned to this ingestion policy. Please use the Ingestion Policy facet of the Account Search API to get the full list of users for this policy  # noqa: E501

        :param sampled_user_accounts: The sampled_user_accounts of this IngestionPolicy.  # noqa: E501
        :type: list[str]
        """

        self._sampled_user_accounts = sampled_user_accounts

    @property
    def service_account_count(self):
        """Gets the service_account_count of this IngestionPolicy.  # noqa: E501

        Total number of service accounts that are linked to the ingestion policy  # noqa: E501

        :return: The service_account_count of this IngestionPolicy.  # noqa: E501
        :rtype: int
        """
        return self._service_account_count

    @service_account_count.setter
    def service_account_count(self, service_account_count):
        """Sets the service_account_count of this IngestionPolicy.

        Total number of service accounts that are linked to the ingestion policy  # noqa: E501

        :param service_account_count: The service_account_count of this IngestionPolicy.  # noqa: E501
        :type: int
        """

        self._service_account_count = service_account_count

    @property
    def user_account_count(self):
        """Gets the user_account_count of this IngestionPolicy.  # noqa: E501

        Total number of user accounts that are linked to the ingestion policy  # noqa: E501

        :return: The user_account_count of this IngestionPolicy.  # noqa: E501
        :rtype: int
        """
        return self._user_account_count

    @user_account_count.setter
    def user_account_count(self, user_account_count):
        """Sets the user_account_count of this IngestionPolicy.

        Total number of user accounts that are linked to the ingestion policy  # noqa: E501

        :param user_account_count: The user_account_count of this IngestionPolicy.  # noqa: E501
        :type: int
        """

        self._user_account_count = user_account_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IngestionPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IngestionPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IngestionPolicy):
            return True

        return self.to_dict() != other.to_dict()
