# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class FacetsResponseContainer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'facets': 'dict(str, list[str])',
        'limit': 'int'
    }

    attribute_map = {
        'facets': 'facets',
        'limit': 'limit'
    }

    def __init__(self, facets=None, limit=None, _configuration=None):  # noqa: E501
        """FacetsResponseContainer - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._facets = None
        self._limit = None
        self.discriminator = None

        if facets is not None:
            self.facets = facets
        if limit is not None:
            self.limit = limit

    @property
    def facets(self):
        """Gets the facets of this FacetsResponseContainer.  # noqa: E501

        The requested facets, returned in a map whose key is the facet property and whose value is a list of facet values  # noqa: E501

        :return: The facets of this FacetsResponseContainer.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._facets

    @facets.setter
    def facets(self, facets):
        """Sets the facets of this FacetsResponseContainer.

        The requested facets, returned in a map whose key is the facet property and whose value is a list of facet values  # noqa: E501

        :param facets: The facets of this FacetsResponseContainer.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._facets = facets

    @property
    def limit(self):
        """Gets the limit of this FacetsResponseContainer.  # noqa: E501

        The requested limit  # noqa: E501

        :return: The limit of this FacetsResponseContainer.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this FacetsResponseContainer.

        The requested limit  # noqa: E501

        :param limit: The limit of this FacetsResponseContainer.  # noqa: E501
        :type: int
        """

        self._limit = limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FacetsResponseContainer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FacetsResponseContainer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FacetsResponseContainer):
            return True

        return self.to_dict() != other.to_dict()
