# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class AccessPolicyRuleDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'description': 'str',
        'name': 'str',
        'subnet': 'str'
    }

    attribute_map = {
        'action': 'action',
        'description': 'description',
        'name': 'name',
        'subnet': 'subnet'
    }

    def __init__(self, action=None, description=None, name=None, subnet=None, _configuration=None):  # noqa: E501
        """AccessPolicyRuleDTO - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._action = None
        self._description = None
        self._name = None
        self._subnet = None
        self.discriminator = None

        if action is not None:
            self.action = action
        if description is not None:
            self.description = description
        if name is not None:
            self.name = name
        if subnet is not None:
            self.subnet = subnet

    @property
    def action(self):
        """Gets the action of this AccessPolicyRuleDTO.  # noqa: E501


        :return: The action of this AccessPolicyRuleDTO.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this AccessPolicyRuleDTO.


        :param action: The action of this AccessPolicyRuleDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["ALLOW", "DENY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                action not in allowed_values):
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def description(self):
        """Gets the description of this AccessPolicyRuleDTO.  # noqa: E501


        :return: The description of this AccessPolicyRuleDTO.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AccessPolicyRuleDTO.


        :param description: The description of this AccessPolicyRuleDTO.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this AccessPolicyRuleDTO.  # noqa: E501


        :return: The name of this AccessPolicyRuleDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AccessPolicyRuleDTO.


        :param name: The name of this AccessPolicyRuleDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def subnet(self):
        """Gets the subnet of this AccessPolicyRuleDTO.  # noqa: E501


        :return: The subnet of this AccessPolicyRuleDTO.  # noqa: E501
        :rtype: str
        """
        return self._subnet

    @subnet.setter
    def subnet(self, subnet):
        """Sets the subnet of this AccessPolicyRuleDTO.


        :param subnet: The subnet of this AccessPolicyRuleDTO.  # noqa: E501
        :type: str
        """

        self._subnet = subnet

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccessPolicyRuleDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessPolicyRuleDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccessPolicyRuleDTO):
            return True

        return self.to_dict() != other.to_dict()
