# wavefront-api-client
<p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v2
- Package version: 2.95.2
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/wavefrontHQ/python-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/wavefrontHQ/python-client.git`)

Then import the package:
```python
import wavefront_api_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wavefront_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import wavefront_api_client
from wavefront_api_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: api_key
configuration = wavefront_api_client.Configuration()
configuration.api_key['X-AUTH-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = wavefront_api_client.AccessPolicyApi(wavefront_api_client.ApiClient(configuration))

try:
    # Get the access policy
    api_response = api_instance.get_access_policy()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccessPolicyApi->get_access_policy: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessPolicyApi* | [**get_access_policy**](docs/AccessPolicyApi.md#get_access_policy) | **GET** /api/v2/accesspolicy | Get the access policy
*AccessPolicyApi* | [**update_access_policy**](docs/AccessPolicyApi.md#update_access_policy) | **PUT** /api/v2/accesspolicy | Update the access policy
*AccessPolicyApi* | [**validate_url**](docs/AccessPolicyApi.md#validate_url) | **GET** /api/v2/accesspolicy/validate | Validate a given url and ip address
*AccountUserAndServiceAccountApi* | [**activate_account**](docs/AccountUserAndServiceAccountApi.md#activate_account) | **POST** /api/v2/account/serviceaccount/{id}/activate | Activates the given service account
*AccountUserAndServiceAccountApi* | [**add_account_to_roles**](docs/AccountUserAndServiceAccountApi.md#add_account_to_roles) | **POST** /api/v2/account/{id}/addRoles | Adds specific roles to the account (user or service account)
*AccountUserAndServiceAccountApi* | [**add_account_to_user_groups**](docs/AccountUserAndServiceAccountApi.md#add_account_to_user_groups) | **POST** /api/v2/account/{id}/addUserGroups | Adds specific user groups to the account (user or service account)
*AccountUserAndServiceAccountApi* | [**add_ingestion_policy**](docs/AccountUserAndServiceAccountApi.md#add_ingestion_policy) | **POST** /api/v2/account/addingestionpolicy | Add a specific ingestion policy to multiple accounts
*AccountUserAndServiceAccountApi* | [**create_or_update_user_account**](docs/AccountUserAndServiceAccountApi.md#create_or_update_user_account) | **POST** /api/v2/account/user | Creates or updates a user account
*AccountUserAndServiceAccountApi* | [**create_service_account**](docs/AccountUserAndServiceAccountApi.md#create_service_account) | **POST** /api/v2/account/serviceaccount | Creates a service account
*AccountUserAndServiceAccountApi* | [**deactivate_account**](docs/AccountUserAndServiceAccountApi.md#deactivate_account) | **POST** /api/v2/account/serviceaccount/{id}/deactivate | Deactivates the given service account
*AccountUserAndServiceAccountApi* | [**delete_account**](docs/AccountUserAndServiceAccountApi.md#delete_account) | **DELETE** /api/v2/account/{id} | Deletes an account (user or service account) identified by id
*AccountUserAndServiceAccountApi* | [**delete_multiple_accounts**](docs/AccountUserAndServiceAccountApi.md#delete_multiple_accounts) | **POST** /api/v2/account/deleteAccounts | Deletes multiple accounts (users or service accounts)
*AccountUserAndServiceAccountApi* | [**get_account**](docs/AccountUserAndServiceAccountApi.md#get_account) | **GET** /api/v2/account/{id} | Get a specific account (user or service account)
*AccountUserAndServiceAccountApi* | [**get_account_business_functions**](docs/AccountUserAndServiceAccountApi.md#get_account_business_functions) | **GET** /api/v2/account/{id}/businessFunctions | Returns business functions of a specific account (user or service account).
*AccountUserAndServiceAccountApi* | [**get_all_accounts**](docs/AccountUserAndServiceAccountApi.md#get_all_accounts) | **GET** /api/v2/account | Get all accounts (users and service accounts) of a customer
*AccountUserAndServiceAccountApi* | [**get_all_service_accounts**](docs/AccountUserAndServiceAccountApi.md#get_all_service_accounts) | **GET** /api/v2/account/serviceaccount | Get all service accounts
*AccountUserAndServiceAccountApi* | [**get_all_user_accounts**](docs/AccountUserAndServiceAccountApi.md#get_all_user_accounts) | **GET** /api/v2/account/user | Get all user accounts
*AccountUserAndServiceAccountApi* | [**get_service_account**](docs/AccountUserAndServiceAccountApi.md#get_service_account) | **GET** /api/v2/account/serviceaccount/{id} | Retrieves a service account by identifier
*AccountUserAndServiceAccountApi* | [**get_user_account**](docs/AccountUserAndServiceAccountApi.md#get_user_account) | **GET** /api/v2/account/user/{id} | Retrieves a user by identifier (email address)
*AccountUserAndServiceAccountApi* | [**grant_account_permission**](docs/AccountUserAndServiceAccountApi.md#grant_account_permission) | **POST** /api/v2/account/{id}/grant/{permission} | Grants a specific permission to account (user or service account)
*AccountUserAndServiceAccountApi* | [**grant_permission_to_accounts**](docs/AccountUserAndServiceAccountApi.md#grant_permission_to_accounts) | **POST** /api/v2/account/grant/{permission} | Grants a specific permission to multiple accounts (users or service accounts)
*AccountUserAndServiceAccountApi* | [**invite_user_accounts**](docs/AccountUserAndServiceAccountApi.md#invite_user_accounts) | **POST** /api/v2/account/user/invite | Invite user accounts with given user groups and permissions.
*AccountUserAndServiceAccountApi* | [**remove_account_from_roles**](docs/AccountUserAndServiceAccountApi.md#remove_account_from_roles) | **POST** /api/v2/account/{id}/removeRoles | Removes specific roles from the account (user or service account)
*AccountUserAndServiceAccountApi* | [**remove_account_from_user_groups**](docs/AccountUserAndServiceAccountApi.md#remove_account_from_user_groups) | **POST** /api/v2/account/{id}/removeUserGroups | Removes specific user groups from the account (user or service account)
*AccountUserAndServiceAccountApi* | [**remove_ingestion_policies**](docs/AccountUserAndServiceAccountApi.md#remove_ingestion_policies) | **POST** /api/v2/account/removeingestionpolicies | Removes ingestion policies from multiple accounts
*AccountUserAndServiceAccountApi* | [**revoke_account_permission**](docs/AccountUserAndServiceAccountApi.md#revoke_account_permission) | **POST** /api/v2/account/{id}/revoke/{permission} | Revokes a specific permission from account (user or service account)
*AccountUserAndServiceAccountApi* | [**revoke_permission_from_accounts**](docs/AccountUserAndServiceAccountApi.md#revoke_permission_from_accounts) | **POST** /api/v2/account/revoke/{permission} | Revokes a specific permission from multiple accounts (users or service accounts)
*AccountUserAndServiceAccountApi* | [**update_service_account**](docs/AccountUserAndServiceAccountApi.md#update_service_account) | **PUT** /api/v2/account/serviceaccount/{id} | Updates the service account
*AccountUserAndServiceAccountApi* | [**update_user_account**](docs/AccountUserAndServiceAccountApi.md#update_user_account) | **PUT** /api/v2/account/user/{id} | Update user with given user groups, permissions and ingestion policy.
*AccountUserAndServiceAccountApi* | [**validate_accounts**](docs/AccountUserAndServiceAccountApi.md#validate_accounts) | **POST** /api/v2/account/validateAccounts | Returns valid accounts (users and service accounts), also invalid identifiers from the given list
*AlertApi* | [**add_alert_access**](docs/AlertApi.md#add_alert_access) | **POST** /api/v2/alert/acl/add | Adds the specified ids to the given alerts&#39; ACL
*AlertApi* | [**add_alert_tag**](docs/AlertApi.md#add_alert_tag) | **PUT** /api/v2/alert/{id}/tag/{tagValue} | Add a tag to a specific alert
*AlertApi* | [**check_query_type**](docs/AlertApi.md#check_query_type) | **POST** /api/v2/alert/checkQuery | Return the type of provided query.
*AlertApi* | [**clone_alert**](docs/AlertApi.md#clone_alert) | **POST** /api/v2/alert/{id}/clone | Clones the specified alert
*AlertApi* | [**create_alert**](docs/AlertApi.md#create_alert) | **POST** /api/v2/alert | Create a specific alert
*AlertApi* | [**delete_alert**](docs/AlertApi.md#delete_alert) | **DELETE** /api/v2/alert/{id} | Delete a specific alert
*AlertApi* | [**get_alert**](docs/AlertApi.md#get_alert) | **GET** /api/v2/alert/{id} | Get a specific alert
*AlertApi* | [**get_alert_access_control_list**](docs/AlertApi.md#get_alert_access_control_list) | **GET** /api/v2/alert/acl | Get Access Control Lists&#39; union for the specified alerts
*AlertApi* | [**get_alert_history**](docs/AlertApi.md#get_alert_history) | **GET** /api/v2/alert/{id}/history | Get the version history of a specific alert
*AlertApi* | [**get_alert_tags**](docs/AlertApi.md#get_alert_tags) | **GET** /api/v2/alert/{id}/tag | Get all tags associated with a specific alert
*AlertApi* | [**get_alert_version**](docs/AlertApi.md#get_alert_version) | **GET** /api/v2/alert/{id}/history/{version} | Get a specific historical version of a specific alert
*AlertApi* | [**get_alerts_summary**](docs/AlertApi.md#get_alerts_summary) | **GET** /api/v2/alert/summary | Count alerts of various statuses for a customer
*AlertApi* | [**get_all_alert**](docs/AlertApi.md#get_all_alert) | **GET** /api/v2/alert | Get all alerts for a customer
*AlertApi* | [**hide_alert**](docs/AlertApi.md#hide_alert) | **POST** /api/v2/alert/{id}/uninstall | Hide a specific integration alert 
*AlertApi* | [**remove_alert_access**](docs/AlertApi.md#remove_alert_access) | **POST** /api/v2/alert/acl/remove | Removes the specified ids from the given alerts&#39; ACL
*AlertApi* | [**remove_alert_tag**](docs/AlertApi.md#remove_alert_tag) | **DELETE** /api/v2/alert/{id}/tag/{tagValue} | Remove a tag from a specific alert
*AlertApi* | [**set_alert_acl**](docs/AlertApi.md#set_alert_acl) | **PUT** /api/v2/alert/acl/set | Set ACL for the specified alerts
*AlertApi* | [**set_alert_tags**](docs/AlertApi.md#set_alert_tags) | **POST** /api/v2/alert/{id}/tag | Set all tags associated with a specific alert
*AlertApi* | [**snooze_alert**](docs/AlertApi.md#snooze_alert) | **POST** /api/v2/alert/{id}/snooze | Snooze a specific alert for some number of seconds
*AlertApi* | [**undelete_alert**](docs/AlertApi.md#undelete_alert) | **POST** /api/v2/alert/{id}/undelete | Undelete a specific alert
*AlertApi* | [**unhide_alert**](docs/AlertApi.md#unhide_alert) | **POST** /api/v2/alert/{id}/install | Unhide a specific integration alert
*AlertApi* | [**unsnooze_alert**](docs/AlertApi.md#unsnooze_alert) | **POST** /api/v2/alert/{id}/unsnooze | Unsnooze a specific alert
*AlertApi* | [**update_alert**](docs/AlertApi.md#update_alert) | **PUT** /api/v2/alert/{id} | Update a specific alert
*ApiTokenApi* | [**create_token**](docs/ApiTokenApi.md#create_token) | **POST** /api/v2/apitoken | Create new api token
*ApiTokenApi* | [**delete_token**](docs/ApiTokenApi.md#delete_token) | **DELETE** /api/v2/apitoken/{id} | Delete the specified api token
*ApiTokenApi* | [**delete_token_service_account**](docs/ApiTokenApi.md#delete_token_service_account) | **DELETE** /api/v2/apitoken/serviceaccount/{id}/{token} | Delete the specified api token of the given service account
*ApiTokenApi* | [**generate_token_service_account**](docs/ApiTokenApi.md#generate_token_service_account) | **POST** /api/v2/apitoken/serviceaccount/{id} | Create a new api token for the service account
*ApiTokenApi* | [**get_all_tokens**](docs/ApiTokenApi.md#get_all_tokens) | **GET** /api/v2/apitoken | Get all api tokens for a user
*ApiTokenApi* | [**get_tokens_service_account**](docs/ApiTokenApi.md#get_tokens_service_account) | **GET** /api/v2/apitoken/serviceaccount/{id} | Get all api tokens for the given service account
*ApiTokenApi* | [**update_token_name**](docs/ApiTokenApi.md#update_token_name) | **PUT** /api/v2/apitoken/{id} | Update the name of the specified api token
*ApiTokenApi* | [**update_token_name_service_account**](docs/ApiTokenApi.md#update_token_name_service_account) | **PUT** /api/v2/apitoken/serviceaccount/{id}/{token} | Update the name of the specified api token for the given service account
*CloudIntegrationApi* | [**create_aws_external_id**](docs/CloudIntegrationApi.md#create_aws_external_id) | **POST** /api/v2/cloudintegration/awsExternalId | Create an external id
*CloudIntegrationApi* | [**create_cloud_integration**](docs/CloudIntegrationApi.md#create_cloud_integration) | **POST** /api/v2/cloudintegration | Create a cloud integration
*CloudIntegrationApi* | [**delete_aws_external_id**](docs/CloudIntegrationApi.md#delete_aws_external_id) | **DELETE** /api/v2/cloudintegration/awsExternalId/{id} | DELETEs an external id that was created by Wavefront
*CloudIntegrationApi* | [**delete_cloud_integration**](docs/CloudIntegrationApi.md#delete_cloud_integration) | **DELETE** /api/v2/cloudintegration/{id} | Delete a specific cloud integration
*CloudIntegrationApi* | [**disable_cloud_integration**](docs/CloudIntegrationApi.md#disable_cloud_integration) | **POST** /api/v2/cloudintegration/{id}/disable | Disable a specific cloud integration
*CloudIntegrationApi* | [**enable_cloud_integration**](docs/CloudIntegrationApi.md#enable_cloud_integration) | **POST** /api/v2/cloudintegration/{id}/enable | Enable a specific cloud integration
*CloudIntegrationApi* | [**get_all_cloud_integration**](docs/CloudIntegrationApi.md#get_all_cloud_integration) | **GET** /api/v2/cloudintegration | Get all cloud integrations for a customer
*CloudIntegrationApi* | [**get_aws_external_id**](docs/CloudIntegrationApi.md#get_aws_external_id) | **GET** /api/v2/cloudintegration/awsExternalId/{id} | GETs (confirms) a valid external id that was created by Wavefront
*CloudIntegrationApi* | [**get_cloud_integration**](docs/CloudIntegrationApi.md#get_cloud_integration) | **GET** /api/v2/cloudintegration/{id} | Get a specific cloud integration
*CloudIntegrationApi* | [**undelete_cloud_integration**](docs/CloudIntegrationApi.md#undelete_cloud_integration) | **POST** /api/v2/cloudintegration/{id}/undelete | Undelete a specific cloud integration
*CloudIntegrationApi* | [**update_cloud_integration**](docs/CloudIntegrationApi.md#update_cloud_integration) | **PUT** /api/v2/cloudintegration/{id} | Update a specific cloud integration
*DashboardApi* | [**add_dashboard_access**](docs/DashboardApi.md#add_dashboard_access) | **POST** /api/v2/dashboard/acl/add | Adds the specified ids to the given dashboards&#39; ACL
*DashboardApi* | [**add_dashboard_tag**](docs/DashboardApi.md#add_dashboard_tag) | **PUT** /api/v2/dashboard/{id}/tag/{tagValue} | Add a tag to a specific dashboard
*DashboardApi* | [**create_dashboard**](docs/DashboardApi.md#create_dashboard) | **POST** /api/v2/dashboard | Create a specific dashboard
*DashboardApi* | [**delete_dashboard**](docs/DashboardApi.md#delete_dashboard) | **DELETE** /api/v2/dashboard/{id} | Delete a specific dashboard
*DashboardApi* | [**favorite_dashboard**](docs/DashboardApi.md#favorite_dashboard) | **POST** /api/v2/dashboard/{id}/favorite | Mark a dashboard as favorite
*DashboardApi* | [**get_all_dashboard**](docs/DashboardApi.md#get_all_dashboard) | **GET** /api/v2/dashboard | Get all dashboards for a customer
*DashboardApi* | [**get_dashboard**](docs/DashboardApi.md#get_dashboard) | **GET** /api/v2/dashboard/{id} | Get a specific dashboard
*DashboardApi* | [**get_dashboard_access_control_list**](docs/DashboardApi.md#get_dashboard_access_control_list) | **GET** /api/v2/dashboard/acl | Get list of Access Control Lists for the specified dashboards
*DashboardApi* | [**get_dashboard_history**](docs/DashboardApi.md#get_dashboard_history) | **GET** /api/v2/dashboard/{id}/history | Get the version history of a specific dashboard
*DashboardApi* | [**get_dashboard_tags**](docs/DashboardApi.md#get_dashboard_tags) | **GET** /api/v2/dashboard/{id}/tag | Get all tags associated with a specific dashboard
*DashboardApi* | [**get_dashboard_version**](docs/DashboardApi.md#get_dashboard_version) | **GET** /api/v2/dashboard/{id}/history/{version} | Get a specific version of a specific dashboard
*DashboardApi* | [**remove_dashboard_access**](docs/DashboardApi.md#remove_dashboard_access) | **POST** /api/v2/dashboard/acl/remove | Removes the specified ids from the given dashboards&#39; ACL
*DashboardApi* | [**remove_dashboard_tag**](docs/DashboardApi.md#remove_dashboard_tag) | **DELETE** /api/v2/dashboard/{id}/tag/{tagValue} | Remove a tag from a specific dashboard
*DashboardApi* | [**set_dashboard_acl**](docs/DashboardApi.md#set_dashboard_acl) | **PUT** /api/v2/dashboard/acl/set | Set ACL for the specified dashboards
*DashboardApi* | [**set_dashboard_tags**](docs/DashboardApi.md#set_dashboard_tags) | **POST** /api/v2/dashboard/{id}/tag | Set all tags associated with a specific dashboard
*DashboardApi* | [**undelete_dashboard**](docs/DashboardApi.md#undelete_dashboard) | **POST** /api/v2/dashboard/{id}/undelete | Undelete a specific dashboard
*DashboardApi* | [**unfavorite_dashboard**](docs/DashboardApi.md#unfavorite_dashboard) | **POST** /api/v2/dashboard/{id}/unfavorite | Unmark a dashboard as favorite
*DashboardApi* | [**update_dashboard**](docs/DashboardApi.md#update_dashboard) | **PUT** /api/v2/dashboard/{id} | Update a specific dashboard
*DerivedMetricApi* | [**add_tag_to_derived_metric**](docs/DerivedMetricApi.md#add_tag_to_derived_metric) | **PUT** /api/v2/derivedmetric/{id}/tag/{tagValue} | Add a tag to a specific Derived Metric
*DerivedMetricApi* | [**create_derived_metric**](docs/DerivedMetricApi.md#create_derived_metric) | **POST** /api/v2/derivedmetric | Create a specific derived metric definition
*DerivedMetricApi* | [**delete_derived_metric**](docs/DerivedMetricApi.md#delete_derived_metric) | **DELETE** /api/v2/derivedmetric/{id} | Delete a specific derived metric definition
*DerivedMetricApi* | [**get_all_derived_metrics**](docs/DerivedMetricApi.md#get_all_derived_metrics) | **GET** /api/v2/derivedmetric | Get all derived metric definitions for a customer
*DerivedMetricApi* | [**get_derived_metric**](docs/DerivedMetricApi.md#get_derived_metric) | **GET** /api/v2/derivedmetric/{id} | Get a specific registered query
*DerivedMetricApi* | [**get_derived_metric_by_version**](docs/DerivedMetricApi.md#get_derived_metric_by_version) | **GET** /api/v2/derivedmetric/{id}/history/{version} | Get a specific historical version of a specific derived metric definition
*DerivedMetricApi* | [**get_derived_metric_history**](docs/DerivedMetricApi.md#get_derived_metric_history) | **GET** /api/v2/derivedmetric/{id}/history | Get the version history of a specific derived metric definition
*DerivedMetricApi* | [**get_derived_metric_tags**](docs/DerivedMetricApi.md#get_derived_metric_tags) | **GET** /api/v2/derivedmetric/{id}/tag | Get all tags associated with a specific derived metric definition
*DerivedMetricApi* | [**remove_tag_from_derived_metric**](docs/DerivedMetricApi.md#remove_tag_from_derived_metric) | **DELETE** /api/v2/derivedmetric/{id}/tag/{tagValue} | Remove a tag from a specific Derived Metric
*DerivedMetricApi* | [**set_derived_metric_tags**](docs/DerivedMetricApi.md#set_derived_metric_tags) | **POST** /api/v2/derivedmetric/{id}/tag | Set all tags associated with a specific derived metric definition
*DerivedMetricApi* | [**undelete_derived_metric**](docs/DerivedMetricApi.md#undelete_derived_metric) | **POST** /api/v2/derivedmetric/{id}/undelete | Undelete a specific derived metric definition
*DerivedMetricApi* | [**update_derived_metric**](docs/DerivedMetricApi.md#update_derived_metric) | **PUT** /api/v2/derivedmetric/{id} | Update a specific derived metric definition
*DirectIngestionApi* | [**report**](docs/DirectIngestionApi.md#report) | **POST** /report | Directly ingest data/data stream with specified format
*EventApi* | [**add_event_tag**](docs/EventApi.md#add_event_tag) | **PUT** /api/v2/event/{id}/tag/{tagValue} | Add a tag to a specific event
*EventApi* | [**close_event**](docs/EventApi.md#close_event) | **POST** /api/v2/event/{id}/close | Close a specific event
*EventApi* | [**create_event**](docs/EventApi.md#create_event) | **POST** /api/v2/event | Create a specific event
*EventApi* | [**delete_event**](docs/EventApi.md#delete_event) | **DELETE** /api/v2/event/{id} | Delete a specific event
*EventApi* | [**get_alert_event_queries_slug**](docs/EventApi.md#get_alert_event_queries_slug) | **GET** /api/v2/event/{id}/alertQueriesSlug | If the specified event is associated with an alert, returns a slug encoding the queries having to do with that alert firing or resolution
*EventApi* | [**get_alert_firing_details**](docs/EventApi.md#get_alert_firing_details) | **GET** /api/v2/event/{id}/alertFiringDetails | Return details of a particular alert firing, including all the series that fired during the referred alert firing
*EventApi* | [**get_alert_firing_events**](docs/EventApi.md#get_alert_firing_events) | **GET** /api/v2/event/alertFirings | Get firings events of an alert within a time range
*EventApi* | [**get_all_events_with_time_range**](docs/EventApi.md#get_all_events_with_time_range) | **GET** /api/v2/event | List all the events for a customer within a time range
*EventApi* | [**get_event**](docs/EventApi.md#get_event) | **GET** /api/v2/event/{id} | Get a specific event
*EventApi* | [**get_event_tags**](docs/EventApi.md#get_event_tags) | **GET** /api/v2/event/{id}/tag | Get all tags associated with a specific event
*EventApi* | [**get_related_events_with_time_span**](docs/EventApi.md#get_related_events_with_time_span) | **GET** /api/v2/event/{id}/events | List all related events for a specific firing event with a time span of one hour
*EventApi* | [**remove_event_tag**](docs/EventApi.md#remove_event_tag) | **DELETE** /api/v2/event/{id}/tag/{tagValue} | Remove a tag from a specific event
*EventApi* | [**set_event_tags**](docs/EventApi.md#set_event_tags) | **POST** /api/v2/event/{id}/tag | Set all tags associated with a specific event
*EventApi* | [**update_event**](docs/EventApi.md#update_event) | **PUT** /api/v2/event/{id} | Update a specific event
*ExternalLinkApi* | [**create_external_link**](docs/ExternalLinkApi.md#create_external_link) | **POST** /api/v2/extlink | Create a specific external link
*ExternalLinkApi* | [**delete_external_link**](docs/ExternalLinkApi.md#delete_external_link) | **DELETE** /api/v2/extlink/{id} | Delete a specific external link
*ExternalLinkApi* | [**get_all_external_link**](docs/ExternalLinkApi.md#get_all_external_link) | **GET** /api/v2/extlink | Get all external links for a customer
*ExternalLinkApi* | [**get_external_link**](docs/ExternalLinkApi.md#get_external_link) | **GET** /api/v2/extlink/{id} | Get a specific external link
*ExternalLinkApi* | [**update_external_link**](docs/ExternalLinkApi.md#update_external_link) | **PUT** /api/v2/extlink/{id} | Update a specific external link
*IngestionSpyApi* | [**spy_on_delta_counters**](docs/IngestionSpyApi.md#spy_on_delta_counters) | **GET** /api/spy/deltas | Gets new delta counters that are added to existing time series.
*IngestionSpyApi* | [**spy_on_histograms**](docs/IngestionSpyApi.md#spy_on_histograms) | **GET** /api/spy/histograms | Gets new histograms that are added to existing time series.
*IngestionSpyApi* | [**spy_on_id_creations**](docs/IngestionSpyApi.md#spy_on_id_creations) | **GET** /api/spy/ids | Gets newly allocated IDs that correspond to new metric names, source names, point tags, or span tags. A new ID generally indicates that a new time series has been introduced.
*IngestionSpyApi* | [**spy_on_points**](docs/IngestionSpyApi.md#spy_on_points) | **GET** /api/spy/points | Gets a sampling of new metric data points that are added to existing time series.
*IngestionSpyApi* | [**spy_on_spans**](docs/IngestionSpyApi.md#spy_on_spans) | **GET** /api/spy/spans | Gets new spans with existing source names and span tags.
*IntegrationApi* | [**get_all_integration**](docs/IntegrationApi.md#get_all_integration) | **GET** /api/v2/integration | Gets a flat list of all Wavefront integrations available, along with their status
*IntegrationApi* | [**get_all_integration_in_manifests**](docs/IntegrationApi.md#get_all_integration_in_manifests) | **GET** /api/v2/integration/manifests | Gets all Wavefront integrations as structured in their integration manifests, along with their status and content
*IntegrationApi* | [**get_all_integration_in_manifests_min**](docs/IntegrationApi.md#get_all_integration_in_manifests_min) | **GET** /api/v2/integration/manifests/min | Gets all Wavefront integrations as structured in their integration manifests.
*IntegrationApi* | [**get_all_integration_statuses**](docs/IntegrationApi.md#get_all_integration_statuses) | **GET** /api/v2/integration/status | Gets the status of all Wavefront integrations
*IntegrationApi* | [**get_installed_integration**](docs/IntegrationApi.md#get_installed_integration) | **GET** /api/v2/integration/installed | Gets a flat list of all Integrations that are installed, along with their status
*IntegrationApi* | [**get_integration**](docs/IntegrationApi.md#get_integration) | **GET** /api/v2/integration/{id} | Gets a single Wavefront integration by its id, along with its status
*IntegrationApi* | [**get_integration_status**](docs/IntegrationApi.md#get_integration_status) | **GET** /api/v2/integration/{id}/status | Gets the status of a single Wavefront integration
*IntegrationApi* | [**install_all_integration_alerts**](docs/IntegrationApi.md#install_all_integration_alerts) | **POST** /api/v2/integration/{id}/install-all-alerts | Enable all alerts associated with this integration
*IntegrationApi* | [**install_integration**](docs/IntegrationApi.md#install_integration) | **POST** /api/v2/integration/{id}/install | Installs a Wavefront integration
*IntegrationApi* | [**uninstall_all_integration_alerts**](docs/IntegrationApi.md#uninstall_all_integration_alerts) | **POST** /api/v2/integration/{id}/uninstall-all-alerts | Disable all alerts associated with this integration
*IntegrationApi* | [**uninstall_integration**](docs/IntegrationApi.md#uninstall_integration) | **POST** /api/v2/integration/{id}/uninstall | Uninstalls a Wavefront integration
*MaintenanceWindowApi* | [**create_maintenance_window**](docs/MaintenanceWindowApi.md#create_maintenance_window) | **POST** /api/v2/maintenancewindow | Create a maintenance window
*MaintenanceWindowApi* | [**delete_maintenance_window**](docs/MaintenanceWindowApi.md#delete_maintenance_window) | **DELETE** /api/v2/maintenancewindow/{id} | Delete a specific maintenance window
*MaintenanceWindowApi* | [**get_all_maintenance_window**](docs/MaintenanceWindowApi.md#get_all_maintenance_window) | **GET** /api/v2/maintenancewindow | Get all maintenance windows for a customer
*MaintenanceWindowApi* | [**get_maintenance_window**](docs/MaintenanceWindowApi.md#get_maintenance_window) | **GET** /api/v2/maintenancewindow/{id} | Get a specific maintenance window
*MaintenanceWindowApi* | [**update_maintenance_window**](docs/MaintenanceWindowApi.md#update_maintenance_window) | **PUT** /api/v2/maintenancewindow/{id} | Update a specific maintenance window
*MessageApi* | [**user_get_messages**](docs/MessageApi.md#user_get_messages) | **GET** /api/v2/message | Gets messages applicable to the current user, i.e. within time range and distribution scope
*MessageApi* | [**user_read_message**](docs/MessageApi.md#user_read_message) | **POST** /api/v2/message/{id}/read | Mark a specific message as read
*MetricApi* | [**get_metric_details**](docs/MetricApi.md#get_metric_details) | **GET** /api/v2/chart/metric/detail | Get more details on a metric, including reporting sources and approximate last time reported
*MetricsPolicyApi* | [**get_metrics_policy**](docs/MetricsPolicyApi.md#get_metrics_policy) | **GET** /api/v2/metricspolicy | Get the metrics policy
*MetricsPolicyApi* | [**get_metrics_policy_by_version**](docs/MetricsPolicyApi.md#get_metrics_policy_by_version) | **GET** /api/v2/metricspolicy/history/{version} | Get a specific historical version of a metrics policy
*MetricsPolicyApi* | [**get_metrics_policy_history**](docs/MetricsPolicyApi.md#get_metrics_policy_history) | **GET** /api/v2/metricspolicy/history | Get the version history of metrics policy
*MetricsPolicyApi* | [**revert_metrics_policy_by_version**](docs/MetricsPolicyApi.md#revert_metrics_policy_by_version) | **POST** /api/v2/metricspolicy/revert/{version} | Revert to a specific historical version of a metrics policy
*MetricsPolicyApi* | [**update_metrics_policy**](docs/MetricsPolicyApi.md#update_metrics_policy) | **PUT** /api/v2/metricspolicy | Update the metrics policy
*MonitoredApplicationApi* | [**get_all_applications**](docs/MonitoredApplicationApi.md#get_all_applications) | **GET** /api/v2/monitoredapplication | Get all monitored services
*MonitoredApplicationApi* | [**get_application**](docs/MonitoredApplicationApi.md#get_application) | **GET** /api/v2/monitoredapplication/{application} | Get a specific application
*MonitoredApplicationApi* | [**update_service**](docs/MonitoredApplicationApi.md#update_service) | **PUT** /api/v2/monitoredapplication/{application} | Update a specific service
*MonitoredServiceApi* | [**batch_update**](docs/MonitoredServiceApi.md#batch_update) | **PUT** /api/v2/monitoredservice/services | Update multiple applications and services in a batch. Batch size is limited to 100.
*MonitoredServiceApi* | [**get_all_services**](docs/MonitoredServiceApi.md#get_all_services) | **GET** /api/v2/monitoredservice | Get all monitored services
*MonitoredServiceApi* | [**get_service**](docs/MonitoredServiceApi.md#get_service) | **GET** /api/v2/monitoredservice/{application}/{service} | Get a specific application
*MonitoredServiceApi* | [**get_services_of_application**](docs/MonitoredServiceApi.md#get_services_of_application) | **GET** /api/v2/monitoredservice/{application} | Get a specific application
*MonitoredServiceApi* | [**update_service**](docs/MonitoredServiceApi.md#update_service) | **PUT** /api/v2/monitoredservice/{application}/{service} | Update a specific service
*NotificantApi* | [**create_notificant**](docs/NotificantApi.md#create_notificant) | **POST** /api/v2/notificant | Create a notification target
*NotificantApi* | [**delete_notificant**](docs/NotificantApi.md#delete_notificant) | **DELETE** /api/v2/notificant/{id} | Delete a specific notification target
*NotificantApi* | [**get_all_notificants**](docs/NotificantApi.md#get_all_notificants) | **GET** /api/v2/notificant | Get all notification targets for a customer
*NotificantApi* | [**get_notificant**](docs/NotificantApi.md#get_notificant) | **GET** /api/v2/notificant/{id} | Get a specific notification target
*NotificantApi* | [**test_notificant**](docs/NotificantApi.md#test_notificant) | **POST** /api/v2/notificant/test/{id} | Test a specific notification target
*NotificantApi* | [**update_notificant**](docs/NotificantApi.md#update_notificant) | **PUT** /api/v2/notificant/{id} | Update a specific notification target
*ProxyApi* | [**delete_proxy**](docs/ProxyApi.md#delete_proxy) | **DELETE** /api/v2/proxy/{id} | Delete a specific proxy
*ProxyApi* | [**get_all_proxy**](docs/ProxyApi.md#get_all_proxy) | **GET** /api/v2/proxy | Get all proxies for a customer
*ProxyApi* | [**get_proxy**](docs/ProxyApi.md#get_proxy) | **GET** /api/v2/proxy/{id} | Get a specific proxy
*ProxyApi* | [**undelete_proxy**](docs/ProxyApi.md#undelete_proxy) | **POST** /api/v2/proxy/{id}/undelete | Undelete a specific proxy
*ProxyApi* | [**update_proxy**](docs/ProxyApi.md#update_proxy) | **PUT** /api/v2/proxy/{id} | Update the name of a specific proxy
*QueryApi* | [**query_api**](docs/QueryApi.md#query_api) | **GET** /api/v2/chart/api | Perform a charting query against Wavefront servers that returns the appropriate points in the specified time window and granularity
*QueryApi* | [**query_raw**](docs/QueryApi.md#query_raw) | **GET** /api/v2/chart/raw | Perform a raw data query against Wavefront servers that returns second granularity points grouped by tags
*RoleApi* | [**add_assignees**](docs/RoleApi.md#add_assignees) | **POST** /api/v2/role/{id}/addAssignees | Add multiple users and user groups to a specific role
*RoleApi* | [**create_role**](docs/RoleApi.md#create_role) | **POST** /api/v2/role | Create a specific role
*RoleApi* | [**delete_role**](docs/RoleApi.md#delete_role) | **DELETE** /api/v2/role/{id} | Delete a specific role
*RoleApi* | [**get_all_roles**](docs/RoleApi.md#get_all_roles) | **GET** /api/v2/role | Get all roles for a customer
*RoleApi* | [**get_role**](docs/RoleApi.md#get_role) | **GET** /api/v2/role/{id} | Get a specific role
*RoleApi* | [**grant_permission_to_roles**](docs/RoleApi.md#grant_permission_to_roles) | **POST** /api/v2/role/grant/{permission} | Grants a single permission to role(s)
*RoleApi* | [**remove_assignees**](docs/RoleApi.md#remove_assignees) | **POST** /api/v2/role/{id}/removeAssignees | Remove multiple users and user groups from a specific role
*RoleApi* | [**revoke_permission_from_roles**](docs/RoleApi.md#revoke_permission_from_roles) | **POST** /api/v2/role/revoke/{permission} | Revokes a single permission from role(s)
*RoleApi* | [**update_role**](docs/RoleApi.md#update_role) | **PUT** /api/v2/role/{id} | Update a specific role
*SavedSearchApi* | [**create_saved_search**](docs/SavedSearchApi.md#create_saved_search) | **POST** /api/v2/savedsearch | Create a saved search
*SavedSearchApi* | [**delete_saved_search**](docs/SavedSearchApi.md#delete_saved_search) | **DELETE** /api/v2/savedsearch/{id} | Delete a specific saved search
*SavedSearchApi* | [**get_all_entity_type_saved_searches**](docs/SavedSearchApi.md#get_all_entity_type_saved_searches) | **GET** /api/v2/savedsearch/type/{entitytype} | Get all saved searches for a specific entity type for a user
*SavedSearchApi* | [**get_all_saved_searches**](docs/SavedSearchApi.md#get_all_saved_searches) | **GET** /api/v2/savedsearch | Get all saved searches for a user
*SavedSearchApi* | [**get_saved_search**](docs/SavedSearchApi.md#get_saved_search) | **GET** /api/v2/savedsearch/{id} | Get a specific saved search
*SavedSearchApi* | [**update_saved_search**](docs/SavedSearchApi.md#update_saved_search) | **PUT** /api/v2/savedsearch/{id} | Update a specific saved search
*SearchApi* | [**search_account_entities**](docs/SearchApi.md#search_account_entities) | **POST** /api/v2/search/account | Search over a customer&#39;s accounts
*SearchApi* | [**search_account_for_facet**](docs/SearchApi.md#search_account_for_facet) | **POST** /api/v2/search/account/{facet} | Lists the values of a specific facet over the customer&#39;s accounts
*SearchApi* | [**search_account_for_facets**](docs/SearchApi.md#search_account_for_facets) | **POST** /api/v2/search/account/facets | Lists the values of one or more facets over the customer&#39;s accounts
*SearchApi* | [**search_alert_deleted_entities**](docs/SearchApi.md#search_alert_deleted_entities) | **POST** /api/v2/search/alert/deleted | Search over a customer&#39;s deleted alerts
*SearchApi* | [**search_alert_deleted_for_facet**](docs/SearchApi.md#search_alert_deleted_for_facet) | **POST** /api/v2/search/alert/deleted/{facet} | Lists the values of a specific facet over the customer&#39;s deleted alerts
*SearchApi* | [**search_alert_deleted_for_facets**](docs/SearchApi.md#search_alert_deleted_for_facets) | **POST** /api/v2/search/alert/deleted/facets | Lists the values of one or more facets over the customer&#39;s deleted alerts
*SearchApi* | [**search_alert_entities**](docs/SearchApi.md#search_alert_entities) | **POST** /api/v2/search/alert | Search over a customer&#39;s non-deleted alerts
*SearchApi* | [**search_alert_for_facet**](docs/SearchApi.md#search_alert_for_facet) | **POST** /api/v2/search/alert/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted alerts
*SearchApi* | [**search_alert_for_facets**](docs/SearchApi.md#search_alert_for_facets) | **POST** /api/v2/search/alert/facets | Lists the values of one or more facets over the customer&#39;s non-deleted alerts
*SearchApi* | [**search_cloud_integration_deleted_entities**](docs/SearchApi.md#search_cloud_integration_deleted_entities) | **POST** /api/v2/search/cloudintegration/deleted | Search over a customer&#39;s deleted cloud integrations
*SearchApi* | [**search_cloud_integration_deleted_for_facet**](docs/SearchApi.md#search_cloud_integration_deleted_for_facet) | **POST** /api/v2/search/cloudintegration/deleted/{facet} | Lists the values of a specific facet over the customer&#39;s deleted cloud integrations
*SearchApi* | [**search_cloud_integration_deleted_for_facets**](docs/SearchApi.md#search_cloud_integration_deleted_for_facets) | **POST** /api/v2/search/cloudintegration/deleted/facets | Lists the values of one or more facets over the customer&#39;s deleted cloud integrations
*SearchApi* | [**search_cloud_integration_entities**](docs/SearchApi.md#search_cloud_integration_entities) | **POST** /api/v2/search/cloudintegration | Search over a customer&#39;s non-deleted cloud integrations
*SearchApi* | [**search_cloud_integration_for_facet**](docs/SearchApi.md#search_cloud_integration_for_facet) | **POST** /api/v2/search/cloudintegration/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted cloud integrations
*SearchApi* | [**search_cloud_integration_for_facets**](docs/SearchApi.md#search_cloud_integration_for_facets) | **POST** /api/v2/search/cloudintegration/facets | Lists the values of one or more facets over the customer&#39;s non-deleted cloud integrations
*SearchApi* | [**search_dashboard_deleted_entities**](docs/SearchApi.md#search_dashboard_deleted_entities) | **POST** /api/v2/search/dashboard/deleted | Search over a customer&#39;s deleted dashboards
*SearchApi* | [**search_dashboard_deleted_for_facet**](docs/SearchApi.md#search_dashboard_deleted_for_facet) | **POST** /api/v2/search/dashboard/deleted/{facet} | Lists the values of a specific facet over the customer&#39;s deleted dashboards
*SearchApi* | [**search_dashboard_deleted_for_facets**](docs/SearchApi.md#search_dashboard_deleted_for_facets) | **POST** /api/v2/search/dashboard/deleted/facets | Lists the values of one or more facets over the customer&#39;s deleted dashboards
*SearchApi* | [**search_dashboard_entities**](docs/SearchApi.md#search_dashboard_entities) | **POST** /api/v2/search/dashboard | Search over a customer&#39;s non-deleted dashboards
*SearchApi* | [**search_dashboard_for_facet**](docs/SearchApi.md#search_dashboard_for_facet) | **POST** /api/v2/search/dashboard/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted dashboards
*SearchApi* | [**search_dashboard_for_facets**](docs/SearchApi.md#search_dashboard_for_facets) | **POST** /api/v2/search/dashboard/facets | Lists the values of one or more facets over the customer&#39;s non-deleted dashboards
*SearchApi* | [**search_external_link_entities**](docs/SearchApi.md#search_external_link_entities) | **POST** /api/v2/search/extlink | Search over a customer&#39;s external links
*SearchApi* | [**search_external_links_for_facet**](docs/SearchApi.md#search_external_links_for_facet) | **POST** /api/v2/search/extlink/{facet} | Lists the values of a specific facet over the customer&#39;s external links
*SearchApi* | [**search_external_links_for_facets**](docs/SearchApi.md#search_external_links_for_facets) | **POST** /api/v2/search/extlink/facets | Lists the values of one or more facets over the customer&#39;s external links
*SearchApi* | [**search_ingestion_policy_entities**](docs/SearchApi.md#search_ingestion_policy_entities) | **POST** /api/v2/search/ingestionpolicy | Search over a customer&#39;s ingestion policies
*SearchApi* | [**search_ingestion_policy_for_facet**](docs/SearchApi.md#search_ingestion_policy_for_facet) | **POST** /api/v2/search/ingestionpolicy/{facet} | Lists the values of a specific facet over the customer&#39;s ingestion policies
*SearchApi* | [**search_ingestion_policy_for_facets**](docs/SearchApi.md#search_ingestion_policy_for_facets) | **POST** /api/v2/search/ingestionpolicy/facets | Lists the values of one or more facets over the customer&#39;s ingestion policies
*SearchApi* | [**search_maintenance_window_entities**](docs/SearchApi.md#search_maintenance_window_entities) | **POST** /api/v2/search/maintenancewindow | Search over a customer&#39;s maintenance windows
*SearchApi* | [**search_maintenance_window_for_facet**](docs/SearchApi.md#search_maintenance_window_for_facet) | **POST** /api/v2/search/maintenancewindow/{facet} | Lists the values of a specific facet over the customer&#39;s maintenance windows
*SearchApi* | [**search_maintenance_window_for_facets**](docs/SearchApi.md#search_maintenance_window_for_facets) | **POST** /api/v2/search/maintenancewindow/facets | Lists the values of one or more facets over the customer&#39;s maintenance windows
*SearchApi* | [**search_monitored_application_entities**](docs/SearchApi.md#search_monitored_application_entities) | **POST** /api/v2/search/monitoredapplication | Search over all the customer&#39;s non-deleted monitored applications
*SearchApi* | [**search_monitored_application_for_facet**](docs/SearchApi.md#search_monitored_application_for_facet) | **POST** /api/v2/search/monitoredapplication/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted monitored application
*SearchApi* | [**search_monitored_application_for_facets**](docs/SearchApi.md#search_monitored_application_for_facets) | **POST** /api/v2/search/monitoredapplication/facets | Lists the values of one or more facets over the customer&#39;s non-deleted monitored clusters
*SearchApi* | [**search_monitored_service_entities**](docs/SearchApi.md#search_monitored_service_entities) | **POST** /api/v2/search/monitoredservice | Search over all the customer&#39;s non-deleted monitored services
*SearchApi* | [**search_monitored_service_for_facet**](docs/SearchApi.md#search_monitored_service_for_facet) | **POST** /api/v2/search/monitoredservice/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted monitored application
*SearchApi* | [**search_monitored_service_for_facets**](docs/SearchApi.md#search_monitored_service_for_facets) | **POST** /api/v2/search/monitoredservice/facets | Lists the values of one or more facets over the customer&#39;s non-deleted monitored clusters
*SearchApi* | [**search_notficant_for_facets**](docs/SearchApi.md#search_notficant_for_facets) | **POST** /api/v2/search/notificant/facets | Lists the values of one or more facets over the customer&#39;s notificants
*SearchApi* | [**search_notificant_entities**](docs/SearchApi.md#search_notificant_entities) | **POST** /api/v2/search/notificant | Search over a customer&#39;s notificants
*SearchApi* | [**search_notificant_for_facet**](docs/SearchApi.md#search_notificant_for_facet) | **POST** /api/v2/search/notificant/{facet} | Lists the values of a specific facet over the customer&#39;s notificants
*SearchApi* | [**search_proxy_deleted_entities**](docs/SearchApi.md#search_proxy_deleted_entities) | **POST** /api/v2/search/proxy/deleted | Search over a customer&#39;s deleted proxies
*SearchApi* | [**search_proxy_deleted_for_facet**](docs/SearchApi.md#search_proxy_deleted_for_facet) | **POST** /api/v2/search/proxy/deleted/{facet} | Lists the values of a specific facet over the customer&#39;s deleted proxies
*SearchApi* | [**search_proxy_deleted_for_facets**](docs/SearchApi.md#search_proxy_deleted_for_facets) | **POST** /api/v2/search/proxy/deleted/facets | Lists the values of one or more facets over the customer&#39;s deleted proxies
*SearchApi* | [**search_proxy_entities**](docs/SearchApi.md#search_proxy_entities) | **POST** /api/v2/search/proxy | Search over a customer&#39;s non-deleted proxies
*SearchApi* | [**search_proxy_for_facet**](docs/SearchApi.md#search_proxy_for_facet) | **POST** /api/v2/search/proxy/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted proxies
*SearchApi* | [**search_proxy_for_facets**](docs/SearchApi.md#search_proxy_for_facets) | **POST** /api/v2/search/proxy/facets | Lists the values of one or more facets over the customer&#39;s non-deleted proxies
*SearchApi* | [**search_registered_query_deleted_entities**](docs/SearchApi.md#search_registered_query_deleted_entities) | **POST** /api/v2/search/derivedmetric/deleted | Search over a customer&#39;s deleted derived metric definitions
*SearchApi* | [**search_registered_query_deleted_for_facet**](docs/SearchApi.md#search_registered_query_deleted_for_facet) | **POST** /api/v2/search/derivedmetric/deleted/{facet} | Lists the values of a specific facet over the customer&#39;s deleted derived metric definitions
*SearchApi* | [**search_registered_query_deleted_for_facets**](docs/SearchApi.md#search_registered_query_deleted_for_facets) | **POST** /api/v2/search/derivedmetric/deleted/facets | Lists the values of one or more facets over the customer&#39;s deleted derived metric definitions
*SearchApi* | [**search_registered_query_entities**](docs/SearchApi.md#search_registered_query_entities) | **POST** /api/v2/search/derivedmetric | Search over a customer&#39;s non-deleted derived metric definitions
*SearchApi* | [**search_registered_query_for_facet**](docs/SearchApi.md#search_registered_query_for_facet) | **POST** /api/v2/search/derivedmetric/{facet} | Lists the values of a specific facet over the customer&#39;s non-deleted derived metric definitions
*SearchApi* | [**search_registered_query_for_facets**](docs/SearchApi.md#search_registered_query_for_facets) | **POST** /api/v2/search/derivedmetric/facets | Lists the values of one or more facets over the customer&#39;s non-deleted derived metric definition
*SearchApi* | [**search_related_report_event_anomaly_entities**](docs/SearchApi.md#search_related_report_event_anomaly_entities) | **POST** /api/v2/search/event/related/{eventId}/withAnomalies | List the related events and anomalies over a firing event
*SearchApi* | [**search_related_report_event_entities**](docs/SearchApi.md#search_related_report_event_entities) | **POST** /api/v2/search/event/related/{eventId} | List the related events over a firing event
*SearchApi* | [**search_report_event_entities**](docs/SearchApi.md#search_report_event_entities) | **POST** /api/v2/search/event | Search over a customer&#39;s events
*SearchApi* | [**search_report_event_for_facet**](docs/SearchApi.md#search_report_event_for_facet) | **POST** /api/v2/search/event/{facet} | Lists the values of a specific facet over the customer&#39;s events
*SearchApi* | [**search_report_event_for_facets**](docs/SearchApi.md#search_report_event_for_facets) | **POST** /api/v2/search/event/facets | Lists the values of one or more facets over the customer&#39;s events
*SearchApi* | [**search_role_entities**](docs/SearchApi.md#search_role_entities) | **POST** /api/v2/search/role | Search over a customer&#39;s roles
*SearchApi* | [**search_role_for_facet**](docs/SearchApi.md#search_role_for_facet) | **POST** /api/v2/search/role/{facet} | Lists the values of a specific facet over the customer&#39;s roles
*SearchApi* | [**search_role_for_facets**](docs/SearchApi.md#search_role_for_facets) | **POST** /api/v2/search/role/facets | Lists the values of one or more facets over the customer&#39;s roles
*SearchApi* | [**search_service_account_entities**](docs/SearchApi.md#search_service_account_entities) | **POST** /api/v2/search/serviceaccount | Search over a customer&#39;s service accounts
*SearchApi* | [**search_service_account_for_facet**](docs/SearchApi.md#search_service_account_for_facet) | **POST** /api/v2/search/serviceaccount/{facet} | Lists the values of a specific facet over the customer&#39;s service accounts
*SearchApi* | [**search_service_account_for_facets**](docs/SearchApi.md#search_service_account_for_facets) | **POST** /api/v2/search/serviceaccount/facets | Lists the values of one or more facets over the customer&#39;s service accounts
*SearchApi* | [**search_tagged_source_entities**](docs/SearchApi.md#search_tagged_source_entities) | **POST** /api/v2/search/source | Search over a customer&#39;s sources
*SearchApi* | [**search_tagged_source_for_facet**](docs/SearchApi.md#search_tagged_source_for_facet) | **POST** /api/v2/search/source/{facet} | Lists the values of a specific facet over the customer&#39;s sources
*SearchApi* | [**search_tagged_source_for_facets**](docs/SearchApi.md#search_tagged_source_for_facets) | **POST** /api/v2/search/source/facets | Lists the values of one or more facets over the customer&#39;s sources
*SearchApi* | [**search_user_entities**](docs/SearchApi.md#search_user_entities) | **POST** /api/v2/search/user | Search over a customer&#39;s users
*SearchApi* | [**search_user_for_facet**](docs/SearchApi.md#search_user_for_facet) | **POST** /api/v2/search/user/{facet} | Lists the values of a specific facet over the customer&#39;s users
*SearchApi* | [**search_user_for_facets**](docs/SearchApi.md#search_user_for_facets) | **POST** /api/v2/search/user/facets | Lists the values of one or more facets over the customer&#39;s users
*SearchApi* | [**search_user_group_entities**](docs/SearchApi.md#search_user_group_entities) | **POST** /api/v2/search/usergroup | Search over a customer&#39;s user groups
*SearchApi* | [**search_user_group_for_facet**](docs/SearchApi.md#search_user_group_for_facet) | **POST** /api/v2/search/usergroup/{facet} | Lists the values of a specific facet over the customer&#39;s user groups
*SearchApi* | [**search_user_group_for_facets**](docs/SearchApi.md#search_user_group_for_facets) | **POST** /api/v2/search/usergroup/facets | Lists the values of one or more facets over the customer&#39;s user groups
*SearchApi* | [**search_web_hook_entities**](docs/SearchApi.md#search_web_hook_entities) | **POST** /api/v2/search/webhook | Search over a customer&#39;s webhooks
*SearchApi* | [**search_web_hook_for_facet**](docs/SearchApi.md#search_web_hook_for_facet) | **POST** /api/v2/search/webhook/{facet} | Lists the values of a specific facet over the customer&#39;s webhooks
*SearchApi* | [**search_webhook_for_facets**](docs/SearchApi.md#search_webhook_for_facets) | **POST** /api/v2/search/webhook/facets | Lists the values of one or more facets over the customer&#39;s webhooks
*SourceApi* | [**add_source_tag**](docs/SourceApi.md#add_source_tag) | **PUT** /api/v2/source/{id}/tag/{tagValue} | Add a tag to a specific source
*SourceApi* | [**create_source**](docs/SourceApi.md#create_source) | **POST** /api/v2/source | Create metadata (description or tags) for a specific source
*SourceApi* | [**delete_source**](docs/SourceApi.md#delete_source) | **DELETE** /api/v2/source/{id} | Delete metadata (description and tags) for a specific source
*SourceApi* | [**get_all_source**](docs/SourceApi.md#get_all_source) | **GET** /api/v2/source | Get all sources for a customer
*SourceApi* | [**get_source**](docs/SourceApi.md#get_source) | **GET** /api/v2/source/{id} | Get a specific source for a customer
*SourceApi* | [**get_source_tags**](docs/SourceApi.md#get_source_tags) | **GET** /api/v2/source/{id}/tag | Get all tags associated with a specific source
*SourceApi* | [**remove_description**](docs/SourceApi.md#remove_description) | **DELETE** /api/v2/source/{id}/description | Remove description from a specific source
*SourceApi* | [**remove_source_tag**](docs/SourceApi.md#remove_source_tag) | **DELETE** /api/v2/source/{id}/tag/{tagValue} | Remove a tag from a specific source
*SourceApi* | [**set_description**](docs/SourceApi.md#set_description) | **POST** /api/v2/source/{id}/description | Set description associated with a specific source
*SourceApi* | [**set_source_tags**](docs/SourceApi.md#set_source_tags) | **POST** /api/v2/source/{id}/tag | Set all tags associated with a specific source
*SourceApi* | [**update_source**](docs/SourceApi.md#update_source) | **PUT** /api/v2/source/{id} | Update metadata (description or tags) for a specific source.
*UsageApi* | [**create_ingestion_policy**](docs/UsageApi.md#create_ingestion_policy) | **POST** /api/v2/usage/ingestionpolicy | Create a specific ingestion policy
*UsageApi* | [**delete_ingestion_policy**](docs/UsageApi.md#delete_ingestion_policy) | **DELETE** /api/v2/usage/ingestionpolicy/{id} | Delete a specific ingestion policy
*UsageApi* | [**export_csv**](docs/UsageApi.md#export_csv) | **GET** /api/v2/usage/exportcsv | Export a CSV report
*UsageApi* | [**get_all_ingestion_policies**](docs/UsageApi.md#get_all_ingestion_policies) | **GET** /api/v2/usage/ingestionpolicy | Get all ingestion policies for a customer
*UsageApi* | [**get_ingestion_policy**](docs/UsageApi.md#get_ingestion_policy) | **GET** /api/v2/usage/ingestionpolicy/{id} | Get a specific ingestion policy
*UsageApi* | [**update_ingestion_policy**](docs/UsageApi.md#update_ingestion_policy) | **PUT** /api/v2/usage/ingestionpolicy/{id} | Update a specific ingestion policy
*UserApi* | [**add_user_to_user_groups**](docs/UserApi.md#add_user_to_user_groups) | **POST** /api/v2/user/{id}/addUserGroups | Adds specific user groups to the user or service account
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /api/v2/user | Creates an user if the user doesn&#39;t already exist.
*UserApi* | [**delete_multiple_users**](docs/UserApi.md#delete_multiple_users) | **POST** /api/v2/user/deleteUsers | Deletes multiple users or service accounts
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /api/v2/user/{id} | Deletes a user or service account identified by id
*UserApi* | [**get_all_users**](docs/UserApi.md#get_all_users) | **GET** /api/v2/user | Get all users
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /api/v2/user/{id} | Retrieves a user by identifier (email address)
*UserApi* | [**get_user_business_functions**](docs/UserApi.md#get_user_business_functions) | **GET** /api/v2/user/{id}/businessFunctions | Returns business functions of a specific user or service account.
*UserApi* | [**grant_permission_to_users**](docs/UserApi.md#grant_permission_to_users) | **POST** /api/v2/user/grant/{permission} | Grants a specific permission to multiple users or service accounts
*UserApi* | [**grant_user_permission**](docs/UserApi.md#grant_user_permission) | **POST** /api/v2/user/{id}/grant | Grants a specific permission to user or service account
*UserApi* | [**invite_users**](docs/UserApi.md#invite_users) | **POST** /api/v2/user/invite | Invite users with given user groups and permissions.
*UserApi* | [**remove_user_from_user_groups**](docs/UserApi.md#remove_user_from_user_groups) | **POST** /api/v2/user/{id}/removeUserGroups | Removes specific user groups from the user or service account
*UserApi* | [**revoke_permission_from_users**](docs/UserApi.md#revoke_permission_from_users) | **POST** /api/v2/user/revoke/{permission} | Revokes a specific permission from multiple users or service accounts
*UserApi* | [**revoke_user_permission**](docs/UserApi.md#revoke_user_permission) | **POST** /api/v2/user/{id}/revoke | Revokes a specific permission from user or service account
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /api/v2/user/{id} | Update user with given user groups, permissions and ingestion policy.
*UserApi* | [**validate_users**](docs/UserApi.md#validate_users) | **POST** /api/v2/user/validateUsers | Returns valid users and service accounts, also invalid identifiers from the given list
*UserGroupApi* | [**add_roles_to_user_group**](docs/UserGroupApi.md#add_roles_to_user_group) | **POST** /api/v2/usergroup/{id}/addRoles | Add multiple roles to a specific user group
*UserGroupApi* | [**add_users_to_user_group**](docs/UserGroupApi.md#add_users_to_user_group) | **POST** /api/v2/usergroup/{id}/addUsers | Add multiple users to a specific user group
*UserGroupApi* | [**create_user_group**](docs/UserGroupApi.md#create_user_group) | **POST** /api/v2/usergroup | Create a specific user group
*UserGroupApi* | [**delete_user_group**](docs/UserGroupApi.md#delete_user_group) | **DELETE** /api/v2/usergroup/{id} | Delete a specific user group
*UserGroupApi* | [**get_all_user_groups**](docs/UserGroupApi.md#get_all_user_groups) | **GET** /api/v2/usergroup | Get all user groups for a customer
*UserGroupApi* | [**get_user_group**](docs/UserGroupApi.md#get_user_group) | **GET** /api/v2/usergroup/{id} | Get a specific user group
*UserGroupApi* | [**remove_roles_from_user_group**](docs/UserGroupApi.md#remove_roles_from_user_group) | **POST** /api/v2/usergroup/{id}/removeRoles | Remove multiple roles from a specific user group
*UserGroupApi* | [**remove_users_from_user_group**](docs/UserGroupApi.md#remove_users_from_user_group) | **POST** /api/v2/usergroup/{id}/removeUsers | Remove multiple users from a specific user group
*UserGroupApi* | [**update_user_group**](docs/UserGroupApi.md#update_user_group) | **PUT** /api/v2/usergroup/{id} | Update a specific user group
*WebhookApi* | [**create_webhook**](docs/WebhookApi.md#create_webhook) | **POST** /api/v2/webhook | Create a specific webhook
*WebhookApi* | [**delete_webhook**](docs/WebhookApi.md#delete_webhook) | **DELETE** /api/v2/webhook/{id} | Delete a specific webhook
*WebhookApi* | [**get_all_webhooks**](docs/WebhookApi.md#get_all_webhooks) | **GET** /api/v2/webhook | Get all webhooks for a customer
*WebhookApi* | [**get_webhook**](docs/WebhookApi.md#get_webhook) | **GET** /api/v2/webhook/{id} | Get a specific webhook
*WebhookApi* | [**update_webhook**](docs/WebhookApi.md#update_webhook) | **PUT** /api/v2/webhook/{id} | Update a specific webhook


## Documentation For Models

 - [AWSBaseCredentials](docs/AWSBaseCredentials.md)
 - [AccessControlElement](docs/AccessControlElement.md)
 - [AccessControlListReadDTO](docs/AccessControlListReadDTO.md)
 - [AccessControlListSimple](docs/AccessControlListSimple.md)
 - [AccessControlListWriteDTO](docs/AccessControlListWriteDTO.md)
 - [AccessPolicy](docs/AccessPolicy.md)
 - [AccessPolicyRuleDTO](docs/AccessPolicyRuleDTO.md)
 - [Account](docs/Account.md)
 - [Alert](docs/Alert.md)
 - [AlertMin](docs/AlertMin.md)
 - [AlertRoute](docs/AlertRoute.md)
 - [Annotation](docs/Annotation.md)
 - [Anomaly](docs/Anomaly.md)
 - [AppDynamicsConfiguration](docs/AppDynamicsConfiguration.md)
 - [AzureActivityLogConfiguration](docs/AzureActivityLogConfiguration.md)
 - [AzureBaseCredentials](docs/AzureBaseCredentials.md)
 - [AzureConfiguration](docs/AzureConfiguration.md)
 - [Chart](docs/Chart.md)
 - [ChartSettings](docs/ChartSettings.md)
 - [ChartSourceQuery](docs/ChartSourceQuery.md)
 - [ClassLoader](docs/ClassLoader.md)
 - [CloudIntegration](docs/CloudIntegration.md)
 - [CloudTrailConfiguration](docs/CloudTrailConfiguration.md)
 - [CloudWatchConfiguration](docs/CloudWatchConfiguration.md)
 - [Conversion](docs/Conversion.md)
 - [ConversionObject](docs/ConversionObject.md)
 - [CustomerFacingUserObject](docs/CustomerFacingUserObject.md)
 - [Dashboard](docs/Dashboard.md)
 - [DashboardMin](docs/DashboardMin.md)
 - [DashboardParameterValue](docs/DashboardParameterValue.md)
 - [DashboardSection](docs/DashboardSection.md)
 - [DashboardSectionRow](docs/DashboardSectionRow.md)
 - [DerivedMetricDefinition](docs/DerivedMetricDefinition.md)
 - [EC2Configuration](docs/EC2Configuration.md)
 - [Event](docs/Event.md)
 - [EventSearchRequest](docs/EventSearchRequest.md)
 - [EventTimeRange](docs/EventTimeRange.md)
 - [ExternalLink](docs/ExternalLink.md)
 - [FacetResponse](docs/FacetResponse.md)
 - [FacetSearchRequestContainer](docs/FacetSearchRequestContainer.md)
 - [FacetsResponseContainer](docs/FacetsResponseContainer.md)
 - [FacetsSearchRequestContainer](docs/FacetsSearchRequestContainer.md)
 - [FastReaderBuilder](docs/FastReaderBuilder.md)
 - [Field](docs/Field.md)
 - [GCPBillingConfiguration](docs/GCPBillingConfiguration.md)
 - [GCPConfiguration](docs/GCPConfiguration.md)
 - [HistoryEntry](docs/HistoryEntry.md)
 - [HistoryResponse](docs/HistoryResponse.md)
 - [IngestionPolicy](docs/IngestionPolicy.md)
 - [IngestionPolicyMapping](docs/IngestionPolicyMapping.md)
 - [InstallAlerts](docs/InstallAlerts.md)
 - [Integration](docs/Integration.md)
 - [IntegrationAlert](docs/IntegrationAlert.md)
 - [IntegrationAlias](docs/IntegrationAlias.md)
 - [IntegrationDashboard](docs/IntegrationDashboard.md)
 - [IntegrationManifestGroup](docs/IntegrationManifestGroup.md)
 - [IntegrationMetrics](docs/IntegrationMetrics.md)
 - [IntegrationStatus](docs/IntegrationStatus.md)
 - [JsonNode](docs/JsonNode.md)
 - [KubernetesComponent](docs/KubernetesComponent.md)
 - [KubernetesComponentStatus](docs/KubernetesComponentStatus.md)
 - [LogicalType](docs/LogicalType.md)
 - [MaintenanceWindow](docs/MaintenanceWindow.md)
 - [Message](docs/Message.md)
 - [MetricDetails](docs/MetricDetails.md)
 - [MetricDetailsResponse](docs/MetricDetailsResponse.md)
 - [MetricStatus](docs/MetricStatus.md)
 - [MetricsPolicyReadModel](docs/MetricsPolicyReadModel.md)
 - [MetricsPolicyWriteModel](docs/MetricsPolicyWriteModel.md)
 - [Module](docs/Module.md)
 - [ModuleDescriptor](docs/ModuleDescriptor.md)
 - [ModuleLayer](docs/ModuleLayer.md)
 - [MonitoredApplicationDTO](docs/MonitoredApplicationDTO.md)
 - [MonitoredCluster](docs/MonitoredCluster.md)
 - [MonitoredServiceDTO](docs/MonitoredServiceDTO.md)
 - [NewRelicConfiguration](docs/NewRelicConfiguration.md)
 - [NewRelicMetricFilters](docs/NewRelicMetricFilters.md)
 - [Notificant](docs/Notificant.md)
 - [Package](docs/Package.md)
 - [Paged](docs/Paged.md)
 - [PagedAccount](docs/PagedAccount.md)
 - [PagedAlert](docs/PagedAlert.md)
 - [PagedAlertWithStats](docs/PagedAlertWithStats.md)
 - [PagedAnomaly](docs/PagedAnomaly.md)
 - [PagedCloudIntegration](docs/PagedCloudIntegration.md)
 - [PagedCustomerFacingUserObject](docs/PagedCustomerFacingUserObject.md)
 - [PagedDashboard](docs/PagedDashboard.md)
 - [PagedDerivedMetricDefinition](docs/PagedDerivedMetricDefinition.md)
 - [PagedDerivedMetricDefinitionWithStats](docs/PagedDerivedMetricDefinitionWithStats.md)
 - [PagedEvent](docs/PagedEvent.md)
 - [PagedExternalLink](docs/PagedExternalLink.md)
 - [PagedIngestionPolicy](docs/PagedIngestionPolicy.md)
 - [PagedIntegration](docs/PagedIntegration.md)
 - [PagedMaintenanceWindow](docs/PagedMaintenanceWindow.md)
 - [PagedMessage](docs/PagedMessage.md)
 - [PagedMonitoredApplicationDTO](docs/PagedMonitoredApplicationDTO.md)
 - [PagedMonitoredCluster](docs/PagedMonitoredCluster.md)
 - [PagedMonitoredServiceDTO](docs/PagedMonitoredServiceDTO.md)
 - [PagedNotificant](docs/PagedNotificant.md)
 - [PagedProxy](docs/PagedProxy.md)
 - [PagedRelatedEvent](docs/PagedRelatedEvent.md)
 - [PagedReportEventAnomalyDTO](docs/PagedReportEventAnomalyDTO.md)
 - [PagedRoleDTO](docs/PagedRoleDTO.md)
 - [PagedSavedSearch](docs/PagedSavedSearch.md)
 - [PagedServiceAccount](docs/PagedServiceAccount.md)
 - [PagedSource](docs/PagedSource.md)
 - [PagedUserGroupModel](docs/PagedUserGroupModel.md)
 - [Point](docs/Point.md)
 - [PolicyRuleReadModel](docs/PolicyRuleReadModel.md)
 - [PolicyRuleWriteModel](docs/PolicyRuleWriteModel.md)
 - [Proxy](docs/Proxy.md)
 - [QueryEvent](docs/QueryEvent.md)
 - [QueryResult](docs/QueryResult.md)
 - [QueryTypeDTO](docs/QueryTypeDTO.md)
 - [RawTimeseries](docs/RawTimeseries.md)
 - [RelatedAnomaly](docs/RelatedAnomaly.md)
 - [RelatedData](docs/RelatedData.md)
 - [RelatedEvent](docs/RelatedEvent.md)
 - [RelatedEventTimeRange](docs/RelatedEventTimeRange.md)
 - [ReportEventAnomalyDTO](docs/ReportEventAnomalyDTO.md)
 - [ResponseContainer](docs/ResponseContainer.md)
 - [ResponseContainerAccessPolicy](docs/ResponseContainerAccessPolicy.md)
 - [ResponseContainerAccessPolicyAction](docs/ResponseContainerAccessPolicyAction.md)
 - [ResponseContainerAccount](docs/ResponseContainerAccount.md)
 - [ResponseContainerAlert](docs/ResponseContainerAlert.md)
 - [ResponseContainerCloudIntegration](docs/ResponseContainerCloudIntegration.md)
 - [ResponseContainerDashboard](docs/ResponseContainerDashboard.md)
 - [ResponseContainerDerivedMetricDefinition](docs/ResponseContainerDerivedMetricDefinition.md)
 - [ResponseContainerEvent](docs/ResponseContainerEvent.md)
 - [ResponseContainerExternalLink](docs/ResponseContainerExternalLink.md)
 - [ResponseContainerFacetResponse](docs/ResponseContainerFacetResponse.md)
 - [ResponseContainerFacetsResponseContainer](docs/ResponseContainerFacetsResponseContainer.md)
 - [ResponseContainerHistoryResponse](docs/ResponseContainerHistoryResponse.md)
 - [ResponseContainerIngestionPolicy](docs/ResponseContainerIngestionPolicy.md)
 - [ResponseContainerIntegration](docs/ResponseContainerIntegration.md)
 - [ResponseContainerIntegrationStatus](docs/ResponseContainerIntegrationStatus.md)
 - [ResponseContainerListAccessControlListReadDTO](docs/ResponseContainerListAccessControlListReadDTO.md)
 - [ResponseContainerListIntegration](docs/ResponseContainerListIntegration.md)
 - [ResponseContainerListIntegrationManifestGroup](docs/ResponseContainerListIntegrationManifestGroup.md)
 - [ResponseContainerListServiceAccount](docs/ResponseContainerListServiceAccount.md)
 - [ResponseContainerListString](docs/ResponseContainerListString.md)
 - [ResponseContainerListUserApiToken](docs/ResponseContainerListUserApiToken.md)
 - [ResponseContainerMaintenanceWindow](docs/ResponseContainerMaintenanceWindow.md)
 - [ResponseContainerMapStringInteger](docs/ResponseContainerMapStringInteger.md)
 - [ResponseContainerMapStringIntegrationStatus](docs/ResponseContainerMapStringIntegrationStatus.md)
 - [ResponseContainerMessage](docs/ResponseContainerMessage.md)
 - [ResponseContainerMetricsPolicyReadModel](docs/ResponseContainerMetricsPolicyReadModel.md)
 - [ResponseContainerMonitoredApplicationDTO](docs/ResponseContainerMonitoredApplicationDTO.md)
 - [ResponseContainerMonitoredCluster](docs/ResponseContainerMonitoredCluster.md)
 - [ResponseContainerMonitoredServiceDTO](docs/ResponseContainerMonitoredServiceDTO.md)
 - [ResponseContainerNotificant](docs/ResponseContainerNotificant.md)
 - [ResponseContainerPagedAccount](docs/ResponseContainerPagedAccount.md)
 - [ResponseContainerPagedAlert](docs/ResponseContainerPagedAlert.md)
 - [ResponseContainerPagedAlertWithStats](docs/ResponseContainerPagedAlertWithStats.md)
 - [ResponseContainerPagedAnomaly](docs/ResponseContainerPagedAnomaly.md)
 - [ResponseContainerPagedCloudIntegration](docs/ResponseContainerPagedCloudIntegration.md)
 - [ResponseContainerPagedCustomerFacingUserObject](docs/ResponseContainerPagedCustomerFacingUserObject.md)
 - [ResponseContainerPagedDashboard](docs/ResponseContainerPagedDashboard.md)
 - [ResponseContainerPagedDerivedMetricDefinition](docs/ResponseContainerPagedDerivedMetricDefinition.md)
 - [ResponseContainerPagedDerivedMetricDefinitionWithStats](docs/ResponseContainerPagedDerivedMetricDefinitionWithStats.md)
 - [ResponseContainerPagedEvent](docs/ResponseContainerPagedEvent.md)
 - [ResponseContainerPagedExternalLink](docs/ResponseContainerPagedExternalLink.md)
 - [ResponseContainerPagedIngestionPolicy](docs/ResponseContainerPagedIngestionPolicy.md)
 - [ResponseContainerPagedIntegration](docs/ResponseContainerPagedIntegration.md)
 - [ResponseContainerPagedMaintenanceWindow](docs/ResponseContainerPagedMaintenanceWindow.md)
 - [ResponseContainerPagedMessage](docs/ResponseContainerPagedMessage.md)
 - [ResponseContainerPagedMonitoredApplicationDTO](docs/ResponseContainerPagedMonitoredApplicationDTO.md)
 - [ResponseContainerPagedMonitoredCluster](docs/ResponseContainerPagedMonitoredCluster.md)
 - [ResponseContainerPagedMonitoredServiceDTO](docs/ResponseContainerPagedMonitoredServiceDTO.md)
 - [ResponseContainerPagedNotificant](docs/ResponseContainerPagedNotificant.md)
 - [ResponseContainerPagedProxy](docs/ResponseContainerPagedProxy.md)
 - [ResponseContainerPagedRelatedEvent](docs/ResponseContainerPagedRelatedEvent.md)
 - [ResponseContainerPagedReportEventAnomalyDTO](docs/ResponseContainerPagedReportEventAnomalyDTO.md)
 - [ResponseContainerPagedRoleDTO](docs/ResponseContainerPagedRoleDTO.md)
 - [ResponseContainerPagedSavedSearch](docs/ResponseContainerPagedSavedSearch.md)
 - [ResponseContainerPagedServiceAccount](docs/ResponseContainerPagedServiceAccount.md)
 - [ResponseContainerPagedSource](docs/ResponseContainerPagedSource.md)
 - [ResponseContainerPagedUserGroupModel](docs/ResponseContainerPagedUserGroupModel.md)
 - [ResponseContainerProxy](docs/ResponseContainerProxy.md)
 - [ResponseContainerQueryTypeDTO](docs/ResponseContainerQueryTypeDTO.md)
 - [ResponseContainerRoleDTO](docs/ResponseContainerRoleDTO.md)
 - [ResponseContainerSavedSearch](docs/ResponseContainerSavedSearch.md)
 - [ResponseContainerServiceAccount](docs/ResponseContainerServiceAccount.md)
 - [ResponseContainerSetBusinessFunction](docs/ResponseContainerSetBusinessFunction.md)
 - [ResponseContainerSetSourceLabelPair](docs/ResponseContainerSetSourceLabelPair.md)
 - [ResponseContainerSource](docs/ResponseContainerSource.md)
 - [ResponseContainerString](docs/ResponseContainerString.md)
 - [ResponseContainerTagsResponse](docs/ResponseContainerTagsResponse.md)
 - [ResponseContainerUserApiToken](docs/ResponseContainerUserApiToken.md)
 - [ResponseContainerUserGroupModel](docs/ResponseContainerUserGroupModel.md)
 - [ResponseContainerValidatedUsersDTO](docs/ResponseContainerValidatedUsersDTO.md)
 - [ResponseStatus](docs/ResponseStatus.md)
 - [RoleDTO](docs/RoleDTO.md)
 - [SavedSearch](docs/SavedSearch.md)
 - [Schema](docs/Schema.md)
 - [SearchQuery](docs/SearchQuery.md)
 - [ServiceAccount](docs/ServiceAccount.md)
 - [ServiceAccountWrite](docs/ServiceAccountWrite.md)
 - [SortableSearchRequest](docs/SortableSearchRequest.md)
 - [Sorting](docs/Sorting.md)
 - [Source](docs/Source.md)
 - [SourceLabelPair](docs/SourceLabelPair.md)
 - [SourceSearchRequestContainer](docs/SourceSearchRequestContainer.md)
 - [Span](docs/Span.md)
 - [SpecificData](docs/SpecificData.md)
 - [StatsModelInternalUse](docs/StatsModelInternalUse.md)
 - [Stripe](docs/Stripe.md)
 - [TagsResponse](docs/TagsResponse.md)
 - [TargetInfo](docs/TargetInfo.md)
 - [TeslaConfiguration](docs/TeslaConfiguration.md)
 - [Timeseries](docs/Timeseries.md)
 - [Trace](docs/Trace.md)
 - [TriageDashboard](docs/TriageDashboard.md)
 - [Tuple](docs/Tuple.md)
 - [TupleResult](docs/TupleResult.md)
 - [TupleValueResult](docs/TupleValueResult.md)
 - [UserApiToken](docs/UserApiToken.md)
 - [UserDTO](docs/UserDTO.md)
 - [UserGroup](docs/UserGroup.md)
 - [UserGroupModel](docs/UserGroupModel.md)
 - [UserGroupPropertiesDTO](docs/UserGroupPropertiesDTO.md)
 - [UserGroupWrite](docs/UserGroupWrite.md)
 - [UserModel](docs/UserModel.md)
 - [UserRequestDTO](docs/UserRequestDTO.md)
 - [UserToCreate](docs/UserToCreate.md)
 - [ValidatedUsersDTO](docs/ValidatedUsersDTO.md)
 - [WFTags](docs/WFTags.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: X-AUTH-TOKEN
- **Location**: HTTP header


## Author

chitimba@wavefront.com

