from sqlalchemy import Column, JSON, String, BigInteger, DateTime, MetaData, create_engine, Boolean,FLOAT
from sqlalchemy.orm import declarative_base

db = create_engine('mysql+pymysql://root:secret@db/lucas')
metadata = MetaData(db)
Base = declarative_base(metadata=metadata)

class Call(Base):
    __tablename__ = 'calls'
    id = Column(BigInteger, primary_key=True)
    tenant_id = Column(String(70))
    account_sid = Column(String(70), nullable=True)
    sid = Column(String(70))
    user_id = Column(String(70),nullable=True)
    appointment_setter_id = Column(String(70),nullable=True)
    receiver_id = Column(String(70),nullable=True)
    opportunity_id = Column(BigInteger, nullable=True)
    recording_sid = Column(String(40), nullable=True)
    recording_duration = Column(FLOAT, default=0)
    conference_sid = Column(String(40), nullable=True)
    last_status = Column(String(20), nullable=True)
    direction = Column(String(20), nullable=True)
    from_ = Column(String(255), nullable=True)
    to = Column(String(255), nullable=True)
    start = Column(DateTime, nullable=True)
    end = Column(DateTime, nullable=True)
    task = Column(Boolean, default=False)
    task_sid = Column(String(40), nullable=True)
    start_leg = Column(Boolean, default=False)
    recorded = Column(Boolean, default=False)
    conference_moderator = Column(Boolean, default=False)
    conference_name = Column(String(40), nullable=True)
    listening = Column(Boolean, default=False)
    recording_url = Column(String(255), nullable=True)
    recording_migrated = Column(Boolean, default=False)
    transcribed = Column(Boolean, default=False)
    transcribing = Column(Boolean, default=False)
    transferred = Column(Boolean, default=False)
    called_state = Column(String(20), nullable=True)
    called_zip = Column(String(20), nullable=True)
    called_country = Column(String(20), nullable=True)
    called_city = Column(String(20), nullable=True)
    caller_id = Column(BigInteger, nullable=True)
    caller_state = Column(String(20), nullable=True)
    caller_zip = Column(String(20), nullable=True)
    caller_country = Column(String(20), nullable=True)
    caller_city = Column(String(20), nullable=True)
    coaching = Column(Boolean, default=False)
    payload = Column(JSON)
    metadata_ = Column(JSON)