# vrt_lss_routing
Veeroute Routing API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.10.176314
- Package version: 3.10.176314
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_routing
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_routing
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import vrt_lss_routing
from vrt_lss_routing.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.veeroute.tech/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_lss_routing.Configuration(
    host = "https://api.veeroute.tech/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_lss_routing.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_lss_routing.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vrt_lss_routing.MatrixApi(api_client)
    matrix_task = vrt_lss_routing.MatrixTask() # MatrixTask | New request for matrix calculation.

    try:
        # Creating a time-distance matrix.
        api_response = api_instance.build_matrix(matrix_task)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling MatrixApi->build_matrix: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MatrixApi* | [**build_matrix**](docs/MatrixApi.md#build_matrix) | **POST** /routing/matrix | Creating a time-distance matrix.
*RouteApi* | [**build_route**](docs/RouteApi.md#build_route) | **POST** /routing/route | Planning a location-to-location route.
*SystemApi* | [**check**](docs/SystemApi.md#check) | **GET** /routing/check | Checking the service availability.
*SystemApi* | [**version**](docs/SystemApi.md#version) | **GET** /routing/version | Getting the service version.


## Documentation For Models

 - [CheckResult](docs/CheckResult.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse400Validations](docs/InlineResponse400Validations.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse406](docs/InlineResponse406.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [MatrixResult](docs/MatrixResult.md)
 - [MatrixTask](docs/MatrixTask.md)
 - [Route](docs/Route.md)
 - [RouteLeg](docs/RouteLeg.md)
 - [RoutePolyline](docs/RoutePolyline.md)
 - [RouteResult](docs/RouteResult.md)
 - [RouteStatistics](docs/RouteStatistics.md)
 - [RouteStatisticsTimeWindow](docs/RouteStatisticsTimeWindow.md)
 - [RouteStep](docs/RouteStep.md)
 - [RouteTask](docs/RouteTask.md)
 - [RoutingMatrix](docs/RoutingMatrix.md)
 - [TraceData](docs/TraceData.md)
 - [TransportType](docs/TransportType.md)
 - [VersionResult](docs/VersionResult.md)
 - [Waypoint](docs/Waypoint.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


