import json
from decimal import Decimal as D


class Allocations(object):

    def __init__(self, initial_data=None):
        self._allocations = initial_data or {}

    def add(self, code, amount):
        if self.contains(code):
            self._allocations[code] += amount
        else:
            self._allocations[code] = amount

    def remove(self, code):
        if self.contains(code):
            del self._allocations[code]

    @property
    def total(self):
        total = D('0.00')
        for allocation in self._allocations.values():
            total += allocation
        return total

    def contains(self, code):
        return code in self._allocations

    def __len__(self):
        return len(self._allocations)

    def items(self):
        return self._allocations.items()

    @classmethod
    def serialize(cls, obj):
        """
        Return a JSON-serialized string representing the object.
        """
        data = {}
        for k, v in obj.items():
            data[k] = str(v)

        return json.dumps(data, sort_keys=True)

    @classmethod
    def deserialize(cls, json_data):
        """
        Parse JSON-serialized string generated by Allocations.serialize and
        return an Allocations object.
        """
        data = json.loads(json_data)
        # Convert string numerals to Decimal
        for k in data:
            data[k] = D(data[k])

        return cls(data)
