"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.DetailType = exports.PipelineEvent = exports.ApplicationEvent = exports.ProjectEvent = exports.RepositoryEvent = exports.ApplicationNotificationRule = exports.ProjectNotificationRule = exports.PipelineNotificationRule = exports.RepositoryNotificationRule = exports.NotificationRule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codestarnotifications_1 = require("@aws-cdk/aws-codestarnotifications");
const core_1 = require("@aws-cdk/core");
class NotificationRule extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.targets = new Array();
        for (const target of props.targets || []) {
            this.addTarget(target);
        }
        const notificationRule = new aws_codestarnotifications_1.CfnNotificationRule(this, 'NotificationRule', {
            name: props.name,
            status: props.status || Status.ENABLED,
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: props.events,
            resource: props.resource,
        });
        this.notificationRuleArn = notificationRule.ref;
    }
    addTarget(target) {
        this.targets.push(target.bind(this, this));
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        if (this.targets.length === 0) {
            return ['Notification rule must have a target'];
        }
        return [];
    }
}
exports.NotificationRule = NotificationRule;
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.NotificationRule", version: "1.28.0" };
class RepositoryNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.repository.repositoryArn,
        });
    }
}
exports.RepositoryNotificationRule = RepositoryNotificationRule;
_b = JSII_RTTI_SYMBOL_1;
RepositoryNotificationRule[_b] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.RepositoryNotificationRule", version: "1.28.0" };
class PipelineNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.pipeline.pipelineArn,
        });
    }
}
exports.PipelineNotificationRule = PipelineNotificationRule;
_c = JSII_RTTI_SYMBOL_1;
PipelineNotificationRule[_c] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.PipelineNotificationRule", version: "1.28.0" };
class ProjectNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.project.projectArn,
        });
    }
}
exports.ProjectNotificationRule = ProjectNotificationRule;
_d = JSII_RTTI_SYMBOL_1;
ProjectNotificationRule[_d] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.ProjectNotificationRule", version: "1.28.0" };
class ApplicationNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.application.applicationArn,
        });
    }
}
exports.ApplicationNotificationRule = ApplicationNotificationRule;
_e = JSII_RTTI_SYMBOL_1;
ApplicationNotificationRule[_e] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.ApplicationNotificationRule", version: "1.28.0" };
var RepositoryEvent;
(function (RepositoryEvent) {
    RepositoryEvent["COMMENTS_ON_COMMITS"] = "codecommit-repository-comments-on-commits";
    RepositoryEvent["COMMENTS_ON_PULL_REQUEST"] = "codecommit-repository-comments-on-pull-requests";
    RepositoryEvent["APPROVAL_STATUS_CHANGED"] = "codecommit-repository-approvals-status-changed";
    RepositoryEvent["APPROVAL_RULE_OVERRIDE"] = "codecommit-repository-approvals-rule-override";
    RepositoryEvent["PULL_REQUEST_CREATED"] = "codecommit-repository-pull-request-created";
    RepositoryEvent["PULL_REQUEST_SOURCE_UPDATED"] = "codecommit-repository-pull-request-source-updated";
    RepositoryEvent["PULL_REQUEST_STATUS_CHANGED"] = "codecommit-repository-pull-request-status-changed";
    RepositoryEvent["PULL_REQUEST_MERGED"] = "codecommit-repository-pull-request-merged";
    RepositoryEvent["BRANCHES_AND_TAGS_CREATED"] = "codecommit-repository-branches-and-tags-created";
    RepositoryEvent["BRANCHES_AND_TAGS_DELETED"] = "codecommit-repository-branches-and-tags-deleted";
    RepositoryEvent["BRANCHES_AND_TAGS_UPDATED"] = "codecommit-repository-branches-and-tags-updated";
})(RepositoryEvent = exports.RepositoryEvent || (exports.RepositoryEvent = {}));
var ProjectEvent;
(function (ProjectEvent) {
    ProjectEvent["BUILD_STATE_FAILED"] = "codebuild-project-build-state-failed";
    ProjectEvent["BUILD_STATE_SUCCEEDED"] = "codebuild-project-build-state-succeeded";
    ProjectEvent["BUILD_STATE_IN_PROGRESS"] = "codebuild-project-build-state-in-progress";
    ProjectEvent["BUILD_STATE_STOPPED"] = "codebuild-project-build-state-stopped";
    ProjectEvent["BUILD_PHASE_FAILURE"] = "codebuild-project-build-phase-failure";
    ProjectEvent["BUILD_PHASE_SUCCESS"] = "codebuild-project-build-phase-success";
})(ProjectEvent = exports.ProjectEvent || (exports.ProjectEvent = {}));
var ApplicationEvent;
(function (ApplicationEvent) {
    ApplicationEvent["DEPLOYMENT_FAILED"] = "codedeploy-application-deployment-failed";
    ApplicationEvent["DEPLOYMENT_SUCCEEDED"] = "codedeploy-application-deployment-succeeded";
    ApplicationEvent["DEPLOYMENT_STARTED"] = "codedeploy-application-deployment-started";
})(ApplicationEvent = exports.ApplicationEvent || (exports.ApplicationEvent = {}));
var PipelineEvent;
(function (PipelineEvent) {
    PipelineEvent["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    PipelineEvent["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    PipelineEvent["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    PipelineEvent["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    PipelineEvent["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    PipelineEvent["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    PipelineEvent["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    PipelineEvent["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    PipelineEvent["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    PipelineEvent["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    PipelineEvent["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    PipelineEvent["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    PipelineEvent["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    PipelineEvent["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    PipelineEvent["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    PipelineEvent["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineEvent = exports.PipelineEvent || (exports.PipelineEvent = {}));
var DetailType;
(function (DetailType) {
    DetailType["FULL"] = "FULL";
    DetailType["BASIC"] = "BASIC";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
var Status;
(function (Status) {
    Status["DISABLED"] = "DISABLED";
    Status["ENABLED"] = "ENABLED";
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=data:application/json;base64,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