# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

Veil is a Python library for masking sensitive data (PII) - emails, phones, names, and more. The library is in early development stage.

## Project Setup

This project uses Python 3.11+ with a virtual environment:
- Virtual environment: `.venv/` (already created)
- License: MIT
- Python environment management appears to use standard venv

## Expected Architecture

Since this is a PII masking library, the typical structure should include:
- Core masking functions for different data types (email, phone, names, etc.)
- Pattern detection/recognition for identifying PII in text
- Configurable masking strategies (partial masking, full masking, tokenization)
- Support for different locales/regions (phone formats, name patterns vary by country)

## Development Guidelines

### PII Masking Considerations
- Ensure masking is irreversible unless explicitly designed for reversible tokenization
- Support both in-place masking and returning masked copies
- Consider performance for large-scale text processing
- Handle edge cases (malformed emails, international phone formats, etc.)
- Provide clear documentation about what constitutes "masked" vs "anonymized" data

### Testing Requirements
- Test with diverse PII formats across different locales
- Include negative tests (text without PII should remain unchanged)
- Test performance with large inputs
- Verify no PII leakage in edge cases

### Security Considerations
- Never log or expose unmasked PII during processing
- Ensure no PII appears in error messages or stack traces
- If implementing reversible masking, secure the key management

### Project Structure

veil/
├── veil/                      # 메인 패키지 (내용 비움)
│   ├── __init__.py           # __version__ = "0.1.0"만 유지
│   ├── masker.py             # docstring만 유지
│   ├── patterns.py           # docstring만 유지
│   └── utils.py              # docstring만 유지
├── tests/                     # 테스트 (내용 비움)
│   ├── __init__.py
│   ├── test_masker.py
│   ├── test_patterns.py
│   └── test_utils.py
├── examples/                  # 예제 (내용 비움)
│   └── basic_usage.py
├── docs/
│   └── README.md
├── pyproject.toml            # PyPI 설정 유지
├── setup.py                  # 호환성 파일 유지
├── MANIFEST.in               # 배포 설정 유지
├── README.md                 # 프로젝트 README 유지
├── LICENSE                   # MIT 라이선스 유지
├── CLAUDE.md                 # AI 가이드 유지
└── .gitignore               # Git 설정 유지