"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const SecretsManager = require("aws-sdk/clients/secretsmanager");
const redshift_data_1 = require("./redshift-data");
const util_1 = require("./util");
const secretsManager = new SecretsManager();
async function handler(props, event) {
    const username = props.username;
    const passwordSecretArn = props.passwordSecretArn;
    const clusterProps = props;
    if (event.RequestType === 'Create') {
        await createUser(username, passwordSecretArn, clusterProps);
        return { PhysicalResourceId: util_1.makePhysicalId(username, clusterProps, event.RequestId), Data: { username: username } };
    }
    else if (event.RequestType === 'Delete') {
        await dropUser(username, clusterProps);
        return;
    }
    else if (event.RequestType === 'Update') {
        const { replace } = await updateUser(username, passwordSecretArn, clusterProps, event.OldResourceProperties);
        const physicalId = replace ? util_1.makePhysicalId(username, clusterProps, event.RequestId) : event.PhysicalResourceId;
        return { PhysicalResourceId: physicalId, Data: { username: username } };
    }
    else {
        /* eslint-disable-next-line dot-notation */
        throw new Error(`Unrecognized event type: ${event['RequestType']}`);
    }
}
exports.handler = handler;
async function dropUser(username, clusterProps) {
    await redshift_data_1.executeStatement(`DROP USER ${username}`, clusterProps);
}
async function createUser(username, passwordSecretArn, clusterProps) {
    const password = await getPasswordFromSecret(passwordSecretArn);
    await redshift_data_1.executeStatement(`CREATE USER ${username} PASSWORD '${password}'`, clusterProps);
}
async function updateUser(username, passwordSecretArn, clusterProps, oldResourceProperties) {
    const oldClusterProps = oldResourceProperties;
    if (clusterProps.clusterName !== oldClusterProps.clusterName || clusterProps.databaseName !== oldClusterProps.databaseName) {
        await createUser(username, passwordSecretArn, clusterProps);
        return { replace: true };
    }
    const oldUsername = oldResourceProperties.username;
    const oldPasswordSecretArn = oldResourceProperties.passwordSecretArn;
    const oldPassword = await getPasswordFromSecret(oldPasswordSecretArn);
    const password = await getPasswordFromSecret(passwordSecretArn);
    if (username !== oldUsername) {
        await createUser(username, passwordSecretArn, clusterProps);
        return { replace: true };
    }
    if (password !== oldPassword) {
        await redshift_data_1.executeStatement(`ALTER USER ${username} PASSWORD '${password}'`, clusterProps);
        return { replace: false };
    }
    return { replace: false };
}
async function getPasswordFromSecret(passwordSecretArn) {
    const secretValue = await secretsManager.getSecretValue({
        SecretId: passwordSecretArn,
    }).promise();
    const secretString = secretValue.SecretString;
    if (!secretString) {
        throw new Error(`Secret string for ${passwordSecretArn} was empty`);
    }
    const { password } = JSON.parse(secretString);
    return password;
}
//# sourceMappingURL=data:application/json;base64,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