"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
const redshift = new aws_sdk_1.Redshift();
async function handler(event) {
    if (event.RequestType !== 'Delete') {
        return rebootClusterIfRequired(event.ResourceProperties?.ClusterId, event.ResourceProperties?.ParameterGroupName);
    }
    else {
        return;
    }
}
exports.handler = handler;
async function rebootClusterIfRequired(clusterId, parameterGroupName) {
    return executeActionForStatus(await getApplyStatus());
    // https://docs.aws.amazon.com/redshift/latest/APIReference/API_ClusterParameterStatus.html
    async function executeActionForStatus(status, retryDurationMs) {
        await sleep(retryDurationMs ?? 0);
        if (['pending-reboot', 'apply-deferred', 'apply-error'].includes(status)) {
            try {
                await redshift.rebootCluster({ ClusterIdentifier: clusterId }).promise();
            }
            catch (err) {
                if (err.code === 'InvalidClusterState') {
                    return await executeActionForStatus(status, 30000);
                }
                else {
                    throw err;
                }
            }
            return;
        }
        else if (['applying', 'retry'].includes(status)) {
            return executeActionForStatus(await getApplyStatus(), 30000);
        }
        return;
    }
    async function getApplyStatus() {
        const clusterDetails = await redshift.describeClusters({ ClusterIdentifier: clusterId }).promise();
        if (clusterDetails.Clusters?.[0].ClusterParameterGroups === undefined) {
            throw new Error(`Unable to find any Parameter Groups associated with ClusterId "${clusterId}".`);
        }
        for (const group of clusterDetails.Clusters?.[0].ClusterParameterGroups) {
            if (group.ParameterGroupName === parameterGroupName) {
                return group.ParameterApplyStatus ?? 'retry';
            }
        }
        throw new Error(`Unable to find Parameter Group named "${parameterGroupName}" associated with ClusterId "${clusterId}".`);
    }
}
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
//# sourceMappingURL=data:application/json;base64,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