# coding: utf-8

"""
    Influx API Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from influxdb_client.api_client import ApiClient


class ScraperTargetsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_scrapers_id(self, scraper_target_id, **kwargs):  # noqa: E501
        """Delete a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501
        """Delete a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scrapers_id_labels_id(self, scraper_target_id, label_id, **kwargs):  # noqa: E501
        """Delete a label from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_labels_id(scraper_target_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_labels_id_with_http_info(self, scraper_target_id, label_id, **kwargs):  # noqa: E501
        """Delete a label from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'label_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_scrapers_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scrapers_id_members_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501
        """Remove a member from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_members_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501
        """Remove a member from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scrapers_id_owners_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501
        """Remove an owner from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_owners_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501
        """Remove an owner from a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scrapers(self, **kwargs):  # noqa: E501
        """Get all scraper targets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: Specifies the name of the scraper target.
        :param list[str] id: List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: Specifies the organization ID of the scraper target.
        :param str org: Specifies the organization name of the scraper target.
        :return: ScraperTargetResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_scrapers_with_http_info(self, **kwargs):  # noqa: E501
        """Get all scraper targets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: Specifies the name of the scraper target.
        :param list[str] id: List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: Specifies the organization ID of the scraper target.
        :param str org: Specifies the organization name of the scraper target.
        :return: ScraperTargetResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['zap_trace_span', 'name', 'id', 'org_id', 'org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'multi'  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScraperTargetResponses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scrapers_id(self, scraper_target_id, **kwargs):  # noqa: E501
        """Get a scraper target by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501
        """Get a scraper target by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scrapers_id_labels(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all labels for a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_labels(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_labels_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_labels_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_labels_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all labels for a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_labels_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scrapers_id_members(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all users with member privileges for a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_members_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all users with member privileges for a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scrapers_id_owners(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all owners of a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_owners_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501
        """List all owners of a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_scrapers_id(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501
        """Update a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id(scraper_target_id, scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param ScraperTargetRequest scraper_target_request: Scraper target update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, **kwargs)  # noqa: E501
            return data

    def patch_scrapers_id_with_http_info(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501
        """Update a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param ScraperTargetRequest scraper_target_request: Scraper target update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'scraper_target_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_scrapers_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `patch_scrapers_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_request' is set
        if ('scraper_target_request' not in local_var_params or
                local_var_params['scraper_target_request'] is None):
            raise ValueError("Missing the required parameter `scraper_target_request` when calling `patch_scrapers_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'scraper_target_request' in local_var_params:
            body_params = local_var_params['scraper_target_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_scrapers_id_labels_id(self, scraper_target_id, label_id, label, **kwargs):  # noqa: E501
        """Update a label on a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id_labels_id(scraper_target_id, label_id, label, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param Label label: Label update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, label, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, label, **kwargs)  # noqa: E501
            return data

    def patch_scrapers_id_labels_id_with_http_info(self, scraper_target_id, label_id, label, **kwargs):  # noqa: E501
        """Update a label on a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, label, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param Label label: Label update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'label_id', 'label', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_scrapers_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `patch_scrapers_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `patch_scrapers_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label' is set
        if ('label' not in local_var_params or
                local_var_params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `patch_scrapers_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label' in local_var_params:
            body_params = local_var_params['label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels/{labelID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_scrapers(self, scraper_target_request, **kwargs):  # noqa: E501
        """Create a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers(scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScraperTargetRequest scraper_target_request: Scraper target to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_with_http_info(scraper_target_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_with_http_info(scraper_target_request, **kwargs)  # noqa: E501
            return data

    def post_scrapers_with_http_info(self, scraper_target_request, **kwargs):  # noqa: E501
        """Create a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_with_http_info(scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScraperTargetRequest scraper_target_request: Scraper target to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_request' is set
        if ('scraper_target_request' not in local_var_params or
                local_var_params['scraper_target_request'] is None):
            raise ValueError("Missing the required parameter `scraper_target_request` when calling `post_scrapers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'scraper_target_request' in local_var_params:
            body_params = local_var_params['scraper_target_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_scrapers_id_labels(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501
        """Add a label to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_labels(scraper_target_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_labels_with_http_info(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501
        """Add a label to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_scrapers_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_scrapers_id_members(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add a member to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_members_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add a member to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_scrapers_id_owners(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add an owner to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_owners_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add an owner to a scraper target  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
