"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-1 --password pass1234 \
 *   --user-attributes Name="phone_number",Value="<valid-phone-number-with-intl-extension>"
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-2 --password pass1234 \
 *   --user-attributes Name="email",Value="<valid-email-address>"
 * * An email with the message 'integ-test: Account verification code is <code>' should be received.
 * * An SMS with the message 'integ-test: Account verification code is <code>' should be received.
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-signup-code');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    autoVerify: {
        email: true,
        phone: true,
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailStyle: lib_1.VerificationEmailStyle.CODE,
        emailSubject: 'integ-test: Verify your account',
        emailBody: 'integ-test: Account verification code is {####}',
        smsMessage: 'integ-test: Account verification code is {####}',
    },
    passwordPolicy: {
        requireUppercase: false,
        requireLowercase: false,
        requireDigits: false,
        requireSymbols: false,
    },
});
const client = new lib_1.UserPoolClient(stack, 'myuserpoolclient', {
    userPool: userpool,
    userPoolClientName: 'signup-test',
    generateSecret: false,
});
new core_1.CfnOutput(stack, 'user-pool-id', {
    value: userpool.userPoolId,
});
new core_1.CfnOutput(stack, 'client-id', {
    value: client.userPoolClientId,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLXNpZ251cC1jb2RlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcudXNlci1wb29sLXNpZ251cC1jb2RlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXNEO0FBQ3RELGdDQUEwRTtBQUUxRTs7Ozs7Ozs7R0FRRztBQUVILE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLDZCQUE2QixDQUFDLENBQUM7QUFFNUQsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtJQUNqRCxZQUFZLEVBQUUsWUFBWTtJQUMxQixVQUFVLEVBQUU7UUFDVixLQUFLLEVBQUUsSUFBSTtRQUNYLEtBQUssRUFBRSxJQUFJO0tBQ1o7SUFDRCxpQkFBaUIsRUFBRSxJQUFJO0lBQ3ZCLGdCQUFnQixFQUFFO1FBQ2hCLFVBQVUsRUFBRSw0QkFBc0IsQ0FBQyxJQUFJO1FBQ3ZDLFlBQVksRUFBRSxpQ0FBaUM7UUFDL0MsU0FBUyxFQUFFLGlEQUFpRDtRQUM1RCxVQUFVLEVBQUUsaURBQWlEO0tBQzlEO0lBQ0QsY0FBYyxFQUFFO1FBQ2QsZ0JBQWdCLEVBQUUsS0FBSztRQUN2QixnQkFBZ0IsRUFBRSxLQUFLO1FBQ3ZCLGFBQWEsRUFBRSxLQUFLO1FBQ3BCLGNBQWMsRUFBRSxLQUFLO0tBQ3RCO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsTUFBTSxNQUFNLEdBQUcsSUFBSSxvQkFBYyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRTtJQUMzRCxRQUFRLEVBQUUsUUFBUTtJQUNsQixrQkFBa0IsRUFBRSxhQUFhO0lBQ2pDLGNBQWMsRUFBRSxLQUFLO0NBQ3RCLENBQUMsQ0FBQztBQUVILElBQUksZ0JBQVMsQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQ25DLEtBQUssRUFBRSxRQUFRLENBQUMsVUFBVTtDQUMzQixDQUFDLENBQUM7QUFFSCxJQUFJLGdCQUFTLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtJQUNoQyxLQUFLLEVBQUUsTUFBTSxDQUFDLGdCQUFnQjtDQUMvQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHAsIENmbk91dHB1dCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFVzZXJQb29sLCBVc2VyUG9vbENsaWVudCwgVmVyaWZpY2F0aW9uRW1haWxTdHlsZSB9IGZyb20gJy4uL2xpYic7XG5cbi8qXG4gKiBTdGFjayB2ZXJpZmljYXRpb24gc3RlcHM6XG4gKiAqIGBhd3MgY29nbml0by1pZHAgc2lnbi11cCAtLWNsaWVudC1pZCA8Y2Zub3V0cHV0LWNsaWVudC1pZD4gLS11c2VybmFtZSB1c2VyLTEgLS1wYXNzd29yZCBwYXNzMTIzNCBcXFxuICogICAtLXVzZXItYXR0cmlidXRlcyBOYW1lPVwicGhvbmVfbnVtYmVyXCIsVmFsdWU9XCI8dmFsaWQtcGhvbmUtbnVtYmVyLXdpdGgtaW50bC1leHRlbnNpb24+XCJcbiAqICogYGF3cyBjb2duaXRvLWlkcCBzaWduLXVwIC0tY2xpZW50LWlkIDxjZm5vdXRwdXQtY2xpZW50LWlkPiAtLXVzZXJuYW1lIHVzZXItMiAtLXBhc3N3b3JkIHBhc3MxMjM0IFxcXG4gKiAgIC0tdXNlci1hdHRyaWJ1dGVzIE5hbWU9XCJlbWFpbFwiLFZhbHVlPVwiPHZhbGlkLWVtYWlsLWFkZHJlc3M+XCJcbiAqICogQW4gZW1haWwgd2l0aCB0aGUgbWVzc2FnZSAnaW50ZWctdGVzdDogQWNjb3VudCB2ZXJpZmljYXRpb24gY29kZSBpcyA8Y29kZT4nIHNob3VsZCBiZSByZWNlaXZlZC5cbiAqICogQW4gU01TIHdpdGggdGhlIG1lc3NhZ2UgJ2ludGVnLXRlc3Q6IEFjY291bnQgdmVyaWZpY2F0aW9uIGNvZGUgaXMgPGNvZGU+JyBzaG91bGQgYmUgcmVjZWl2ZWQuXG4gKi9cblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnaW50ZWctdXNlci1wb29sLXNpZ251cC1jb2RlJyk7XG5cbmNvbnN0IHVzZXJwb29sID0gbmV3IFVzZXJQb29sKHN0YWNrLCAnbXl1c2VycG9vbCcsIHtcbiAgdXNlclBvb2xOYW1lOiAnTXlVc2VyUG9vbCcsXG4gIGF1dG9WZXJpZnk6IHtcbiAgICBlbWFpbDogdHJ1ZSxcbiAgICBwaG9uZTogdHJ1ZSxcbiAgfSxcbiAgc2VsZlNpZ25VcEVuYWJsZWQ6IHRydWUsXG4gIHVzZXJWZXJpZmljYXRpb246IHtcbiAgICBlbWFpbFN0eWxlOiBWZXJpZmljYXRpb25FbWFpbFN0eWxlLkNPREUsXG4gICAgZW1haWxTdWJqZWN0OiAnaW50ZWctdGVzdDogVmVyaWZ5IHlvdXIgYWNjb3VudCcsXG4gICAgZW1haWxCb2R5OiAnaW50ZWctdGVzdDogQWNjb3VudCB2ZXJpZmljYXRpb24gY29kZSBpcyB7IyMjI30nLFxuICAgIHNtc01lc3NhZ2U6ICdpbnRlZy10ZXN0OiBBY2NvdW50IHZlcmlmaWNhdGlvbiBjb2RlIGlzIHsjIyMjfScsXG4gIH0sXG4gIHBhc3N3b3JkUG9saWN5OiB7XG4gICAgcmVxdWlyZVVwcGVyY2FzZTogZmFsc2UsXG4gICAgcmVxdWlyZUxvd2VyY2FzZTogZmFsc2UsXG4gICAgcmVxdWlyZURpZ2l0czogZmFsc2UsXG4gICAgcmVxdWlyZVN5bWJvbHM6IGZhbHNlLFxuICB9LFxufSk7XG5cbmNvbnN0IGNsaWVudCA9IG5ldyBVc2VyUG9vbENsaWVudChzdGFjaywgJ215dXNlcnBvb2xjbGllbnQnLCB7XG4gIHVzZXJQb29sOiB1c2VycG9vbCxcbiAgdXNlclBvb2xDbGllbnROYW1lOiAnc2lnbnVwLXRlc3QnLFxuICBnZW5lcmF0ZVNlY3JldDogZmFsc2UsXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ3VzZXItcG9vbC1pZCcsIHtcbiAgdmFsdWU6IHVzZXJwb29sLnVzZXJQb29sSWQsXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ2NsaWVudC1pZCcsIHtcbiAgdmFsdWU6IGNsaWVudC51c2VyUG9vbENsaWVudElkLFxufSk7Il19