"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps
 * * Visit the URL provided by stack output 'SignInLink' in a browser, and verify the 'Login with Amazon' link shows up.
 * * If you plug in valid 'Login with Amazon' credentials, the federated log in should work.
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-idp');
const userpool = new lib_1.UserPool(stack, 'pool');
new lib_1.UserPoolIdentityProviderAmazon(stack, 'amazon', {
    userPool: userpool,
    clientId: 'amzn-client-id',
    clientSecret: 'amzn-client-secret',
    attributeMapping: {
        givenName: lib_1.ProviderAttribute.AMAZON_NAME,
        email: lib_1.ProviderAttribute.AMAZON_EMAIL,
        custom: {
            userId: lib_1.ProviderAttribute.AMAZON_USER_ID,
        },
    },
});
const client = userpool.addClient('client');
const domain = userpool.addDomain('domain', {
    cognitoDomain: {
        domainPrefix: 'nija-test-pool',
    },
});
new core_1.CfnOutput(stack, 'SignInLink', {
    value: domain.signInUrl(client, {
        redirectUri: 'https://example.com',
    }),
});
//# sourceMappingURL=data:application/json;base64,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