"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * Verify that the CloudFrontDistribution stack output is of the format 'xxxxxxxxxxxxxx.cloudfront.net'
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-domain-cfdist');
const userpool = new lib_1.UserPool(stack, 'UserPool');
const domain = userpool.addDomain('Domain', {
    cognitoDomain: {
        domainPrefix: 'cdk-integ-user-pool-domain',
    },
});
new core_1.CfnOutput(stack, 'Domain', {
    value: domain.domainName,
});
new core_1.CfnOutput(stack, 'CloudFrontDomainName', {
    value: domain.cloudFrontDomainName,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLWRvbWFpbi1jZmRpc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy51c2VyLXBvb2wtZG9tYWluLWNmZGlzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG1DQUFtQztBQUNuQyx3Q0FBc0Q7QUFDdEQsZ0NBQWtDO0FBRWxDOzs7R0FHRztBQUVILE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLCtCQUErQixDQUFDLENBQUM7QUFFOUQsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBRWpELE1BQU0sTUFBTSxHQUFHLFFBQVEsQ0FBQyxTQUFTLENBQUMsUUFBUSxFQUFFO0lBQzFDLGFBQWEsRUFBRTtRQUNiLFlBQVksRUFBRSw0QkFBNEI7S0FDM0M7Q0FDRixDQUFDLENBQUM7QUFFSCxJQUFJLGdCQUFTLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtJQUM3QixLQUFLLEVBQUUsTUFBTSxDQUFDLFVBQVU7Q0FDekIsQ0FBQyxDQUFDO0FBRUgsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRTtJQUMzQyxLQUFLLEVBQUUsTUFBTSxDQUFDLG9CQUFvQjtDQUNuQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy8gIWNkay1pbnRlZyBwcmFnbWE6aWdub3JlLWFzc2V0c1xuaW1wb3J0IHsgQXBwLCBDZm5PdXRwdXQsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBVc2VyUG9vbCB9IGZyb20gJy4uL2xpYic7XG5cbi8qXG4gKiBTdGFjayB2ZXJpZmljYXRpb24gc3RlcHM6XG4gKiAqIFZlcmlmeSB0aGF0IHRoZSBDbG91ZEZyb250RGlzdHJpYnV0aW9uIHN0YWNrIG91dHB1dCBpcyBvZiB0aGUgZm9ybWF0ICd4eHh4eHh4eHh4eHh4eC5jbG91ZGZyb250Lm5ldCdcbiAqL1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdpbnRlZy11c2VyLXBvb2wtZG9tYWluLWNmZGlzdCcpO1xuXG5jb25zdCB1c2VycG9vbCA9IG5ldyBVc2VyUG9vbChzdGFjaywgJ1VzZXJQb29sJyk7XG5cbmNvbnN0IGRvbWFpbiA9IHVzZXJwb29sLmFkZERvbWFpbignRG9tYWluJywge1xuICBjb2duaXRvRG9tYWluOiB7XG4gICAgZG9tYWluUHJlZml4OiAnY2RrLWludGVnLXVzZXItcG9vbC1kb21haW4nLFxuICB9LFxufSk7XG5cbm5ldyBDZm5PdXRwdXQoc3RhY2ssICdEb21haW4nLCB7XG4gIHZhbHVlOiBkb21haW4uZG9tYWluTmFtZSxcbn0pO1xuXG5uZXcgQ2ZuT3V0cHV0KHN0YWNrLCAnQ2xvdWRGcm9udERvbWFpbk5hbWUnLCB7XG4gIHZhbHVlOiBkb21haW4uY2xvdWRGcm9udERvbWFpbk5hbWUsXG59KTsiXX0=