"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProvider = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * User pool third-party identity providers
 */
class UserPoolIdentityProvider {
    /**
     * Import an existing UserPoolIdentityProvider
     */
    static fromProviderName(scope, id, providerName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.providerName = providerName;
            }
        }
        return new Import(scope, id);
    }
    constructor() { }
}
exports.UserPoolIdentityProvider = UserPoolIdentityProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1wb29sLWlkcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInVzZXItcG9vbC1pZHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQStEO0FBYS9EOztHQUVHO0FBQ0gsTUFBYSx3QkFBd0I7SUFFbkM7O09BRUc7SUFDSSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsWUFBb0I7UUFDL0UsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ2tCLGlCQUFZLEdBQVcsWUFBWSxDQUFDO1lBQ3RELENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRCxnQkFBdUIsQ0FBQztDQUN6QjtBQWRELDREQWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBJUmVzb3VyY2UsIFJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIFVzZXJQb29sSWRlbnRpdHlQcm92aWRlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIElVc2VyUG9vbElkZW50aXR5UHJvdmlkZXIgZXh0ZW5kcyBJUmVzb3VyY2Uge1xuICAvKipcbiAgICogVGhlIHByaW1hcnkgaWRlbnRpZmllciBvZiB0aGlzIGlkZW50aXR5IHByb3ZpZGVyXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHByb3ZpZGVyTmFtZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFVzZXIgcG9vbCB0aGlyZC1wYXJ0eSBpZGVudGl0eSBwcm92aWRlcnNcbiAqL1xuZXhwb3J0IGNsYXNzIFVzZXJQb29sSWRlbnRpdHlQcm92aWRlciB7XG5cbiAgLyoqXG4gICAqIEltcG9ydCBhbiBleGlzdGluZyBVc2VyUG9vbElkZW50aXR5UHJvdmlkZXJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVByb3ZpZGVyTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm92aWRlck5hbWU6IHN0cmluZyk6IElVc2VyUG9vbElkZW50aXR5UHJvdmlkZXIge1xuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVVzZXJQb29sSWRlbnRpdHlQcm92aWRlciB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgcHJvdmlkZXJOYW1lOiBzdHJpbmcgPSBwcm92aWRlck5hbWU7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoKSB7fVxufSJdfQ==