#python
"""
This module defines Django signals related to Okta events.

It contains the event types that are eligible for use with an event hook only.
Ref: https://developer.okta.com/docs/reference/api/event-types/

---------------------------------------------------
- WARNING - This file is automatically generated! -
---------------------------------------------------
Permanent changes should be applied on the template, located at "okta_client/templates/okta-client/signal_events.py-template"
"""

from logging import getLogger

from django.dispatch import Signal

LOGGER = getLogger(__name__)

access_request_cancel = Signal()
access_request_cancel.__doc__ = """
Access request canceled. Can be used to audit access to an Okta resource or to trigger downstream automation that depends on request cancellation. Okta Identity Governance API can be used to get more details about the canceled request.
"""

access_request_condition_activate = Signal()
access_request_condition_activate.__doc__ = """
Access request condition activated. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition activation. Okta Identity Governance API can be used to get more details about the activated access request condition.
"""

access_request_condition_create = Signal()
access_request_condition_create.__doc__ = """
Access request condition created. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition creation. Okta Identity Governance API can be used to get more details about the created access request condition.
"""

access_request_condition_deactivate = Signal()
access_request_condition_deactivate.__doc__ = """
Access request condition deactivated. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition deactivation. Okta Identity Governance API can be used to get more details about the deactivated access request condition.
"""

access_request_condition_delete = Signal()
access_request_condition_delete.__doc__ = """
Access request condition deleted. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition deletion. Okta Identity Governance API can be used to get more details about the deleted access request condition.
"""

access_request_condition_invalidate = Signal()
access_request_condition_invalidate.__doc__ = """
Access request condition invalidated. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition invalidation. Okta Identity Governance API can be used to get more details about the invalidated access request condition.
"""

access_request_condition_update = Signal()
access_request_condition_update.__doc__ = """
Access request condition updated. Can be used to audit access request condition to an Okta resource or to trigger downstream automation that depends on access request condition update. Okta Identity Governance API can be used to get more details about the updated access request condition.
"""

access_request_create = Signal()
access_request_create.__doc__ = """
Access request created. Can be used to audit access to an Okta resource or to trigger downstream automation that depends on request creation. Okta Identity Governance API can be used to get more details about the created request.
"""

access_request_expire = Signal()
access_request_expire.__doc__ = """
Access request expired. Can be used to audit access to an Okta resource or to trigger downstream automation that depends on request expiration. Okta Identity Governance API can be used to get more details about the expired request.
"""

access_request_reject = Signal()
access_request_reject.__doc__ = """
Access request rejected. Can be used to audit access to an Okta resource or to trigger downstream automation that depends on request rejection. Okta Identity Governance API can be used to get more details about the rejected request.
"""

access_request_resolve = Signal()
access_request_resolve.__doc__ = """
Access request resolved. Can be used to audit access to an Okta resource or to trigger downstream automation that depends on request resolution. Okta Identity Governance API can be used to get more details about the resolved request.
"""

access_request_sequence_create = Signal()
access_request_sequence_create.__doc__ = """
Access request sequence created. Can be used to audit the approval sequence and when it was created and what was defined within the sequence to verify the approvals required. Okta Identity Governance API can be used to get more details about the created access request sequence.
"""

access_request_sequence_delete = Signal()
access_request_sequence_delete.__doc__ = """
Access request sequence deleted. Can be used to audit the approval sequence and when it was deleted and what was defined within the sequence to verify the approvals required. Okta Identity Governance API can be used to get more details about the deleted access request sequence.
"""

access_request_sequence_update = Signal()
access_request_sequence_update.__doc__ = """
Access request sequence updated. Can be used to audit the approval sequence and when it was updated and what was defined within the sequence to verify the approvals required. Okta Identity Governance API can be used to get more details about the updated access request sequence.
"""

access_request_settings_update = Signal()
access_request_settings_update.__doc__ = """
Access request settings updated. Can be used to audit access request settings to an Okta resource or to trigger downstream automation that depends on access request settings update. Okta Identity Governance API can be used to get more details about the updated access request settings.
"""

app_access_request_approver_approve = Signal()
app_access_request_approver_approve.__doc__ = """
Request to access an app was approved by an administrator-defined approver.
"""

app_access_request_approver_deny = Signal()
app_access_request_approver_deny.__doc__ = """
Request to access an app was denied by an administrator-defined approver.
"""

app_access_request_delete = Signal()
app_access_request_delete.__doc__ = """
Request to access an app was deleted by an administrator.
"""

app_access_request_deny = Signal()
app_access_request_deny.__doc__ = """
Request to access an app was denied after at least one approver denied the request.
"""

app_access_request_expire = Signal()
app_access_request_expire.__doc__ = """
Request to access an app expired by the system due to lack of approver action.
"""

app_access_request_grant = Signal()
app_access_request_grant.__doc__ = """
Request to access an app was granted after all approvers approved the request.
"""

app_access_request_request = Signal()
app_access_request_request.__doc__ = """
Request to access an app was performed by a user.
"""

app_oauth2_as_consent_grant = Signal()
app_oauth2_as_consent_grant.__doc__ = """
User granted consent to app.
"""

app_oauth2_as_consent_revoke = Signal()
app_oauth2_as_consent_revoke.__doc__ = """
Consent revoked.
"""

app_oauth2_as_consent_revoke_implicit_as = Signal()
app_oauth2_as_consent_revoke_implicit_as.__doc__ = """
All consent revoked for authorization server.
"""

app_oauth2_as_consent_revoke_implicit_client = Signal()
app_oauth2_as_consent_revoke_implicit_client.__doc__ = """
All consent revoked for client.
"""

app_oauth2_as_consent_revoke_implicit_scope = Signal()
app_oauth2_as_consent_revoke_implicit_scope.__doc__ = """
All consent revoked for scope.
"""

app_oauth2_as_consent_revoke_implicit_user = Signal()
app_oauth2_as_consent_revoke_implicit_user.__doc__ = """
Consent for all scopes revoked for user.
"""

app_oauth2_as_consent_revoke_user = Signal()
app_oauth2_as_consent_revoke_user.__doc__ = """
All consent revoked for user.
"""

app_oauth2_as_consent_revoke_user_client = Signal()
app_oauth2_as_consent_revoke_user_client.__doc__ = """
User consent revoked for client.
"""

app_oauth2_client_privilege_grant = Signal()
app_oauth2_client_privilege_grant.__doc__ = """
An OAuth 2.0 client app's admin privileges changed. This can be used to audit the provisioning of admin privileges for OAuth 2.0 client apps. When fired, this event contains information about the type of admin privileges the OAuth 2.0 client app currently has.  Related events include: APP_OAUTH2_CLIENT_PRIVILEGE_REVOKE.
"""

app_oauth2_client_privilege_revoke = Signal()
app_oauth2_client_privilege_revoke.__doc__ = """
All privileges for OAuth 2.0 client app were revoked. This can be used to audit the deprovisioning of admin privileges from OAuth 2.0 client apps. When fired, this event indicates the OAuth 2.0 client app has no more admin privileges. All of OAuth 2.0 client app's privileges were revoked.  Related events include: APP_OAUTH2_CLIENT_PRIVILEGE_GRANT.
"""

app_oauth2_trusted_server_add = Signal()
app_oauth2_trusted_server_add.__doc__ = """
Trusted authorization server is added. Administrators can use this event to debug and audit trusted authorization server operations. When fired, this event contains the authorization server IDs of the servers involved.
"""

app_oauth2_trusted_server_delete = Signal()
app_oauth2_trusted_server_delete.__doc__ = """
Trusted authorization server is removed. Administrators can use this event to debug and audit trusted authorization server operations. When fired, this event contains the authorization server IDs of the servers involved.
"""

application_lifecycle_activate = Signal()
application_lifecycle_activate.__doc__ = """
Activate application.
"""

application_lifecycle_create = Signal()
application_lifecycle_create.__doc__ = """
Create application.
"""

application_lifecycle_deactivate = Signal()
application_lifecycle_deactivate.__doc__ = """
Deactivate application.
"""

application_lifecycle_delete = Signal()
application_lifecycle_delete.__doc__ = """
Delete application.
"""

application_lifecycle_update = Signal()
application_lifecycle_update.__doc__ = """
Update application.
"""

application_policy_sign_on_deny_access = Signal()
application_policy_sign_on_deny_access.__doc__ = """
Deny user access due to app sign on policy. When fired due to app assurance being evaluated as unsatisfiable (the policy requirements could not be satisfied by the users' current set of available authenticator enrollments), this event contains information about the user and the app that the user is trying to authenticate into.
"""

application_provision_group_push_mapping_update_or_delete_failed_with_error = Signal()
application_provision_group_push_mapping_update_or_delete_failed_with_error.__doc__ = """
Group push mapping change failed and cannot be retried. Can be used to identify group push mapping errors which may require admin intervention to address. Unlike the similarly named event, application.provision.group_push.mapping.update.or.delete.failed, when this event is fired the corresponding action that triggered it will not be retried by Okta and may indicate a configuration problem. For example, invalid authorization credentials with the target application due to an expired password or invalid access token.
"""

application_provision_user_sync = Signal()
application_provision_user_sync.__doc__ = """
Sync user in external application.
"""

application_user_membership_add = Signal()
application_user_membership_add.__doc__ = """
Add user to application membership.
"""

application_user_membership_change_password = Signal()
application_user_membership_change_password.__doc__ = """
Change application password for user.
"""

application_user_membership_remove = Signal()
application_user_membership_remove.__doc__ = """
Remove user's application membership.
"""

application_user_membership_update = Signal()
application_user_membership_update.__doc__ = """
Updated user application property.
"""

certification_campaign_close = Signal()
certification_campaign_close.__doc__ = """
Triggered when a campaign is closed. This event can be used by admins to audit Access Certification Review activity to understand when a Campaign Instance has transitioned into the closed state. This event is triggered when a Campaign is closed either by an admin or on the configured campaign end date.
"""

certification_campaign_context_update = Signal()
certification_campaign_context_update.__doc__ = """
Triggered when the customizable context settings are updated at org level. Can be used to audit customizable context settings changes in the system log as well as reports. This is triggered when the customizable context settings are updated at the org level.
"""

certification_campaign_item_decide = Signal()
certification_campaign_item_decide.__doc__ = """
Triggered when a decision on the access to a resource is made. Can be used to audit the decision activity related to an item in a certification campaign, such as the access of a user to an application. The outcome.result field will be SUCCESS for a decision to approve or revoke and will be SKIPPED for a decision to delegate. This is triggered when a reviewer makes a decision on a campaign item, or at the end of a campaign if an item has not been reviewed. The result of the decision is included in the debugData (APPROVE, REVOKE, DELEGATE, NORESPONSE).
"""

certification_campaign_item_remediate = Signal()
certification_campaign_item_remediate.__doc__ = """
Triggered when the remediation is performed on the campaign item. Can be used to audit remediation activity in the system log as well as reports. This is triggered when the remediation is acted upon by reviewer.
"""

certification_campaign_launch = Signal()
certification_campaign_launch.__doc__ = """
Triggered when a campaign is launched. This event can be used by admins to audit Access Certification Review activity to understand when a Campaign Instance has transitioned into the Active state. This event is triggered when a Campaign starts and moves from scheduled to active.
"""

device_enrollment_create = Signal()
device_enrollment_create.__doc__ = """
Enroll new device. This can be used by any admin to monitor when a new device is registered successfully for Okta Verify. The user must have below the max allowed devices and a valid device status (not suspended or deactivated).The targets field contains key details of the enrolled device including name, status, serialNumber, imei, meid, osVersion, osPlatform. which may be useful for identifying the device, tracking  which device platforms and OS versions that enrolled in Okta Device Authenticator.
"""

device_lifecycle_activate = Signal()
device_lifecycle_activate.__doc__ = """
Activate device. You can use the event to audit device status change. When triggered, the device can be suspended or deactivated. Also, a user can access protected resources from an active device if permitted by the App Sign-On policies applied to the resources.
"""

device_lifecycle_deactivate = Signal()
device_lifecycle_deactivate.__doc__ = """
Deactivate device. You can use the event to audit device status change. When a device is deactivated, it can not be associated with any Okta Verify factor in the future.
"""

device_lifecycle_delete = Signal()
device_lifecycle_delete.__doc__ = """
Delete device. You can use the event to audit device status change. When triggered, the device no longer appears in the Admin Console.
"""

device_lifecycle_suspend = Signal()
device_lifecycle_suspend.__doc__ = """
Suspend device. You can use the event to audit device status change. When triggered, access to the device is temporarily paused for users such as contractors or employees who take a leave of absence. Only active devices can be suspended. If a device suspension fails, the cause may be that the device was not active and therefore cannot be suspended.
"""

device_lifecycle_unsuspend = Signal()
device_lifecycle_unsuspend.__doc__ = """
Unsuspend device. You can use the event to audit device status change. When triggered, all Okta Verify factors associated with the device are unsuspended, and users can access protected resources from the device.
"""

device_user_add = Signal()
device_user_add.__doc__ = """
Add device to user. You can use the event to audit device user association activity. The event is triggered when a user adds a new account in Okta Verify.
"""

device_user_remove = Signal()
device_user_remove.__doc__ = """
Remove device from user. You can use the event to audit device user association activity. The device remains in the Universal Directory after the user is removed.
"""

group_application_assignment_add = Signal()
group_application_assignment_add.__doc__ = """
Add assigned application to group.
"""

group_application_assignment_remove = Signal()
group_application_assignment_remove.__doc__ = """
Remove assigned application from group.
"""

group_application_assignment_update = Signal()
group_application_assignment_update.__doc__ = """
Update assigned application in group.
"""

group_lifecycle_create = Signal()
group_lifecycle_create.__doc__ = """
Create Okta group. This can be used to make sure an Okta group is successfully created. Event fired when an Okta group is successfully created.
"""

group_lifecycle_delete = Signal()
group_lifecycle_delete.__doc__ = """
Delete Okta group. This can be used to make sure an Okta group is successfully deleted. Event fired when an Okta group is successfully deleted.
"""

group_privilege_grant = Signal()
group_privilege_grant.__doc__ = """
Group's admin privilege granted. This can be used to audit the provisioning of admin privileges for groups. When fired, this event contains information about the type of admin privileges the group currently has, and what entity sources the group. The group granted privileges can be an Okta sourced group, and AD-sourced group, or an LDAP-sourced group Related events include: GROUP_PRIVILEGE_REVOKE.
"""

group_privilege_revoke = Signal()
group_privilege_revoke.__doc__ = """
Group's admin privilege revoked. This can be used to audit the deprovisioning of admin privileges from groups. When fired, this event indicates the group has no more admin privileges. All of group's privileges were revoked.  Related events include: GROUP_PRIVILEGE_GRANT.
"""

group_profile_update = Signal()
group_profile_update.__doc__ = """
Okta group profile updated. Events of this type can be used by an IT administrator who wants to trigger an Okta Workflow to provision groups into downstream systems. The utility of the Event type is for Provisioning use cases to downstream systems.A classic example of this is a customer who uses Okta for Office 365 LCM, and wants to push a distribution list from Okta to Office 365.
"""

group_user_membership_add = Signal()
group_user_membership_add.__doc__ = """
Add user to group membership.
"""

group_user_membership_remove = Signal()
group_user_membership_remove.__doc__ = """
Remove user from group membership.
"""

iam_policy_configuration_update = Signal()
iam_policy_configuration_update.__doc__ = """
IAM policy configuration update. Use this event to track and audit updates to IAM policy configuration for the org. This event contains information about the IAM policy configuration updates for an org.
"""

iam_resourceset_bindings_add = Signal()
iam_resourceset_bindings_add.__doc__ = """
Admin role assignment is created. This event can be used to track and audit when a new admin role assignment is created. When fired this event contains information about the new user or group admin assignments for roles associated with the resource set.
"""

iam_resourceset_bindings_delete = Signal()
iam_resourceset_bindings_delete.__doc__ = """
Admin assignment is deleted. This event can be used to track and audit when an admin role assignment is deleted. When fired this event contains information about the deleted user or group admin assignments for roles associated with the resource set.
"""

iam_resourceset_create = Signal()
iam_resourceset_create.__doc__ = """
Resource set is created. This event can be used to track and audit when a resource set is created. When fired this event contains information about the resources contained in the resource set that is created.
"""

iam_resourceset_delete = Signal()
iam_resourceset_delete.__doc__ = """
Resource set is deleted. This event can be used to track and audit when a resource set is deleted. When fired this event contains information about the resources contained in the resource set that is deleted.
"""

iam_resourceset_resources_add = Signal()
iam_resourceset_resources_add.__doc__ = """
Resources are added to a resource set. This event can be used to audit the resources added to a resource set. When fired this event contains information about the resources added to the resource set.
"""

iam_resourceset_resources_delete = Signal()
iam_resourceset_resources_delete.__doc__ = """
Resources are deleted from a resource set. This event can be used to audit the resources deleted from a resource set. When fired this event contains information about the resources deleted from the resource set.
"""

iam_resourceset_resources_update = Signal()
iam_resourceset_resources_update.__doc__ = """
Resources updated in a resource set. Used this event to audit resources updated in a resource set. This event contains information about resources that were updated in a resource set.
"""

iam_resourceset_update = Signal()
iam_resourceset_update.__doc__ = """
Resource set update. Use this event to track and audit when a resource set was updated. This event contains information about the updated name and description of the resource set.
"""

iam_role_create = Signal()
iam_role_create.__doc__ = """
Custom admin role is created. This event can be used to track and audit when a custom admin role is created. When fired this event contains information about the permissions contained in the role that is created.
"""

iam_role_delete = Signal()
iam_role_delete.__doc__ = """
Custom admin role is deleted. This event can be used to track and audit when a custom admin role is deleted. When fired this event contains information about the permissions contained in the role that is deleted.
"""

iam_role_permission_conditions_add = Signal()
iam_role_permission_conditions_add.__doc__ = """
Conditions added to a permission in Okta. Use this event to evaluate impact on admin privileges as their scope might be impacted. This event is triggered when a condition is added to a role-based permission in Okta. A condition on a permission allows super admins to implement finer grained authorizations for stricter security postures. The event can be  accompanied with other events for permissions such as iam.role.permissions.add.
"""

iam_role_permission_conditions_delete = Signal()
iam_role_permission_conditions_delete.__doc__ = """
Conditions deleted from a permission in Okta. Use this event to evaluate impact on admin privileges as their scope might be impacted. This event is triggered when a condition is deleted from a role-based permission in Okta. A condition on a permission allows super admins to implement finer grained authorizations for stricter security postures. The event can be  accompanied with other events for permissions such as iam.role.permissions.delete.
"""

iam_role_permissions_add = Signal()
iam_role_permissions_add.__doc__ = """
Permissions are added to a custom admin role. This event can be used to audit the permissions added to a custom admin role. When fired this event contains information about the permissions added to the role.
"""

iam_role_permissions_delete = Signal()
iam_role_permissions_delete.__doc__ = """
Permissions are deleted from a custom admin role. This event can be used to audit the permissions deleted from a custom admin role. When fired this event contains information about the permissions deleted from the role.
"""

iam_role_update = Signal()
iam_role_update.__doc__ = """
Custom admin role update. Use this event to track and audit when a custom admin role was updated. This event contains information about the updated name and description of the role.
"""

inline_hook_executed = Signal()
inline_hook_executed.__doc__ = """
Triggered when an inline hook has been executed. Used to notify admins about the outcome of execution of an inline hook. Note that the event is fired when the execution is unsuccessful.
"""

policy_auth_reevaluate_fail = Signal()
policy_auth_reevaluate_fail.__doc__ = """
Auth policy re-evaluation has occurred and has resulted in a policy violation. Can be used to identify which user, apps, and session were involved in a policy violation event. Event fired when continuing access evaluation results in failure.
"""

policy_lifecycle_activate = Signal()
policy_lifecycle_activate.__doc__ = """
Activate policy.
"""

policy_lifecycle_deactivate = Signal()
policy_lifecycle_deactivate.__doc__ = """
Deactivate policy.
"""

policy_lifecycle_update = Signal()
policy_lifecycle_update.__doc__ = """
Update policy.
"""

policy_rule_activate = Signal()
policy_rule_activate.__doc__ = """
Activate policy rule.
"""

policy_rule_add = Signal()
policy_rule_add.__doc__ = """
Add policy rule.
"""

policy_rule_deactivate = Signal()
policy_rule_deactivate.__doc__ = """
Deactivate policy rule.
"""

policy_rule_delete = Signal()
policy_rule_delete.__doc__ = """
Delete policy rule.
"""

policy_rule_update = Signal()
policy_rule_update.__doc__ = """
Update policy rule.
"""

security_authenticator_lifecycle_activate = Signal()
security_authenticator_lifecycle_activate.__doc__ = """
Fired when an admin activates an authenticator for the org. This event can be used to identify who activated an authenticator and which authenticator was activated. When fired, this event contains information about the authenticator type that was activated and the actor who activated the authenticator. Authenticator activation occurs when an authenticator is added. Related events include security.authenticator.lifecycle.deactivate.
"""

security_authenticator_lifecycle_create = Signal()
security_authenticator_lifecycle_create.__doc__ = """
Fired when an admin creates an authenticator for the org. This event can be used to identify who created an authenticator and which authenticator was created. The actor specifies the user that created the authenticator and the target specifies the authenticator name and the id. This event could also contain some authenticator specific information. Authenticator creation occurs when an authenticator is added. Related events include security.authenticator.lifecycle.update.
"""

security_authenticator_lifecycle_deactivate = Signal()
security_authenticator_lifecycle_deactivate.__doc__ = """
Fired when an admin deactivates an authenticator for the org. This event can be used to identify who deactivated an authenticator and which authenticator was deactivated. When fired, this event contains information about the authenticator type that was deactivated and the actor who deactivated the authenticator. Authenticator deactivation occurs when an authenticator is removed. Related events include security.authenticator.lifecycle.activate.
"""

security_authenticator_lifecycle_update = Signal()
security_authenticator_lifecycle_update.__doc__ = """
Fired when an admin updates an authenticator in the org. This event can be used to identify who updated an authenticator and which authenticator was updated. The actor specifies the user that updated the authenticator and the target specifies the authenticator name and the ID. There may be a second target with details of any authenticator method updates. This event could also contain authenticator specific information. Authenticator update occurs when an authenticator is edited. Related events include security.authenticator.lifecycle.create.
"""

security_breached_credential_detected = Signal()
security_breached_credential_detected.__doc__ = """
A credential, such as a password, which is associated with a known breach was used during an authentication flow. Used to identify users for whom credential rotation or other risk mitigation is necessary. The actor is the user with the breached credential. For Identity Engine, a target will indicate the specific credential associated with the breach. The outcome for this event will always be SUCCESS with a severity level of WARN. If breached credential protection is enabled, auser.session.clear will also be fired. These two events can be correlated by the Request ID.
"""

security_trusted_origin_activate = Signal()
security_trusted_origin_activate.__doc__ = """
A trusted origin is activated. When an event is emitted upon the activation of a trusted origin, customers can monitor these events and take remedial action. Event is triggered when a trusted origin is activated.
"""

security_trusted_origin_create = Signal()
security_trusted_origin_create.__doc__ = """
A trusted origin is created. When an event is emitted upon the creation of a trusted origin, customers can monitor these events and take remedial action. Event is triggered when a trusted origin is created.
"""

security_trusted_origin_deactivate = Signal()
security_trusted_origin_deactivate.__doc__ = """
A trusted origin is deactivated. When an event is emitted upon the deactivation of a trusted origin, customers can monitor these events and take remedial action. Event is triggered when a trusted origin is deactivated.
"""

security_trusted_origin_delete = Signal()
security_trusted_origin_delete.__doc__ = """
A trusted origin is deleted. When an event is emitted upon the deletion of a trusted origin, customers can monitor these events and take remedial action. Event is triggered when a trusted origin is deleted.
"""

security_trusted_origin_update = Signal()
security_trusted_origin_update.__doc__ = """
A trusted origin is updated. When an event is emitted upon the modification of a trusted origin, customers can monitor these events and take remedial action. Event is triggered when a trusted origin is updated.
"""

system_api_token_create = Signal()
system_api_token_create.__doc__ = """
Create API token. This event occurs when a new unscoped API token is generated within the system. The unscoped API token grants authenticated access to the system's API for automated tasks or integration purposes. Event log details include the token ID, the user, or service it was created for, and the time of creation. This information helps maintain a secure API access framework by allowing administrators to track token issuance. Administrators can also enforce least privilege access and promptly identify any unauthorized token creation.
"""

system_api_token_request_outside_allowed_range = Signal()
system_api_token_request_outside_allowed_range.__doc__ = """
Request with API tokens made from outside the allowed network zone. Use to detect when an API token comes from an IP address that's outside of the specified allowed zone. Fired when an API token comes from an IP address that's outside of the specified allowed zone of the token.
"""

system_api_token_revoke = Signal()
system_api_token_revoke.__doc__ = """
Revoke API token.
"""

system_email_delivery = Signal()
system_email_delivery.__doc__ = """
An email's delivery status was updated. Used to notify admins of a bounced or dropped email. For certain bounce events, the context information may be lost by the email provider(s) due to email server communication delays. Such delayed bounce events will not appear in syslog. As of the 2022.08.0 release, this is also used to identify other email events e.g. delivered, deferred. See the event debugData for help identifying a remediation, such as updating an incorrect email address.
"""

system_idp_key_create = Signal()
system_idp_key_create.__doc__ = """
Identity provider key credential created. This can be used to audit that a new identity provider key credential has been created. When fired, this event indicates a new X.509 certificate credential is added to the IdP key store.
"""

system_idp_key_delete = Signal()
system_idp_key_delete.__doc__ = """
Identity provider key credential deleted. This can be used to audit that an identity provider key credential has been deleted. When fired, this event indicates a X.509 certificate credential by kid is deleted if it isn't currently being used by an active or inactive IdP.
"""

system_idp_key_update = Signal()
system_idp_key_update.__doc__ = """
Identity provider key credential updated. This can be used to audit that an identity provider key credential has been updated. When fired, this event indicates a X.509 certificate credential is updated in the IdP key store.
"""

system_idp_lifecycle_activate = Signal()
system_idp_lifecycle_activate.__doc__ = """
Identity provider activated. This can be used to audit that an identity provider has been activated. When fired, this event indicates an Identity provider was activated. This event also indicates the type of the identity provider that was activated.
"""

system_idp_lifecycle_create = Signal()
system_idp_lifecycle_create.__doc__ = """
Identity provider created. This can be used to audit that a new identity provider has been created. When fired, this event indicates an Identity provider was successfully created. This event also indicates the type of the identity provider that was created.
"""

system_idp_lifecycle_deactivate = Signal()
system_idp_lifecycle_deactivate.__doc__ = """
Identity provider deactivated. This can be used to audit that an identity provider has been deactivated. When fired, this event indicates an Identity provider has been deactivated. This event also indicates the type of the identity provider that was deactivated.
"""

system_idp_lifecycle_delete = Signal()
system_idp_lifecycle_delete.__doc__ = """
Identity provider deleted. This can be used to audit that an identity provider has been deleted. When fired, this event indicates an Identity provider was deleted. This event also indicates the type of the identity provider that was deleted.
"""

system_idp_lifecycle_read_client_secret = Signal()
system_idp_lifecycle_read_client_secret.__doc__ = """
Identity provider(s) with a client secret is read. This can be used to audit that identity provider(s) with a client secret has been read. When fired, this event indicates one or more Identity providers with a client secret was read.
"""

system_idp_lifecycle_update = Signal()
system_idp_lifecycle_update.__doc__ = """
Identity provider updated. This can be used to audit that an identity provider configuration has been updated. When fired, this event indicates an Identity provider configuration was updated. This event also indicates the type of the identity provider that was updated.
"""

system_import_complete = Signal()
system_import_complete.__doc__ = """
Import process complete.
"""

system_import_group_create = Signal()
system_import_group_create.__doc__ = """
Create group triggered by import process.
"""

system_import_group_delete = Signal()
system_import_group_delete.__doc__ = """
Remove group triggered by import process.
"""

system_import_roadblock = Signal()
system_import_roadblock.__doc__ = """
Import roadblock triggered due to exceeded threshold.
"""

system_import_start = Signal()
system_import_start.__doc__ = """
import started.
"""

system_log_stream_lifecycle_activate = Signal()
system_log_stream_lifecycle_activate.__doc__ = """
Log stream activated. This event can be used to track and audit when a user activates a log stream. When fired, this event indicates that a user activated a log stream configuration.
"""

system_log_stream_lifecycle_create = Signal()
system_log_stream_lifecycle_create.__doc__ = """
Log stream created. This event can be used to track and audit when a user creates a log stream. When fired, this event indicates that a user created a log stream configuration.
"""

system_log_stream_lifecycle_deactivate = Signal()
system_log_stream_lifecycle_deactivate.__doc__ = """
Log stream deactivated. This event can be used to track and audit when a user or Okta deactivates a log stream. When fired, this event indicates that a user or Okta deactivated a log stream configuration.
"""

system_log_stream_lifecycle_delete = Signal()
system_log_stream_lifecycle_delete.__doc__ = """
Log stream deleted. This event can be used to track and audit when a user deletes a log stream. When fired, this event indicates that a user deleted a log stream configuration.
"""

system_log_stream_lifecycle_update = Signal()
system_log_stream_lifecycle_update.__doc__ = """
Log stream updated. This event can be used to track and audit when a user updates a log stream. When fired, this event indicates that a user updated a log stream configuration.
"""

system_oauth2_token_request_outside_allowed_range = Signal()
system_oauth2_token_request_outside_allowed_range.__doc__ = """
Request with valid bearer tokens made from outside the allowed network zone. Use to detect when a bearer token comes from an IP address that's outside of the specified allowed zone. Fired when a bearer token comes from an IP address that's outside of the specified allowed zone of the client.
"""

system_org_rate_limit_violation = Signal()
system_org_rate_limit_violation.__doc__ = """
Rate limit violation.
"""

system_org_rate_limit_warning = Signal()
system_org_rate_limit_warning.__doc__ = """
Rate limit warning.
"""

system_sms_send_phone_verification_message = Signal()
system_sms_send_phone_verification_message.__doc__ = """
Send phone verification SMS message. As of the 2022.06.0 release this event is also used to identify transactions blocked by Okta, which is indicated by a "deny" outcome. Previously, the system.operation.rate_limit.violation was used to identify blocked transactions. Additionally, the method of generating the MobilePhone ID in the event has changed for Okta Classic. It has not changed for Okta Identity Engine.
"""

system_voice_send_phone_verification_call = Signal()
system_voice_send_phone_verification_call.__doc__ = """
Send phone verification call. As of the 2022.06.0 release this event is also used to identify transactions blocked by Okta, which is indicated by a "deny" outcome. Previously, the system.operation.rate_limit.violation was used to identify blocked transactions. Additionally, the method of generating the MobilePhone ID in the event has changed for Okta Classic. It has not changed for Okta Identity Engine.
"""

user_account_lock = Signal()
user_account_lock.__doc__ = """
Auto-lock user account for Okta.
"""

user_account_privilege_grant = Signal()
user_account_privilege_grant.__doc__ = """
A User's admin privileges changed. This can be used to audit the provisioning of admin privileges for users. When fired, this event contains information about the type of admin privileges the user currently has.  The list of current privileges contain both individually assigned roles  as well as the ones granted to the user through their group membership. Related events include: USER_ACCOUNT_PRIVILEGE_REVOKE.
"""

user_account_privilege_revoke = Signal()
user_account_privilege_revoke.__doc__ = """
All of user's admin privilege revoked. This can be used to audit the deprovisioning of admin privileges from users. When fired, this event indicates the user has no more admin privileges. All of user's privileges were revoked including individually assigned roles  as well as the ones granted to the user through their group membership. Related events include: USER_ACCOUNT_PRIVILEGE_GRANT.
"""

user_account_report_suspicious_activity_by_enduser = Signal()
user_account_report_suspicious_activity_by_enduser.__doc__ = """
User reported suspicious activity. This event is used to identify user account suspicious activity.
"""

user_account_reset_password = Signal()
user_account_reset_password.__doc__ = """
User's Okta password has been reset.
"""

user_account_unlock = Signal()
user_account_unlock.__doc__ = """
Auto-unlock user account for Okta.
"""

user_account_unlock_by_admin = Signal()
user_account_unlock_by_admin.__doc__ = """
User account unlock by admin.
"""

user_account_update_password = Signal()
user_account_update_password.__doc__ = """
User update password for Okta.
"""

user_account_update_profile = Signal()
user_account_update_profile.__doc__ = """
Update user profile for Okta.
"""

user_authentication_auth_via_IDP = Signal()
user_authentication_auth_via_IDP.__doc__ = """
Authenticate user via IDP.
"""

user_authentication_auth_via_mfa = Signal()
user_authentication_auth_via_mfa.__doc__ = """
Authentication of user via MFA. For Okta Classic orgs, this event will only fire for second factor verifications, whereas for Identity Engine orgs, this event will fire for both primary and second factor verifications.
"""

user_authentication_auth_via_social = Signal()
user_authentication_auth_via_social.__doc__ = """
Authenticate user with social login.
"""

user_authentication_authenticate = Signal()
user_authentication_authenticate.__doc__ = """
Authentication via device trust certificate.
"""

user_authentication_sso = Signal()
user_authentication_sso.__doc__ = """
Fired when a user performs a single sign-on (SSO) to an app instance and contains the client details of the user. Can be used to identify when a user attempted to sign into an application for audit or debugging purposes. Note that the event is fired even when the sign-on is unsuccessful.
"""

user_authentication_universal_logout = Signal()
user_authentication_universal_logout.__doc__ = """
This event is fired when an admin or system account triggers Universal Logout against an app instance. It contains the app instance details for which the Universal Logout API was fired. This event identifies when applications have had Universal Logout triggered for audit or debugging purposes. This event is only fired once. It's only fired for applications that have been configured for Universal Logout. You can configure it under Risk policy, Post Auth Session policy, or in an admin-initiated Clear User Session.
"""

user_authentication_universal_logout_scheduled = Signal()
user_authentication_universal_logout_scheduled.__doc__ = """
This event is fired when an admin manually triggers Universal Logout for a user. It contains context about the initiating request, such as where the request originated and how the Universal Logout endpoint was invoked. After Universal Logout is complete, the user.authentication.universal_logout event is fired, and you can correlate both events using the traceID. This event identifies the geolocation, IP address, and IP chain of the requesting entity. This event is only fired once. You can correlate this event with the user.authentication.universal_logout event using traceID.
"""

user_behavior_profile_reset = Signal()
user_behavior_profile_reset.__doc__ = """
User behavior profile reset. This event can be used to identify resets to a user behavior profiles, which may be helpful when troubleshooting unexpected behavior detection evaluations. This event is triggered when an administrator manually resets a user's behavior profile in the Admin Console.
"""

user_credential_enroll = Signal()
user_credential_enroll.__doc__ = """
Device Trust certificate enrollment.
"""

user_identity_verification = Signal()
user_identity_verification.__doc__ = """
This event is fired when a user is directed to complete an Identity Verification as a result of an Okta Account Management (OAMP) Policy evaluation. This event indicates an identity verification request has occurred and will contain the results of the id verification. Completion of an id verification will determine whether the trigger OAMP operation can be completed; start is recorded by user.identity_verification.start.
"""

user_identity_verification_start = Signal()
user_identity_verification_start.__doc__ = """
An Okta account management policy (OAMP) prompted the user to verify their identity with an identity verification service. Helps admins audit identity-verification prompts and troubleshoot IDV-flow issues. Initiates the prompt for identity-verification flow; completion is recorded by user.identity_verification event.
"""

user_import_password = Signal()
user_import_password.__doc__ = """
Imported user password from external system during login. This can be used to understand if a user password import attempt was successful or if it failed. If the attempt failed, the password import will be tried again on a subsequent successful login. When fired, this event contains information about the import type, and whether or not the password import was successful. If the import is successful, it is safe to "clean up" that user from an external system. If the import failed, Okta will continue retrying the import during every successful authentication attempt until the password is successfully imported. Check the failure reason for details about whether any action is needed for the import to succeed.
"""

user_lifecycle_activate = Signal()
user_lifecycle_activate.__doc__ = """
Activate Okta user.
"""

user_lifecycle_create = Signal()
user_lifecycle_create.__doc__ = """
Create Okta user.
"""

user_lifecycle_deactivate = Signal()
user_lifecycle_deactivate.__doc__ = """
Deactivate Okta user.
"""

user_lifecycle_delete_initiated = Signal()
user_lifecycle_delete_initiated.__doc__ = """
Delete Okta user initiated.
"""

user_lifecycle_reactivate = Signal()
user_lifecycle_reactivate.__doc__ = """
Reactivate Okta user.
"""

user_lifecycle_suspend = Signal()
user_lifecycle_suspend.__doc__ = """
Suspend Okta user.
"""

user_lifecycle_unsuspend = Signal()
user_lifecycle_unsuspend.__doc__ = """
Unsuspend Okta user.
"""

user_mfa_factor_activate = Signal()
user_mfa_factor_activate.__doc__ = """
Activate factor or authenticator enrollment method for user. Provides org admins with audit log and oversight utility for an MFA factor when it is activated. When fired, the event contains information about the MFA factor that has been activated, as well as the target user and the user activating the factor. For Identity Engine orgs, this event will fire when an authentication method is enrolled.
"""

user_mfa_factor_deactivate = Signal()
user_mfa_factor_deactivate.__doc__ = """
Reset factor or authenticator enrollment method for user. Provides org admins with audit log and oversight utility for the change in MFA factor lifecycle status when a specific factor is permanently deactivated. When fired, the event contains information about the MFA factor that has been deactivated, as well as the target user and the user deactivating the factor. For Identity Engine orgs, this event will fire when an authentication method is unenrolled.
"""

user_mfa_factor_reset_all = Signal()
user_mfa_factor_reset_all.__doc__ = """
Reset all factors or authenticator enrollments for user. Provides org admins with audit log and oversight utility for the change in MFA factor lifecycle statuses when all MFA factors for a user are permanently deactivated. When fired, the event contains information about the target user for whom all factors have been deactivated, as well as the user resetting the factors. For Identity Engine orgs, this event contains information about a target user for whom all authenticator enrollments have been reset.
"""

user_mfa_factor_suspend = Signal()
user_mfa_factor_suspend.__doc__ = """
Suspend factor or authenticator enrollment method for user. Provides org admins with audit log and oversight utility for the change in MFA factor lifecycle status when a factor is suspended, usually as a result of suspected compromise. When fired, the event contains information about the MFA factor that has been suspended, as well as the target user and the user suspending the factor. When unsuspended, related event user.mfa.factor.unsuspend will be fired.
"""

user_mfa_factor_unsuspend = Signal()
user_mfa_factor_unsuspend.__doc__ = """
Unsuspend factor or authenticator enrollment method for user. Provides org admins with audit log and oversight utility for the change in MFA factor lifecycle status when a factor is reactivated from a state of suspension, after it has been determined that the authenticator is secure. When fired, the event contains information about the MFA factor that has been unsuspended, as well as the target user and the user reactivating the suspended factor. Before suspension, related event user.mfa.factor.suspend would have been fired.
"""

user_mfa_factor_update = Signal()
user_mfa_factor_update.__doc__ = """
Update factor for user.
"""

user_risk_change = Signal()
user_risk_change.__doc__ = """
Indicates a user's risk level has changed. This event can be used to monitor risk level changes for users. This event triggers when Okta determines that a user is associated with a change in risk activity or context.
"""

user_risk_detect = Signal()
user_risk_detect.__doc__ = """
Indicates a user risk was detected. This event can be used to monitor risk level detections for users. This event triggers when Okta detects that a user is associated with risk activity or context.
"""

user_session_clear = Signal()
user_session_clear.__doc__ = """
Clear user session.
"""

user_session_context_change = Signal()
user_session_context_change.__doc__ = """
User session context changed. This event indicates that the context in which the session is being used has changed significantly enough from the context in which the event was created, that re-evaluation of policy may be required. Often this indicates a security issue related to the session.
"""

user_session_end = Signal()
user_session_end.__doc__ = """
User logout from Okta.
"""

user_session_start = Signal()
user_session_start.__doc__ = """
User login to Okta.
"""
