# Generated by Django 5.2.6 on 2025-09-15 15:49

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('okta_client', '0002_alter_oktauser_options_alter_oktauser_managers_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='oktauser',
            name='last_refresh_timestamp',
            field=models.DateTimeField(blank=True, help_text='The last time the user was updated (refreshed) from Okta', null=True, verbose_name='Last refresh timestamp'),
        ),
        migrations.AddField(
            model_name='oktauser',
            name='okta_activated',
            field=models.DateTimeField(blank=True, help_text='Timestamp of the account activation.', null=True, verbose_name='activated'),
        ),
        migrations.AddField(
            model_name='oktauser',
            name='okta_created',
            field=models.DateTimeField(blank=True, help_text='Timestamp of the account creation.', null=True, verbose_name='created'),
        ),
        migrations.AddField(
            model_name='oktauser',
            name='okta_id',
            field=models.CharField(blank=True, help_text='Okta internal ID for the user.', max_length=50, null=True, unique=True, verbose_name='id'),
        ),
        migrations.AddField(
            model_name='oktauser',
            name='okta_status',
            field=models.CharField(blank=True, choices=[('STAGED', 'Staged'), ('PROVISIONED', 'Pending User Action'), ('ACTIVE', 'Active'), ('RECOVERY', 'Password Reset'), ('PASSWORD_EXPIRED', 'Password Expired'), ('LOCKED_OUT', 'Locked Out'), ('SUSPENDED', 'Suspended'), ('DEPROVISIONED', 'Deprovisioned')], help_text='Status of the Okta account.', max_length=30, verbose_name='status'),
        ),
        migrations.AddField(
            model_name='oktauser',
            name='okta_status_changed',
            field=models.DateTimeField(blank=True, help_text='Timestamp of the last update of the "status" attribute.', null=True, verbose_name='status changed'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='city',
            field=models.CharField(blank=True, help_text="City or locality component of user's address (locality)", max_length=100, verbose_name='city'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='costCenter',
            field=models.CharField(blank=True, help_text='Name of a cost center assigned to user', max_length=100, verbose_name='cost center'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='countryCode',
            field=models.CharField(blank=True, help_text="Country name component of user's address (country)", max_length=2, verbose_name='country code'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='date_joined',
            field=models.DateTimeField(auto_now_add=True, help_text='The timestamp when the local account was created', verbose_name='date joined'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='department',
            field=models.CharField(blank=True, help_text="Name of user's department", max_length=100, verbose_name='department'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='displayName',
            field=models.CharField(blank=True, help_text='Name of the user, suitable for display to end users', max_length=250, verbose_name='display name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='division',
            field=models.CharField(blank=True, help_text="Name of user's division", max_length=100, verbose_name='division'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='email',
            field=models.EmailField(help_text='Primary email address of user', max_length=254, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100', regex='^.{5,100}$')], verbose_name='email'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='employeeNumber',
            field=models.CharField(blank=True, help_text='Organization or company assigned unique identifier for the user', max_length=100, verbose_name='employee number'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='firstName',
            field=models.CharField(help_text='Given name of the user (givenName)', max_length=50, verbose_name='first name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='honorificPrefix',
            field=models.CharField(blank=True, help_text='Honorific prefix(es) of the user, or title in most Western languages', max_length=50, verbose_name='honorific prefix'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='honorificSuffix',
            field=models.CharField(blank=True, help_text='Honorific suffix(es) of the user', max_length=50, verbose_name='honorific suffix'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='is_staff',
            field=models.BooleanField(default=False, help_text='Designates whether the user can log into the admin site.', verbose_name='staff status'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='lastName',
            field=models.CharField(help_text='Family name of the user (familyName)', max_length=50, verbose_name='last name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='locale',
            field=models.CharField(blank=True, help_text="User's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.", max_length=5, verbose_name='locale'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='login',
            field=models.CharField(help_text='Unique identifier for the user (username)', max_length=100, primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100', regex='^.{5,100}$')], verbose_name='login'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='manager',
            field=models.CharField(blank=True, help_text="DisplayName of the user's manager", max_length=100, verbose_name='manager'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='managerId',
            field=models.CharField(blank=True, help_text="ID of a user's manager", max_length=100, verbose_name='manager ID'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='middleName',
            field=models.CharField(blank=True, help_text='Middle name(s) of the user', max_length=50, verbose_name='middle name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='mobilePhone',
            field=models.CharField(blank=True, help_text='Mobile phone number of user', max_length=100, verbose_name='mobile phone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='nickName',
            field=models.CharField(blank=True, help_text='Casual way to address the user in real life', max_length=50, verbose_name='nickname'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='organization',
            field=models.CharField(blank=True, help_text="Name of user's organization", max_length=100, verbose_name='organization'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='postalAddress',
            field=models.CharField(blank=True, help_text="Mailing address component of user's address", max_length=100, verbose_name='postal address'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='preferredLanguage',
            field=models.CharField(blank=True, help_text="User's preferred written or spoken languages", max_length=100, verbose_name='preferred language'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='primaryPhone',
            field=models.CharField(blank=True, help_text='Primary phone number of user such as home number', max_length=100, verbose_name='primary phone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='profileUrl',
            field=models.URLField(blank=True, help_text="URL of user's online profile (e.g. a web page)", verbose_name='profile URL'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='secondEmail',
            field=models.EmailField(blank=True, help_text='Secondary email address of user typically used for account recovery', max_length=254, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100 (or nothing)', regex='(^.{5,100}$)|(ˆ$)')], verbose_name='second email'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='state',
            field=models.CharField(blank=True, help_text="State or region component of user's address (region)", max_length=100, verbose_name='state'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='streetAddress',
            field=models.CharField(blank=True, help_text="Full street address component of user's address", max_length=100, verbose_name='street address'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='timezone',
            field=models.CharField(blank=True, help_text="User's time zone", max_length=100, verbose_name='time zone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='title',
            field=models.CharField(blank=True, help_text='User\'s title, such as "Vice President"', max_length=100, verbose_name='title'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='userType',
            field=models.CharField(blank=True, help_text='Used to describe the organization to user relationship such as "Employee" or "Contractor"', max_length=100, verbose_name='user type'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='zipCode',
            field=models.CharField(blank=True, help_text="Zipcode or postal code component of user's address (postalCode)", max_length=100, verbose_name='ZIP code'),
        ),
    ]
